// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * Represents the lyrics of a song.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Lyrics
{
    /**
     * Gets or sets he start bar on which the lyrics should begin.
     */
    public var startBar: Double = 0.0
    
    /**
     * Gets or sets the raw lyrics text in Guitar Pro format.
     * (spaces split word syllables, plus merge syllables, [..] are comments)
     */
    public var text: String = ""
    
    /**
     * Gets or sets the prepared chunks of the lyrics to apply to beats.
     */
    public lateinit var chunks: alphaTab.collections.List<String>
    /**
     */
    public fun finish(skipEmptyEntries: Boolean = false): Unit{
        this.chunks = alphaTab.collections.List<String>(
        )
        
        this.parse(this.text, 0.0, this.chunks, skipEmptyEntries)
    }
    
    /**
     */
    private fun parse(str: String, p: Double, chunks: alphaTab.collections.List<String>, skipEmptyEntries: Boolean): Unit{
        var paramp = p
        if (!alphaTab.core.TypeHelper.isTruthy(str))
        {
            return
        }
        var state: alphaTab.model.LyricsState = alphaTab.model.LyricsState.Begin
        var next: alphaTab.model.LyricsState = alphaTab.model.LyricsState.Begin
        var skipSpace: Boolean = false
        var start: Double = 0.0
        while (paramp < str.length.toDouble())
        {
            var c: Double = str.charCodeAt(paramp)
            when (state)
            {
                alphaTab.model.LyricsState.IgnoreSpaces -> 
                {
                    when (c)
                    {
                        alphaTab.model.Lyrics.CharCodeLF, alphaTab.model.Lyrics.CharCodeCR, alphaTab.model.Lyrics.CharCodeTab -> 
                        {
                        }
                        alphaTab.model.Lyrics.CharCodeSpace -> 
                        {
                            if (!skipSpace)
                            {
                                state = next
                                continue
                            }
                        }
                        else -> 
                        {
                            skipSpace = false
                            state = next
                            continue
                        }
                    }
                }
                alphaTab.model.LyricsState.Begin -> 
                {
                    when (c)
                    {
                        alphaTab.model.Lyrics.CharCodeBrackedOpen -> 
                        {
                            state = alphaTab.model.LyricsState.Comment
                        }
                        else -> 
                        {
                            start = paramp
                            state = alphaTab.model.LyricsState.Text
                            continue
                        }
                    }
                }
                alphaTab.model.LyricsState.Comment -> 
                {
                    when (c)
                    {
                        alphaTab.model.Lyrics.CharCodeBrackedClose -> 
                        {
                            state = alphaTab.model.LyricsState.Begin
                        }
                        else -> { }
                    }
                }
                alphaTab.model.LyricsState.Text -> 
                {
                    when (c)
                    {
                        alphaTab.model.Lyrics.CharCodeDash -> 
                        {
                            state = alphaTab.model.LyricsState.Dash
                        }
                        alphaTab.model.Lyrics.CharCodeCR, alphaTab.model.Lyrics.CharCodeLF, alphaTab.model.Lyrics.CharCodeSpace -> 
                        {
                            var txt: String = str.substr(start, paramp - start)
                            this.addChunk(txt, skipEmptyEntries)
                            state = alphaTab.model.LyricsState.IgnoreSpaces
                            next = alphaTab.model.LyricsState.Begin
                        }
                        else -> { }
                    }
                }
                alphaTab.model.LyricsState.Dash -> 
                {
                    when (c)
                    {
                        alphaTab.model.Lyrics.CharCodeDash -> 
                        {
                        }
                        else -> 
                        {
                            var txt: String = str.substr(start, paramp - start)
                            this.addChunk(txt, skipEmptyEntries)
                            skipSpace = true
                            state = alphaTab.model.LyricsState.IgnoreSpaces
                            next = alphaTab.model.LyricsState.Begin
                            continue
                        }
                    }
                }
                else -> { }
            }
            paramp += 1.0
        }
        if (state == alphaTab.model.LyricsState.Text)
        {
            if (paramp != start)
            {
                this.addChunk(str.substr(start, paramp - start), skipEmptyEntries)
            }
        }
    }
    
    /**
     */
    private fun addChunk(txt: String, skipEmptyEntries: Boolean): Unit{
        var paramtxt = txt
        paramtxt = this.prepareChunk(paramtxt)
        if (!skipEmptyEntries || (paramtxt.length.toDouble() > 0 && paramtxt != "-"))
        {
            this.chunks.push(paramtxt)
        }
    }
    
    /**
     */
    private fun prepareChunk(txt: String): String{
        var chunk: String = txt.splitBy("+").join(" ")
        var endLength: Double = chunk.length.toDouble()
        while (endLength > 0 && chunk.charAt(endLength - 1.0) == "_")
        {
            endLength--
        }
        return if(endLength != chunk.length.toDouble())  chunk.substr(0.0, endLength) else chunk
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val CharCodeLF: Double = 10.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeTab: Double = 9.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeCR: Double = 13.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeSpace: Double = 32.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeBrackedClose: Double = 93.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeBrackedOpen: Double = 91.0
        
        @kotlin.jvm.JvmStatic
        private val CharCodeDash: Double = 45.0
        
    }
    public constructor()
}

internal enum class LyricsState(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    IgnoreSpaces(0),
    Begin(1),
    Text(2),
    Comment(3),
    Dash(4);
    companion object{
        public fun fromValue(v:Double): LyricsState{
            return when(v.toInt()){
                IgnoreSpaces.value -> IgnoreSpaces
                Begin.value -> Begin
                Text.value -> Text
                Comment.value -> Comment
                Dash.value -> Dash
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

