// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * The MasterBar stores information about a bar which affects
 * all tracks.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MasterBar
{
    /**
     * Gets or sets the bitflag for the alternate endings. Each bit defines for which repeat counts
     * the bar is played.
     */
    public var alternateEndings: Double = 0.0
    
    /**
     * Gets or sets the next masterbar in the song.
     */
    public var nextMasterBar: alphaTab.model.MasterBar? = null
    
    /**
     * Gets or sets the next masterbar in the song.
     */
    public var previousMasterBar: alphaTab.model.MasterBar? = null
    
    /**
     * Gets the zero based index of the masterbar.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the key signature used on all bars.
     */
    public var keySignature: alphaTab.model.KeySignature = alphaTab.model.KeySignature.C
    
    /**
     * Gets or sets the type of key signature (major/minor)
     */
    public var keySignatureType: alphaTab.model.KeySignatureType = alphaTab.model.KeySignatureType.Major
    
    /**
     * Gets or sets whether a double bar is shown for this masterbar.
     */
    public var isDoubleBar: Boolean = false
    
    /**
     * Gets or sets whether a repeat section starts on this masterbar.
     */
    public var isRepeatStart: Boolean = false
    
    public val isRepeatEnd: Boolean
    get(){
        return this.repeatCount > 0
    }
    
    /**
     * Gets or sets the number of repeats for the current repeat section.
     */
    public var repeatCount: Double = 0.0
    
    /**
     * Gets or sets the repeat group this bar belongs to.
     */
    public lateinit var repeatGroup: alphaTab.model.RepeatGroup
    /**
     * Gets or sets the time signature numerator.
     */
    public var timeSignatureNumerator: Double = 4.0
    
    /**
     * Gets or sets the time signature denominiator.
     */
    public var timeSignatureDenominator: Double = 4.0
    
    /**
     * Gets or sets whether this is bar has a common time signature.
     */
    public var timeSignatureCommon: Boolean = false
    
    /**
     * Gets or sets the triplet feel that is valid for this bar.
     */
    public var tripletFeel: alphaTab.model.TripletFeel = alphaTab.model.TripletFeel.NoTripletFeel
    
    /**
     * Gets or sets the new section information for this bar.
     */
    public var section: alphaTab.model.Section? = null
    
    public val isSectionStart: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.section)
    }
    
    /**
     * Gets or sets the tempo automation for this bar.
     */
    public var tempoAutomation: alphaTab.model.Automation? = null
    
    /**
     * Gets or sets the reference to the score this song belongs to.
     */
    public lateinit var score: alphaTab.model.Score
    /**
     * Gets or sets the fermatas for this bar. The key is the offset of the fermata in midi ticks.
     */
    public var fermata: alphaTab.collections.DoubleObjectMap<alphaTab.model.Fermata>? = null
    
    /**
     * The timeline position of the voice within the whole score. (unit: midi ticks)
     */
    public var start: Double = 0.0
    
    /**
     * Gets or sets a value indicating whether the master bar is an anacrusis (aka. pickup bar)
     */
    public var isAnacrusis: Boolean = false
    
    /**
     * Gets a percentual scale for the size of the bars when displayed in a multi-track layout.
     */
    public var displayScale: Double = 1.0
    
    /**
     * An absolute width of the bar to use when displaying in a multi-track layout.
     */
    public var displayWidth: Double = -1.0
    
    /**
     * Calculates the time spent in this bar. (unit: midi ticks)
     */
    public fun calculateDuration(respectAnacrusis: Boolean = true): Double{
        if (this.isAnacrusis && respectAnacrusis)
        {
            var duration: Double = 0.0
            for (track in this.score.tracks)
            {
                for (staff in track.staves)
                {
                    var barDuration: Double = if(this.index < staff.bars.length)  staff.bars[(this.index).toInt()].calculateDuration() else 0.0
                    if (barDuration > duration)
                    {
                        duration = barDuration
                    }
                }
            }
            return duration
        }
        return this.timeSignatureNumerator * alphaTab.midi.MidiUtils.valueToTicks(this.timeSignatureDenominator)
    }
    
    /**
     * Adds a fermata to the masterbar.
     * @param offset The offset of the fermata within the bar in midi ticks.
     * @param fermata The fermata.
     */
    public fun addFermata(offset: Double, fermata: alphaTab.model.Fermata): Unit{
        var fermataMap: alphaTab.collections.DoubleObjectMap<alphaTab.model.Fermata>? = this.fermata
        if (fermataMap == null)
        {
            fermataMap = alphaTab.collections.DoubleObjectMap<alphaTab.model.Fermata>()
            this.fermata = fermataMap
        }
        fermataMap.set(offset, fermata)
    }
    
    /**
     * Gets the fermata for a given beat.
     * @param beat The beat to get the fermata for.
     */
    public fun getFermata(beat: alphaTab.model.Beat): alphaTab.model.Fermata?{
        var fermataMap: alphaTab.collections.DoubleObjectMap<alphaTab.model.Fermata>? = this.fermata
        if (fermataMap == null)
        {
            return null
        }
        if (fermataMap.has(beat.playbackStart))
        {
            return fermataMap.get(beat.playbackStart)!!
        }
        return null
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val MaxAlternateEndings: Double = 8.0
        
    }
    public constructor()
}

