// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * This public class contains some utilities for working with model public classes
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ModelUtils
{
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getIndex(duration: alphaTab.model.Duration): Double{
            var index: Double = 0.0
            var value: Double = (duration.toDouble())
            if (value < 0)
            {
                return index
            }
            return ((alphaTab.core.ecmaScript.Math.log2((duration.toDouble()))).toInt() or 0).toDouble()
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun keySignatureIsFlat(ks: Double): Boolean{
            return ks < 0
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun keySignatureIsNatural(ks: Double): Boolean{
            return ks == 0.0
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun keySignatureIsSharp(ks: Double): Boolean{
            return ks > 0
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun applyPitchOffsets(settings: alphaTab.Settings, score: alphaTab.model.Score): Unit{
            if(true) {
                var i: Double = 0.0
                
                while(i < score.tracks.length){
                    try{
                        if (i < settings.notation.displayTranspositionPitches.length)
                        {
                            for (staff in score.tracks[(i).toInt()].staves)
                            {
                                staff.displayTranspositionPitch = -settings.notation.displayTranspositionPitches[(i).toInt()]
                            }
                        }
                        if (i < settings.notation.transpositionPitches.length)
                        {
                            for (staff in score.tracks[(i).toInt()].staves)
                            {
                                staff.transpositionPitch = -settings.notation.transpositionPitches[(i).toInt()]
                            }
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun fingerToString(settings: alphaTab.Settings, beat: alphaTab.model.Beat, finger: alphaTab.model.Fingers, leftHand: Boolean): String?{
            if (settings.notation.fingeringMode == alphaTab.FingeringMode.ScoreForcePiano || settings.notation.fingeringMode == alphaTab.FingeringMode.SingleNoteEffectBandForcePiano || alphaTab.midi.GeneralMidi.isPiano(beat.voice.bar.staff.track.playbackInfo.program))
            {
                when (finger)
                {
                    alphaTab.model.Fingers.Unknown, alphaTab.model.Fingers.NoOrDead -> 
                    {
                        return null
                    }
                    alphaTab.model.Fingers.Thumb -> 
                    {
                        return "1"
                    }
                    alphaTab.model.Fingers.IndexFinger -> 
                    {
                        return "2"
                    }
                    alphaTab.model.Fingers.MiddleFinger -> 
                    {
                        return "3"
                    }
                    alphaTab.model.Fingers.AnnularFinger -> 
                    {
                        return "4"
                    }
                    alphaTab.model.Fingers.LittleFinger -> 
                    {
                        return "5"
                    }
                    else -> 
                    {
                        return null
                    }
                }
            }
            if (leftHand)
            {
                when (finger)
                {
                    alphaTab.model.Fingers.Unknown, alphaTab.model.Fingers.NoOrDead -> 
                    {
                        return "0"
                    }
                    alphaTab.model.Fingers.Thumb -> 
                    {
                        return "T"
                    }
                    alphaTab.model.Fingers.IndexFinger -> 
                    {
                        return "1"
                    }
                    alphaTab.model.Fingers.MiddleFinger -> 
                    {
                        return "2"
                    }
                    alphaTab.model.Fingers.AnnularFinger -> 
                    {
                        return "3"
                    }
                    alphaTab.model.Fingers.LittleFinger -> 
                    {
                        return "4"
                    }
                    else -> 
                    {
                        return null
                    }
                }
            }
            when (finger)
            {
                alphaTab.model.Fingers.Unknown, alphaTab.model.Fingers.NoOrDead -> 
                {
                    return null
                }
                alphaTab.model.Fingers.Thumb -> 
                {
                    return "p"
                }
                alphaTab.model.Fingers.IndexFinger -> 
                {
                    return "i"
                }
                alphaTab.model.Fingers.MiddleFinger -> 
                {
                    return "m"
                }
                alphaTab.model.Fingers.AnnularFinger -> 
                {
                    return "a"
                }
                alphaTab.model.Fingers.LittleFinger -> 
                {
                    return "c"
                }
                else -> 
                {
                    return null
                }
            }
        }
        
        /**
         * Checks if the given string is a tuning inticator.
         */
        @kotlin.jvm.JvmStatic
        public fun isTuning(name: String): Boolean{
            return !!alphaTab.core.TypeHelper.isTruthy(alphaTab.model.ModelUtils.parseTuning(name))
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun parseTuning(name: String): alphaTab.model.TuningParseResult?{
            var note: String = ""
            var octave: String = ""
            if(true) {
                var i: Double = 0.0
                
                while(i < name.length.toDouble()){
                    try{
                        var c: Double = name.charCodeAt(i)
                        if (c >= 48 && c <= 57)
                        {
                            if (!alphaTab.core.TypeHelper.isTruthy(note))
                            {
                                return null
                            }
                            octave += alphaTab.core.ecmaScript.CoreString.fromCharCode(c)
                        }
                        else if ((c >= 65 && c <= 90) || (c >= 97 && c <= 122) || c == 35.0)
                        {
                            note += alphaTab.core.ecmaScript.CoreString.fromCharCode(c)
                        }
                        else 
                        {
                            return null
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            if (!alphaTab.core.TypeHelper.isTruthy(octave) || !alphaTab.core.TypeHelper.isTruthy(note))
            {
                return null
            }
            var result: alphaTab.model.TuningParseResult = alphaTab.model.TuningParseResult()
            result.octave = alphaTab.core.Globals.parseInt(octave) + 1.0
            result.note = note.lowercase()
            result.noteValue = alphaTab.model.ModelUtils.getToneForText(result.note!!)
            return result
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getTuningForText(str: String): Double{
            var result: alphaTab.model.TuningParseResult? = alphaTab.model.ModelUtils.parseTuning(str)
            if (!alphaTab.core.TypeHelper.isTruthy(result))
            {
                return -1.0
            }
            return result.realValue
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getToneForText(note: String): Double{
            when (note.lowercase())
            {
                "c" -> 
                {
                    return 0.0
                }
                "c#", "db" -> 
                {
                    return 1.0
                }
                "d" -> 
                {
                    return 2.0
                }
                "d#", "eb" -> 
                {
                    return 3.0
                }
                "e" -> 
                {
                    return 4.0
                }
                "f" -> 
                {
                    return 5.0
                }
                "f#", "gb" -> 
                {
                    return 6.0
                }
                "g" -> 
                {
                    return 7.0
                }
                "g#", "ab" -> 
                {
                    return 8.0
                }
                "a" -> 
                {
                    return 9.0
                }
                "a#", "bb" -> 
                {
                    return 10.0
                }
                "b" -> 
                {
                    return 11.0
                }
                else -> 
                {
                    return 0.0
                }
            }
        }
        
        @kotlin.jvm.JvmStatic
        public fun newGuid(): String{
            return (alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + "-" + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + "-" + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + "-" + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + "-" + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0) + alphaTab.core.ecmaScript.Math.floor((1.0 + alphaTab.core.ecmaScript.Math.random()) * 65536.0).toInvariantString(16.0).substring(1.0))
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun isAlmostEqualTo(a: Double, b: Double): Boolean{
            return alphaTab.core.ecmaScript.Math.abs(a - b) < 0.00001
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun toHexString(n: Double, digits: Double = 0.0): String{
            var paramn = n
            var s: String = ""
            var hexChars: String = "0123456789ABCDEF"
            do
            {
                s = alphaTab.core.ecmaScript.CoreString.fromCharCode(hexChars.charCodeAt(((paramn).toInt() and 15).toDouble())) + s
                paramn = ((paramn).toInt() shr 4).toDouble()
            }
            while (paramn > 0)
            while (s.length.toDouble() < digits)
            {
                s = "0" + s
            }
            return s
        }
        
    }
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TuningParseResult
{
    public var note: String? = null
    
    public var noteValue: Double = 0.0
    
    public var octave: Double = 0.0
    
    public val realValue: Double
    get(){
        return this.octave * 12.0 + this.noteValue
    }
    
    public constructor()
}

