// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * A note is a single played sound on a fretted instrument.
 * It consists of a fret offset and a string on which the note is played on.
 * It also can be modified by a lot of different effects.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Note
{
    /**
     * Gets or sets the unique id of this note.
     */
    public var id: Double = alphaTab.model.Note.GlobalNoteId++
    
    /**
     * Gets or sets the zero-based index of this note within the beat.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the accentuation of this note.
     */
    public var accentuated: alphaTab.model.AccentuationType = alphaTab.model.AccentuationType.None
    
    /**
     * Gets or sets the bend type for this note.
     */
    public var bendType: alphaTab.model.BendType = alphaTab.model.BendType.None
    
    /**
     * Gets or sets the bend style for this note.
     */
    public var bendStyle: alphaTab.model.BendStyle = alphaTab.model.BendStyle.Default
    
    /**
     * Gets or sets the note from which this note continues the bend.
     */
    public var bendOrigin: alphaTab.model.Note? = null
    
    /**
     * Gets or sets whether this note continues a bend from a previous note.
     */
    public var isContinuedBend: Boolean = false
    
    /**
     * Gets or sets a list of the points defining the bend behavior.
     */
    public var bendPoints: alphaTab.collections.List<alphaTab.model.BendPoint>? = null
    
    /**
     * Gets or sets the bend point with the highest bend value.
     */
    public var maxBendPoint: alphaTab.model.BendPoint? = null
    
    public val hasBend: Boolean
    get(){
        return this.bendPoints != null && this.bendType != alphaTab.model.BendType.None
    }
    
    public val isStringed: Boolean
    get(){
        return this.string >= 0
    }
    
    /**
     * Gets or sets the fret on which this note is played on the instrument.
     * 0 is the nut.
     */
    public var fret: Double = -1.0
    
    /**
     * Gets or sets the string number where the note is placed.
     * 1 is the lowest string on the guitar and the bottom line on the tablature.
     * It then increases the the number of strings on available on the track.
     */
    public var string: Double = -1.0
    
    public val isPiano: Boolean
    get(){
        return !this.isStringed && this.octave >= 0 && this.tone >= 0
    }
    
    /**
     * Gets or sets the octave on which this note is played.
     */
    public var octave: Double = -1.0
    
    /**
     * Gets or sets the tone of this note within the octave.
     */
    public var tone: Double = -1.0
    
    public val isPercussion: Boolean
    get(){
        return !this.isStringed && this.percussionArticulation >= 0
    }
    
    public val element: Double
    get(){
        return if(this.isPercussion)  alphaTab.model.PercussionMapper.getElementAndVariation(this)[(0).toInt()] else -1.0
    }
    
    public val variation: Double
    get(){
        return if(this.isPercussion)  alphaTab.model.PercussionMapper.getElementAndVariation(this)[(1).toInt()] else -1.0
    }
    
    /**
     * Gets or sets the index of percussion articulation in the related `track.percussionArticulations`.
     * If the articulation is not listed in `track.percussionArticulations` the following list based on GP7 applies:
     * - 029 Ride (choke)
     * - 030 Cymbal (hit)
     * - 031 Snare (side stick)
     * - 033 Snare (side stick)
     * - 034 Snare (hit)
     * - 035 Kick (hit)
     * - 036 Kick (hit)
     * - 037 Snare (side stick)
     * - 038 Snare (hit)
     * - 039 Hand Clap (hit)
     * - 040 Snare (hit)
     * - 041 Low Floor Tom (hit)
     * - 042 Hi-Hat (closed)
     * - 043 Very Low Tom (hit)
     * - 044 Pedal Hi-Hat (hit)
     * - 045 Low Tom (hit)
     * - 046 Hi-Hat (open)
     * - 047 Mid Tom (hit)
     * - 048 High Tom (hit)
     * - 049 Crash high (hit)
     * - 050 High Floor Tom (hit)
     * - 051 Ride (middle)
     * - 052 China (hit)
     * - 053 Ride (bell)
     * - 054 Tambourine (hit)
     * - 055 Splash (hit)
     * - 056 Cowbell medium (hit)
     * - 057 Crash medium (hit)
     * - 058 Vibraslap (hit)
     * - 059 Ride (edge)
     * - 060 Hand (hit)
     * - 061 Hand (hit)
     * - 062 Conga high (mute)
     * - 063 Conga high (hit)
     * - 064 Conga low (hit)
     * - 065 Timbale high (hit)
     * - 066 Timbale low (hit)
     * - 067 Agogo high (hit)
     * - 068 Agogo tow (hit)
     * - 069 Cabasa (hit)
     * - 070 Left Maraca (hit)
     * - 071 Whistle high (hit)
     * - 072 Whistle low (hit)
     * - 073 Guiro (hit)
     * - 074 Guiro (scrap-return)
     * - 075 Claves (hit)
     * - 076 Woodblock high (hit)
     * - 077 Woodblock low (hit)
     * - 078 Cuica (mute)
     * - 079 Cuica (open)
     * - 080 Triangle (rnute)
     * - 081 Triangle (hit)
     * - 082 Shaker (hit)
     * - 083 Tinkle Bell (hat)
     * - 083 Jingle Bell (hit)
     * - 084 Bell Tree (hit)
     * - 085 Castanets (hit)
     * - 086 Surdo (hit)
     * - 087 Surdo (mute)
     * - 091 Snare (rim shot)
     * - 092 Hi-Hat (half)
     * - 093 Ride (edge)
     * - 094 Ride (choke)
     * - 095 Splash (choke)
     * - 096 China (choke)
     * - 097 Crash high (choke)
     * - 098 Crash medium (choke)
     * - 099 Cowbell low (hit)
     * - 100 Cowbell low (tip)
     * - 101 Cowbell medium (tip)
     * - 102 Cowbell high (hit)
     * - 103 Cowbell high (tip)
     * - 104 Hand (mute)
     * - 105 Hand (slap)
     * - 106 Hand (mute)
     * - 107 Hand (slap)
     * - 108 Conga low (slap)
     * - 109 Conga low (mute)
     * - 110 Conga high (slap)
     * - 111 Tambourine (return)
     * - 112 Tambourine (roll)
     * - 113 Tambourine (hand)
     * - 114 Grancassa (hit)
     * - 115 Piatti (hat)
     * - 116 Piatti (hand)
     * - 117 Cabasa (return)
     * - 118 Left Maraca (return)
     * - 119 Right Maraca (hit)
     * - 120 Right Maraca (return)
     * - 122 Shaker (return)
     * - 123 Bell Tee (return)
     * - 124 Golpe (thumb)
     * - 125 Golpe (finger)
     * - 126 Ride (middle)
     * - 127 Ride (bell)
     */
    public var percussionArticulation: Double = -1.0
    
    /**
     * Gets or sets whether this note is visible on the music sheet.
     */
    public var isVisible: Boolean = true
    
    /**
     * Gets a value indicating whether the note is left hand tapped.
     */
    public var isLeftHandTapped: Boolean = false
    
    /**
     * Gets or sets whether this note starts a hammeron or pulloff.
     */
    public var isHammerPullOrigin: Boolean = false
    
    public val isHammerPullDestination: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.hammerPullOrigin)
    }
    
    /**
     * Gets the origin of the hammeron/pulloff of this note.
     */
    public var hammerPullOrigin: alphaTab.model.Note? = null
    
    /**
     * Gets the destination for the hammeron/pullof started by this note.
     */
    public var hammerPullDestination: alphaTab.model.Note? = null
    
    public val isSlurOrigin: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.slurDestination)
    }
    
    /**
     * Gets or sets whether this note finishes a slur.
     */
    public var isSlurDestination: Boolean = false
    
    /**
     * Gets or sets the note where the slur of this note starts.
     */
    public var slurOrigin: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the note where the slur of this note ends.
     */
    public var slurDestination: alphaTab.model.Note? = null
    
    public val isHarmonic: Boolean
    get(){
        return this.harmonicType != alphaTab.model.HarmonicType.None
    }
    
    /**
     * Gets or sets the harmonic type applied to this note.
     */
    public var harmonicType: alphaTab.model.HarmonicType = alphaTab.model.HarmonicType.None
    
    /**
     * Gets or sets the value defining the harmonic pitch.
     */
    public var harmonicValue: Double = 0.0
    
    /**
     * Gets or sets whether the note is a ghost note and shown in parenthesis. Also this will make the note a bit more silent.
     */
    public var isGhost: Boolean = false
    
    /**
     * Gets or sets whether this note has a let-ring effect.
     */
    public var isLetRing: Boolean = false
    
    /**
     * Gets or sets the destination note for the let-ring effect.
     */
    public var letRingDestination: alphaTab.model.Note? = null
    
    /**
     * Gets or sets whether this note has a palm-mute effect.
     */
    public var isPalmMute: Boolean = false
    
    /**
     * Gets or sets the destination note for the palm-mute effect.
     */
    public var palmMuteDestination: alphaTab.model.Note? = null
    
    /**
     * Gets or sets whether the note is shown and played as dead note.
     */
    public var isDead: Boolean = false
    
    /**
     * Gets or sets whether the note is played as staccato.
     */
    public var isStaccato: Boolean = false
    
    /**
     * Gets or sets the slide-in type this note is played with.
     */
    public var slideInType: alphaTab.model.SlideInType = alphaTab.model.SlideInType.None
    
    /**
     * Gets or sets the slide-out type this note is played with.
     */
    public var slideOutType: alphaTab.model.SlideOutType = alphaTab.model.SlideOutType.None
    
    /**
     * Gets or sets the target note for several slide types.
     */
    public var slideTarget: alphaTab.model.Note? = null
    
    /**
     * Gets or sets the source note for several slide types.
     */
    public var slideOrigin: alphaTab.model.Note? = null
    
    /**
     * Gets or sets whether a vibrato is played on the note.
     */
    public var vibrato: alphaTab.model.VibratoType = alphaTab.model.VibratoType.None
    
    /**
     * Gets the origin of the tied if this note is tied.
     */
    public var tieOrigin: alphaTab.model.Note? = null
    
    /**
     * Gets the desination of the tie.
     */
    public var tieDestination: alphaTab.model.Note? = null
    
    /**
     * Gets or sets whether this note is ends a tied note.
     */
    public var isTieDestination: Boolean = false
    
    public val isTieOrigin: Boolean
    get(){
        return this.tieDestination != null
    }
    
    /**
     * Gets or sets the fingers used for this note on the left hand.
     */
    public var leftHandFinger: alphaTab.model.Fingers = alphaTab.model.Fingers.Unknown
    
    /**
     * Gets or sets the fingers used for this note on the right hand.
     */
    public var rightHandFinger: alphaTab.model.Fingers = alphaTab.model.Fingers.Unknown
    
    /**
     * Gets or sets whether this note has fingering defined.
     */
    public var isFingering: Boolean = false
    
    /**
     * Gets or sets the target note value for the trill effect.
     */
    public var trillValue: Double = -1.0
    
    public val trillFret: Double
    get(){
        return this.trillValue - this.stringTuning
    }
    
    public val isTrill: Boolean
    get(){
        return this.trillValue >= 0
    }
    
    /**
     * Gets or sets the speed of the trill effect.
     */
    public var trillSpeed: alphaTab.model.Duration = alphaTab.model.Duration.ThirtySecond
    
    /**
     * Gets or sets the percentual duration of the note relative to the overall beat duration .
     */
    public var durationPercent: Double = 1.0
    
    /**
     * Gets or sets how accidetnals for this note should  be handled.
     */
    public var accidentalMode: alphaTab.model.NoteAccidentalMode = alphaTab.model.NoteAccidentalMode.Default
    
    /**
     * Gets or sets the reference to the parent beat to which this note belongs to.
     */
    public lateinit var beat: alphaTab.model.Beat
    /**
     * Gets or sets the dynamics for this note.
     */
    public var dynamics: alphaTab.model.DynamicValue = alphaTab.model.DynamicValue.F
    
    public var isEffectSlurOrigin: Boolean = false
    
    public var hasEffectSlur: Boolean = false
    
    public val isEffectSlurDestination: Boolean
    get(){
        return !!alphaTab.core.TypeHelper.isTruthy(this.effectSlurOrigin)
    }
    
    public var effectSlurOrigin: alphaTab.model.Note? = null
    
    public var effectSlurDestination: alphaTab.model.Note? = null
    
    public val stringTuning: Double
    get(){
        return this.beat.voice.bar.staff.capo + alphaTab.model.Note.getStringTuning(this.beat.voice.bar.staff, this.string)
    }
    
    public val realValue: Double
    get(){
        return this.calculateRealValue(true, true)
    }
    
    public val realValueWithoutHarmonic: Double
    get(){
        return this.calculateRealValue(true, false)
    }
    
    /**
     * Calculates the real note value of this note as midi key respecting the given options.
     * @param applyTranspositionPitch Whether or not to apply the transposition pitch of the current staff.
     * @param applyHarmonic Whether or not to apply harmonic pitches to the note.
     */
    public fun calculateRealValue(applyTranspositionPitch: Boolean, applyHarmonic: Boolean): Double{
        var transpositionPitch: Double = if(applyTranspositionPitch)  this.beat.voice.bar.staff.transpositionPitch else 0.0
        if (applyHarmonic)
        {
            var realValue: Double = this.calculateRealValue(applyTranspositionPitch, false)
            if (this.isStringed)
            {
                if (this.harmonicType == alphaTab.model.HarmonicType.Natural)
                {
                    realValue = this.harmonicPitch + this.stringTuning - transpositionPitch
                }
                else 
                {
                    realValue += this.harmonicPitch
                }
            }
            return realValue
        }
        else 
        {
            if (this.isPercussion)
            {
                return this.percussionArticulation
            }
            if (this.isStringed)
            {
                return this.fret + this.stringTuning - transpositionPitch
            }
            if (this.isPiano)
            {
                return this.octave * 12.0 + this.tone - transpositionPitch
            }
            return 0.0
        }
    }
    
    public val harmonicPitch: Double
    get(){
        if (this.harmonicType == alphaTab.model.HarmonicType.None || !this.isStringed)
        {
            return 0.0
        }
        var value: Double = this.harmonicValue
        if (alphaTab.model.ModelUtils.isAlmostEqualTo(value, 2.4))
        {
            return 36.0
        }
        if (alphaTab.model.ModelUtils.isAlmostEqualTo(value, 2.7))
        {
            return 34.0
        }
        if (value < 3)
        {
            return 0.0
        }
        if (value <= 3.5)
        {
            return 31.0
        }
        if (value <= 4)
        {
            return 28.0
        }
        if (value <= 5)
        {
            return 24.0
        }
        if (value <= 6)
        {
            return 34.0
        }
        if (value <= 7)
        {
            return 19.0
        }
        if (value <= 8.5)
        {
            return 36.0
        }
        if (value <= 9)
        {
            return 28.0
        }
        if (value <= 10)
        {
            return 34.0
        }
        if (value <= 11)
        {
            return 0.0
        }
        if (value <= 12)
        {
            return 12.0
        }
        if (value < 14)
        {
            return 0.0
        }
        if (value <= 15)
        {
            return 34.0
        }
        if (value <= 16)
        {
            return 28.0
        }
        if (value <= 17)
        {
            return 36.0
        }
        if (value <= 18)
        {
            return 0.0
        }
        if (value <= 19)
        {
            return 19.0
        }
        if (value <= 21)
        {
            return 0.0
        }
        if (value <= 22)
        {
            return 36.0
        }
        if (value <= 24)
        {
            return 24.0
        }
        return 0.0
    }
    
    public val initialBendValue: Double
    get(){
        if (this.hasBend)
        {
            return alphaTab.core.ecmaScript.Math.floor(this.bendPoints!![(0).toInt()].value / (2.0).toDouble())
        }
        else if (alphaTab.core.TypeHelper.isTruthy(this.bendOrigin))
        {
            return alphaTab.core.ecmaScript.Math.floor(this.bendOrigin!!.bendPoints!![(this.bendOrigin!!.bendPoints!!.length - 1.0).toInt()].value / (2.0).toDouble())
        }
        else if (this.isTieDestination && alphaTab.core.TypeHelper.isTruthy(this.tieOrigin!!.bendOrigin))
        {
            return alphaTab.core.ecmaScript.Math.floor(this.tieOrigin!!.bendOrigin!!.bendPoints!![(this.tieOrigin!!.bendOrigin!!.bendPoints!!.length - 1.0).toInt()].value / (2.0).toDouble())
        }
        else if (this.beat.hasWhammyBar)
        {
            return alphaTab.core.ecmaScript.Math.floor(this.beat.whammyBarPoints!![(0).toInt()].value / (2.0).toDouble())
        }
        else if (this.beat.isContinuedWhammy)
        {
            return alphaTab.core.ecmaScript.Math.floor(this.beat.previousBeat!!.whammyBarPoints!![(this.beat.previousBeat!!.whammyBarPoints!!.length - 1.0).toInt()].value / (2.0).toDouble())
        }
        return 0.0
    }
    
    public val displayValue: Double
    get(){
        return this.displayValueWithoutBend + this.initialBendValue
    }
    
    public val displayValueWithoutBend: Double
    get(){
        var noteValue: Double = this.realValue
        if (this.harmonicType != alphaTab.model.HarmonicType.Natural && this.harmonicType != alphaTab.model.HarmonicType.None)
        {
            noteValue -= this.harmonicPitch
        }
        when (this.beat.ottava)
        {
            alphaTab.model.Ottavia._15ma -> 
            {
                noteValue -= 24.0
            }
            alphaTab.model.Ottavia._8va -> 
            {
                noteValue -= 12.0
            }
            alphaTab.model.Ottavia.Regular -> 
            {
            }
            alphaTab.model.Ottavia._8vb -> 
            {
                noteValue += 12.0
            }
            alphaTab.model.Ottavia._15mb -> 
            {
                noteValue += 24.0
            }
            else -> { }
        }
        when (this.beat.voice.bar.clefOttava)
        {
            alphaTab.model.Ottavia._15ma -> 
            {
                noteValue -= 24.0
            }
            alphaTab.model.Ottavia._8va -> 
            {
                noteValue -= 12.0
            }
            alphaTab.model.Ottavia.Regular -> 
            {
            }
            alphaTab.model.Ottavia._8vb -> 
            {
                noteValue += 12.0
            }
            alphaTab.model.Ottavia._15mb -> 
            {
                noteValue += 24.0
            }
            else -> { }
        }
        return noteValue - this.beat.voice.bar.staff.displayTranspositionPitch
    }
    
    public val hasQuarterToneOffset: Boolean
    get(){
        if (this.hasBend)
        {
            return this.bendPoints!![(0).toInt()].value % 2.0 != 0.0
        }
        if (alphaTab.core.TypeHelper.isTruthy(this.bendOrigin))
        {
            return this.bendOrigin!!.bendPoints!![(this.bendOrigin!!.bendPoints!!.length - 1.0).toInt()].value % 2.0 != 0.0
        }
        if (this.beat.hasWhammyBar)
        {
            return this.beat.whammyBarPoints!![(0).toInt()].value % 2.0 != 0.0
        }
        if (this.beat.isContinuedWhammy)
        {
            return (this.beat.previousBeat!!.whammyBarPoints!![(this.beat.previousBeat!!.whammyBarPoints!!.length - 1.0).toInt()].value % 2.0 != 0.0)
        }
        return false
    }
    
    /**
     */
    public fun addBendPoint(point: alphaTab.model.BendPoint): Unit{
        var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = this.bendPoints
        if (points == null)
        {
            points = alphaTab.collections.List(
            )
            
            this.bendPoints = points
        }
        points.push(point)
        if (!alphaTab.core.TypeHelper.isTruthy(this.maxBendPoint) || point.value > this.maxBendPoint!!.value)
        {
            this.maxBendPoint = point
        }
        if (this.bendType == alphaTab.model.BendType.None)
        {
            this.bendType = alphaTab.model.BendType.Custom
        }
    }
    
    /**
     */
    public fun finish(settings: alphaTab.Settings, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        var nextNoteOnLine: alphaTab.util.Lazy<alphaTab.model.Note?> = alphaTab.util.Lazy<alphaTab.model.Note?>(fun(): alphaTab.model.Note?{
            return alphaTab.model.Note.nextNoteOnSameLine(this)
        }
        )
        var isSongBook: Boolean = alphaTab.core.TypeHelper.isTruthy(settings) && settings.notation.notationMode == alphaTab.NotationMode.SongBook
        if (this.isTieDestination)
        {
            this.chain(sharedDataBag)
            if (isSongBook && alphaTab.core.TypeHelper.isTruthy(this.tieOrigin) && this.tieOrigin!!.isLetRing)
            {
                this.isLetRing = true
            }
        }
        if (this.isLetRing)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(nextNoteOnLine.value) || !nextNoteOnLine.value!!.isLetRing)
            {
                this.letRingDestination = this
            }
            else 
            {
                this.letRingDestination = nextNoteOnLine.value
            }
            if (isSongBook && this.isTieDestination && !this.tieOrigin!!.hasBend)
            {
                this.isVisible = false
            }
        }
        if (this.isPalmMute)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(nextNoteOnLine.value) || !nextNoteOnLine.value!!.isPalmMute)
            {
                this.palmMuteDestination = this
            }
            else 
            {
                this.palmMuteDestination = nextNoteOnLine.value
            }
        }
        if (this.isHammerPullOrigin)
        {
            var hammerPullDestination: alphaTab.model.Note? = alphaTab.model.Note.findHammerPullDestination(this)
            if (!alphaTab.core.TypeHelper.isTruthy(hammerPullDestination))
            {
                this.isHammerPullOrigin = false
            }
            else 
            {
                this.hammerPullDestination = hammerPullDestination
                hammerPullDestination.hammerPullOrigin = this
            }
        }
        when (this.slideOutType)
        {
            alphaTab.model.SlideOutType.Shift, alphaTab.model.SlideOutType.Legato -> 
            {
                this.slideTarget = nextNoteOnLine.value
                if (!alphaTab.core.TypeHelper.isTruthy(this.slideTarget))
                {
                    this.slideOutType = alphaTab.model.SlideOutType.None
                }
                else 
                {
                    this.slideTarget!!.slideOrigin = this
                }
            }
            else -> { }
        }
        var effectSlurDestination: alphaTab.model.Note? = null
        if (this.isHammerPullOrigin && alphaTab.core.TypeHelper.isTruthy(this.hammerPullDestination))
        {
            effectSlurDestination = this.hammerPullDestination
        }
        else if (this.slideOutType == alphaTab.model.SlideOutType.Legato && alphaTab.core.TypeHelper.isTruthy(this.slideTarget))
        {
            effectSlurDestination = this.slideTarget
        }
        if (alphaTab.core.TypeHelper.isTruthy(effectSlurDestination))
        {
            this.hasEffectSlur = true
            if (alphaTab.core.TypeHelper.isTruthy(this.effectSlurOrigin) && this.beat.pickStroke == alphaTab.model.PickStroke.None)
            {
                this.effectSlurOrigin!!.effectSlurDestination = effectSlurDestination
                this.effectSlurOrigin!!.effectSlurDestination!!.effectSlurOrigin = this.effectSlurOrigin
                this.effectSlurOrigin = null
            }
            else 
            {
                this.isEffectSlurOrigin = true
                this.effectSlurDestination = effectSlurDestination
                this.effectSlurDestination!!.effectSlurOrigin = this
            }
        }
        var points: alphaTab.collections.List<alphaTab.model.BendPoint>? = this.bendPoints
        if (points != null && points.length > 0 && this.bendType == alphaTab.model.BendType.Custom)
        {
            var isContinuedBend: Boolean = this.isTieDestination && this.tieOrigin!!.hasBend
            this.isContinuedBend = isContinuedBend
            if (points.length == 4.0)
            {
                var origin: alphaTab.model.BendPoint = points[(0).toInt()]
                var middle1: alphaTab.model.BendPoint = points[(1).toInt()]
                var middle2: alphaTab.model.BendPoint = points[(2).toInt()]
                var destination: alphaTab.model.BendPoint = points[(3).toInt()]
                if (middle1.value == middle2.value)
                {
                    if (destination.value > origin.value)
                    {
                        if (middle1.value > destination.value)
                        {
                            this.bendType = alphaTab.model.BendType.BendRelease
                        }
                        else if (!isContinuedBend && origin.value > 0)
                        {
                            this.bendType = alphaTab.model.BendType.PrebendBend
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                        else 
                        {
                            this.bendType = alphaTab.model.BendType.Bend
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                    }
                    else if (destination.value < origin.value)
                    {
                        if (isContinuedBend)
                        {
                            this.bendType = alphaTab.model.BendType.Release
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                        else 
                        {
                            this.bendType = alphaTab.model.BendType.PrebendRelease
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                    }
                    else 
                    {
                        if (middle1.value > origin.value)
                        {
                            this.bendType = alphaTab.model.BendType.BendRelease
                        }
                        else if (origin.value > 0 && !isContinuedBend)
                        {
                            this.bendType = alphaTab.model.BendType.Prebend
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                        else 
                        {
                            this.bendType = alphaTab.model.BendType.Hold
                            points.splice(2.0, 1.0)
                            points.splice(1.0, 1.0)
                        }
                    }
                }
                else 
                {
                    alphaTab.Logger.warning("Model", "Unsupported bend type detected, fallback to custom", null)
                }
            }
            else if (points.length == 2.0)
            {
                var origin: alphaTab.model.BendPoint = points[(0).toInt()]
                var destination: alphaTab.model.BendPoint = points[(1).toInt()]
                if (destination.value > origin.value)
                {
                    if (!isContinuedBend && origin.value > 0)
                    {
                        this.bendType = alphaTab.model.BendType.PrebendBend
                    }
                    else 
                    {
                        this.bendType = alphaTab.model.BendType.Bend
                    }
                }
                else if (destination.value < origin.value)
                {
                    if (isContinuedBend)
                    {
                        this.bendType = alphaTab.model.BendType.Release
                    }
                    else 
                    {
                        this.bendType = alphaTab.model.BendType.PrebendRelease
                    }
                }
                else 
                {
                    this.bendType = alphaTab.model.BendType.Hold
                }
            }
        }
        else if (points == null || points.length == 0.0)
        {
            this.bendType = alphaTab.model.BendType.None
        }
        if (this.initialBendValue > 0)
        {
            this.accidentalMode = alphaTab.model.NoteAccidentalMode.Default
        }
    }
    
    private var _noteIdBag: alphaTab.model.NoteIdBag? = null
    
    /**
     */
    public fun chain(sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        if (sharedDataBag == null)
        {
            return
        }
        if (this._noteIdBag != null)
        {
            var noteIdLookup: alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>
            if (sharedDataBag.has(alphaTab.model.Note.NoteIdLookupKey))
            {
                noteIdLookup = (sharedDataBag.get(alphaTab.model.Note.NoteIdLookupKey) as alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>)
            }
            else 
            {
                noteIdLookup = alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>()
                sharedDataBag.set(alphaTab.model.Note.NoteIdLookupKey, ((noteIdLookup as Any?)))
            }
            if (this._noteIdBag!!.hammerPullDestinationNoteId != -1.0 || this._noteIdBag!!.tieDestinationNoteId != -1.0 || this._noteIdBag!!.slurDestinationNoteId != -1.0)
            {
                noteIdLookup.set(this.id, this)
            }
            if (this._noteIdBag!!.hammerPullOriginNoteId != -1.0)
            {
                this.hammerPullOrigin = noteIdLookup.get(this._noteIdBag!!.hammerPullOriginNoteId)!!
                this.hammerPullOrigin!!.hammerPullDestination = this
            }
            if (this._noteIdBag!!.tieOriginNoteId != -1.0)
            {
                this.tieOrigin = noteIdLookup.get(this._noteIdBag!!.tieOriginNoteId)!!
                this.tieOrigin!!.tieDestination = this
            }
            if (this._noteIdBag!!.slurOriginNoteId != -1.0)
            {
                this.slurOrigin = noteIdLookup.get(this._noteIdBag!!.slurOriginNoteId)!!
                this.slurOrigin!!.slurDestination = this
            }
            this._noteIdBag = null
        }
        else 
        {
            if (!this.isTieDestination && this.tieOrigin == null)
            {
                return
            }
            var tieOrigin: alphaTab.model.Note? = this.tieOrigin ?: alphaTab.model.Note.findTieOrigin(this)
            if (!alphaTab.core.TypeHelper.isTruthy(tieOrigin))
            {
                this.isTieDestination = false
            }
            else 
            {
                tieOrigin.tieDestination = this
                this.tieOrigin = tieOrigin
                this.fret = tieOrigin.fret
                this.octave = tieOrigin.octave
                this.tone = tieOrigin.tone
                if (tieOrigin.hasBend)
                {
                    this.bendOrigin = this.tieOrigin
                }
            }
        }
    }
    
    /**
     */
    internal fun toJson(o: alphaTab.collections.Map<String, Any?>): Unit{
        if (this.tieDestination != null)
        {
            o.set("tiedestinationnoteid", ((this.tieDestination!!.id as Any?)))
        }
        if (this.tieOrigin != null)
        {
            o.set("tieoriginnoteid", ((this.tieOrigin!!.id as Any?)))
        }
        if (this.slurDestination != null)
        {
            o.set("slurdestinationnoteid", ((this.slurDestination!!.id as Any?)))
        }
        if (this.slurOrigin != null)
        {
            o.set("sluroriginnoteid", ((this.slurOrigin!!.id as Any?)))
        }
        if (this.hammerPullOrigin != null)
        {
            o.set("hammerpulloriginnoteid", ((this.hammerPullOrigin!!.id as Any?)))
        }
        if (this.hammerPullDestination != null)
        {
            o.set("hammerpulldestinationnoteid", ((this.hammerPullDestination!!.id as Any?)))
        }
    }
    
    /**
     */
    internal fun setProperty(property: String, v: Any?): Boolean{
        when (property)
        {
            "tiedestinationnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.tieDestinationNoteId = v.toDouble()
                return true
            }
            "tieoriginnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.tieOriginNoteId = v.toDouble()
                return true
            }
            "slurdestinationnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.slurDestinationNoteId = v.toDouble()
                return true
            }
            "sluroriginnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.slurOriginNoteId = v.toDouble()
                return true
            }
            "hammerpulloriginnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.hammerPullOriginNoteId = v.toDouble()
                return true
            }
            "hammerpulldestinationnoteid" -> 
            {
                if (this._noteIdBag == null)
                {
                    this._noteIdBag = alphaTab.model.NoteIdBag()
                }
                this._noteIdBag!!.hammerPullDestinationNoteId = v.toDouble()
                return true
            }
            else -> { }
        }
        return false
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public var GlobalNoteId: Double = 0.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getStringTuning(staff: alphaTab.model.Staff, noteString: Double): Double{
            if (staff.tuning.length > 0)
            {
                return staff.tuning[(staff.tuning.length - (noteString - 1.0) - 1.0).toInt()]
            }
            return 0.0
        }
        
        @kotlin.jvm.JvmStatic
        private val MaxOffsetForSameLineSearch: Double = 3.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun nextNoteOnSameLine(note: alphaTab.model.Note): alphaTab.model.Note?{
            var nextBeat: alphaTab.model.Beat? = note.beat.nextBeat
            while (alphaTab.core.TypeHelper.isTruthy(nextBeat) && nextBeat.voice.bar.index <= note.beat.voice.bar.index + alphaTab.model.Note.MaxOffsetForSameLineSearch)
            {
                var noteOnString: alphaTab.model.Note? = nextBeat.getNoteOnString(note.string)
                if (alphaTab.core.TypeHelper.isTruthy(noteOnString))
                {
                    return noteOnString
                }
                nextBeat = nextBeat.nextBeat
            }
            return null
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun findHammerPullDestination(note: alphaTab.model.Note): alphaTab.model.Note?{
            var nextBeat: alphaTab.model.Beat? = note.beat.nextBeat
            while (alphaTab.core.TypeHelper.isTruthy(nextBeat) && nextBeat.voice.bar.index <= note.beat.voice.bar.index + alphaTab.model.Note.MaxOffsetForSameLineSearch)
            {
                var noteOnString: alphaTab.model.Note? = nextBeat.getNoteOnString(note.string)
                if (alphaTab.core.TypeHelper.isTruthy(noteOnString))
                {
                    return noteOnString
                }
                if(true) {
                    var str: Double = note.string
                    
                    while(str > 0){
                        try{
                            noteOnString = nextBeat.getNoteOnString(str)
                            if (alphaTab.core.TypeHelper.isTruthy(noteOnString))
                            {
                                if (noteOnString.isLeftHandTapped)
                                {
                                    return noteOnString
                                }
                                else 
                                {
                                    break
                                }
                            }
                        }
                        finally{
                            str--
                        }
                    }
                }
                if(true) {
                    var str: Double = note.string
                    
                    while(str <= note.beat.voice.bar.staff.tuning.length){
                        try{
                            noteOnString = nextBeat.getNoteOnString(str)
                            if (alphaTab.core.TypeHelper.isTruthy(noteOnString))
                            {
                                if (noteOnString.isLeftHandTapped)
                                {
                                    return noteOnString
                                }
                                else 
                                {
                                    break
                                }
                            }
                        }
                        finally{
                            str++
                        }
                    }
                }
                nextBeat = nextBeat.nextBeat
            }
            return null
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun findTieOrigin(note: alphaTab.model.Note): alphaTab.model.Note?{
            var previousBeat: alphaTab.model.Beat? = note.beat.previousBeat
            while (alphaTab.core.TypeHelper.isTruthy(previousBeat) && previousBeat.voice.bar.index >= note.beat.voice.bar.index - alphaTab.model.Note.MaxOffsetForSameLineSearch)
            {
                if (note.isStringed)
                {
                    var noteOnString: alphaTab.model.Note? = previousBeat.getNoteOnString(note.string)
                    if (alphaTab.core.TypeHelper.isTruthy(noteOnString))
                    {
                        return noteOnString
                    }
                }
                else 
                {
                    if (note.octave == -1.0 && note.tone == -1.0)
                    {
                        if (note.index < previousBeat.notes.length)
                        {
                            return previousBeat.notes[(note.index).toInt()]
                        }
                    }
                    else 
                    {
                        var noteWithValue: alphaTab.model.Note? = previousBeat.getNoteWithRealValue(note.realValue)
                        if (alphaTab.core.TypeHelper.isTruthy(noteWithValue))
                        {
                            return noteWithValue
                        }
                    }
                }
                previousBeat = previousBeat.previousBeat
            }
            return null
        }
        
        @kotlin.jvm.JvmStatic
        private var NoteIdLookupKey: String = "NoteIdLookup"
        
    }
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class NoteIdBag
{
    public var tieDestinationNoteId: Double = -1.0
    
    public var tieOriginNoteId: Double = -1.0
    
    public var slurDestinationNoteId: Double = -1.0
    
    public var slurOriginNoteId: Double = -1.0
    
    public var hammerPullDestinationNoteId: Double = -1.0
    
    public var hammerPullOriginNoteId: Double = -1.0
    
    public constructor()
}

