// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * This class describes a single staff within a track. There are instruments like pianos
 * where a single track can contain multiple staffs.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Staff
{
    /**
     * Gets or sets the zero-based index of this staff within the track.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the reference to the track this staff belongs to.
     */
    public lateinit var track: alphaTab.model.Track
    /**
     * Gets or sets a list of all bars contained in this staff.
     */
    public var bars: alphaTab.collections.List<alphaTab.model.Bar> = alphaTab.collections.List<alphaTab.model.Bar>(
    )
    
    
    /**
     * Gets or sets a list of all chords defined for this staff.  refers to entries in this lookup.
     */
    public var chords: alphaTab.collections.Map<String, alphaTab.model.Chord>? = null
    
    /**
     * Gets or sets the fret on which a capo is set.
     */
    public var capo: Double = 0.0
    
    /**
     * Gets or sets the number of semitones this track should be
     * transposed. This applies to rendering and playback.
     */
    public var transpositionPitch: Double = 0.0
    
    /**
     * Gets or sets the number of semitones this track should be
     * transposed. This applies only to rendering.
     */
    public var displayTranspositionPitch: Double = 0.0
    
    /**
     * Get or set the guitar tuning of the guitar. This tuning also indicates the number of strings shown in the
     * guitar tablature. Unlike the  property this array directly represents
     * the order of the tracks shown in the tablature. The first item is the most top tablature line.
     */
    public var stringTuning: alphaTab.model.Tuning = alphaTab.model.Tuning("", alphaTab.collections.DoubleList(
    )
    , false)
    
    public val tuning: alphaTab.collections.DoubleList
    get(){
        return this.stringTuning.tunings
    }
    
    public val tuningName: String
    get(){
        return this.stringTuning.name
    }
    
    public val isStringed: Boolean
    get(){
        return this.stringTuning.tunings.length > 0
    }
    
    /**
     * Gets or sets whether the tabs are shown.
     */
    public var showTablature: Boolean = true
    
    /**
     * Gets or sets whether the standard notation is shown.
     */
    public var showStandardNotation: Boolean = true
    
    /**
     * Gets or sets whether the staff contains percussion notation
     */
    public var isPercussion: Boolean = false
    
    /**
     * The number of lines shown for the standard notation.
     * For some percussion instruments this number might vary.
     */
    public var standardNotationLineCount: Double = 5.0
    
    /**
     */
    public fun finish(settings: alphaTab.Settings, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        this.stringTuning.finish()
        if(true) {
            var i: Double = 0.0
            var j: Double = this.bars.length
            
            while(i < j){
                try{
                    this.bars[(i).toInt()].finish(settings, sharedDataBag)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun addChord(chordId: String, chord: alphaTab.model.Chord): Unit{
        chord.staff = this
        var chordMap: alphaTab.collections.Map<String, alphaTab.model.Chord>? = this.chords
        if (chordMap == null)
        {
            chordMap = alphaTab.collections.Map<String, alphaTab.model.Chord>()
            this.chords = chordMap
        }
        chordMap.set(chordId, chord)
    }
    
    /**
     */
    public fun hasChord(chordId: String): Boolean{
        return this.chords?.has(chordId) ?: false
    }
    
    /**
     */
    public fun getChord(chordId: String): alphaTab.model.Chord?{
        return this.chords?.get(chordId) 
    }
    
    /**
     */
    public fun addBar(bar: alphaTab.model.Bar): Unit{
        var bars: alphaTab.collections.List<alphaTab.model.Bar> = this.bars
        bar.staff = this
        bar.index = bars.length
        if (bars.length > 0)
        {
            bar.previousBar = bars[(bars.length - 1.0).toInt()]
            bar.previousBar!!.nextBar = bar
        }
        bars.push(bar)
    }
    
    public constructor()
}

