// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * This public class describes a single track or instrument of score.
 * It is bascially a list of staffs containing individual music notation kinds.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Track
{
    /**
     * Gets or sets the zero-based index of this track.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the reference this track belongs to.
     */
    public lateinit var score: alphaTab.model.Score
    /**
     * Gets or sets the list of staffs that are defined for this track.
     */
    public var staves: alphaTab.collections.List<alphaTab.model.Staff> = alphaTab.collections.List<alphaTab.model.Staff>(
    )
    
    
    /**
     * Gets or sets the playback information for this track.
     */
    public var playbackInfo: alphaTab.model.PlaybackInformation = alphaTab.model.PlaybackInformation()
    
    /**
     * Gets or sets the display color defined for this track.
     */
    public var color: alphaTab.model.Color = alphaTab.model.Color(200.0, 0.0, 0.0, 255.0)
    
    /**
     * Gets or sets the long name of this track.
     */
    public var name: String = ""
    
    /**
     * Gets or sets the short name of this track.
     */
    public var shortName: String = ""
    
    /**
     * Defines how many bars are placed into the systems (rows) when displaying
     * the track unless a value is set in the systemsLayout.
     */
    public var defaultSystemsLayout: Double = 3.0
    
    /**
     * Defines how many bars are placed into the systems (rows) when displaying
     * the track.
     */
    public var systemsLayout: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
    )
    
    
    /**
     * Gets or sets a mapping on which staff liens particular percussion instruments
     * should be shown.
     */
    public var percussionArticulations: alphaTab.collections.List<alphaTab.model.InstrumentArticulation> = alphaTab.collections.List<alphaTab.model.InstrumentArticulation>(
    )
    
    
    /**
     */
    public fun ensureStaveCount(staveCount: Double): Unit{
        while (this.staves.length < staveCount)
        {
            this.addStaff(alphaTab.model.Staff())
        }
    }
    
    /**
     */
    public fun addStaff(staff: alphaTab.model.Staff): Unit{
        staff.index = this.staves.length
        staff.track = this
        this.staves.push(staff)
    }
    
    /**
     */
    public fun finish(settings: alphaTab.Settings, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.shortName))
        {
            this.shortName = this.name
            if (this.shortName.length.toDouble() > alphaTab.model.Track.ShortNameMaxLength)
            {
                this.shortName = this.shortName.substr(0.0, alphaTab.model.Track.ShortNameMaxLength)
            }
        }
        if(true) {
            var i: Double = 0.0
            var j: Double = this.staves.length
            
            while(i < j){
                try{
                    this.staves[(i).toInt()].finish(settings, sharedDataBag)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun applyLyrics(lyrics: alphaTab.collections.List<alphaTab.model.Lyrics>): Unit{
        for (lyric in lyrics)
        {
            lyric.finish()
        }
        var staff: alphaTab.model.Staff = this.staves[(0).toInt()]
        if(true) {
            var li: Double = 0.0
            
            while(li < lyrics.length){
                try{
                    var lyric: alphaTab.model.Lyrics = lyrics[(li).toInt()]
                    if (lyric.startBar >= 0 && lyric.startBar < staff.bars.length)
                    {
                        var beat: alphaTab.model.Beat? = staff.bars[(lyric.startBar).toInt()].voices[(0).toInt()].beats[(0).toInt()]
                        if(true) {
                            var ci: Double = 0.0
                            
                            while(ci < lyric.chunks.length && alphaTab.core.TypeHelper.isTruthy(beat)){
                                try{
                                    while (alphaTab.core.TypeHelper.isTruthy(beat) && (beat.isEmpty || beat.isRest))
                                    {
                                        beat = beat.nextBeat
                                    }
                                    if (alphaTab.core.TypeHelper.isTruthy(beat))
                                    {
                                        if (!alphaTab.core.TypeHelper.isTruthy(beat.lyrics))
                                        {
                                            beat.lyrics = alphaTab.collections.List<String>((lyrics.length).toInt())
                                            beat.lyrics!!.fill("")
                                        }
                                        beat.lyrics!![(li).toInt()] = lyric.chunks[(ci).toInt()]
                                        beat = beat.nextBeat
                                    }
                                }
                                finally{
                                    ci++
                                }
                            }
                        }
                    }
                }
                finally{
                    li++
                }
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val ShortNameMaxLength: Double = 10.0
        
    }
    public constructor()
}

