// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * This public class represents a predefined string tuning.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Tuning
{
    /**
     * Gets or sets whether this is the standard tuning for this number of strings.
     */
    public var isStandard: Boolean
    /**
     * Gets or sets the name of the tuning.
     */
    public var name: String
    /**
     * Gets or sets the values for each string of the instrument.
     */
    public var tunings: alphaTab.collections.DoubleList
    public constructor(name: String = "", tuning: alphaTab.collections.DoubleList? = null, isStandard: Boolean = false){
        this.isStandard = isStandard
        this.name = name
        this.tunings = tuning ?: alphaTab.collections.DoubleList(
        )
        
    }
    
    /**
     * Tries to detect the name and standard flag of the tuning from a known tuning list based
     * on the string values.
     */
    public fun finish(): Unit{
        var knownTuning: alphaTab.model.Tuning? = alphaTab.model.Tuning.findTuning(this.tunings)
        if (alphaTab.core.TypeHelper.isTruthy(knownTuning))
        {
            this.name = knownTuning.name
            this.isStandard = knownTuning.isStandard
        }
        this.name = this.name.trim()
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private var _sevenStrings: alphaTab.collections.List<alphaTab.model.Tuning> = alphaTab.collections.List<alphaTab.model.Tuning>(
        )
        
        
        @kotlin.jvm.JvmStatic
        private var _sixStrings: alphaTab.collections.List<alphaTab.model.Tuning> = alphaTab.collections.List<alphaTab.model.Tuning>(
        )
        
        
        @kotlin.jvm.JvmStatic
        private var _fiveStrings: alphaTab.collections.List<alphaTab.model.Tuning> = alphaTab.collections.List<alphaTab.model.Tuning>(
        )
        
        
        @kotlin.jvm.JvmStatic
        private var _fourStrings: alphaTab.collections.List<alphaTab.model.Tuning> = alphaTab.collections.List<alphaTab.model.Tuning>(
        )
        
        
        @kotlin.jvm.JvmStatic
        private var _defaultTunings: alphaTab.collections.DoubleObjectMap<alphaTab.model.Tuning> = alphaTab.collections.DoubleObjectMap<alphaTab.model.Tuning>()
        
        @kotlin.jvm.JvmStatic
        public var defaultAccidentals: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
            
            "", 
            "#", 
            "", 
            "#", 
            "", 
            "", 
            "#", 
            "", 
            "#", 
            "", 
            "#", 
            "")
        
        
        @kotlin.jvm.JvmStatic
        public var defaultSteps: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
            
            "C", 
            "C", 
            "D", 
            "D", 
            "E", 
            "F", 
            "F", 
            "G", 
            "G", 
            "A", 
            "A", 
            "B")
        
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getTextForTuning(tuning: Double, includeOctave: Boolean): String{
            var parts: alphaTab.collections.List<String> = alphaTab.model.Tuning.getTextPartsForTuning(tuning)
            return if(includeOctave)  parts.join("") else parts[(0).toInt()]
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getTextPartsForTuning(tuning: Double, octaveShift: Double = -1.0): alphaTab.collections.List<String>{
            var octave: Double = (((tuning / (12.0).toDouble())).toInt() or 0).toDouble()
            var note: Double = tuning % 12.0
            var notes: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
                
                "C", 
                "Db", 
                "D", 
                "Eb", 
                "E", 
                "F", 
                "Gb", 
                "G", 
                "Ab", 
                "A", 
                "Bb", 
                "B")
            
            return alphaTab.collections.List<String>(
                notes[(note).toInt()], (octave + octaveShift).toInvariantString())
            
        }
        
        /**
         * Gets the default tuning for the given string count.
         * @param stringCount The string count.
         */
        @kotlin.jvm.JvmStatic
        public fun getDefaultTuningFor(stringCount: Double): alphaTab.model.Tuning?{
            if (alphaTab.model.Tuning._defaultTunings.has(stringCount))
            {
                return alphaTab.model.Tuning._defaultTunings.get(stringCount)!!
            }
            return null
        }
        
        /**
         * Gets a list of all tuning presets for a given stirng count.
         * @param stringCount The string count.
         */
        @kotlin.jvm.JvmStatic
        public fun getPresetsFor(stringCount: Double): alphaTab.collections.List<alphaTab.model.Tuning>{
            when (stringCount)
            {
                7.0 -> 
                {
                    return alphaTab.model.Tuning._sevenStrings
                }
                6.0 -> 
                {
                    return alphaTab.model.Tuning._sixStrings
                }
                5.0 -> 
                {
                    return alphaTab.model.Tuning._fiveStrings
                }
                4.0 -> 
                {
                    return alphaTab.model.Tuning._fourStrings
                }
                else -> { }
            }
            return alphaTab.collections.List<alphaTab.model.Tuning>(
            )
            
        }
        
        @kotlin.jvm.JvmStatic
        public fun initialize(): Unit{
            alphaTab.model.Tuning._defaultTunings.set(7.0, alphaTab.model.Tuning("Guitar 7 strings", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 50.0, 45.0, 40.0, 35.0)
            , true))
            alphaTab.model.Tuning._sevenStrings.push(alphaTab.model.Tuning._defaultTunings.get(7.0)!!)
            alphaTab.model.Tuning._defaultTunings.set(6.0, alphaTab.model.Tuning("Guitar Standard Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 50.0, 45.0, 40.0)
            , true))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning._defaultTunings.get(6.0)!!)
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Tune down ½ step", alphaTab.collections.DoubleList(
                63.0, 58.0, 54.0, 49.0, 44.0, 39.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Tune down 1 step", alphaTab.collections.DoubleList(
                62.0, 57.0, 53.0, 48.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Tune down 2 step", alphaTab.collections.DoubleList(
                60.0, 55.0, 51.0, 46.0, 41.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Dropped D Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Dropped D Tuning variant", alphaTab.collections.DoubleList(
                64.0, 57.0, 55.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Double Dropped D Tuning", alphaTab.collections.DoubleList(
                62.0, 59.0, 55.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Dropped E Tuning", alphaTab.collections.DoubleList(
                66.0, 61.0, 57.0, 52.0, 47.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Dropped C Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 53.0, 48.0, 43.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open C Tuning", alphaTab.collections.DoubleList(
                64.0, 60.0, 55.0, 48.0, 43.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Cm Tuning", alphaTab.collections.DoubleList(
                63.0, 60.0, 55.0, 48.0, 43.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open C6 Tuning", alphaTab.collections.DoubleList(
                64.0, 57.0, 55.0, 48.0, 43.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Cmaj7 Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 52.0, 43.0, 36.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open D Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 54.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Dm Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 53.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open D5 Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 50.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open D6 Tuning", alphaTab.collections.DoubleList(
                62.0, 59.0, 54.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Dsus4 Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 55.0, 50.0, 45.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open E Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 56.0, 52.0, 47.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Em Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 52.0, 47.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Esus11 Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 52.0, 45.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open F Tuning", alphaTab.collections.DoubleList(
                65.0, 60.0, 53.0, 48.0, 45.0, 41.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open G Tuning", alphaTab.collections.DoubleList(
                62.0, 59.0, 55.0, 50.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Gm Tuning", alphaTab.collections.DoubleList(
                62.0, 58.0, 55.0, 50.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open G6 Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 55.0, 50.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Gsus4 Tuning", alphaTab.collections.DoubleList(
                62.0, 60.0, 55.0, 50.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open A Tuning", alphaTab.collections.DoubleList(
                64.0, 61.0, 57.0, 52.0, 45.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Open Am Tuning", alphaTab.collections.DoubleList(
                64.0, 60.0, 57.0, 52.0, 45.0, 40.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Guitar Nashville Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 67.0, 62.0, 57.0, 52.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Bass 6 Strings Tuning", alphaTab.collections.DoubleList(
                48.0, 43.0, 38.0, 33.0, 28.0, 23.0)
            , false))
            alphaTab.model.Tuning._sixStrings.push(alphaTab.model.Tuning("Lute or Vihuela Tuning", alphaTab.collections.DoubleList(
                64.0, 59.0, 54.0, 50.0, 45.0, 40.0)
            , false))
            alphaTab.model.Tuning._defaultTunings.set(5.0, alphaTab.model.Tuning("Bass 5 Strings Tuning", alphaTab.collections.DoubleList(
                43.0, 38.0, 33.0, 28.0, 23.0)
            , true))
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning._defaultTunings.get(5.0)!!)
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning("Banjo Dropped C Tuning", alphaTab.collections.DoubleList(
                62.0, 59.0, 55.0, 48.0, 67.0)
            , false))
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning("Banjo Open D Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 54.0, 50.0, 69.0)
            , false))
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning("Banjo Open G Tuning", alphaTab.collections.DoubleList(
                62.0, 59.0, 55.0, 50.0, 67.0)
            , false))
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning("Banjo G Minor Tuning", alphaTab.collections.DoubleList(
                62.0, 58.0, 55.0, 50.0, 67.0)
            , false))
            alphaTab.model.Tuning._fiveStrings.push(alphaTab.model.Tuning("Banjo G Modal Tuning", alphaTab.collections.DoubleList(
                62.0, 57.0, 55.0, 50.0, 67.0)
            , false))
            alphaTab.model.Tuning._defaultTunings.set(4.0, alphaTab.model.Tuning("Bass Standard Tuning", alphaTab.collections.DoubleList(
                43.0, 38.0, 33.0, 28.0)
            , true))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning._defaultTunings.get(4.0)!!)
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Bass Tune down ½ step", alphaTab.collections.DoubleList(
                42.0, 37.0, 32.0, 27.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Bass Tune down 1 step", alphaTab.collections.DoubleList(
                41.0, 36.0, 31.0, 26.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Bass Tune down 2 step", alphaTab.collections.DoubleList(
                39.0, 34.0, 29.0, 24.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Bass Dropped D Tuning", alphaTab.collections.DoubleList(
                43.0, 38.0, 33.0, 26.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Ukulele C Tuning", alphaTab.collections.DoubleList(
                45.0, 40.0, 36.0, 43.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Ukulele G Tuning", alphaTab.collections.DoubleList(
                52.0, 47.0, 43.0, 38.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Mandolin Standard Tuning", alphaTab.collections.DoubleList(
                64.0, 57.0, 50.0, 43.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Mandolin or Violin Tuning", alphaTab.collections.DoubleList(
                76.0, 69.0, 62.0, 55.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Viola Tuning", alphaTab.collections.DoubleList(
                69.0, 62.0, 55.0, 48.0)
            , false))
            alphaTab.model.Tuning._fourStrings.push(alphaTab.model.Tuning("Cello Tuning", alphaTab.collections.DoubleList(
                57.0, 50.0, 43.0, 36.0)
            , false))
        }
        
        /**
         * Tries to find a known tuning by a given list of tuning values.
         * @param strings The values defining the tuning.
         */
        @kotlin.jvm.JvmStatic
        public fun findTuning(strings: alphaTab.collections.DoubleList): alphaTab.model.Tuning?{
            var tunings: alphaTab.collections.List<alphaTab.model.Tuning> = alphaTab.model.Tuning.getPresetsFor(strings.length)
            if(true) {
                var t: Double = 0.0
                var tc: Double = tunings.length
                
                while(t < tc){
                    try{
                        var tuning: alphaTab.model.Tuning = tunings[(t).toInt()]
                        var equals: Boolean = true
                        if(true) {
                            var i: Double = 0.0
                            var j: Double = strings.length
                            
                            while(i < j){
                                try{
                                    if (strings[(i).toInt()] != tuning.tunings[(i).toInt()])
                                    {
                                        equals = false
                                        break
                                    }
                                }
                                finally{
                                    i++
                                }
                            }
                        }
                        if (equals)
                        {
                            return tuning
                        }
                    }
                    finally{
                        t++
                    }
                }
            }
            return null
        }
        
        init {
            alphaTab.model.Tuning.initialize()
        }
        
    }
}

