// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.model
import alphaTab.core.*

/**
 * A voice represents a group of beats
 * that can be played during a bar.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class Voice
{
    private lateinit var _beatLookup: alphaTab.collections.DoubleObjectMap<alphaTab.model.Beat>
    
    /**
     * Gets or sets the unique id of this bar.
     */
    public var id: Double = alphaTab.model.Voice._globalBarId++
    
    /**
     * Gets or sets the zero-based index of this voice within the bar.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the reference to the bar this voice belongs to.
     */
    public lateinit var bar: alphaTab.model.Bar
    /**
     * Gets or sets the list of beats contained in this voice.
     */
    public var beats: alphaTab.collections.List<alphaTab.model.Beat> = alphaTab.collections.List<alphaTab.model.Beat>(
    )
    
    
    /**
     * Gets or sets a value indicating whether this voice is empty.
     */
    public var isEmpty: Boolean = true
    
    /**
     */
    public fun insertBeat(after: alphaTab.model.Beat, newBeat: alphaTab.model.Beat): Unit{
        newBeat.nextBeat = after.nextBeat
        if (alphaTab.core.TypeHelper.isTruthy(newBeat.nextBeat))
        {
            newBeat.nextBeat!!.previousBeat = newBeat
        }
        newBeat.previousBeat = after
        newBeat.voice = this
        after.nextBeat = newBeat
        this.beats.splice(after.index + 1.0, 0.0, newBeat)
    }
    
    /**
     */
    public fun addBeat(beat: alphaTab.model.Beat): Unit{
        beat.voice = this
        beat.index = this.beats.length
        this.beats.push(beat)
        if (!beat.isEmpty)
        {
            this.isEmpty = false
        }
    }
    
    /**
     */
    private fun chain(beat: alphaTab.model.Beat, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.bar))
        {
            return
        }
        if (beat.index < this.beats.length - 1.0)
        {
            beat.nextBeat = this.beats[(beat.index + 1.0).toInt()]
            beat.nextBeat!!.previousBeat = beat
        }
        else if (beat.isLastOfVoice && alphaTab.core.TypeHelper.isTruthy(beat.voice.bar.nextBar))
        {
            var nextVoice: alphaTab.model.Voice = this.bar.nextBar!!.voices[(this.index).toInt()]
            if (nextVoice.beats.length > 0)
            {
                beat.nextBeat = nextVoice.beats[(0).toInt()]
                beat.nextBeat!!.previousBeat = beat
            }
            else 
            {
                beat.nextBeat!!.previousBeat = beat
            }
        }
        beat.chain(sharedDataBag)
    }
    
    /**
     */
    public fun addGraceBeat(beat: alphaTab.model.Beat): Unit{
        if (this.beats.length == 0.0)
        {
            this.addBeat(beat)
            return
        }
        var lastBeat: alphaTab.model.Beat = this.beats[(this.beats.length - 1.0).toInt()]
        this.beats.splice(this.beats.length - 1.0, 1.0)
        this.addBeat(beat)
        this.addBeat(lastBeat)
        this.isEmpty = false
    }
    
    /**
     */
    public fun getBeatAtPlaybackStart(playbackStart: Double): alphaTab.model.Beat?{
        if (this._beatLookup.has(playbackStart))
        {
            return this._beatLookup.get(playbackStart)!!
        }
        return null
    }
    
    /**
     */
    public fun finish(settings: alphaTab.Settings, sharedDataBag: alphaTab.collections.Map<String, Any?>? = null): Unit{
        this._beatLookup = alphaTab.collections.DoubleObjectMap<alphaTab.model.Beat>()
        var currentGraceGroup: alphaTab.model.GraceGroup? = null
        if(true) {
            var index: Double = 0.0
            
            while(index < this.beats.length){
                try{
                    var beat: alphaTab.model.Beat = this.beats[(index).toInt()]
                    beat.index = index
                    this.chain(beat, sharedDataBag)
                    if (beat.graceType == alphaTab.model.GraceType.None)
                    {
                        beat.graceGroup = currentGraceGroup
                        if (alphaTab.core.TypeHelper.isTruthy(currentGraceGroup))
                        {
                            currentGraceGroup.isComplete = true
                        }
                        currentGraceGroup = null
                    }
                    else 
                    {
                        if (!alphaTab.core.TypeHelper.isTruthy(currentGraceGroup))
                        {
                            currentGraceGroup = alphaTab.model.GraceGroup()
                        }
                        currentGraceGroup.addBeat(beat)
                    }
                }
                finally{
                    index++
                }
            }
        }
        var currentDisplayTick: Double = 0.0
        var currentPlaybackTick: Double = 0.0
        if(true) {
            var i: Double = 0.0
            
            while(i < this.beats.length){
                try{
                    var beat: alphaTab.model.Beat = this.beats[(i).toInt()]
                    beat.index = i
                    beat.finish(settings, sharedDataBag)
                    if (beat.graceType == alphaTab.model.GraceType.None)
                    {
                        if (alphaTab.core.TypeHelper.isTruthy(beat.graceGroup))
                        {
                            var firstGraceBeat: alphaTab.model.Beat = beat.graceGroup!!.beats[(0).toInt()]
                            var lastGraceBeat: alphaTab.model.Beat = beat.graceGroup!!.beats[(beat.graceGroup!!.beats.length - 1.0).toInt()]
                            if (firstGraceBeat.graceType != alphaTab.model.GraceType.BendGrace)
                            {
                                var stolenDuration: Double = lastGraceBeat.playbackStart + lastGraceBeat.playbackDuration - firstGraceBeat.playbackStart
                                when (firstGraceBeat.graceType)
                                {
                                    alphaTab.model.GraceType.BeforeBeat -> 
                                    {
                                        if (alphaTab.core.TypeHelper.isTruthy(firstGraceBeat.previousBeat))
                                        {
                                            firstGraceBeat.previousBeat!!.playbackDuration -= stolenDuration
                                            if (firstGraceBeat.previousBeat!!.voice == this)
                                            {
                                                currentPlaybackTick = firstGraceBeat.previousBeat!!.playbackStart + firstGraceBeat.previousBeat!!.playbackDuration
                                            }
                                            else 
                                            {
                                                currentPlaybackTick = -stolenDuration
                                            }
                                        }
                                        else 
                                        {
                                            currentPlaybackTick = -stolenDuration
                                        }
                                        for (graceBeat in beat.graceGroup!!.beats)
                                        {
                                            this._beatLookup.delete(graceBeat.playbackStart)
                                            graceBeat.playbackStart = currentPlaybackTick
                                            this._beatLookup.set(graceBeat.playbackStart, beat)
                                            currentPlaybackTick += graceBeat.playbackDuration
                                        }
                                    }
                                    alphaTab.model.GraceType.OnBeat -> 
                                    {
                                        beat.playbackDuration -= stolenDuration
                                        if (lastGraceBeat.voice == this)
                                        {
                                            currentPlaybackTick = lastGraceBeat.playbackStart + lastGraceBeat.playbackDuration
                                        }
                                        else 
                                        {
                                            currentPlaybackTick = -stolenDuration
                                        }
                                    }
                                    else -> { }
                                }
                            }
                        }
                        beat.displayStart = currentDisplayTick
                        beat.playbackStart = currentPlaybackTick
                        if (alphaTab.core.TypeHelper.isTruthy(beat.fermata))
                        {
                            this.bar.masterBar.addFermata(beat.playbackStart, beat.fermata!!)
                        }
                        else 
                        {
                            beat.fermata = this.bar.masterBar.getFermata(beat)
                        }
                        this._beatLookup.set(beat.playbackStart, beat)
                    }
                    else 
                    {
                        beat.displayStart = currentDisplayTick
                        beat.playbackStart = currentPlaybackTick
                    }
                    beat.finishTuplet()
                    if (alphaTab.core.TypeHelper.isTruthy(beat.graceGroup))
                    {
                        beat.graceGroup!!.finish()
                    }
                    currentDisplayTick += beat.displayDuration
                    currentPlaybackTick += beat.playbackDuration
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public fun calculateDuration(): Double{
        if (this.isEmpty || this.beats.length == 0.0)
        {
            return 0.0
        }
        var lastBeat: alphaTab.model.Beat = this.beats[(this.beats.length - 1.0).toInt()]
        var firstBeat: alphaTab.model.Beat = this.beats[(0).toInt()]
        return lastBeat.playbackStart + lastBeat.playbackDuration - firstBeat.playbackStart
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private var _globalBarId: Double = 0.0
        
    }
    public constructor()
}

