// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.platform
import alphaTab.core.*

/**
 * This interface represents a container control in the UI layer.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public interface IContainer
{
    /**
     * Gets or sets the width of the control.
     */
    var width: Double
    /**
     * Gets or sets the height of the control.
     */
    var height: Double
    /**
     * Gets a value indicating whether the control is visible.
     */
    val isVisible: Boolean
    /**
     * Gets or sets the horizontal scroll offset of this control if it is scrollable.
     */
    var scrollLeft: Double
    /**
     * Gets or sets the vertical scroll offset of this control if it is scrollable.
     */
    var scrollTop: Double
    /**
     * Adds the given child control to this container.
     * @param child The child control to add.
     */
    fun appendChild(child: alphaTab.platform.IContainer): Unit
    
    /**
     * Stops the animations of this control immediately.
     */
    fun stopAnimation(): Unit
    
    /**
     * Sets the position and size of the container for efficient repositioning.
     * @param x The X-position
     * @param y The Y-position
     * @param w The width
     * @param h The height
     */
    fun setBounds(x: Double, y: Double, w: Double, h: Double): Unit
    
    /**
     * Tells the control to move to the given X-position in the given time.
     * @param duration The milliseconds that should be needed to reach the new X-position
     * @param x The new X-position
     */
    fun transitionToX(duration: Double, x: Double): Unit
    
    /**
     * Clears the container and removes all child items.
     */
    fun clear(): Unit
    
    /**
     * This event occurs when the control was resized.
     */
    var resize: alphaTab.IEventEmitter
    /**
     * This event occurs when a mouse/finger press happened on the control.
     */
    var mouseDown: alphaTab.IEventEmitterOfT<alphaTab.platform.IMouseEventArgs>
    /**
     * This event occurs when a mouse/finger moves on top of the control.
     */
    var mouseMove: alphaTab.IEventEmitterOfT<alphaTab.platform.IMouseEventArgs>
    /**
     * This event occurs when a mouse/finger is released from the control.
     */
    var mouseUp: alphaTab.IEventEmitterOfT<alphaTab.platform.IMouseEventArgs>
}

