// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.platform
import alphaTab.core.*

/**
 * This interface represents the UI abstraction between alphaTab and the corresponding UI framework being used.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public interface IUiFacade<TSettings>
{
    /**
     * Gets the root UI element that holds the whole alphaTab control.
     */
    val rootContainer: alphaTab.platform.IContainer
    /**
     * Gets a value indicating whether the UI framework supports worker based rendering.
     */
    val areWorkersSupported: Boolean
    /**
     * Gets or sets whether the UI is ready to render the music notation. On some platforms where pre-loading of assets is done asynchronously,
     * rendering might need to be deferred.
     */
    val canRender: Boolean
    /**
     * Gets the resize throttling in milliseconds. Then the music sheet is resized, the re-rendering is deferred until this timeout is reached.
     */
    val resizeThrottle: Double
    /**
     * Initializes the UI using the given alphaTab API and settings object.
     * @param api The alphaTab API wrapper responsible for UI interaction.
     * @param settings The settings object holding the settings from the UI layer.
     */
    fun initialize(api: alphaTab.AlphaTabApiBase<TSettings>, settings: TSettings): Unit
    
    /**
     * Tells the UI layer to destroy the alphaTab controls and restore the initial state.
     */
    fun destroy(): Unit
    
    /**
     * Creates the canvas element that wraps all individually rendered partials.
     */
    fun createCanvasElement(): alphaTab.platform.IContainer
    
    /**
     * Tells the UI layer to trigger an event with the given name and details.
     * @param container The element on which the event should be triggered.
     * @param eventName The event that should be triggered.
     * @param details The object holding the details about the event.
     * @param originalEvent The original event related to this custom event.
     */
    fun triggerEvent(container: alphaTab.platform.IContainer, eventName: String, details: Any?, originalEvent: alphaTab.platform.IMouseEventArgs? = null): Unit
    
    /**
     * Tells the UI layer to do the initial rendering.
     */
    fun initialRender(): Unit
    
    /**
     * Tells the UI layer to append the given render results to the UI. At this point
     * the partial result is not actually rendered yet, only the layouting process 
     * completed.
     * @param renderResults The rendered partial that should be added to the UI. null indicates the rendering finished.
     */
    fun beginAppendRenderResults(renderResults: alphaTab.rendering.RenderFinishedEventArgs?): Unit
    
    /**
     * Tells the UI layer to update the given render results within the UI.
     * @param renderResults The rendered partial that should be updated within the UI.
     */
    fun beginUpdateRenderResults(renderResults: alphaTab.rendering.RenderFinishedEventArgs): Unit
    
    /**
     * Tells the UI layer to create the worker renderer. This method is the UI layer supports worker rendering and worker rendering is not disabled via setting.
     */
    fun createWorkerRenderer(): alphaTab.rendering.IScoreRenderer
    
    /**
     * Tells the UI layer to create a player worker.
     */
    fun createWorkerPlayer(): alphaTab.synth.IAlphaSynth?
    
    /**
     * Creates the cursor objects that are used to highlight the currently played beats and bars.
     */
    fun createCursors(): alphaTab.platform.Cursors?
    
    /**
     * Destroys the cursor objects that are used to highlight the currently played beats and bars.
     */
    fun destroyCursors(): Unit
    
    /**
     * Tells the UI layer to invoke the given action.
     */
    fun beginInvoke(action: () -> Unit): Unit
    
    /**
     * Tells the UI layer to remove all highlights from highlighted music notation elements.
     */
    fun removeHighlights(): Unit
    
    /**
     * Tells the UI layer to highlight the music notation elements with the given ID.
     * @param groupId The group id that identifies the elements to be highlighted.
     * @param masterBarIndex The index of the related masterbar of the highlighted group.
     */
    fun highlightElements(groupId: String, masterBarIndex: Double): Unit
    
    /**
     * Creates a new UI element that is used to display the selection rectangle.
     */
    fun createSelectionElement(): alphaTab.platform.IContainer?
    
    /**
     * Gets the UI element that is used for scrolling during playback.
     */
    fun getScrollContainer(): alphaTab.platform.IContainer
    
    /**
     * Calculates the relative offset of a container to the scroll element.
     * @param scrollElement The parent scroll element to which the relative position is computed.
     * @param container The container element for which the relative position is calculated.
     */
    fun getOffset(scrollElement: alphaTab.platform.IContainer?, container: alphaTab.platform.IContainer): alphaTab.rendering.utils.Bounds
    
    /**
     * Initiates a vertical scroll on the given element.
     * @param scrollElement The element on which the scrolling should happen.
     * @param offset The absolute scroll offset to which scrolling should happen.
     * @param speed How fast the scrolling from the current offset to the given one should happen in milliseconds.
     */
    fun scrollToY(scrollElement: alphaTab.platform.IContainer, offset: Double, speed: Double): Unit
    
    /**
     * Initiates a horizontal scroll on the given element.
     * @param scrollElement The element on which the scrolling should happen.
     * @param offset The absolute scroll offset to which scrolling should happen.
     * @param speed How fast the scrolling from the current offset to the given one should happen in milliseconds.
     */
    fun scrollToX(scrollElement: alphaTab.platform.IContainer, offset: Double, speed: Double): Unit
    
    /**
     * Attempts a load of the score represented by the given data object.
     * @param `data` The data object to decode
     * @param success The action to call if the score was loaded
     * @param error The action to call if any error during loading ocurred.
     */
    fun load(`data`: Any?, success: (arg1: alphaTab.model.Score) -> Unit, error: (arg1: alphaTab.core.ecmaScript.Error) -> Unit): Boolean
    
    /**
     * Attempts a load of the score represented by the given data object.
     * @param `data` The data object to decode
     * @param append Whether to fully replace or append the data from the given soundfont.
     */
    fun loadSoundFont(`data`: Any?, append: Boolean): Boolean
    
    /**
     * This events is fired when the  property changes.
     */
    val canRenderChanged: alphaTab.IEventEmitter
    /**
     * This event is fired when  became visible when it was invisible at the time rendering was initiated.
     */
    val rootContainerBecameVisible: alphaTab.IEventEmitter
}

