// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.platform.svg
import alphaTab.core.*

/**
 * A canvas implementation storing SVG data
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public abstract class SvgCanvas: alphaTab.platform.ICanvas
{
    protected var buffer: String = ""
    
    private var _currentPath: String = ""
    
    private var _currentPathIsEmpty: Boolean = true
    
    public override var color: alphaTab.model.Color = alphaTab.model.Color(255.0, 255.0, 255.0, 255.0)
    
    public override var lineWidth: Double = 1.0
    
    public override var font: alphaTab.model.Font = alphaTab.model.Font("Arial", 10.0, alphaTab.model.FontStyle.Plain)
    
    public override var textAlign: alphaTab.platform.TextAlign = alphaTab.platform.TextAlign.Left
    
    public override var textBaseline: alphaTab.platform.TextBaseline = alphaTab.platform.TextBaseline.Top
    
    public override lateinit var settings: alphaTab.Settings
    public override fun destroy(): Unit{
    }
    
    /**
     */
    public override fun beginRender(width: Double, height: Double): Unit{
        this.buffer = """<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="${(((width).toInt() or 0).toDouble()).toTemplate()}px" height="${(((height).toInt() or 0).toDouble()).toTemplate()}px" class="at-surface-svg">
"""
        this._currentPath = ""
        this._currentPathIsEmpty = true
        this.textBaseline = alphaTab.platform.TextBaseline.Top
    }
    
    /**
     */
    public override fun beginGroup(identifier: String): Unit{
        this.buffer += """<g class="${(identifier).toTemplate()}">"""
    }
    
    public override fun endGroup(): Unit{
        this.buffer += "</g>"
    }
    
    public override fun endRender(): Any?{
        this.buffer += "</svg>"
        return ((this.buffer as Any?))
    }
    
    /**
     */
    public override fun fillRect(x: Double, y: Double, w: Double, h: Double): Unit{
        if (w > 0)
        {
            this.buffer += """<rect x="${(((x).toInt() or 0).toDouble()).toTemplate()}" y="${(((y).toInt() or 0).toDouble()).toTemplate()}" width="${(w).toTemplate()}" height="${(h).toTemplate()}" fill="${(this.color.rgba).toTemplate()}" />
"""
        }
    }
    
    /**
     */
    public override fun strokeRect(x: Double, y: Double, w: Double, h: Double): Unit{
        this.buffer += """<rect x="${(((x).toInt() or 0).toDouble()).toTemplate()}" y="${(((y).toInt() or 0).toDouble()).toTemplate()}" width="${(w).toTemplate()}" height="${(h).toTemplate()}" stroke="${(this.color.rgba).toTemplate()}""""
        if (this.lineWidth != 1.0)
        {
            this.buffer += """ stroke-width="${(this.lineWidth).toTemplate()}""""
        }
        this.buffer += " fill=\"transparent\" />\n"
    }
    
    public override fun beginPath(): Unit{
    }
    
    public override fun closePath(): Unit{
        this._currentPath += " z"
    }
    
    /**
     */
    public override fun moveTo(x: Double, y: Double): Unit{
        this._currentPath += """ M${(x).toTemplate()},${(y).toTemplate()}"""
    }
    
    /**
     */
    public override fun lineTo(x: Double, y: Double): Unit{
        this._currentPathIsEmpty = false
        this._currentPath += """ L${(x).toTemplate()},${(y).toTemplate()}"""
    }
    
    /**
     */
    public override fun quadraticCurveTo(cpx: Double, cpy: Double, x: Double, y: Double): Unit{
        this._currentPathIsEmpty = false
        this._currentPath += """ Q${(cpx).toTemplate()},${(cpy).toTemplate()},${(x).toTemplate()},${(y).toTemplate()}"""
    }
    
    /**
     */
    public override fun bezierCurveTo(cp1X: Double, cp1Y: Double, cp2X: Double, cp2Y: Double, x: Double, y: Double): Unit{
        this._currentPathIsEmpty = false
        this._currentPath += """ C${(cp1X).toTemplate()},${(cp1Y).toTemplate()},${(cp2X).toTemplate()},${(cp2Y).toTemplate()},${(x).toTemplate()},${(y).toTemplate()}"""
    }
    
    /**
     */
    public override fun fillCircle(x: Double, y: Double, radius: Double): Unit{
        this._currentPathIsEmpty = false
        this._currentPath += """ M${(x - radius).toTemplate()},${(y).toTemplate()} A1,1 0 0,0 ${(x + radius).toTemplate()},${(y).toTemplate()} A1,1 0 0,0 ${(x - radius).toTemplate()},${(y).toTemplate()} z"""
        this.fill()
    }
    
    /**
     */
    public override fun strokeCircle(x: Double, y: Double, radius: Double): Unit{
        this._currentPathIsEmpty = false
        this._currentPath += """ M${(x - radius).toTemplate()},${(y).toTemplate()} A1,1 0 0,0 ${(x + radius).toTemplate()},${(y).toTemplate()} A1,1 0 0,0 ${(x - radius).toTemplate()},${(y).toTemplate()} z"""
        this.stroke()
    }
    
    public override fun fill(): Unit{
        if (!this._currentPathIsEmpty)
        {
            this.buffer += """<path d="${(this._currentPath).toTemplate()}""""
            if (this.color.rgba != "#000000")
            {
                this.buffer += """ fill="${(this.color.rgba).toTemplate()}""""
            }
            this.buffer += " style=\"stroke: none\"/>"
        }
        this._currentPath = ""
        this._currentPathIsEmpty = true
    }
    
    public override fun stroke(): Unit{
        if (!this._currentPathIsEmpty)
        {
            var s: String = """<path d="${(this._currentPath).toTemplate()}" stroke="${(this.color.rgba).toTemplate()}""""
            if (this.lineWidth != 1.0)
            {
                s += """ stroke-width="${(this.lineWidth).toTemplate()}""""
            }
            s += " style=\"fill: none\" />"
            this.buffer += s
        }
        this._currentPath = ""
        this._currentPathIsEmpty = true
    }
    
    /**
     */
    public override fun fillText(text: String, x: Double, y: Double): Unit{
        if (text == "")
        {
            return
        }
        var s: String = """<text x="${(((x).toInt() or 0).toDouble()).toTemplate()}" y="${(((y).toInt() or 0).toDouble()).toTemplate()}" style="stroke: none; font:${(this.font.toCssString(this.settings.display.scale)).toTemplate()}" ${(this.getSvgBaseLine()).toTemplate()}"""
        if (this.color.rgba != "#000000")
        {
            s += """ fill="${(this.color.rgba).toTemplate()}""""
        }
        if (this.textAlign != alphaTab.platform.TextAlign.Left)
        {
            s += """ text-anchor="${(this.getSvgTextAlignment(this.textAlign)).toTemplate()}""""
        }
        s += """>${(alphaTab.platform.svg.SvgCanvas.escapeText(text)).toTemplate()}</text>"""
        this.buffer += s
    }
    
    /**
     */
    protected fun getSvgTextAlignment(textAlign: alphaTab.platform.TextAlign): String{
        when (textAlign)
        {
            alphaTab.platform.TextAlign.Left -> 
            {
                return "start"
            }
            alphaTab.platform.TextAlign.Center -> 
            {
                return "middle"
            }
            alphaTab.platform.TextAlign.Right -> 
            {
                return "end"
            }
            else -> { }
        }
        return ""
    }
    
    protected fun getSvgBaseLine(): String{
        when (this.textBaseline)
        {
            alphaTab.platform.TextBaseline.Top -> 
            {
                return "dominant-baseline=\"hanging\""
            }
            alphaTab.platform.TextBaseline.Bottom -> 
            {
                return "dominant-baseline=\"bottom\""
            }
            else -> 
            {
                return ""
            }
        }
    }
    
    /**
     */
    public override fun measureText(text: String): Double{
        if (!alphaTab.core.TypeHelper.isTruthy(text))
        {
            return 0.0
        }
        return alphaTab.platform.svg.FontSizes.measureString(text, this.font.families, this.font.size, this.font.style, this.font.weight)
    }
    
    /**
     */
    public abstract override fun fillMusicFontSymbol(x: Double, y: Double, scale: Double, symbol: alphaTab.model.MusicFontSymbol, centerAtPosition: Boolean?): Unit
    
    /**
     */
    public abstract override fun fillMusicFontSymbols(x: Double, y: Double, scale: Double, symbols: alphaTab.collections.List<alphaTab.model.MusicFontSymbol>, centerAtPosition: Boolean?): Unit
    
    public override fun onRenderFinished(): Any?{
        return null
    }
    
    /**
     */
    public override fun beginRotate(centerX: Double, centerY: Double, angle: Double): Unit{
        this.buffer += "<g transform=\"translate(" + (centerX).toInvariantString() + " ," + (centerY).toInvariantString() + ") rotate( " + (angle).toInvariantString() + ")\">"
    }
    
    public override fun endRotate(): Unit{
        this.buffer += "</g>"
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun escapeText(text: String): String{
            return text.replace(alphaTab.core.TypeHelper.createRegex("&", "g"), "&amp;").replace(alphaTab.core.TypeHelper.createRegex("\"", "g"), "&quot;").replace(alphaTab.core.TypeHelper.createRegex("'", "g"), "&#39;").replace(alphaTab.core.TypeHelper.createRegex("<", "g"), "&lt;").replace(alphaTab.core.TypeHelper.createRegex(">", "g"), "&gt;")
        }
        
    }
    public constructor()
}

