// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * This is the base public class for creating blocks which can render bars.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public open class BarRendererBase
{
    private var _preBeatGlyphs: alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup = alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup()
    
    private var _voiceContainers: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.VoiceContainerGlyph> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.VoiceContainerGlyph>()
    
    private var _postBeatGlyphs: alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup = alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup()
    
    private var _ties: alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph> = alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>(
    )
    
    
    public val nextRenderer: alphaTab.rendering.BarRendererBase?
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.bar) || !alphaTab.core.TypeHelper.isTruthy(this.bar.nextBar))
        {
            return null
        }
        return this.scoreRenderer.layout!!.getRendererForBar(this.staff.staveId, this.bar.nextBar!!)
    }
    
    public val previousRenderer: alphaTab.rendering.BarRendererBase?
    get(){
        if (!alphaTab.core.TypeHelper.isTruthy(this.bar) || !alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar))
        {
            return null
        }
        return this.scoreRenderer.layout!!.getRendererForBar(this.staff.staveId, this.bar.previousBar!!)
    }
    
    public var scoreRenderer: alphaTab.rendering.ScoreRenderer
    public lateinit var staff: alphaTab.rendering.staves.RenderStaff
    public lateinit var layoutingInfo: alphaTab.rendering.staves.BarLayoutingInfo
    public var bar: alphaTab.model.Bar
    public var x: Double = 0.0
    
    public var y: Double = 0.0
    
    public var width: Double = 0.0
    
    public var computedWidth: Double = 0.0
    
    public var height: Double = 0.0
    
    public var index: Double = 0.0
    
    public var topOverflow: Double = 0.0
    
    public var bottomOverflow: Double = 0.0
    
    public lateinit var helpers: alphaTab.rendering.utils.BarHelpers
    /**
     * Gets or sets whether this renderer is linked to the next one
     * by some glyphs like a vibrato effect
     */
    public var isLinkedToPrevious: Boolean = false
    
    /**
     * Gets or sets whether this renderer can wrap to the next line
     * or it needs to stay connected to the previous one.
     * (e.g. when having double bar repeats we must not separate the 2 bars)
     */
    public var canWrap: Boolean = true
    
    public constructor(renderer: alphaTab.rendering.ScoreRenderer, bar: alphaTab.model.Bar){
        this.scoreRenderer = renderer
        this.bar = bar
        if (alphaTab.core.TypeHelper.isTruthy(bar))
        {
            this.helpers = alphaTab.rendering.utils.BarHelpers(this)
        }
    }
    
    /**
     */
    public fun registerTies(ties: alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>): Unit{
        this._ties.push(ties)
    }
    
    public open val middleYPosition: Double
    get(){
        return 0.0
    }
    
    /**
     */
    public fun registerOverflowTop(topOverflow: Double): Boolean{
        if (topOverflow > this.topOverflow)
        {
            this.topOverflow = topOverflow
            return true
        }
        return false
    }
    
    /**
     */
    public fun registerOverflowBottom(bottomOverflow: Double): Boolean{
        if (bottomOverflow > this.bottomOverflow)
        {
            this.bottomOverflow = bottomOverflow
            return true
        }
        return false
    }
    
    /**
     */
    public open fun scaleToWidth(width: Double): Unit{
        var containerWidth: Double = width - this._preBeatGlyphs.width - this._postBeatGlyphs.width
        for (container in this._voiceContainers.values())
        {
            container.scaleToWidth(containerWidth)
        }
        this._postBeatGlyphs.x = this._preBeatGlyphs.x + this._preBeatGlyphs.width + containerWidth
        this.width = width
    }
    
    public val resources: alphaTab.RenderingResources
    get(){
        return this.settings.display.resources
    }
    
    public val settings: alphaTab.Settings
    get(){
        return this.scoreRenderer.settings
    }
    
    public val scale: Double
    get(){
        return this.settings.display.scale
    }
    
    public val barDisplayScale: Double
    get(){
        return if(this.staff.staveGroup.staves.length > 1)  this.bar.masterBar.displayScale else this.bar.displayScale
    }
    
    public val barDisplayWidth: Double
    get(){
        return if(this.staff.staveGroup.staves.length > 1)  this.bar.masterBar.displayWidth else this.bar.displayWidth
    }
    
    private var _wasFirstOfLine: Boolean = false
    
    public val isFirstOfLine: Boolean
    get(){
        return this.index == 0.0
    }
    
    public val isLast: Boolean
    get(){
        return !alphaTab.core.TypeHelper.isTruthy(this.bar) || this.bar.index == this.scoreRenderer.layout!!.lastBarIndex
    }
    
    public fun registerLayoutingInfo(): Unit{
        var info: alphaTab.rendering.staves.BarLayoutingInfo = this.layoutingInfo
        var preSize: Double = this._preBeatGlyphs.width
        if (info.preBeatSize < preSize)
        {
            info.preBeatSize = preSize
        }
        var postBeatStart: Double = 0.0
        for (container in this._voiceContainers.values())
        {
            container.registerLayoutingInfo(info)
            var x: Double = container.x + container.width
            if (postBeatStart < x)
            {
                postBeatStart = x
            }
        }
        var postSize: Double = this._postBeatGlyphs.width
        if (info.postBeatSize < postSize)
        {
            info.postBeatSize = postSize
        }
    }
    
    private var _appliedLayoutingInfo: Double = 0.0
    
    public open fun applyLayoutingInfo(): Boolean{
        if (this._appliedLayoutingInfo >= this.layoutingInfo.version)
        {
            return false
        }
        this._appliedLayoutingInfo = this.layoutingInfo.version
        this._preBeatGlyphs.width = this.layoutingInfo.preBeatSize
        var voiceEnd: Double = this._preBeatGlyphs.x + this._preBeatGlyphs.width
        for (c in this._voiceContainers.values())
        {
            c.x = this._preBeatGlyphs.x + this._preBeatGlyphs.width
            c.applyLayoutingInfo(this.layoutingInfo)
            var newEnd: Double = c.x + c.width
            if (voiceEnd < newEnd)
            {
                voiceEnd = newEnd
            }
        }
        this._postBeatGlyphs.x = alphaTab.core.ecmaScript.Math.floor(voiceEnd)
        this._postBeatGlyphs.width = this.layoutingInfo.postBeatSize
        this.width = alphaTab.core.ecmaScript.Math.ceil(this._postBeatGlyphs.x + this._postBeatGlyphs.width)
        this.computedWidth = this.width
        var fixedBarWidth: Double = this.barDisplayWidth
        if (fixedBarWidth > 0 && this.scoreRenderer.layout!!.systemsLayoutMode == alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithWidths)
        {
            this.width = fixedBarWidth
            this.computedWidth = fixedBarWidth
        }
        return true
    }
    
    public var isFinalized: Boolean = false
    
    public open fun finalizeRenderer(): Boolean{
        this.isFinalized = true
        var didChangeOverflows: Boolean = false
        var barTop: Double = this.y - this.staff.topSpacing
        var barBottom: Double = this.y + this.height + this.staff.bottomSpacing
        for (tie in this._ties)
        {
            tie.doLayout()
            if (tie.height > 0)
            {
                var bottomOverflow: Double = tie.y + tie.height - barBottom
                if (bottomOverflow > 0)
                {
                    if (this.registerOverflowBottom(bottomOverflow))
                    {
                        didChangeOverflows = true
                    }
                }
                var topOverflow: Double = tie.y - barTop
                if (topOverflow < 0)
                {
                    if (this.registerOverflowTop(topOverflow * -1.0))
                    {
                        didChangeOverflows = true
                    }
                }
            }
        }
        return didChangeOverflows
    }
    
    /**
     * Gets the top padding for the main content of the renderer.
     * Can be used to specify where i.E. the score lines of the notation start.
     */
    public var topPadding: Double = 0.0
    
    /**
     * Gets the bottom padding for the main content of the renderer.
     * Can be used to specify where i.E. the score lines of the notation end.
     */
    public var bottomPadding: Double = 0.0
    
    public open fun doLayout(): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.bar))
        {
            return
        }
        this.helpers.initialize()
        this._ties = alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>(
        )
        
        this._preBeatGlyphs = alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup()
        this._preBeatGlyphs.renderer = this
        this._voiceContainers.clear()
        this._postBeatGlyphs = alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup()
        this._postBeatGlyphs.renderer = this
        if(true) {
            var i: Double = 0.0
            
            while(i < this.bar.voices.length){
                try{
                    var voice: alphaTab.model.Voice = this.bar.voices[(i).toInt()]
                    if (this.hasVoiceContainer(voice))
                    {
                        var c: alphaTab.rendering.glyphs.VoiceContainerGlyph = alphaTab.rendering.glyphs.VoiceContainerGlyph(0.0, 0.0, voice)
                        c.renderer = this
                        this._voiceContainers.set(this.bar.voices[(i).toInt()].index, c)
                    }
                }
                finally{
                    i++
                }
            }
        }
        if (this.bar.simileMark == alphaTab.model.SimileMark.SecondOfDouble)
        {
            this.canWrap = false
        }
        this.createPreBeatGlyphs()
        this.createBeatGlyphs()
        this.createPostBeatGlyphs()
        this.updateSizes()
        for (v in this.helpers.beamHelpers)
        {
            for (h in v)
            {
                h.finish()
            }
        }
        this.computedWidth = this.width
    }
    
    /**
     */
    protected fun hasVoiceContainer(voice: alphaTab.model.Voice): Boolean{
        return !voice.isEmpty || voice.index == 0.0
    }
    
    protected open fun updateSizes(): Unit{
        this.staff.registerStaffTop(this.topPadding)
        this.staff.registerStaffBottom(this.height - this.bottomPadding)
        var voiceContainers: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.VoiceContainerGlyph> = this._voiceContainers
        var beatGlyphsStart: Double = this.beatGlyphsStart
        var postBeatStart: Double = beatGlyphsStart
        for (c in voiceContainers.values())
        {
            c.x = beatGlyphsStart
            c.doLayout()
            var x: Double = c.x + c.width
            if (postBeatStart < x)
            {
                postBeatStart = x
            }
        }
        this._postBeatGlyphs.x = alphaTab.core.ecmaScript.Math.floor(postBeatStart)
        this.width = alphaTab.core.ecmaScript.Math.ceil(this._postBeatGlyphs.x + this._postBeatGlyphs.width)
        this.height += this.layoutingInfo.height * this.scale
    }
    
    /**
     */
    protected fun addPreBeatGlyph(g: alphaTab.rendering.glyphs.Glyph): Unit{
        g.renderer = this
        this._preBeatGlyphs.addGlyph(g)
    }
    
    /**
     */
    protected fun addBeatGlyph(g: alphaTab.rendering.glyphs.BeatContainerGlyph): Unit{
        g.renderer = this
        g.preNotes.renderer = this
        g.onNotes.renderer = this
        g.onNotes.beamingHelper = this.helpers.beamHelperLookup[(g.beat.voice.index).toInt()].get(g.beat.index)!!
        this.getVoiceContainer(g.beat.voice)!!.addGlyph(g)
    }
    
    /**
     */
    protected fun getVoiceContainer(voice: alphaTab.model.Voice): alphaTab.rendering.glyphs.VoiceContainerGlyph?{
        return if(this._voiceContainers.has(voice.index))  this._voiceContainers.get(voice.index) else null
    }
    
    /**
     */
    public fun getBeatContainer(beat: alphaTab.model.Beat): alphaTab.rendering.glyphs.BeatContainerGlyph?{
        return this.getVoiceContainer(beat.voice)?.beatGlyphs?.get((beat.index).toInt())
    }
    
    /**
     */
    public fun getPreNotesGlyphForBeat(beat: alphaTab.model.Beat): alphaTab.rendering.glyphs.BeatGlyphBase?{
        return this.getBeatContainer(beat)?.preNotes
    }
    
    /**
     */
    public fun getOnNotesGlyphForBeat(beat: alphaTab.model.Beat): alphaTab.rendering.glyphs.BeatOnNoteGlyphBase?{
        return this.getBeatContainer(beat)?.onNotes
    }
    
    /**
     */
    public open fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        this.paintBackground(cx, cy, canvas)
        canvas.color = this.resources.mainGlyphColor
        this._preBeatGlyphs.paint(cx + this.x, cy + this.y, canvas)
        for (c in this._voiceContainers.values())
        {
            canvas.color = if(c.voice.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
            c.paint(cx + this.x, cy + this.y, canvas)
        }
        canvas.color = this.resources.mainGlyphColor
        this._postBeatGlyphs.paint(cx + this.x, cy + this.y, canvas)
    }
    
    /**
     */
    protected open fun paintBackground(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        this.layoutingInfo.paint(cx + this.x + this._preBeatGlyphs.x + this._preBeatGlyphs.width, cy + this.y + this.height, canvas)
    }
    
    /**
     */
    public fun buildBoundingsLookup(masterBarBounds: alphaTab.rendering.utils.MasterBarBounds, cx: Double, cy: Double): Unit{
        var barBounds: alphaTab.rendering.utils.BarBounds = alphaTab.rendering.utils.BarBounds()
        barBounds.bar = this.bar
        barBounds.visualBounds = alphaTab.rendering.utils.Bounds()
        barBounds.visualBounds.x = cx + this.x
        barBounds.visualBounds.y = cy + this.y + this.topPadding
        barBounds.visualBounds.w = this.width
        barBounds.visualBounds.h = this.height - this.topPadding - this.bottomPadding
        barBounds.realBounds = alphaTab.rendering.utils.Bounds()
        barBounds.realBounds.x = cx + this.x
        barBounds.realBounds.y = cy + this.y
        barBounds.realBounds.w = this.width
        barBounds.realBounds.h = this.height
        masterBarBounds.addBar(barBounds)
        for ((index, c) in this._voiceContainers)
        {
            var isEmptyBar: Boolean = this.bar.isEmpty && index == 0.0
            if (!c.voice.isEmpty || isEmptyBar)
            {
                if(true) {
                    var i: Double = 0.0
                    var j: Double = c.beatGlyphs.length
                    
                    while(i < j){
                        try{
                            var bc: alphaTab.rendering.glyphs.BeatContainerGlyph = c.beatGlyphs[(i).toInt()]
                            bc.buildBoundingsLookup(barBounds, cx + this.x + c.x, cy + this.y + c.y, isEmptyBar)
                        }
                        finally{
                            i++
                        }
                    }
                }
            }
        }
    }
    
    /**
     */
    protected fun addPostBeatGlyph(g: alphaTab.rendering.glyphs.Glyph): Unit{
        this._postBeatGlyphs.addGlyph(g)
    }
    
    protected open fun createPreBeatGlyphs(): Unit{
        this._wasFirstOfLine = this.isFirstOfLine
    }
    
    protected open fun createBeatGlyphs(): Unit{
        if(true) {
            var v: Double = 0.0
            
            while(v < this.bar.voices.length){
                try{
                    var voice: alphaTab.model.Voice = this.bar.voices[(v).toInt()]
                    if (this.hasVoiceContainer(voice))
                    {
                        this.createVoiceGlyphs(this.bar.voices[(v).toInt()])
                    }
                }
                finally{
                    v++
                }
            }
        }
    }
    
    /**
     */
    protected open fun createVoiceGlyphs(v: alphaTab.model.Voice): Unit{
    }
    
    protected open fun createPostBeatGlyphs(): Unit{
    }
    
    public val beatGlyphsStart: Double
    get(){
        return this._preBeatGlyphs.x + this._preBeatGlyphs.width
    }
    
    public val postBeatGlyphsStart: Double
    get(){
        return this._postBeatGlyphs.x
    }
    
    /**
     */
    public fun getBeatX(beat: alphaTab.model.Beat, requestedPosition: alphaTab.rendering.BeatXPosition = alphaTab.rendering.BeatXPosition.PreNotes): Double{
        var container: alphaTab.rendering.glyphs.BeatContainerGlyph? = this.getBeatContainer(beat)
        if (alphaTab.core.TypeHelper.isTruthy(container))
        {
            when (requestedPosition)
            {
                alphaTab.rendering.BeatXPosition.PreNotes -> 
                {
                    return container.voiceContainer.x + container.x
                }
                alphaTab.rendering.BeatXPosition.OnNotes -> 
                {
                    return container.voiceContainer.x + container.x + container.onNotes.x
                }
                alphaTab.rendering.BeatXPosition.MiddleNotes -> 
                {
                    return container.voiceContainer.x + container.x + container.onTimeX
                }
                alphaTab.rendering.BeatXPosition.Stem -> 
                {
                    var offset: Double = if(alphaTab.core.TypeHelper.isTruthy(container.onNotes.beamingHelper))  container.onNotes.beamingHelper.getBeatLineX(beat) else container.onNotes.x + container.onNotes.width / (2.0).toDouble()
                    return container.voiceContainer.x + offset
                }
                alphaTab.rendering.BeatXPosition.PostNotes -> 
                {
                    return container.voiceContainer.x + container.x + container.onNotes.x + container.onNotes.width
                }
                alphaTab.rendering.BeatXPosition.EndBeat -> 
                {
                    return container.voiceContainer.x + container.x + container.width
                }
                else -> { }
            }
        }
        return 0.0
    }
    
    /**
     */
    public fun getNoteX(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteXPosition): Double{
        var container: alphaTab.rendering.glyphs.BeatContainerGlyph? = this.getBeatContainer(note.beat)
        if (alphaTab.core.TypeHelper.isTruthy(container))
        {
            return (container.voiceContainer.x + container.x + container.onNotes.x + container.onNotes.getNoteX(note, requestedPosition))
        }
        return 0.0
    }
    
    /**
     */
    public open fun getNoteY(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteYPosition): Double{
        var beat: alphaTab.rendering.glyphs.BeatOnNoteGlyphBase? = this.getOnNotesGlyphForBeat(note.beat)
        if (alphaTab.core.TypeHelper.isTruthy(beat))
        {
            return beat.getNoteY(note, requestedPosition)
        }
        return alphaTab.core.Globals.NaN
    }
    
    public fun reLayout(): Unit{
        if ((this._wasFirstOfLine && !this.isFirstOfLine) || (!this._wasFirstOfLine && this.isFirstOfLine))
        {
            this._preBeatGlyphs = alphaTab.rendering.glyphs.LeftToRightLayoutingGlyphGroup()
            this._preBeatGlyphs.renderer = this
            this.createPreBeatGlyphs()
        }
        this.updateSizes()
        this.registerLayoutingInfo()
    }
    
    /**
     */
    protected fun paintSimileMark(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        when (this.bar.simileMark)
        {
            alphaTab.model.SimileMark.Simple -> 
            {
                canvas.fillMusicFontSymbol(cx + this.x + (this.width - 20.0 * this.scale) / (2.0).toDouble(), cy + this.y + this.height / (2.0).toDouble(), 1.0, alphaTab.model.MusicFontSymbol.Repeat1Bar, false)
            }
            alphaTab.model.SimileMark.SecondOfDouble -> 
            {
                canvas.fillMusicFontSymbol(cx + this.x - (28.0 * this.scale) / (2.0).toDouble(), cy + this.y + this.height / (2.0).toDouble(), 1.0, alphaTab.model.MusicFontSymbol.Repeat2Bars, false)
            }
            else -> { }
        }
    }
    
    /**
     */
    public open fun completeBeamingHelper(helper: alphaTab.rendering.utils.BeamingHelper): Unit{
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val LineSpacing: Double = 8.0
        
        @kotlin.jvm.JvmStatic
        public val StemWidth: Double = 0.12 * alphaTab.rendering.BarRendererBase.LineSpacing
        
        @kotlin.jvm.JvmStatic
        public val StaffLineThickness: Double = 0.13 * alphaTab.rendering.BarRendererBase.LineSpacing
        
        @kotlin.jvm.JvmStatic
        public val BeamThickness: Double = 0.5 * alphaTab.rendering.BarRendererBase.LineSpacing
        
        @kotlin.jvm.JvmStatic
        public val BeamSpacing: Double = 0.25 * alphaTab.rendering.BarRendererBase.LineSpacing
        
    }
}

/**
 * Lists the different position modes for 
 */
public enum class NoteYPosition(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Gets the note y-position on top of the note stem or tab number.
     */
    TopWithStem(0),
    /**
     * Gets the note y-position on top of the note head or tab number.
     */
    Top(1),
    /**
     * Gets the note y-position on the center of the note head or tab number.
     */
    Center(2),
    /**
     * Gets the note y-position on the bottom of the note head or tab number.
     */
    Bottom(3),
    /**
     * Gets the note y-position on the bottom of the note stem or tab number.
     */
    BottomWithStem(4);
    companion object{
        public fun fromValue(v:Double): NoteYPosition{
            return when(v.toInt()){
                TopWithStem.value -> TopWithStem
                Top.value -> Top
                Center.value -> Center
                Bottom.value -> Bottom
                BottomWithStem.value -> BottomWithStem
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

/**
 * Lists the different position modes for 
 */
public enum class NoteXPosition(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Gets the note x-position on left of the note head or tab number.
     */
    Left(0),
    /**
     * Gets the note x-position on the center of the note head or tab number.
     */
    Center(1),
    /**
     * Gets the note x-position on the right of the note head or tab number.
     */
    Right(2);
    companion object{
        public fun fromValue(v:Double): NoteXPosition{
            return when(v.toInt()){
                Left.value -> Left
                Center.value -> Center
                Right.value -> Right
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

