// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * This renderer is responsible for displaying effects above or below the other staves
 * like the vibrato.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class EffectBarRenderer: alphaTab.rendering.BarRendererBase
{
    private var _infos: alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>
    
    private var _bands: alphaTab.collections.List<alphaTab.rendering.EffectBand> = alphaTab.collections.List<alphaTab.rendering.EffectBand>(
    )
    
    
    private var _bandLookup: alphaTab.collections.Map<String, alphaTab.rendering.EffectBand> = alphaTab.collections.Map<String, alphaTab.rendering.EffectBand>()
    
    public var sizingInfo: alphaTab.rendering.EffectBandSizingInfo? = null
    
    public constructor(renderer: alphaTab.rendering.ScoreRenderer, bar: alphaTab.model.Bar, infos: alphaTab.collections.List<alphaTab.rendering.EffectBarRendererInfo>)
        : super(renderer, bar){
        this._infos = infos
    }
    
    protected override fun updateSizes(): Unit{
        this.topOverflow = 0.0
        this.bottomOverflow = 0.0
        this.topPadding = 0.0
        this.bottomPadding = 0.0
        this.updateHeight()
        super.updateSizes()
    }
    
    public override fun finalizeRenderer(): Boolean{
        var didChange: Boolean = super.finalizeRenderer()
        if (this.updateHeight())
        {
            didChange = true
        }
        return didChange
    }
    
    private fun updateHeight(): Boolean{
        if (!alphaTab.core.TypeHelper.isTruthy(this.sizingInfo))
        {
            return false
        }
        var y: Double = 0.0
        for (slot in this.sizingInfo!!.slots)
        {
            slot.shared.y = y
            for (band in slot.bands)
            {
                band.y = y
                band.height = slot.shared.height
            }
            y += slot.shared.height
        }
        if (y != this.height)
        {
            this.height = y
            return true
        }
        return false
    }
    
    public override fun applyLayoutingInfo(): Boolean{
        if (!super.applyLayoutingInfo())
        {
            return false
        }
        if (this.index > 0)
        {
            var previousRenderer: alphaTab.rendering.EffectBarRenderer = (this.previousRenderer as alphaTab.rendering.EffectBarRenderer)
            this.sizingInfo = previousRenderer.sizingInfo
        }
        else 
        {
            this.sizingInfo = alphaTab.rendering.EffectBandSizingInfo()
        }
        for (effectBand in this._bands)
        {
            effectBand.alignGlyphs()
            if (!effectBand.isEmpty)
            {
                this.sizingInfo!!.register(effectBand)
            }
        }
        this.updateHeight()
        return true
    }
    
    /**
     */
    public override fun scaleToWidth(width: Double): Unit{
        super.scaleToWidth(width)
        for (effectBand in this._bands)
        {
            effectBand.alignGlyphs()
        }
    }
    
    protected override fun createBeatGlyphs(): Unit{
        this._bands = alphaTab.collections.List<alphaTab.rendering.EffectBand>(
        )
        
        this._bandLookup = alphaTab.collections.Map<String, alphaTab.rendering.EffectBand>()
        for (voice in this.bar.voices)
        {
            if (this.hasVoiceContainer(voice))
            {
                for (info in this._infos)
                {
                    var band: alphaTab.rendering.EffectBand = alphaTab.rendering.EffectBand(voice, info)
                    band.renderer = this
                    band.doLayout()
                    this._bands.push(band)
                    this._bandLookup.set((voice.index).toInvariantString() + "." + info.effectId, band)
                }
            }
        }
        for (voice in this.bar.voices)
        {
            if (this.hasVoiceContainer(voice))
            {
                this.createVoiceGlyphs(voice)
            }
        }
        for (effectBand in this._bands)
        {
            if (effectBand.isLinkedToPrevious)
            {
                this.isLinkedToPrevious = true
            }
        }
    }
    
    /**
     */
    protected override fun createVoiceGlyphs(v: alphaTab.model.Voice): Unit{
        for (b in v.beats)
        {
            var container: alphaTab.rendering.glyphs.BeatContainerGlyph = alphaTab.rendering.glyphs.BeatContainerGlyph(b, this.getVoiceContainer(v)!!)
            container.preNotes = alphaTab.rendering.glyphs.BeatGlyphBase()
            container.onNotes = alphaTab.rendering.glyphs.BeatOnNoteGlyphBase()
            this.addBeatGlyph(container)
            for (effectBand in this._bands)
            {
                effectBand.createGlyph(b)
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        this.paintBackground(cx, cy, canvas)
        for (effectBand in this._bands)
        {
            canvas.color = if(effectBand.voice.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
            if (!effectBand.isEmpty)
            {
                effectBand.paint(cx + this.x, cy + this.y, canvas)
            }
        }
    }
    
    /**
     */
    public fun getBand(voice: alphaTab.model.Voice, effectId: String): alphaTab.rendering.EffectBand?{
        var id: String = (voice.index).toInvariantString() + "." + effectId
        if (this._bandLookup.has(id))
        {
            return this._bandLookup.get(id)!!
        }
        return null
    }
    
}

