// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * Represents the public interface of the component that can render scores.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public interface IScoreRenderer
{
    /**
     * Gets or sets the lookup which allows fast access to beats at a given position.
     */
    val boundsLookup: alphaTab.rendering.utils.BoundsLookup?
    /**
     * Gets or sets the width of the score to be rendered.
     */
    var width: Double
    /**
     * Initiates a full re-rendering of the score using the current settings.
     */
    fun render(): Unit
    
    /**
     * Initiates a resize-optimized re-rendering of the score using the current settings.
     */
    fun resizeRender(): Unit
    
    /**
     * Initiates the rendering of the specified tracks of the given score.
     * @param score The score defining the tracks.
     * @param trackIndexes The indexes of the tracks to draw.
     */
    fun renderScore(score: alphaTab.model.Score?, trackIndexes: alphaTab.collections.DoubleList?): Unit
    
    /**
     * Initiates the rendering of a partial render result which the renderer
     * should have layed out already.
     * @param resultId the result ID as provided by the  event.
     */
    fun renderResult(resultId: String): Unit
    
    /**
     * Updates the settings to the given object.
     */
    fun updateSettings(settings: alphaTab.Settings): Unit
    
    /**
     * Destroys the renderer.
     */
    fun destroy(): Unit
    
    /**
     * Occurs before the rendering of the tracks starts.
     */
    val preRender: alphaTab.IEventEmitterOfT<Boolean>
    /**
     * Occurs after the rendering of the tracks finished.
     */
    val renderFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>
    /**
     * Occurs whenever a part of the whole music sheet is rendered and can be displayed.
     */
    val partialRenderFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>
    /**
     * Occurs whenever a part of the whole music sheet is layed out but not yet rendered.
     */
    val partialLayoutFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>
    /**
     * Occurs when the whole rendering and layout process finished.
     */
    val postRenderFinished: alphaTab.IEventEmitter
    /**
     * Occurs whenever an error happens.
     */
    val error: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error>
}

