// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * This BarRenderer renders a bar using standard music notation.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ScoreBarRenderer: alphaTab.rendering.BarRendererBase
{
    public var simpleWhammyOverflow: Double = 0.0
    
    private var _firstLineY: Double = 0.0
    
    public var accidentalHelper: alphaTab.rendering.utils.AccidentalHelper
    public constructor(renderer: alphaTab.rendering.ScoreRenderer, bar: alphaTab.model.Bar)
        : super(renderer, bar){
        this._startSpacing = false
        this.accidentalHelper = alphaTab.rendering.utils.AccidentalHelper(this)
    }
    
    /**
     */
    public fun getBeatDirection(beat: alphaTab.model.Beat): alphaTab.rendering.utils.BeamDirection{
        return this.helpers.getBeamingHelperForBeat(beat).direction
    }
    
    public val lineOffset: Double
    get(){
        return (alphaTab.rendering.BarRendererBase.LineSpacing + 1.0) * this.scale
    }
    
    protected override fun updateSizes(): Unit{
        var res: alphaTab.RenderingResources = this.resources
        var glyphOverflow: Double = res.tablatureFont.size / (2.0).toDouble() + res.tablatureFont.size * 0.2
        this.topPadding = glyphOverflow * this.scale
        this.bottomPadding = glyphOverflow * this.scale
        this.height = this.lineOffset * 4.0 + this.topPadding + this.bottomPadding
        this.updateFirstLineY()
        super.updateSizes()
    }
    
    private fun updateFirstLineY(): Unit{
        var fullLineHeight: Double = this.lineOffset * 4.0
        var actualLineHeight: Double = (this.bar.staff.standardNotationLineCount - 1.0) * this.lineOffset
        this._firstLineY = (fullLineHeight - actualLineHeight) / (2.0).toDouble()
    }
    
    public override fun doLayout(): Unit{
        this.updateFirstLineY()
        super.doLayout()
        if (!this.bar.isEmpty && alphaTab.core.TypeHelper.isTruthy(this.accidentalHelper.maxLineBeat))
        {
            var top: Double = this.getScoreY(-2.0)
            var bottom: Double = this.getScoreY(6.0)
            var whammyOffset: Double = this.simpleWhammyOverflow
            this.registerOverflowTop(whammyOffset)
            var maxNoteY: Double = this.getScoreY(this.accidentalHelper.maxLine)
            var maxNoteHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.getBeamingHelperForBeat(this.accidentalHelper.maxLineBeat!!)
            if (maxNoteHelper.direction == alphaTab.rendering.utils.BeamDirection.Up)
            {
                maxNoteY -= this.getStemSize(maxNoteHelper)
                maxNoteY -= maxNoteHelper.fingeringCount * this.resources.graceFont.size
                if (maxNoteHelper.hasTuplet)
                {
                    maxNoteY -= this.resources.effectFont.size * 2.0
                }
            }
            if (maxNoteHelper.hasTuplet)
            {
                maxNoteY -= this.resources.effectFont.size * 1.5
            }
            if (maxNoteY < top)
            {
                this.registerOverflowTop(alphaTab.core.ecmaScript.Math.abs(maxNoteY) + whammyOffset)
            }
            var minNoteY: Double = this.getScoreY(this.accidentalHelper.minLine)
            var minNoteHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.getBeamingHelperForBeat(this.accidentalHelper.minLineBeat!!)
            if (minNoteHelper.direction == alphaTab.rendering.utils.BeamDirection.Down)
            {
                minNoteY += this.getStemSize(minNoteHelper)
                minNoteY += minNoteHelper.fingeringCount * this.resources.graceFont.size
            }
            if (minNoteY > bottom)
            {
                this.registerOverflowBottom(alphaTab.core.ecmaScript.Math.abs(minNoteY) - bottom)
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        super.paint(cx, cy, canvas)
        this.paintBeams(cx, cy, canvas)
        this.paintTuplets(cx, cy, canvas)
    }
    
    /**
     */
    private fun paintTuplets(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        for (voice in this.bar.voices)
        {
            if (this.hasVoiceContainer(voice))
            {
                var container: alphaTab.rendering.glyphs.VoiceContainerGlyph = this.getVoiceContainer(voice)!!
                for (tupletGroup in container.tupletGroups)
                {
                    this.paintTupletHelper(cx + this.beatGlyphsStart, cy, canvas, tupletGroup)
                }
            }
        }
    }
    
    /**
     */
    private fun paintBeams(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = this.helpers.beamHelpers.length
            
            while(i < j){
                try{
                    var v: alphaTab.collections.List<alphaTab.rendering.utils.BeamingHelper> = this.helpers.beamHelpers[(i).toInt()]
                    if(true) {
                        var k: Double = 0.0
                        var l: Double = v.length
                        
                        while(k < l){
                            try{
                                var h: alphaTab.rendering.utils.BeamingHelper = v[(k).toInt()]
                                this.paintBeamHelper(cx + this.beatGlyphsStart, cy, canvas, h)
                            }
                            finally{
                                k++
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun paintBeamHelper(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        canvas.color = if(h.voice!!.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
        if (!h.isRestBeamHelper)
        {
            if (h.beats.length == 1.0)
            {
                this.paintFlag(cx, cy, canvas, h)
            }
            else 
            {
                this.paintBar(cx, cy, canvas, h)
            }
        }
    }
    
    /**
     */
    private fun paintTupletHelper(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.model.TupletGroup): Unit{
        var res: alphaTab.RenderingResources = this.resources
        var oldAlign: alphaTab.platform.TextAlign = canvas.textAlign
        var oldBaseLine: alphaTab.platform.TextBaseline = canvas.textBaseline
        canvas.color = if(h.voice.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
        canvas.textAlign = alphaTab.platform.TextAlign.Center
        canvas.textBaseline = alphaTab.platform.TextBaseline.Middle
        var s: String
        var num: Double = h.beats[(0).toInt()].tupletNumerator
        var den: Double = h.beats[(0).toInt()].tupletDenominator
        if (num == 2.0 && den == 3.0)
        {
            s = "2"
        }
        else if (num == 3.0 && den == 2.0)
        {
            s = "3"
        }
        else if (num == 4.0 && den == 6.0)
        {
            s = "4"
        }
        else if (num == 5.0 && den == 4.0)
        {
            s = "5"
        }
        else if (num == 6.0 && den == 4.0)
        {
            s = "6"
        }
        else if (num == 7.0 && den == 4.0)
        {
            s = "7"
        }
        else if (num == 9.0 && den == 8.0)
        {
            s = "9"
        }
        else if (num == 10.0 && den == 8.0)
        {
            s = "10"
        }
        else if (num == 11.0 && den == 8.0)
        {
            s = "11"
        }
        else if (num == 12.0 && den == 8.0)
        {
            s = "12"
        }
        else if (num == 13.0 && den == 8.0)
        {
            s = "13"
        }
        else 
        {
            s = (num).toInvariantString() + ":" + (den).toInvariantString()
        }
        var offset: Double = 10.0 * this.scale
        var size: Double = 5.0 * this.scale
        if (h.beats.length == 1.0 || !h.isFull)
        {
            if(true) {
                var i: Double = 0.0
                var j: Double = h.beats.length
                
                while(i < j){
                    try{
                        var beat: alphaTab.model.Beat = h.beats[(i).toInt()]
                        var beamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(beat.index)!!
                        if (!alphaTab.core.TypeHelper.isTruthy(beamingHelper))
                        {
                            continue
                        }
                        var direction: alphaTab.rendering.utils.BeamDirection = beamingHelper.direction
                        var tupletX: Double = beamingHelper.getBeatLineX(beat)
                        var tupletY: Double = this.calculateBeamYWithDirection(beamingHelper, tupletX, direction)
                        if (direction == alphaTab.rendering.utils.BeamDirection.Down)
                        {
                            offset *= -1.0
                            size *= -1.0
                        }
                        canvas.font = res.effectFont
                        canvas.fillText(s, cx + this.x + tupletX, cy + this.y + tupletY - offset - size)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        else 
        {
            var firstBeat: alphaTab.model.Beat = h.beats[(0).toInt()]
            var lastBeat: alphaTab.model.Beat = h.beats[(h.beats.length - 1.0).toInt()]
            var firstNonRestBeat: alphaTab.model.Beat? = null
            var lastNonRestBeat: alphaTab.model.Beat? = null
            if(true) {
                var i: Double = 0.0
                
                while(i < h.beats.length){
                    try{
                        if (!h.beats[(i).toInt()].isRest)
                        {
                            firstNonRestBeat = h.beats[(i).toInt()]
                            break
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            if(true) {
                var i: Double = h.beats.length - 1.0
                
                while(i >= 0){
                    try{
                        if (!h.beats[(i).toInt()].isRest)
                        {
                            lastNonRestBeat = h.beats[(i).toInt()]
                            break
                        }
                    }
                    finally{
                        i--
                    }
                }
            }
            var isRestOnly: Boolean = false
            if (!alphaTab.core.TypeHelper.isTruthy(firstNonRestBeat))
            {
                firstNonRestBeat = firstBeat
                isRestOnly = true
            }
            if (!alphaTab.core.TypeHelper.isTruthy(lastNonRestBeat))
            {
                lastNonRestBeat = lastBeat
            }
            var firstBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(firstBeat.index)!!
            var lastBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(lastBeat.index)!!
            var startX: Double = firstBeamingHelper.getBeatLineX(firstBeat)
            var endX: Double = lastBeamingHelper.getBeatLineX(lastBeat)
            var firstNonRestBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(firstNonRestBeat.index)!!
            var lastNonRestBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(lastNonRestBeat.index)!!
            var direction: alphaTab.rendering.utils.BeamDirection = firstBeamingHelper.direction
            var startY: Double = this.calculateBeamYWithDirection(firstNonRestBeamingHelper, startX, direction)
            var endY: Double = this.calculateBeamYWithDirection(lastNonRestBeamingHelper, endX, direction)
            if (isRestOnly)
            {
                startY = alphaTab.core.ecmaScript.Math.max(startY, endY)
                endY = startY
            }
            canvas.font = res.effectFont
            var sw: Double = canvas.measureText(s)
            var sp: Double = 3.0 * this.scale
            var middleX: Double = (startX + endX) / (2.0).toDouble()
            var offset1X: Double = middleX - sw / (2.0).toDouble() - sp
            var offset2X: Double = middleX + sw / (2.0).toDouble() + sp
            var k: Double = (endY - startY) / (endX - startX)
            var d: Double = startY - k * startX
            var offset1Y: Double = k * offset1X + d
            var middleY: Double = k * middleX + d
            var offset2Y: Double = k * offset2X + d
            if (direction == alphaTab.rendering.utils.BeamDirection.Down)
            {
                offset *= -1.0
                size *= -1.0
            }
            canvas.beginPath()
            canvas.moveTo(cx + this.x + startX, (((cy + this.y + startY - offset)).toInt() or 0).toDouble())
            canvas.lineTo(cx + this.x + startX, (((cy + this.y + startY - offset - size)).toInt() or 0).toDouble())
            canvas.lineTo(cx + this.x + offset1X, (((cy + this.y + offset1Y - offset - size)).toInt() or 0).toDouble())
            canvas.stroke()
            canvas.beginPath()
            canvas.moveTo(cx + this.x + offset2X, (((cy + this.y + offset2Y - offset - size)).toInt() or 0).toDouble())
            canvas.lineTo(cx + this.x + endX, (((cy + this.y + endY - offset - size)).toInt() or 0).toDouble())
            canvas.lineTo(cx + this.x + endX, (((cy + this.y + endY - offset)).toInt() or 0).toDouble())
            canvas.stroke()
            canvas.fillText(s, cx + this.x + middleX, cy + this.y + middleY - offset - size)
        }
        canvas.textAlign = oldAlign
        canvas.textBaseline = oldBaseLine
    }
    
    /**
     */
    public fun getStemSize(helper: alphaTab.rendering.utils.BeamingHelper): Double{
        var size: Double = if(helper.beats.length == 1.0)  this.getFlagStemSize(helper.shortestDuration) else this.getBarStemSize(helper.shortestDuration)
        if (helper.isGrace)
        {
            size = size * alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale
        }
        return size
    }
    
    /**
     */
    private fun getBarStemSize(duration: alphaTab.model.Duration): Double{
        var size: Double = 0.0
        when (duration)
        {
            alphaTab.model.Duration.QuadrupleWhole, alphaTab.model.Duration.Half, alphaTab.model.Duration.Quarter, alphaTab.model.Duration.Eighth, alphaTab.model.Duration.Sixteenth -> 
            {
                size = 6.0
            }
            alphaTab.model.Duration.ThirtySecond -> 
            {
                size = 8.0
            }
            alphaTab.model.Duration.SixtyFourth -> 
            {
                size = 9.0
            }
            alphaTab.model.Duration.OneHundredTwentyEighth -> 
            {
                size = 9.0
            }
            alphaTab.model.Duration.TwoHundredFiftySixth -> 
            {
                size = 10.0
            }
            else -> 
            {
                size = 0.0
            }
        }
        return this.getScoreHeight(size)
    }
    
    /**
     */
    private fun getFlagStemSize(duration: alphaTab.model.Duration): Double{
        var size: Double = 0.0
        when (duration)
        {
            alphaTab.model.Duration.QuadrupleWhole, alphaTab.model.Duration.Half, alphaTab.model.Duration.Quarter, alphaTab.model.Duration.Eighth, alphaTab.model.Duration.Sixteenth, alphaTab.model.Duration.ThirtySecond, alphaTab.model.Duration.SixtyFourth, alphaTab.model.Duration.OneHundredTwentyEighth, alphaTab.model.Duration.TwoHundredFiftySixth -> 
            {
                size = 6.0
            }
            else -> 
            {
                size = 0.0
            }
        }
        return this.getScoreHeight(size)
    }
    
    public override val middleYPosition: Double
    get(){
        return this.getScoreY(this.bar.staff.standardNotationLineCount - 1.0)
    }
    
    /**
     */
    public override fun getNoteY(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteYPosition): Double{
        var y: Double = super.getNoteY(note, requestedPosition)
        if (alphaTab.core.Globals.isNaN(y))
        {
            var line: Double = alphaTab.rendering.utils.AccidentalHelper.computeLineWithoutAccidentals(this.bar, note)
            y = this.getScoreY(line)
        }
        return y
    }
    
    /**
     */
    public fun calculateBeamY(h: alphaTab.rendering.utils.BeamingHelper, x: Double): Double{
        return this.calculateBeamYWithDirection(h, x, h.direction)
    }
    
    public override fun applyLayoutingInfo(): Boolean{
        var result: Boolean = super.applyLayoutingInfo()
        if (result && this.bar.isMultiVoice)
        {
            var top: Double = this.getScoreY(-2.0)
            var bottom: Double = this.getScoreY(6.0)
            var minMax: alphaTab.collections.DoubleList = this.helpers.collisionHelper.getBeatMinMaxY()
            if (minMax[(0).toInt()] < top)
            {
                this.registerOverflowTop(alphaTab.core.ecmaScript.Math.abs(minMax[(0).toInt()]))
            }
            if (minMax[(1).toInt()] > bottom)
            {
                this.registerOverflowBottom(alphaTab.core.ecmaScript.Math.abs(minMax[(1).toInt()]) - bottom)
            }
        }
        return result
    }
    
    /**
     */
    private fun calculateBeamYWithDirection(h: alphaTab.rendering.utils.BeamingHelper, x: Double, direction: alphaTab.rendering.utils.BeamDirection): Double{
        var stemSize: Double = this.getStemSize(h)
        if (!h.drawingInfos.has(direction))
        {
            var drawingInfo: alphaTab.rendering.utils.BeamingHelperDrawInfo = alphaTab.rendering.utils.BeamingHelperDrawInfo()
            h.drawingInfos.set(direction, drawingInfo)
            var firstBeat: alphaTab.model.Beat = h.beats[(0).toInt()]
            var lastBeat: alphaTab.model.Beat = h.beats[(h.beats.length - 1.0).toInt()]
            var isRest: Boolean = h.isRestBeamHelper
            drawingInfo.startBeat = firstBeat
            drawingInfo.startX = h.getBeatLineX(firstBeat)
            if (isRest)
            {
                drawingInfo.startY = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.getScoreY(h.minRestLine!!) else this.getScoreY(h.maxRestLine!!)
            }
            else 
            {
                drawingInfo.startY = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.getScoreY(this.accidentalHelper.getMinLine(firstBeat)) - stemSize else this.getScoreY(this.accidentalHelper.getMaxLine(firstBeat)) + stemSize
            }
            drawingInfo.endBeat = lastBeat
            drawingInfo.endX = h.getBeatLineX(lastBeat)
            if (isRest)
            {
                drawingInfo.endY = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.getScoreY(h.minRestLine!!) else this.getScoreY(h.maxRestLine!!)
            }
            else 
            {
                drawingInfo.endY = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.getScoreY(this.accidentalHelper.getMinLine(lastBeat)) - stemSize else this.getScoreY(this.accidentalHelper.getMaxLine(lastBeat)) + stemSize
            }
            var maxDistance: Double = 10.0 * this.scale
            if (direction == alphaTab.rendering.utils.BeamDirection.Down && drawingInfo.startY > drawingInfo.endY && drawingInfo.startY - drawingInfo.endY > maxDistance)
            {
                drawingInfo.endY = drawingInfo.startY - maxDistance
            }
            if (direction == alphaTab.rendering.utils.BeamDirection.Down && drawingInfo.endY > drawingInfo.startY && drawingInfo.endY - drawingInfo.startY > maxDistance)
            {
                drawingInfo.startY = drawingInfo.endY - maxDistance
            }
            if (direction == alphaTab.rendering.utils.BeamDirection.Up && drawingInfo.startY < drawingInfo.endY && drawingInfo.endY - drawingInfo.startY > maxDistance)
            {
                drawingInfo.endY = drawingInfo.startY + maxDistance
            }
            if (direction == alphaTab.rendering.utils.BeamDirection.Up && drawingInfo.endY < drawingInfo.startY && drawingInfo.startY - drawingInfo.endY > maxDistance)
            {
                drawingInfo.startY = drawingInfo.endY + maxDistance
            }
            if (h.beats.length > 1)
            {
                if (direction == alphaTab.rendering.utils.BeamDirection.Up)
                {
                    var yNeededForHighestNote: Double = this.getScoreY(this.accidentalHelper.getMinLine(h.beatOfHighestNote)) - stemSize
                    var yGivenByCurrentValues: Double = drawingInfo.calcY(h.getBeatLineX(h.beatOfHighestNote))
                    var diff: Double = yGivenByCurrentValues - yNeededForHighestNote
                    if (diff > 0)
                    {
                        drawingInfo.startY -= diff
                        drawingInfo.endY -= diff
                    }
                }
                else 
                {
                    var yNeededForLowestNote: Double = this.getScoreY(this.accidentalHelper.getMaxLine(h.beatOfLowestNote)) + stemSize
                    var yGivenByCurrentValues: Double = drawingInfo.calcY(h.getBeatLineX(h.beatOfLowestNote))
                    var diff: Double = yNeededForLowestNote - yGivenByCurrentValues
                    if (diff > 0)
                    {
                        drawingInfo.startY += diff
                        drawingInfo.endY += diff
                    }
                }
                if (h.minRestLine != null || h.maxRestLine != null)
                {
                    var barCount: Double = alphaTab.model.ModelUtils.getIndex(h.shortestDuration) - 2.0
                    var scaleMod: Double = if(h.isGrace)  alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale else 1.0
                    var barSpacing: Double = barCount * (alphaTab.rendering.BarRendererBase.BeamSpacing + alphaTab.rendering.BarRendererBase.BeamThickness) * this.scale * scaleMod
                    barSpacing += alphaTab.rendering.BarRendererBase.BeamSpacing
                    if (direction == alphaTab.rendering.utils.BeamDirection.Up && h.minRestLine != null)
                    {
                        var yNeededForRest: Double = this.getScoreY(h.minRestLine!!) - barSpacing
                        var yGivenByCurrentValues: Double = drawingInfo.calcY(h.getBeatLineX(h.beatOfMinRestLine!!))
                        var diff: Double = yGivenByCurrentValues - yNeededForRest
                        if (diff > 0)
                        {
                            drawingInfo.startY -= diff
                            drawingInfo.endY -= diff
                        }
                    }
                    else if (direction == alphaTab.rendering.utils.BeamDirection.Down && h.maxRestLine != null)
                    {
                        var yNeededForRest: Double = this.getScoreY(h.maxRestLine!!) + barSpacing
                        var yGivenByCurrentValues: Double = drawingInfo.calcY(h.getBeatLineX(h.beatOfMaxRestLine!!))
                        var diff: Double = yNeededForRest - yGivenByCurrentValues
                        if (diff > 0)
                        {
                            drawingInfo.startY += diff
                            drawingInfo.endY += diff
                        }
                    }
                }
            }
        }
        return h.drawingInfos.get(direction)!!.calcY(x)
    }
    
    /**
     */
    private fun paintBar(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = h.beats.length
            
            while(i < j){
                try{
                    var beat: alphaTab.model.Beat = h.beats[(i).toInt()]
                    var isGrace: Boolean = beat.graceType != alphaTab.model.GraceType.None
                    var scaleMod: Double = if(isGrace)  alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale else 1.0
                    var beatLineX: Double = h.getBeatLineX(beat)
                    var direction: alphaTab.rendering.utils.BeamDirection = h.direction
                    var y1: Double = cy + this.y
                    y1 += if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.getScoreY(this.accidentalHelper.getMaxLine(beat)) else this.getScoreY(this.accidentalHelper.getMinLine(beat))
                    var y2: Double = cy + this.y
                    y2 += this.calculateBeamY(h, beatLineX)
                    canvas.lineWidth = alphaTab.rendering.BarRendererBase.StemWidth * this.scale
                    canvas.beginPath()
                    canvas.moveTo(cx + this.x + beatLineX, y1)
                    canvas.lineTo(cx + this.x + beatLineX, y2)
                    canvas.stroke()
                    canvas.lineWidth = this.scale
                    var fingeringY: Double = y2
                    if (direction == alphaTab.rendering.utils.BeamDirection.Down)
                    {
                        fingeringY += canvas.font.size * 2.0
                    }
                    else if (i != 0.0)
                    {
                        fingeringY -= canvas.font.size * 1.5
                    }
                    this.paintFingering(canvas, beat, cx + this.x + beatLineX, direction, fingeringY)
                    var brokenBarOffset: Double = 6.0 * this.scale * scaleMod
                    var barSpacing: Double = (alphaTab.rendering.BarRendererBase.BeamSpacing + alphaTab.rendering.BarRendererBase.BeamThickness) * this.scale * scaleMod
                    var barSize: Double = alphaTab.rendering.BarRendererBase.BeamThickness * this.scale * scaleMod
                    var barCount: Double = alphaTab.model.ModelUtils.getIndex(beat.duration) - 2.0
                    var barStart: Double = cy + this.y
                    if (direction == alphaTab.rendering.utils.BeamDirection.Down)
                    {
                        barSpacing = -barSpacing
                        barSize = -barSize
                    }
                    if(true) {
                        var barIndex: Double = 0.0
                        
                        while(barIndex < barCount){
                            try{
                                var barStartX: Double = 0.0
                                var barEndX: Double = 0.0
                                var barStartY: Double = 0.0
                                var barEndY: Double = 0.0
                                var barY: Double = barStart + barIndex * barSpacing
                                if (i < h.beats.length - 1.0)
                                {
                                    if (alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(beat, h.beats[(i + 1.0).toInt()], barIndex))
                                    {
                                        barStartX = beatLineX
                                        barEndX = h.getBeatLineX(h.beats[(i + 1.0).toInt()])
                                    }
                                    else if (i == 0.0 || !alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(h.beats[(i - 1.0).toInt()], beat, barIndex))
                                    {
                                        barStartX = beatLineX
                                        barEndX = barStartX + brokenBarOffset
                                    }
                                    else 
                                    {
                                        continue
                                    }
                                    barStartY = barY + this.calculateBeamY(h, barStartX)
                                    barEndY = barY + this.calculateBeamY(h, barEndX)
                                    alphaTab.rendering.ScoreBarRenderer.paintSingleBar(
                                        canvas
                                        , 
                                        cx + this.x + barStartX
                                        , 
                                        barStartY
                                        , 
                                        cx + this.x + barEndX
                                        , 
                                        barEndY
                                        , 
                                        barSize
                                    
                                    )
                                }
                                else if (i > 0 && !alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(beat, h.beats[(i - 1.0).toInt()], barIndex))
                                {
                                    barStartX = beatLineX - brokenBarOffset
                                    barEndX = beatLineX
                                    barStartY = barY + this.calculateBeamY(h, barStartX)
                                    barEndY = barY + this.calculateBeamY(h, barEndX)
                                    alphaTab.rendering.ScoreBarRenderer.paintSingleBar(
                                        canvas
                                        , 
                                        cx + this.x + barStartX
                                        , 
                                        barStartY
                                        , 
                                        cx + this.x + barEndX
                                        , 
                                        barEndY
                                        , 
                                        barSize
                                    
                                    )
                                }
                            }
                            finally{
                                barIndex++
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun paintFlag(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        var beat: alphaTab.model.Beat = h.beats[(0).toInt()]
        if (beat.graceType == alphaTab.model.GraceType.BendGrace || (beat.graceType != alphaTab.model.GraceType.None && this.settings.notation.notationMode == alphaTab.NotationMode.SongBook))
        {
            return
        }
        var isGrace: Boolean = beat.graceType != alphaTab.model.GraceType.None
        var scaleMod: Double = if(isGrace)  alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale else 1.0
        var stemSize: Double = this.getFlagStemSize(h.shortestDuration)
        var beatLineX: Double = h.getBeatLineX(beat)
        var direction: alphaTab.rendering.utils.BeamDirection = h.direction
        var topY: Double = this.getScoreY(this.accidentalHelper.getMinLine(beat))
        var bottomY: Double = this.getScoreY(this.accidentalHelper.getMaxLine(beat))
        var beamY: Double = 0.0
        var fingeringY: Double = 0.0
        if (direction == alphaTab.rendering.utils.BeamDirection.Down)
        {
            bottomY += stemSize * scaleMod
            beamY = bottomY
            fingeringY = cy + this.y + bottomY
        }
        else 
        {
            topY -= stemSize * scaleMod
            beamY = topY
            fingeringY = cy + this.y + topY
        }
        this.paintFingering(canvas, beat, cx + this.x + beatLineX, direction, fingeringY)
        if (!h.hasLine)
        {
            return
        }
        canvas.lineWidth = alphaTab.rendering.BarRendererBase.StemWidth * this.scale
        canvas.beginPath()
        canvas.moveTo(cx + this.x + beatLineX, cy + this.y + topY)
        canvas.lineTo(cx + this.x + beatLineX, cy + this.y + bottomY)
        canvas.stroke()
        canvas.lineWidth = this.scale
        if (beat.graceType == alphaTab.model.GraceType.BeforeBeat)
        {
            var graceSizeY: Double = 15.0 * this.scale
            var graceSizeX: Double = 12.0 * this.scale
            canvas.beginPath()
            if (direction == alphaTab.rendering.utils.BeamDirection.Down)
            {
                canvas.moveTo(cx + this.x + beatLineX - graceSizeX / (2.0).toDouble(), cy + this.y + bottomY - graceSizeY)
                canvas.lineTo(cx + this.x + beatLineX + graceSizeX / (2.0).toDouble(), cy + this.y + bottomY)
            }
            else 
            {
                canvas.moveTo(cx + this.x + beatLineX - graceSizeX / (2.0).toDouble(), cy + this.y + topY + graceSizeY)
                canvas.lineTo(cx + this.x + beatLineX + graceSizeX / (2.0).toDouble(), cy + this.y + topY)
            }
            canvas.stroke()
        }
        if (h.hasFlag)
        {
            var glyph: alphaTab.rendering.glyphs.FlagGlyph = alphaTab.rendering.glyphs.FlagGlyph(beatLineX - this.scale / (2.0).toDouble(), beamY, beat.duration, direction, isGrace)
            glyph.renderer = this
            glyph.doLayout()
            glyph.paint(cx + this.x, cy + this.y, canvas)
        }
    }
    
    /**
     */
    private fun paintFingering(canvas: alphaTab.platform.ICanvas, beat: alphaTab.model.Beat, beatLineX: Double, direction: alphaTab.rendering.utils.BeamDirection, topY: Double): Unit{
        var parambeatLineX = beatLineX
        var paramtopY = topY
        var settings: alphaTab.Settings = this.settings
        if (settings.notation.fingeringMode != alphaTab.FingeringMode.ScoreDefault && settings.notation.fingeringMode != alphaTab.FingeringMode.ScoreForcePiano)
        {
            return
        }
        if (direction == alphaTab.rendering.utils.BeamDirection.Up)
        {
            parambeatLineX -= 10.0 * this.scale
        }
        else 
        {
            parambeatLineX += 3.0 * this.scale
        }
        var noteList: alphaTab.collections.List<alphaTab.model.Note> = beat.notes.slice(0.0)
        noteList.sort(fun(a: alphaTab.model.Note, b: alphaTab.model.Note): Double{
            return a.realValue - b.realValue
        }
        )
        if(true) {
            var n: Double = 0.0
            
            while(n < noteList.length){
                try{
                    var note: alphaTab.model.Note = noteList[(n).toInt()]
                    var text: String? = null
                    if (note.leftHandFinger != alphaTab.model.Fingers.Unknown)
                    {
                        text = alphaTab.model.ModelUtils.fingerToString(settings, beat, note.leftHandFinger, true)
                    }
                    else if (note.rightHandFinger != alphaTab.model.Fingers.Unknown)
                    {
                        text = alphaTab.model.ModelUtils.fingerToString(settings, beat, note.rightHandFinger, false)
                    }
                    if (!alphaTab.core.TypeHelper.isTruthy(text))
                    {
                        continue
                    }
                    canvas.fillText(text, parambeatLineX, paramtopY)
                    paramtopY -= (canvas.font.size).toInt() or 0
                }
                finally{
                    n++
                }
            }
        }
    }
    
    protected override fun createPreBeatGlyphs(): Unit{
        super.createPreBeatGlyphs()
        if (this.bar.masterBar.isRepeatStart)
        {
            this.addPreBeatGlyph(alphaTab.rendering.glyphs.RepeatOpenGlyph(0.0, 0.0, 1.5, 3.0))
        }
        if (this.isFirstOfLine || this.bar.clef != this.bar.previousBar!!.clef || this.bar.clefOttava != this.bar.previousBar!!.clefOttava)
        {
            var offset: Double = 0.0
            when (this.bar.clef)
            {
                alphaTab.model.Clef.Neutral -> 
                {
                    offset = this.bar.staff.standardNotationLineCount - 1.0
                }
                alphaTab.model.Clef.F4 -> 
                {
                    offset = 2.0
                }
                alphaTab.model.Clef.C3 -> 
                {
                    offset = 4.0
                }
                alphaTab.model.Clef.C4 -> 
                {
                    offset = 2.0
                }
                alphaTab.model.Clef.G2 -> 
                {
                    offset = 6.0
                }
                else -> { }
            }
            this.createStartSpacing()
            this.addPreBeatGlyph(alphaTab.rendering.glyphs.ClefGlyph(0.0, this.getScoreY(offset) + 0.5 * alphaTab.rendering.BarRendererBase.StaffLineThickness, this.bar.clef, this.bar.clefOttava))
        }
        if ((this.index == 0.0 && this.bar.masterBar.keySignature != alphaTab.model.KeySignature.C) || (alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) && this.bar.masterBar.keySignature != this.bar.previousBar!!.masterBar.keySignature))
        {
            this.createStartSpacing()
            this.createKeySignatureGlyphs()
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) || (alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) && this.bar.masterBar.timeSignatureNumerator != this.bar.previousBar!!.masterBar.timeSignatureNumerator) || (alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) && this.bar.masterBar.timeSignatureDenominator != this.bar.previousBar!!.masterBar.timeSignatureDenominator))
        {
            this.createStartSpacing()
            this.createTimeSignatureGlyphs()
        }
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.BarNumberGlyph(0.0, this.getScoreHeight(-0.5), this.bar.index + 1.0))
    }
    
    protected override fun createBeatGlyphs(): Unit{
        if(true) {
            var v: Double = 0.0
            
            while(v < this.bar.voices.length){
                try{
                    var voice: alphaTab.model.Voice = this.bar.voices[(v).toInt()]
                    if (this.hasVoiceContainer(voice))
                    {
                        this.createVoiceGlyphs(voice)
                    }
                }
                finally{
                    v++
                }
            }
        }
    }
    
    protected override fun createPostBeatGlyphs(): Unit{
        super.createPostBeatGlyphs()
        if (this.bar.masterBar.isRepeatEnd)
        {
            this.addPostBeatGlyph(alphaTab.rendering.glyphs.RepeatCloseGlyph(this.x, 0.0))
            if (this.bar.masterBar.repeatCount > 2)
            {
                this.addPostBeatGlyph(alphaTab.rendering.glyphs.RepeatCountGlyph(0.0, this.getScoreHeight(-0.5), this.bar.masterBar.repeatCount))
            }
        }
        else 
        {
            this.addPostBeatGlyph(alphaTab.rendering.glyphs.BarSeperatorGlyph(0.0, 0.0))
        }
    }
    
    private var _startSpacing: Boolean
    
    private fun createStartSpacing(): Unit{
        if (this._startSpacing)
        {
            return
        }
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 2.0 * this.scale))
        this._startSpacing = true
    }
    
    private fun createKeySignatureGlyphs(): Unit{
        var offsetClef: Double = 0.0
        var currentKey: Double = (this.bar.masterBar.keySignature.toDouble())
        var previousKey: Double = if(!alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar))  0.0 else (this.bar.previousBar!!.masterBar.keySignature.toDouble())
        when (this.bar.clef)
        {
            alphaTab.model.Clef.Neutral -> 
            {
                offsetClef = 0.0
            }
            alphaTab.model.Clef.G2 -> 
            {
                offsetClef = 1.0
            }
            alphaTab.model.Clef.F4 -> 
            {
                offsetClef = 3.0
            }
            alphaTab.model.Clef.C3 -> 
            {
                offsetClef = 2.0
            }
            alphaTab.model.Clef.C4 -> 
            {
                offsetClef = 0.0
            }
            else -> { }
        }
        var newLines: alphaTab.collections.DoubleBooleanMap = alphaTab.collections.DoubleBooleanMap()
        var newGlyphs: alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph> = alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>(
        )
        
        if (alphaTab.model.ModelUtils.keySignatureIsSharp(currentKey))
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < alphaTab.core.ecmaScript.Math.abs(currentKey)){
                    try{
                        var step: Double = alphaTab.rendering.ScoreBarRenderer.SharpKsSteps[(i).toInt()] + offsetClef
                        newGlyphs.push(alphaTab.rendering.glyphs.AccidentalGlyph(0.0, this.getScoreY(step), alphaTab.model.AccidentalType.Sharp, false))
                        newLines.set(step, true)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        else 
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < alphaTab.core.ecmaScript.Math.abs(currentKey)){
                    try{
                        var step: Double = alphaTab.rendering.ScoreBarRenderer.FlatKsSteps[(i).toInt()] + offsetClef
                        newGlyphs.push(alphaTab.rendering.glyphs.AccidentalGlyph(0.0, this.getScoreY(step), alphaTab.model.AccidentalType.Flat, false))
                        newLines.set(step, true)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        var naturalizeSymbols: Double = alphaTab.core.ecmaScript.Math.abs(previousKey)
        var previousKeyPositions: alphaTab.collections.DoubleList = if(alphaTab.model.ModelUtils.keySignatureIsSharp(previousKey))  alphaTab.rendering.ScoreBarRenderer.SharpKsSteps else alphaTab.rendering.ScoreBarRenderer.FlatKsSteps
        if(true) {
            var i: Double = 0.0
            
            while(i < naturalizeSymbols){
                try{
                    var step: Double = previousKeyPositions[(i).toInt()] + offsetClef
                    if (!newLines.has(step))
                    {
                        this.addPreBeatGlyph(alphaTab.rendering.glyphs.AccidentalGlyph(0.0, this.getScoreY(previousKeyPositions[(i).toInt()] + offsetClef), alphaTab.model.AccidentalType.Natural, false))
                    }
                }
                finally{
                    i++
                }
            }
        }
        for (newGlyph in newGlyphs)
        {
            this.addPreBeatGlyph(newGlyph)
        }
    }
    
    private fun createTimeSignatureGlyphs(): Unit{
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 5.0 * this.scale))
        var lines: Double = this.bar.staff.standardNotationLineCount - 1.0
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.ScoreTimeSignatureGlyph(0.0, this.getScoreY(lines), this.bar.masterBar.timeSignatureNumerator, this.bar.masterBar.timeSignatureDenominator, this.bar.masterBar.timeSignatureCommon))
    }
    
    /**
     */
    protected override fun createVoiceGlyphs(v: alphaTab.model.Voice): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = v.beats.length
            
            while(i < j){
                try{
                    var b: alphaTab.model.Beat = v.beats[(i).toInt()]
                    var container: alphaTab.rendering.ScoreBeatContainerGlyph = alphaTab.rendering.ScoreBeatContainerGlyph(b, this.getVoiceContainer(v)!!)
                    container.preNotes = alphaTab.rendering.glyphs.ScoreBeatPreNotesGlyph()
                    container.onNotes = alphaTab.rendering.glyphs.ScoreBeatGlyph()
                    this.addBeatGlyph(container)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun getNoteLine(n: alphaTab.model.Note): Double{
        return this.accidentalHelper.getNoteLine(n)
    }
    
    /**
     * Gets the relative y position of the given steps relative to first line.
     * @param steps the amount of steps while 2 steps are one line
     */
    public fun getScoreY(steps: Double): Double{
        return (this._firstLineY + this.lineOffset + this.getScoreHeight(steps))
    }
    
    /**
     * Gets the height of an element that spans the given amount of steps.
     * @param steps the amount of steps while 2 steps are one line
     */
    public fun getScoreHeight(steps: Double): Double{
        return (this.lineOffset / (2.0).toDouble()) * steps
    }
    
    /**
     */
    protected override fun paintBackground(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        super.paintBackground(cx, cy, canvas)
        var res: alphaTab.RenderingResources = this.resources
        canvas.color = res.staffLineColor
        if(true) {
            var i: Double = 0.0
            
            while(i < this.bar.staff.standardNotationLineCount){
                try{
                    var lineY: Double = cy + this.y + this.getScoreY(i * 2.0)
                    canvas.fillRect(cx + this.x, ((lineY).toInt() or 0).toDouble(), this.width, this.scale * alphaTab.rendering.BarRendererBase.StaffLineThickness)
                }
                finally{
                    i++
                }
            }
        }
        canvas.color = res.mainGlyphColor
        this.paintSimileMark(cx, cy, canvas)
    }
    
    /**
     */
    public override fun completeBeamingHelper(helper: alphaTab.rendering.utils.BeamingHelper): Unit{
        if (this.bar.isMultiVoice && alphaTab.core.TypeHelper.isTruthy(helper.highestNoteInHelper) && alphaTab.core.TypeHelper.isTruthy(helper.lowestNoteInHelper))
        {
            var highestNotePosition: Double = this.getNoteY(helper.highestNoteInHelper!!, alphaTab.rendering.NoteYPosition.Center)
            var lowestNotePosition: Double = this.getNoteY(helper.lowestNoteInHelper!!, alphaTab.rendering.NoteYPosition.Center)
            var offset: Double = this.getStemSize(helper)
            if (helper.hasTuplet)
            {
                offset += this.resources.effectFont.size * 2.0
            }
            if (helper.direction == alphaTab.rendering.utils.BeamDirection.Up)
            {
                highestNotePosition -= offset
            }
            else 
            {
                lowestNotePosition += offset
            }
            for (beat in helper.beats)
            {
                this.helpers.collisionHelper.reserveBeatSlot(beat, highestNotePosition, lowestNotePosition)
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val StaffId: String = "score"
        
        @kotlin.jvm.JvmStatic
        private var SharpKsSteps: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            -1.0, 2.0, -2.0, 1.0, 4.0, 0.0, 3.0)
        
        
        @kotlin.jvm.JvmStatic
        private var FlatKsSteps: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            3.0, 0.0, 4.0, 1.0, 5.0, 2.0, 6.0)
        
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun paintSingleBar(canvas: alphaTab.platform.ICanvas, x1: Double, y1: Double, x2: Double, y2: Double, size: Double): Unit{
            canvas.beginPath()
            canvas.moveTo(x1, y1)
            canvas.lineTo(x2, y2)
            canvas.lineTo(x2, y2 + size)
            canvas.lineTo(x1, y1 + size)
            canvas.closePath()
            canvas.fill()
        }
        
    }
}

