// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * This is the main wrapper of the rendering engine which
 * can render a single track of a score object into a notation sheet.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ScoreRenderer: alphaTab.rendering.IScoreRenderer
{
    private var _currentLayoutMode: alphaTab.LayoutMode = alphaTab.LayoutMode.Page
    
    private var _currentRenderEngine: String? = null
    
    private var _renderedTracks: alphaTab.collections.List<alphaTab.model.Track>? = null
    
    public var canvas: alphaTab.platform.ICanvas? = null
    
    public var score: alphaTab.model.Score? = null
    
    public var tracks: alphaTab.collections.List<alphaTab.model.Track>? = null
    
    internal var layout: alphaTab.rendering.layout.ScoreLayout? = null
    
    public var settings: alphaTab.Settings
    /**
     * Gets or sets the lookup which allows fast access to beats at a given position.
     */
    public override var boundsLookup: alphaTab.rendering.utils.BoundsLookup? = null
    
    /**
     * Gets or sets the width of the score to be rendered.
     */
    public override var width: Double = 0.0
    
    public constructor(settings: alphaTab.Settings){
        this.settings = settings
        this.recreateCanvas()
        this.recreateLayout()
    }
    
    /**
     * Destroys the renderer.
     */
    public override fun destroy(): Unit{
        this.score = null
        this.canvas?.destroy()
        this.canvas = null
        this.layout = null
        this.boundsLookup = null
        this.tracks = null
    }
    
    private fun recreateCanvas(): Boolean{
        if (this._currentRenderEngine != this.settings.core.engine)
        {
            this.canvas?.destroy()
            this.canvas = alphaTab.Environment.getRenderEngineFactory(this.settings.core.engine).createCanvas()
            this._currentRenderEngine = this.settings.core.engine
            return true
        }
        return false
    }
    
    private fun recreateLayout(): Boolean{
        if (!alphaTab.core.TypeHelper.isTruthy(this.layout) || this._currentLayoutMode != this.settings.display.layoutMode)
        {
            this.layout = alphaTab.Environment.getLayoutEngineFactory(this.settings.display.layoutMode).createLayout(this)
            this._currentLayoutMode = this.settings.display.layoutMode
            return true
        }
        return false
    }
    
    /**
     * Initiates the rendering of the specified tracks of the given score.
     */
    public override fun renderScore(score: alphaTab.model.Score?, trackIndexes: alphaTab.collections.DoubleList?): Unit{
        try
        {
            this.score = score
            var tracks: alphaTab.collections.List<alphaTab.model.Track>? = null
            if (score != null && trackIndexes != null)
            {
                if (!alphaTab.core.TypeHelper.isTruthy(trackIndexes))
                {
                    tracks = score.tracks.slice(0.0)
                }
                else 
                {
                    tracks = alphaTab.collections.List(
                    )
                    
                    for (track in trackIndexes)
                    {
                        if (track >= 0 && track < score.tracks.length)
                        {
                            tracks.push(score.tracks[(track).toInt()])
                        }
                    }
                }
                if (tracks.length == 0.0 && score.tracks.length > 0)
                {
                    tracks.push(score.tracks[(0).toInt()])
                }
            }
            this.tracks = tracks
            this.render()
        }
        catch (e: kotlin.Throwable)
        {
            ((this.error as alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>)).trigger((e as alphaTab.core.ecmaScript.Error))
        }
    }
    
    /**
     * Initiates rendering fof the given tracks.
     * @param tracks The tracks to render.
     */
    public fun renderTracks(tracks: alphaTab.collections.List<alphaTab.model.Track>): Unit{
        if (tracks.length == 0.0)
        {
            this.score = null
        }
        else 
        {
            this.score = tracks[(0).toInt()].score
        }
        this.tracks = tracks
        this.render()
    }
    
    /**
     * Updates the settings to the given object.
     */
    public override fun updateSettings(settings: alphaTab.Settings): Unit{
        this.settings = settings
    }
    
    /**
     * Initiates the rendering of a partial render result which the renderer
     * should have layed out already.
     */
    public override fun renderResult(resultId: String): Unit{
        try
        {
            var layout: alphaTab.rendering.layout.ScoreLayout? = this.layout
            if (alphaTab.core.TypeHelper.isTruthy(layout))
            {
                alphaTab.Logger.debug("Rendering", "Request render of lazy partial " + resultId)
                layout.renderLazyPartial(resultId)
            }
            else 
            {
                alphaTab.Logger.warning("Rendering", "Request render of lazy partial " + resultId + " ignored, no layout exists")
            }
        }
        catch (e: kotlin.Throwable)
        {
            ((this.error as alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>)).trigger((e as alphaTab.core.ecmaScript.Error))
        }
    }
    
    /**
     * Initiates a full re-rendering of the score using the current settings.
     */
    public override fun render(): Unit{
        if (this.width == 0.0)
        {
            alphaTab.Logger.warning("Rendering", "AlphaTab skipped rendering because of width=0 (element invisible)", null)
            return
        }
        this.boundsLookup = alphaTab.rendering.utils.BoundsLookup()
        this.recreateCanvas()
        this.canvas!!.lineWidth = this.settings.display.scale
        this.canvas!!.settings = this.settings
        if (!alphaTab.core.TypeHelper.isTruthy(this.tracks) || this.tracks!!.length == 0.0 || !alphaTab.core.TypeHelper.isTruthy(this.score))
        {
            alphaTab.Logger.debug("Rendering", "Clearing rendered tracks because no score or tracks are set")
            ((this.preRender as alphaTab.EventEmitterOfT<Boolean>)).trigger(false)
            this._renderedTracks = null
            this.onRenderFinished()
            ((this.postRenderFinished as alphaTab.EventEmitter)).trigger()
            alphaTab.Logger.debug("Rendering", "Clearing finished")
        }
        else 
        {
            alphaTab.Logger.debug("Rendering", "Rendering " + (this.tracks!!.length).toInvariantString() + " tracks")
            if(true) {
                var i: Double = 0.0
                
                while(i < this.tracks!!.length){
                    try{
                        var track: alphaTab.model.Track = this.tracks!![(i).toInt()]
                        alphaTab.Logger.debug("Rendering", "Track " + (i).toInvariantString() + ": " + track.name)
                    }
                    finally{
                        i++
                    }
                }
            }
            ((this.preRender as alphaTab.EventEmitterOfT<Boolean>)).trigger(false)
            this.recreateLayout()
            this.layoutAndRender()
            alphaTab.Logger.debug("Rendering", "Rendering finished")
        }
    }
    
    /**
     * Initiates a resize-optimized re-rendering of the score using the current settings.
     */
    public override fun resizeRender(): Unit{
        if (this.recreateLayout() || this.recreateCanvas() || this._renderedTracks != this.tracks || !alphaTab.core.TypeHelper.isTruthy(this.tracks))
        {
            alphaTab.Logger.debug("Rendering", "Starting full rerendering due to layout or canvas change", null)
            this.render()
        }
        else if (this.layout!!.supportsResize)
        {
            alphaTab.Logger.debug("Rendering", "Starting optimized rerendering for resize")
            this.boundsLookup = alphaTab.rendering.utils.BoundsLookup()
            ((this.preRender as alphaTab.EventEmitterOfT<Boolean>)).trigger(true)
            this.canvas!!.settings = this.settings
            this.layout!!.resize()
            this.onRenderFinished()
            ((this.postRenderFinished as alphaTab.EventEmitter)).trigger()
        }
        else 
        {
            alphaTab.Logger.debug("Rendering", "Current layout does not support dynamic resizing, nothing was done", null)
        }
        alphaTab.Logger.debug("Rendering", "Resize finished")
    }
    
    private fun layoutAndRender(): Unit{
        alphaTab.Logger.debug("Rendering", "Rendering at scale " + (this.settings.display.scale).toInvariantString() + " with layout " + this.layout!!.name, null)
        this.layout!!.layoutAndRender()
        this._renderedTracks = this.tracks
        this.onRenderFinished()
        ((this.postRenderFinished as alphaTab.EventEmitter)).trigger()
    }
    
    /**
     * Occurs before the rendering of the tracks starts.
     */
    public override var preRender: alphaTab.IEventEmitterOfT<Boolean> = alphaTab.EventEmitterOfT<Boolean>()
    
    /**
     * Occurs after the rendering of the tracks finished.
     */
    public override var renderFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>()
    
    /**
     * Occurs whenever a part of the whole music sheet is rendered and can be displayed.
     */
    public override var partialRenderFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>()
    
    /**
     * Occurs whenever a part of the whole music sheet is layed out but not yet rendered.
     */
    public override var partialLayoutFinished: alphaTab.IEventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>()
    
    /**
     * Occurs when the whole rendering and layout process finished.
     */
    public override var postRenderFinished: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    /**
     * Occurs whenever an error happens.
     */
    public override var error: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error> = alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>()
    
    private fun onRenderFinished(): Unit{
        this.boundsLookup?.finish()
        var e: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        e.totalHeight = this.layout!!.height
        e.totalWidth = this.layout!!.width
        e.renderResult = this.canvas!!.onRenderFinished()
        ((this.renderFinished as alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>)).trigger(e)
    }
    
}

