// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering
import alphaTab.core.*

/**
 * This BarRenderer renders a bar using guitar tablature notation
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TabBarRenderer: alphaTab.rendering.BarRendererBase
{
    private var _firstLineY: Double = 0.0
    
    private var _tupletSize: Double = 0.0
    
    public var showTimeSignature: Boolean = false
    
    public var showRests: Boolean = false
    
    public var showTiedNotes: Boolean = false
    
    public constructor(renderer: alphaTab.rendering.ScoreRenderer, bar: alphaTab.model.Bar)
        : super(renderer, bar)
    public val lineOffset: Double
    get(){
        return (alphaTab.rendering.TabBarRenderer.TabLineSpacing + 1.0) * this.scale
    }
    
    protected override fun updateSizes(): Unit{
        var res: alphaTab.RenderingResources = this.resources
        var numberOverflow: Double = (res.tablatureFont.size / (2.0).toDouble() + res.tablatureFont.size * 0.2) * this.scale
        this.topPadding = numberOverflow
        this.bottomPadding = numberOverflow
        this.height = this.lineOffset * (this.bar.staff.tuning.length - 1.0) + numberOverflow * 2.0
        if (this.settings.notation.rhythmMode != alphaTab.TabRhythmMode.Hidden)
        {
            this.height += this.settings.notation.rhythmHeight * this.settings.display.scale
            this.bottomPadding += this.settings.notation.rhythmHeight * this.settings.display.scale
        }
        this.updateFirstLineY()
        super.updateSizes()
    }
    
    private fun updateFirstLineY(): Unit{
        var res: alphaTab.RenderingResources = this.resources
        this._firstLineY = (res.tablatureFont.size / (2.0).toDouble() + res.tablatureFont.size * 0.2) * this.scale
    }
    
    public override fun doLayout(): Unit{
        this.updateFirstLineY()
        super.doLayout()
        if (this.settings.notation.rhythmMode != alphaTab.TabRhythmMode.Hidden)
        {
            var hasTuplets: Boolean = false
            for (voice in this.bar.voices)
            {
                if (this.hasVoiceContainer(voice))
                {
                    var c: alphaTab.rendering.glyphs.VoiceContainerGlyph = this.getVoiceContainer(voice)!!
                    if (c.tupletGroups.length > 0)
                    {
                        hasTuplets = true
                        break
                    }
                }
            }
            if (hasTuplets)
            {
                this._tupletSize = this.resources.effectFont.size * 0.8
                this.registerOverflowBottom(this._tupletSize)
            }
        }
    }
    
    protected override fun createPreBeatGlyphs(): Unit{
        super.createPreBeatGlyphs()
        if (this.bar.masterBar.isRepeatStart)
        {
            this.addPreBeatGlyph(alphaTab.rendering.glyphs.RepeatOpenGlyph(0.0, 0.0, 1.5, 3.0))
        }
        if (this.isFirstOfLine)
        {
            var center: Double = (this.bar.staff.tuning.length - 1.0) / (2.0).toDouble()
            this.addPreBeatGlyph(alphaTab.rendering.glyphs.TabClefGlyph(5.0 * this.scale, this.getTabY(center)))
        }
        if (this.showTimeSignature && (!alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) || (alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) && this.bar.masterBar.timeSignatureNumerator != this.bar.previousBar!!.masterBar.timeSignatureNumerator) || (alphaTab.core.TypeHelper.isTruthy(this.bar.previousBar) && this.bar.masterBar.timeSignatureDenominator != this.bar.previousBar!!.masterBar.timeSignatureDenominator)))
        {
            this.createStartSpacing()
            this.createTimeSignatureGlyphs()
        }
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.BarNumberGlyph(0.0, this.getTabHeight(-0.5), this.bar.index + 1.0))
    }
    
    private var _startSpacing: Boolean = false
    
    private fun createStartSpacing(): Unit{
        if (this._startSpacing)
        {
            return
        }
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 2.0 * this.scale))
        this._startSpacing = true
    }
    
    private fun createTimeSignatureGlyphs(): Unit{
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 5.0 * this.scale))
        var lines: Double = ((this.bar.staff.tuning.length + 1.0) / (2.0).toDouble()) - 1.0
        this.addPreBeatGlyph(alphaTab.rendering.glyphs.TabTimeSignatureGlyph(0.0, this.getTabY(lines), this.bar.masterBar.timeSignatureNumerator, this.bar.masterBar.timeSignatureDenominator, this.bar.masterBar.timeSignatureCommon))
    }
    
    /**
     */
    protected override fun createVoiceGlyphs(v: alphaTab.model.Voice): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = v.beats.length
            
            while(i < j){
                try{
                    var b: alphaTab.model.Beat = v.beats[(i).toInt()]
                    var container: alphaTab.rendering.glyphs.TabBeatContainerGlyph = alphaTab.rendering.glyphs.TabBeatContainerGlyph(b, this.getVoiceContainer(v)!!)
                    container.preNotes = alphaTab.rendering.glyphs.TabBeatPreNotesGlyph()
                    container.onNotes = alphaTab.rendering.glyphs.TabBeatGlyph()
                    this.addBeatGlyph(container)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    protected override fun createPostBeatGlyphs(): Unit{
        super.createPostBeatGlyphs()
        if (this.bar.masterBar.isRepeatEnd)
        {
            this.addPostBeatGlyph(alphaTab.rendering.glyphs.RepeatCloseGlyph(this.x, 0.0))
            if (this.bar.masterBar.repeatCount > 2)
            {
                this.addPostBeatGlyph(alphaTab.rendering.glyphs.RepeatCountGlyph(0.0, this.getTabY(-1.0), this.bar.masterBar.repeatCount))
            }
        }
        else 
        {
            this.addPostBeatGlyph(alphaTab.rendering.glyphs.BarSeperatorGlyph(0.0, 0.0))
        }
    }
    
    /**
     * Gets the relative y position of the given steps relative to first line.
     * @param line the line of the particular string where 0 is the most top line
     */
    public fun getTabY(line: Double): Double{
        return this._firstLineY + this.getTabHeight(line)
    }
    
    /**
     */
    public fun getTabHeight(line: Double): Double{
        return this.lineOffset * line
    }
    
    public override val middleYPosition: Double
    get(){
        return this.getTabY(this.bar.staff.tuning.length - 1.0)
    }
    
    /**
     */
    protected override fun paintBackground(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        super.paintBackground(cx, cy, canvas)
        var res: alphaTab.RenderingResources = this.resources
        canvas.color = res.staffLineColor
        var padding: Double = this.scale
        var tabNotes: alphaTab.collections.List<alphaTab.collections.List<alphaTab.core.ecmaScript.Float32Array>> = alphaTab.collections.List<alphaTab.collections.List<alphaTab.core.ecmaScript.Float32Array>>(
        )
        
        if(true) {
            var i: Double = 0.0
            var j: Double = this.bar.staff.tuning.length
            
            while(i < j){
                try{
                    tabNotes.push(alphaTab.collections.List<alphaTab.core.ecmaScript.Float32Array>(
                    )
                    )
                }
                finally{
                    i++
                }
            }
        }
        for (voice in this.bar.voices)
        {
            if (this.hasVoiceContainer(voice))
            {
                var vc: alphaTab.rendering.glyphs.VoiceContainerGlyph = this.getVoiceContainer(voice)!!
                for (bg in vc.beatGlyphs)
                {
                    var notes: alphaTab.rendering.glyphs.TabBeatGlyph = (bg.onNotes as alphaTab.rendering.glyphs.TabBeatGlyph)
                    var noteNumbers: alphaTab.rendering.glyphs.TabNoteChordGlyph? = notes.noteNumbers
                    if (alphaTab.core.TypeHelper.isTruthy(noteNumbers))
                    {
                        for ((str, noteNumber) in noteNumbers.notesPerString)
                        {
                            if (!noteNumber.isEmpty)
                            {
                                tabNotes[(this.bar.staff.tuning.length - str).toInt()].push(alphaTab.core.ecmaScript.Float32Array(alphaTab.collections.List(vc.x + bg.x + notes.x + noteNumbers!!.x, noteNumbers!!.width + padding)))
                            }
                        }
                    }
                }
            }
        }
        for (line in tabNotes)
        {
            line.sort(fun(a: alphaTab.core.ecmaScript.Float32Array, b: alphaTab.core.ecmaScript.Float32Array): Double{
                return if(a[(0).toInt()] > b[(0).toInt()])  1.0 else if(a[(0).toInt()] < b[(0).toInt()])  -1.0 else 0.0
            }
            )
        }
        if(true) {
            var i: Double = 0.0
            var j: Double = this.bar.staff.tuning.length
            
            while(i < j){
                try{
                    var lineY: Double = this.getTabY(i)
                    var lineX: Double = 0.0
                    for (line in tabNotes[(i).toInt()])
                    {
                        canvas.fillRect(cx + this.x + lineX, ((cy + this.y + lineY).toInt() or 0).toDouble(), line[(0).toInt()] - lineX, this.scale * alphaTab.rendering.BarRendererBase.StaffLineThickness)
                        lineX = line[(0).toInt()] + line[(1).toInt()]
                    }
                    canvas.fillRect(cx + this.x + lineX, ((cy + this.y + lineY).toInt() or 0).toDouble(), this.width - lineX, this.scale * alphaTab.rendering.BarRendererBase.StaffLineThickness)
                }
                finally{
                    i++
                }
            }
        }
        canvas.color = res.mainGlyphColor
        this.paintSimileMark(cx, cy, canvas)
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        super.paint(cx, cy, canvas)
        if (this.settings.notation.rhythmMode != alphaTab.TabRhythmMode.Hidden)
        {
            this.paintBeams(cx, cy, canvas)
            this.paintTuplets(cx, cy, canvas)
        }
    }
    
    /**
     */
    private fun paintBeams(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = this.helpers.beamHelpers.length
            
            while(i < j){
                try{
                    var v: alphaTab.collections.List<alphaTab.rendering.utils.BeamingHelper> = this.helpers.beamHelpers[(i).toInt()]
                    if(true) {
                        var k: Double = 0.0
                        var l: Double = v.length
                        
                        while(k < l){
                            try{
                                var h: alphaTab.rendering.utils.BeamingHelper = v[(k).toInt()]
                                this.paintBeamHelper(cx + this.beatGlyphsStart, cy, canvas, h)
                            }
                            finally{
                                k++
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun paintTuplets(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        for (voice in this.bar.voices)
        {
            if (this.hasVoiceContainer(voice))
            {
                var container: alphaTab.rendering.glyphs.VoiceContainerGlyph = this.getVoiceContainer(voice)!!
                for (tupletGroup in container.tupletGroups)
                {
                    this.paintTupletHelper(cx + this.beatGlyphsStart, cy, canvas, tupletGroup)
                }
            }
        }
    }
    
    /**
     */
    private fun paintBeamHelper(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        canvas.color = if(h.voice!!.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
        if (!h.isRestBeamHelper)
        {
            if (h.beats.length == 1.0 || this.settings.notation.rhythmMode == alphaTab.TabRhythmMode.ShowWithBeams)
            {
                this.paintFooter(cx, cy, canvas, h)
            }
            else 
            {
                this.paintBar(cx, cy, canvas, h)
            }
        }
    }
    
    /**
     */
    private fun paintBar(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = h.beats.length
            
            while(i < j){
                try{
                    var beat: alphaTab.model.Beat = h.beats[(i).toInt()]
                    if (h.hasBeatLineX(beat))
                    {
                        var beatLineX: Double = h.getBeatLineX(beat)
                        var y1: Double = cy + this.y
                        var y2: Double = cy + this.y + this.height - this._tupletSize
                        var startGlyph: alphaTab.rendering.glyphs.TabBeatGlyph = (this.getOnNotesGlyphForBeat(beat) as alphaTab.rendering.glyphs.TabBeatGlyph)
                        if (!alphaTab.core.TypeHelper.isTruthy(startGlyph.noteNumbers) || beat.duration == alphaTab.model.Duration.Half)
                        {
                            y1 += this.height - this.settings.notation.rhythmHeight * this.settings.display.scale - this._tupletSize
                        }
                        else 
                        {
                            y1 += startGlyph.noteNumbers!!.getNoteY(startGlyph.noteNumbers!!.minStringNote!!, alphaTab.rendering.NoteYPosition.Bottom) + this.lineOffset / (2.0).toDouble()
                        }
                        this.paintBeamingStem(
                            beat
                            , 
                            cy + this.y
                            , 
                            cx + this.x + beatLineX
                            , 
                            y1
                            , 
                            y2
                            , 
                            canvas
                        
                        )
                        var brokenBarOffset: Double = 6.0 * this.scale
                        var barSpacing: Double = -6.0 * this.scale
                        var barSize: Double = 3.0 * this.scale
                        var barCount: Double = alphaTab.model.ModelUtils.getIndex(beat.duration) - 2.0
                        var barStart: Double = y2
                        if(true) {
                            var barIndex: Double = 0.0
                            
                            while(barIndex < barCount){
                                try{
                                    var barStartX: Double = 0.0
                                    var barEndX: Double = 0.0
                                    var barStartY: Double = 0.0
                                    var barEndY: Double = 0.0
                                    var barY: Double = barStart + barIndex * barSpacing
                                    if (h.beats.length == 1.0)
                                    {
                                        barStartX = beatLineX
                                        barEndX = beatLineX + brokenBarOffset
                                        barStartY = barY
                                        barEndY = barY
                                        alphaTab.rendering.TabBarRenderer.paintSingleBar(
                                            canvas
                                            , 
                                            cx + this.x + barStartX
                                            , 
                                            barStartY
                                            , 
                                            cx + this.x + barEndX
                                            , 
                                            barEndY
                                            , 
                                            barSize
                                        
                                        )
                                    }
                                    else if (i < h.beats.length - 1.0)
                                    {
                                        if (alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(beat, h.beats[(i + 1.0).toInt()], barIndex))
                                        {
                                            barStartX = beatLineX
                                            barEndX = h.getBeatLineX(h.beats[(i + 1.0).toInt()])
                                        }
                                        else if (i == 0.0 || !alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(h.beats[(i - 1.0).toInt()], beat, barIndex))
                                        {
                                            barStartX = beatLineX
                                            barEndX = barStartX + brokenBarOffset
                                        }
                                        else 
                                        {
                                            continue
                                        }
                                        barStartY = barY
                                        barEndY = barY
                                        alphaTab.rendering.TabBarRenderer.paintSingleBar(
                                            canvas
                                            , 
                                            cx + this.x + barStartX
                                            , 
                                            barStartY
                                            , 
                                            cx + this.x + barEndX
                                            , 
                                            barEndY
                                            , 
                                            barSize
                                        
                                        )
                                    }
                                    else if (i > 0 && !alphaTab.rendering.utils.BeamingHelper.isFullBarJoin(beat, h.beats[(i - 1.0).toInt()], barIndex))
                                    {
                                        barStartX = beatLineX - brokenBarOffset
                                        barEndX = beatLineX
                                        barStartY = barY
                                        barEndY = barY
                                        alphaTab.rendering.TabBarRenderer.paintSingleBar(
                                            canvas
                                            , 
                                            cx + this.x + barStartX
                                            , 
                                            barStartY
                                            , 
                                            cx + this.x + barEndX
                                            , 
                                            barEndY
                                            , 
                                            barSize
                                        
                                        )
                                    }
                                }
                                finally{
                                    barIndex++
                                }
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun paintTupletHelper(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.model.TupletGroup): Unit{
        var res: alphaTab.RenderingResources = this.resources
        var oldAlign: alphaTab.platform.TextAlign = canvas.textAlign
        var oldBaseLine: alphaTab.platform.TextBaseline = canvas.textBaseline
        canvas.color = if(h.voice.index == 0.0)  this.resources.mainGlyphColor else this.resources.secondaryGlyphColor
        canvas.textAlign = alphaTab.platform.TextAlign.Center
        canvas.textBaseline = alphaTab.platform.TextBaseline.Middle
        var s: String
        var num: Double = h.beats[(0).toInt()].tupletNumerator
        var den: Double = h.beats[(0).toInt()].tupletDenominator
        if (num == 2.0 && den == 3.0)
        {
            s = "2"
        }
        else if (num == 3.0 && den == 2.0)
        {
            s = "3"
        }
        else if (num == 4.0 && den == 6.0)
        {
            s = "4"
        }
        else if (num == 5.0 && den == 4.0)
        {
            s = "5"
        }
        else if (num == 6.0 && den == 4.0)
        {
            s = "6"
        }
        else if (num == 7.0 && den == 4.0)
        {
            s = "7"
        }
        else if (num == 9.0 && den == 8.0)
        {
            s = "9"
        }
        else if (num == 10.0 && den == 8.0)
        {
            s = "10"
        }
        else if (num == 11.0 && den == 8.0)
        {
            s = "11"
        }
        else if (num == 12.0 && den == 8.0)
        {
            s = "12"
        }
        else if (num == 13.0 && den == 8.0)
        {
            s = "13"
        }
        else 
        {
            s = (num).toInvariantString() + ":" + (den).toInvariantString()
        }
        if (h.beats.length == 1.0 || !h.isFull)
        {
            if(true) {
                var i: Double = 0.0
                var j: Double = h.beats.length
                
                while(i < j){
                    try{
                        var beat: alphaTab.model.Beat = h.beats[(i).toInt()]
                        var beamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(beat.index)!!
                        if (!alphaTab.core.TypeHelper.isTruthy(beamingHelper))
                        {
                            continue
                        }
                        var tupletX: Double = beamingHelper.getBeatLineX(beat)
                        var tupletY: Double = cy + this.y + this.height - this._tupletSize + res.effectFont.size * 0.5
                        canvas.font = res.effectFont
                        canvas.fillText(s, cx + this.x + tupletX, tupletY)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        else 
        {
            var firstBeat: alphaTab.model.Beat = h.beats[(0).toInt()]
            var lastBeat: alphaTab.model.Beat = h.beats[(h.beats.length - 1.0).toInt()]
            var firstBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(firstBeat.index)!!
            var lastBeamingHelper: alphaTab.rendering.utils.BeamingHelper = this.helpers.beamHelperLookup[(h.voice.index).toInt()].get(lastBeat.index)!!
            if (alphaTab.core.TypeHelper.isTruthy(firstBeamingHelper) && alphaTab.core.TypeHelper.isTruthy(lastBeamingHelper))
            {
                var startX: Double = firstBeamingHelper.getBeatLineX(firstBeat)
                var endX: Double = lastBeamingHelper.getBeatLineX(lastBeat)
                canvas.font = res.effectFont
                var sw: Double = canvas.measureText(s)
                var sp: Double = 3.0 * this.scale
                var middleX: Double = (startX + endX) / (2.0).toDouble()
                var offset1X: Double = middleX - sw / (2.0).toDouble() - sp
                var offset2X: Double = middleX + sw / (2.0).toDouble() + sp
                var startY: Double = cy + this.y + this.height - this._tupletSize + res.effectFont.size * 0.5
                var offset: Double = -res.effectFont.size * 0.25
                var size: Double = -5.0 * this.scale
                canvas.beginPath()
                canvas.moveTo(cx + this.x + startX, (((startY - offset)).toInt() or 0).toDouble())
                canvas.lineTo(cx + this.x + startX, (((startY - offset - size)).toInt() or 0).toDouble())
                canvas.lineTo(cx + this.x + offset1X, (((startY - offset - size)).toInt() or 0).toDouble())
                canvas.stroke()
                canvas.beginPath()
                canvas.moveTo(cx + this.x + offset2X, (((startY - offset - size)).toInt() or 0).toDouble())
                canvas.lineTo(cx + this.x + endX, (((startY - offset - size)).toInt() or 0).toDouble())
                canvas.lineTo(cx + this.x + endX, (((startY - offset)).toInt() or 0).toDouble())
                canvas.stroke()
                canvas.fillText(s, cx + this.x + middleX, startY - offset - size)
            }
        }
        canvas.textAlign = oldAlign
        canvas.textBaseline = oldBaseLine
    }
    
    /**
     */
    private fun paintBeamingStem(beat: alphaTab.model.Beat, cy: Double, x: Double, topY: Double, bottomY: Double, canvas: alphaTab.platform.ICanvas): Unit{
        canvas.beginPath()
        var holes: alphaTab.collections.List<alphaTab.rendering.utils.ReservedLayoutAreaSlot> = alphaTab.collections.List<alphaTab.rendering.utils.ReservedLayoutAreaSlot>(
        )
        
        if (this.helpers.collisionHelper.reservedLayoutAreasByDisplayTime.has(beat.displayStart))
        {
            holes = this.helpers.collisionHelper.reservedLayoutAreasByDisplayTime.get(beat.displayStart)!!.slots.slice()
            holes.sort(fun(a: alphaTab.rendering.utils.ReservedLayoutAreaSlot, b: alphaTab.rendering.utils.ReservedLayoutAreaSlot): Double{
                return a.topY - b.topY
            }
            )
        }
        var y: Double = bottomY
        while (y > topY)
        {
            canvas.moveTo(x, y)
            var lineY: Double = topY
            if (holes.length > 0 && holes[(holes.length - 1.0).toInt()].bottomY > lineY)
            {
                var bottomHole: alphaTab.rendering.utils.ReservedLayoutAreaSlot = holes.pop()!!
                lineY = cy + bottomHole.bottomY
                canvas.lineTo(x, lineY)
                y = cy + bottomHole.topY
            }
            else 
            {
                canvas.lineTo(x, lineY)
                break
            }
        }
        canvas.stroke()
    }
    
    /**
     */
    private fun paintFooter(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, h: alphaTab.rendering.utils.BeamingHelper): Unit{
        for (beat in h.beats)
        {
            if (beat.graceType != alphaTab.model.GraceType.None || beat.duration == alphaTab.model.Duration.Whole || beat.duration == alphaTab.model.Duration.DoubleWhole || beat.duration == alphaTab.model.Duration.QuadrupleWhole)
            {
                return
            }
            var beatLineX: Double = h.getBeatLineX(beat)
            var y1: Double = cy + this.y
            var y2: Double = cy + this.y + this.height - this._tupletSize
            var startGlyph: alphaTab.rendering.glyphs.TabBeatGlyph = (this.getOnNotesGlyphForBeat(beat) as alphaTab.rendering.glyphs.TabBeatGlyph)
            if (!alphaTab.core.TypeHelper.isTruthy(startGlyph.noteNumbers) || beat.duration == alphaTab.model.Duration.Half)
            {
                y1 += this.height - this.settings.notation.rhythmHeight * this.settings.display.scale - this._tupletSize
            }
            else 
            {
                y1 += startGlyph.noteNumbers!!.getNoteY(startGlyph.noteNumbers!!.minStringNote!!, alphaTab.rendering.NoteYPosition.Bottom)
            }
            this.paintBeamingStem(
                beat
                , 
                cy + this.y
                , 
                cx + this.x + beatLineX
                , 
                y1
                , 
                y2
                , 
                canvas
            
            )
            if (beat.duration > alphaTab.model.Duration.Quarter)
            {
                var glyph: alphaTab.rendering.glyphs.FlagGlyph = alphaTab.rendering.glyphs.FlagGlyph(0.0, 0.0, beat.duration, alphaTab.rendering.utils.BeamDirection.Down, false)
                glyph.renderer = this
                glyph.doLayout()
                glyph.paint(cx + this.x + beatLineX, y2, canvas)
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val StaffId: String = "tab"
        
        @kotlin.jvm.JvmStatic
        public val TabLineSpacing: Double = 10.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun paintSingleBar(canvas: alphaTab.platform.ICanvas, x1: Double, y1: Double, x2: Double, y2: Double, size: Double): Unit{
            canvas.beginPath()
            canvas.moveTo(x1, y1)
            canvas.lineTo(x2, y2)
            canvas.lineTo(x2, y2 - size)
            canvas.lineTo(x1, y1 - size)
            canvas.closePath()
            canvas.fill()
        }
        
    }
}

