// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public open class BeatContainerGlyph: alphaTab.rendering.glyphs.Glyph
{
    public var voiceContainer: alphaTab.rendering.glyphs.VoiceContainerGlyph
    public var beat: alphaTab.model.Beat
    public lateinit var preNotes: alphaTab.rendering.glyphs.BeatGlyphBase
    public lateinit var onNotes: alphaTab.rendering.glyphs.BeatOnNoteGlyphBase
    public var ties: alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph> = alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>(
    )
    
    
    public var minWidth: Double = 0.0
    
    public val onTimeX: Double
    get(){
        return this.onNotes.x + this.onNotes.centerX
    }
    
    public constructor(beat: alphaTab.model.Beat, voiceContainer: alphaTab.rendering.glyphs.VoiceContainerGlyph)
        : super(0.0, 0.0){
        this.beat = beat
        this.ties = alphaTab.collections.List<alphaTab.rendering.glyphs.Glyph>(
        )
        
        this.voiceContainer = voiceContainer
    }
    
    /**
     */
    public fun addTie(tie: alphaTab.rendering.glyphs.Glyph): Unit{
        tie.renderer = this.renderer
        this.ties.push(tie)
    }
    
    /**
     */
    public fun registerLayoutingInfo(layoutings: alphaTab.rendering.staves.BarLayoutingInfo): Unit{
        var preBeatStretch: Double = this.preNotes.computedWidth + this.onNotes.centerX
        if (alphaTab.core.TypeHelper.isTruthy(this.beat.graceGroup) && !this.beat.graceGroup!!.isComplete)
        {
            preBeatStretch += alphaTab.rendering.glyphs.BeatContainerGlyph.GraceBeatPadding * this.renderer.scale
        }
        var postBeatStretch: Double = this.onNotes.computedWidth - this.onNotes.centerX
        var helper: alphaTab.rendering.utils.BeamingHelper = this.renderer.helpers.getBeamingHelperForBeat(this.beat)
        if ((alphaTab.core.TypeHelper.isTruthy(helper) && helper.hasFlag) || this.beat.graceType != alphaTab.model.GraceType.None)
        {
            postBeatStretch += alphaTab.rendering.glyphs.FlagGlyph.FlagWidth * this.scale * (if(this.beat.graceType != alphaTab.model.GraceType.None)  alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale else 1.0)
        }
        for (tie in this.ties)
        {
            postBeatStretch += tie.width
        }
        if (this.beat.graceType != alphaTab.model.GraceType.None)
        {
            postBeatStretch += alphaTab.rendering.glyphs.BeatContainerGlyph.GraceBeatPadding * this.renderer.scale
        }
        layoutings.addBeatSpring(this.beat, preBeatStretch, postBeatStretch)
        layoutings.setPreBeatSize(this.beat, this.preNotes.computedWidth)
        layoutings.setOnBeatSize(this.beat, this.onNotes.computedWidth)
        layoutings.setBeatCenterX(this.beat, this.onNotes.centerX)
    }
    
    /**
     */
    public fun applyLayoutingInfo(info: alphaTab.rendering.staves.BarLayoutingInfo): Unit{
        var offset: Double = info.getBeatCenterX(this.beat) - this.onNotes.centerX
        if (alphaTab.core.TypeHelper.isTruthy(this.beat.graceGroup) && !this.beat.graceGroup!!.isComplete)
        {
            offset += alphaTab.rendering.glyphs.BeatContainerGlyph.GraceBeatPadding * this.renderer.scale
        }
        this.preNotes.x = offset
        this.preNotes.width = info.getPreBeatSize(this.beat)
        this.onNotes.width = info.getOnBeatSize(this.beat)
        this.onNotes.x = this.preNotes.x + this.preNotes.width
        this.onNotes.updateBeamingHelper()
        this.updateWidth()
    }
    
    public override fun doLayout(): Unit{
        this.preNotes.x = 0.0
        this.preNotes.renderer = this.renderer
        this.preNotes.container = this
        this.preNotes.doLayout()
        this.onNotes.x = this.preNotes.x + this.preNotes.width
        this.onNotes.renderer = this.renderer
        this.onNotes.container = this
        this.onNotes.doLayout()
        var i: Double = this.beat.notes.length - 1.0
        while (i >= 0)
        {
            this.createTies(this.beat.notes[(i--).toInt()])
        }
        this.renderer.registerTies(this.ties)
        this.updateWidth()
    }
    
    protected fun updateWidth(): Unit{
        this.minWidth = this.preNotes.width + this.onNotes.width
        if (!this.beat.isRest)
        {
            if (this.onNotes.beamingHelper.beats.length == 1.0)
            {
                if (this.beat.duration >= alphaTab.model.Duration.Eighth)
                {
                    this.minWidth += 20.0 * this.scale
                }
            }
            else 
            {
                when (this.beat.duration)
                {
                    alphaTab.model.Duration.OneHundredTwentyEighth, alphaTab.model.Duration.TwoHundredFiftySixth -> 
                    {
                        this.minWidth += 10.0 * this.scale
                    }
                    else -> { }
                }
            }
        }
        var tieWidth: Double = 0.0
        for (tie in this.ties)
        {
            if (tie.width > tieWidth)
            {
                tieWidth = tie.width
            }
        }
        this.minWidth += tieWidth
        this.width = this.minWidth
    }
    
    /**
     */
    public fun scaleToWidth(beatWidth: Double): Unit{
        this.onNotes.updateBeamingHelper()
        this.width = beatWidth
    }
    
    /**
     */
    protected open fun createTies(n: alphaTab.model.Note): Unit{
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if (this.beat.voice.isEmpty)
        {
            return
        }
        var isEmptyGlyph: Boolean = this.preNotes.isEmpty && this.onNotes.isEmpty && this.ties.length == 0.0
        if (isEmptyGlyph)
        {
            return
        }
        canvas.beginGroup(alphaTab.rendering.glyphs.BeatContainerGlyph.getGroupId(this.beat))
        this.preNotes.paint(cx + this.x, cy + this.y, canvas)
        this.onNotes.paint(cx + this.x, cy + this.y, canvas)
        var staffX: Double = cx - this.voiceContainer.x - this.renderer.x
        var staffY: Double = cy - this.voiceContainer.y - this.renderer.y
        if(true) {
            var i: Double = 0.0
            var j: Double = this.ties.length
            
            while(i < j){
                try{
                    var t: alphaTab.rendering.glyphs.Glyph = this.ties[(i).toInt()]
                    t.renderer = this.renderer
                    t.paint(staffX, staffY, canvas)
                }
                finally{
                    i++
                }
            }
        }
        canvas.endGroup()
    }
    
    /**
     */
    public fun buildBoundingsLookup(barBounds: alphaTab.rendering.utils.BarBounds, cx: Double, cy: Double, isEmptyBar: Boolean): Unit{
        var beatBoundings: alphaTab.rendering.utils.BeatBounds = alphaTab.rendering.utils.BeatBounds()
        beatBoundings.beat = this.beat
        beatBoundings.visualBounds = alphaTab.rendering.utils.Bounds()
        beatBoundings.visualBounds.x = cx + this.x + this.onNotes.x
        beatBoundings.visualBounds.y = barBounds.visualBounds.y
        beatBoundings.visualBounds.w = this.onNotes.width
        beatBoundings.visualBounds.h = barBounds.visualBounds.h
        beatBoundings.realBounds = alphaTab.rendering.utils.Bounds()
        beatBoundings.realBounds.x = cx + this.x
        beatBoundings.realBounds.y = barBounds.realBounds.y
        beatBoundings.realBounds.w = this.width
        beatBoundings.realBounds.h = barBounds.realBounds.h
        if (isEmptyBar)
        {
            beatBoundings.visualBounds.x = cx + this.x
            beatBoundings.realBounds.x = beatBoundings.visualBounds.x
        }
        barBounds.addBeat(beatBoundings)
        if (this.renderer.settings.core.includeNoteBounds)
        {
            this.onNotes.buildBoundingsLookup(beatBoundings, cx + this.x, cy + this.y)
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public val GraceBeatPadding: Double = 3.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getGroupId(beat: alphaTab.model.Beat): String{
            return "b" + (beat.id).toInvariantString()
        }
        
    }
}

