// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ChordDiagramGlyph: alphaTab.rendering.glyphs.EffectGlyph
{
    private var _chord: alphaTab.model.Chord
    
    private var _textRow: Double = 0.0
    
    private var _fretRow: Double = 0.0
    
    private var _firstFretSpacing: Double = 0.0
    
    public constructor(x: Double, y: Double, chord: alphaTab.model.Chord)
        : super(x, y){
        this._chord = chord
    }
    
    public override fun doLayout(): Unit{
        super.doLayout()
        var scale: Double = this.scale
        var res: alphaTab.RenderingResources = this.renderer.resources
        this._textRow = res.effectFont.size * 1.5 * scale
        this._fretRow = res.effectFont.size * 1.5 * scale
        if (this._chord.firstFret > 1)
        {
            this._firstFretSpacing = alphaTab.rendering.glyphs.ChordDiagramGlyph.FretSpacing * scale
        }
        else 
        {
            this._firstFretSpacing = 0.0
        }
        this.height = this._textRow + this._fretRow + (alphaTab.rendering.glyphs.ChordDiagramGlyph.Frets - 1.0) * alphaTab.rendering.glyphs.ChordDiagramGlyph.FretSpacing * scale + 2.0 * alphaTab.rendering.glyphs.ChordDiagramGlyph.Padding * scale
        this.width = this._firstFretSpacing + (this._chord.staff.tuning.length - 1.0) * alphaTab.rendering.glyphs.ChordDiagramGlyph.StringSpacing * scale + 2.0 * alphaTab.rendering.glyphs.ChordDiagramGlyph.Padding * scale
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        var paramcx = cx
        var paramcy = cy
        paramcx += this.x + alphaTab.rendering.glyphs.ChordDiagramGlyph.Padding * this.scale + this._firstFretSpacing
        paramcy += this.y
        var w: Double = this.width - 2.0 * alphaTab.rendering.glyphs.ChordDiagramGlyph.Padding * this.scale + this.scale - this._firstFretSpacing
        var stringSpacing: Double = alphaTab.rendering.glyphs.ChordDiagramGlyph.StringSpacing * this.scale
        var fretSpacing: Double = alphaTab.rendering.glyphs.ChordDiagramGlyph.FretSpacing * this.scale
        var res: alphaTab.RenderingResources = this.renderer.resources
        var circleRadius: Double = alphaTab.rendering.glyphs.ChordDiagramGlyph.CircleRadius * this.scale
        var align: alphaTab.platform.TextAlign = canvas.textAlign
        var baseline: alphaTab.platform.TextBaseline = canvas.textBaseline
        canvas.font = res.effectFont
        canvas.textAlign = alphaTab.platform.TextAlign.Center
        canvas.textBaseline = alphaTab.platform.TextBaseline.Top
        if (this._chord.showName)
        {
            canvas.fillText(this._chord.name, paramcx + this.width / (2.0).toDouble(), paramcy + res.effectFont.size / (2.0).toDouble())
        }
        paramcy += this._textRow
        paramcx += stringSpacing / (2.0).toDouble()
        canvas.font = res.fretboardNumberFont
        canvas.textBaseline = alphaTab.platform.TextBaseline.Middle
        if(true) {
            var i: Double = 0.0
            
            while(i < this._chord.staff.tuning.length){
                try{
                    var x: Double = paramcx + i * stringSpacing
                    var y: Double = paramcy + this._fretRow / (2.0).toDouble()
                    var fret: Double = this._chord.strings[(this._chord.staff.tuning.length - i - 1.0).toInt()]
                    if (fret < 0)
                    {
                        canvas.fillMusicFontSymbol(x, y, this.scale, alphaTab.model.MusicFontSymbol.FretboardX, true)
                    }
                    else if (fret == 0.0)
                    {
                        canvas.fillMusicFontSymbol(x, y, this.scale, alphaTab.model.MusicFontSymbol.FretboardO, true)
                    }
                    else 
                    {
                        fret -= this._chord.firstFret - 1.0
                        canvas.fillText(fret.toInvariantString(), x, y)
                    }
                }
                finally{
                    i++
                }
            }
        }
        paramcy += this._fretRow
        if(true) {
            var i: Double = 0.0
            
            while(i < this._chord.staff.tuning.length){
                try{
                    var x: Double = paramcx + i * stringSpacing
                    canvas.fillRect(x, paramcy, 1.0, fretSpacing * alphaTab.rendering.glyphs.ChordDiagramGlyph.Frets + this.scale)
                }
                finally{
                    i++
                }
            }
        }
        if (this._chord.firstFret > 1)
        {
            canvas.textAlign = alphaTab.platform.TextAlign.Left
            canvas.fillText(this._chord.firstFret.toInvariantString(), paramcx - this._firstFretSpacing, paramcy + fretSpacing / (2.0).toDouble())
        }
        canvas.fillRect(paramcx, paramcy - this.scale, w, 2.0 * this.scale)
        if(true) {
            var i: Double = 0.0
            
            while(i <= alphaTab.rendering.glyphs.ChordDiagramGlyph.Frets){
                try{
                    var y: Double = paramcy + i * fretSpacing
                    canvas.fillRect(paramcx, y, w, this.scale)
                }
                finally{
                    i++
                }
            }
        }
        var barreLookup: alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleList> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleList>()
        for (barreFret in this._chord.barreFrets)
        {
            var strings: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
                -1.0, -1.0)
            
            barreLookup.set(barreFret - this._chord.firstFret, strings)
        }
        if(true) {
            var guitarString: Double = 0.0
            
            while(guitarString < this._chord.strings.length){
                try{
                    var fret: Double = this._chord.strings[(guitarString).toInt()]
                    if (fret > 0)
                    {
                        fret -= this._chord.firstFret
                        if (barreLookup.has(fret))
                        {
                            var info: alphaTab.collections.DoubleList = barreLookup.get(fret)!!
                            if (info[(0.0).toInt()] == -1.0 || guitarString < info[(0).toInt()])
                            {
                                info[(0).toInt()] = guitarString
                            }
                            if (info[(1.0).toInt()] == -1.0 || guitarString > info[(1).toInt()])
                            {
                                info[(1).toInt()] = guitarString
                            }
                        }
                        var y: Double = paramcy + fret * fretSpacing + fretSpacing / (2.0).toDouble() + 0.5 * this.scale
                        var x: Double = paramcx + (this._chord.strings.length - guitarString - 1.0) * stringSpacing
                        canvas.fillCircle(x, y, circleRadius)
                    }
                }
                finally{
                    guitarString++
                }
            }
        }
        for ((fret, strings) in barreLookup)
        {
            var y: Double = paramcy + fret * fretSpacing + fretSpacing / (2.0).toDouble() + 0.5 * this.scale
            var xLeft: Double = paramcx + (this._chord.strings.length - strings[(1).toInt()] - 1.0) * stringSpacing
            var xRight: Double = paramcx + (this._chord.strings.length - strings[(0).toInt()] - 1.0) * stringSpacing
            canvas.fillRect(xLeft, y - circleRadius, xRight - xLeft, circleRadius * 2.0)
        }
        canvas.textAlign = align
        canvas.textBaseline = baseline
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val Padding: Double = 5.0
        
        @kotlin.jvm.JvmStatic
        private val Frets: Double = 5.0
        
        @kotlin.jvm.JvmStatic
        private val CircleRadius: Double = 2.5
        
        @kotlin.jvm.JvmStatic
        private val StringSpacing: Double = 10.0
        
        @kotlin.jvm.JvmStatic
        private val FretSpacing: Double = 12.0
        
    }
}

