// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class NoteNumberGlyph: alphaTab.rendering.glyphs.Glyph
{
    private var _note: alphaTab.model.Note
    
    private var _noteString: String? = null
    
    private var _trillNoteString: String? = null
    
    private var _trillNoteStringWidth: Double = 0.0
    
    public var isEmpty: Boolean = false
    
    public var noteStringWidth: Double = 0.0
    
    public constructor(x: Double, y: Double, note: alphaTab.model.Note)
        : super(x, y){
        this._note = note
    }
    
    public override fun doLayout(): Unit{
        var n: alphaTab.model.Note = this._note
        var fret: Double = n.fret - n.beat.voice.bar.staff.transpositionPitch
        if (n.harmonicType == alphaTab.model.HarmonicType.Natural && n.harmonicValue != 0.0)
        {
            fret = n.harmonicValue - n.beat.voice.bar.staff.transpositionPitch
        }
        if (!n.isTieDestination)
        {
            this._noteString = if(n.isDead)  "x" else fret.toInvariantString()
            if (n.isGhost)
            {
                this._noteString = "(" + this._noteString + ")"
            }
            else if (n.harmonicType == alphaTab.model.HarmonicType.Natural)
            {
                var i: Double = this._noteString!!.indexOfInDouble(alphaTab.core.ecmaScript.CoreString.fromCharCode(46.0))
                if (i >= 0)
                {
                    this._noteString = this._noteString!!.substr(0.0, i + 2.0)
                }
                this._noteString = "<" + this._noteString + ">"
            }
        }
        else if ((n.beat.index == 0.0 && this.renderer.settings.notation.notationMode == alphaTab.NotationMode.GuitarPro) || ((n.bendType == alphaTab.model.BendType.Bend || n.bendType == alphaTab.model.BendType.BendRelease) && this.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.TabNotesOnTiedBends)))
        {
            this._noteString = "(" + (n.tieOrigin!!.fret - n.beat.voice.bar.staff.transpositionPitch).toInvariantString() + ")"
        }
        else 
        {
            this._noteString = ""
        }
        if (n.isTrill)
        {
            this._trillNoteString = "(" + (n.trillFret - n.beat.voice.bar.staff.transpositionPitch).toInvariantString() + ")"
        }
        else if (!alphaTab.model.ModelUtils.isAlmostEqualTo(n.harmonicValue, 0.0))
        {
            when (n.harmonicType)
            {
                alphaTab.model.HarmonicType.Artificial, alphaTab.model.HarmonicType.Pinch, alphaTab.model.HarmonicType.Tap, alphaTab.model.HarmonicType.Semi, alphaTab.model.HarmonicType.Feedback -> 
                {
                    var s: String = (fret + n.harmonicValue).toInvariantString()
                    var i: Double = s.indexOfInDouble(alphaTab.core.ecmaScript.CoreString.fromCharCode(46.0))
                    if (i >= 0)
                    {
                        s = s.substr(0.0, i + 2.0)
                    }
                    this._trillNoteString = "<" + s + ">"
                }
                else -> 
                {
                    this._trillNoteString = ""
                }
            }
        }
        else 
        {
            this._trillNoteString = ""
        }
        this.isEmpty = !alphaTab.core.TypeHelper.isTruthy(this._noteString)
        if (!this.isEmpty)
        {
            this.renderer.scoreRenderer.canvas!!.font = this.renderer.resources.tablatureFont
            this.noteStringWidth = this.renderer.scoreRenderer.canvas!!.measureText(this._noteString!!) * this.scale
            this.width = this.noteStringWidth
            this.height = this.renderer.scoreRenderer.canvas!!.font.size
            var hasTrill: Boolean = !!alphaTab.core.TypeHelper.isTruthy(this._trillNoteString)
            if (hasTrill)
            {
                this.renderer.scoreRenderer.canvas!!.font = this.renderer.resources.graceFont
                this._trillNoteStringWidth = 3.0 * this.scale + this.renderer.scoreRenderer.canvas!!.measureText(this._trillNoteString!!)
                this.width += this._trillNoteStringWidth
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if (this.isEmpty)
        {
            return
        }
        var textWidth: Double = this.noteStringWidth + this._trillNoteStringWidth
        var x: Double = cx + this.x + (this.width - textWidth) / (2.0).toDouble()
        var prevFont: alphaTab.model.Font = this.renderer.scoreRenderer.canvas!!.font
        this.renderer.scoreRenderer.canvas!!.font = this.renderer.resources.graceFont
        canvas.fillText(this._trillNoteString!!, x + this.noteStringWidth + 3.0 * this.scale, cy + this.y)
        this.renderer.scoreRenderer.canvas!!.font = prevFont
        canvas.fillText(this._noteString!!, x, cy + this.y)
    }
    
    /**
     */
    public fun buildBoundingsLookup(beatBounds: alphaTab.rendering.utils.BeatBounds, cx: Double, cy: Double): Unit{
        var noteBounds: alphaTab.rendering.utils.NoteBounds = alphaTab.rendering.utils.NoteBounds()
        noteBounds.note = this._note
        noteBounds.noteHeadBounds = alphaTab.rendering.utils.Bounds()
        noteBounds.noteHeadBounds.x = cx + this.x
        noteBounds.noteHeadBounds.y = cy + this.y - this.height / (2.0).toDouble()
        noteBounds.noteHeadBounds.w = this.width
        noteBounds.noteHeadBounds.h = this.height
        beatBounds.addNote(noteBounds)
    }
    
}

