// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ScoreBeatGlyph: alphaTab.rendering.glyphs.BeatOnNoteGlyphBase
{
    private var _collisionOffset: Double = -1000.0
    
    private var _skipPaint: Boolean = false
    
    public var noteHeads: alphaTab.rendering.glyphs.ScoreNoteChordGlyph? = null
    
    public var restGlyph: alphaTab.rendering.glyphs.ScoreRestGlyph? = null
    
    /**
     */
    public override fun getNoteX(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteXPosition): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this.noteHeads))  this.noteHeads!!.getNoteX(note, requestedPosition) else 0.0
    }
    
    /**
     */
    public override fun buildBoundingsLookup(beatBounds: alphaTab.rendering.utils.BeatBounds, cx: Double, cy: Double): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(this.noteHeads))
        {
            this.noteHeads!!.buildBoundingsLookup(beatBounds, cx + this.x, cy + this.y)
        }
    }
    
    /**
     */
    public override fun getNoteY(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteYPosition): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this.noteHeads))  this.noteHeads!!.getNoteY(note, requestedPosition) else 0.0
    }
    
    public override fun updateBeamingHelper(): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(this.noteHeads))
        {
            this.noteHeads!!.updateBeamingHelper(this.container.x + this.x)
        }
        else if (alphaTab.core.TypeHelper.isTruthy(this.restGlyph))
        {
            this.restGlyph!!.updateBeamingHelper(this.container.x + this.x)
            if (this.renderer.bar.isMultiVoice && this._collisionOffset == -1000.0)
            {
                this._collisionOffset = this.renderer.helpers.collisionHelper.applyRestCollisionOffset(this.container.beat, this.restGlyph!!.y, ((this.renderer as alphaTab.rendering.ScoreBarRenderer)).getScoreHeight(1.0))
                this.y += this._collisionOffset
                var existingRests: alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleDoubleMap> = this.renderer.helpers.collisionHelper.restDurationsByDisplayTime
                if (existingRests.has(this.container.beat.playbackStart) && existingRests.get(this.container.beat.playbackStart)!!.has(this.container.beat.playbackDuration) && existingRests.get(this.container.beat.playbackStart)!!.get(this.container.beat.playbackDuration) != this.container.beat.id)
                {
                    this._skipPaint = true
                }
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if (!this._skipPaint)
        {
            super.paint(cx, cy, canvas)
        }
    }
    
    public override fun doLayout(): Unit{
        var sr: alphaTab.rendering.ScoreBarRenderer = (this.renderer as alphaTab.rendering.ScoreBarRenderer)
        if (!this.container.beat.isEmpty)
        {
            if (!this.container.beat.isRest)
            {
                var noteHeads: alphaTab.rendering.glyphs.ScoreNoteChordGlyph = alphaTab.rendering.glyphs.ScoreNoteChordGlyph()
                this.noteHeads = noteHeads
                noteHeads.beat = this.container.beat
                noteHeads.beamingHelper = this.beamingHelper
                var ghost: alphaTab.rendering.glyphs.GhostNoteContainerGlyph = alphaTab.rendering.glyphs.GhostNoteContainerGlyph(false)
                ghost.renderer = this.renderer
                for (note in this.container.beat.notes)
                {
                    if (note.isVisible)
                    {
                        this.createNoteGlyph(note)
                        ghost.addParenthesis(note)
                    }
                }
                this.addGlyph(noteHeads)
                if (!ghost.isEmpty)
                {
                    this.addGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 4.0 * (if(this.container.beat.graceType != alphaTab.model.GraceType.None)  alphaTab.rendering.glyphs.NoteHeadGlyph.GraceScale else 1.0) * this.scale))
                    this.addGlyph(ghost)
                }
                if (this.container.beat.hasWhammyBar)
                {
                    var whammy: alphaTab.rendering.glyphs.ScoreWhammyBarGlyph = alphaTab.rendering.glyphs.ScoreWhammyBarGlyph(this.container.beat)
                    whammy.renderer = this.renderer
                    whammy.doLayout()
                    this.container.ties.push(whammy)
                }
                if (this.container.beat.dots > 0)
                {
                    this.addGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 5.0 * this.scale))
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < this.container.beat.dots){
                            try{
                                var group: alphaTab.rendering.glyphs.GlyphGroup = alphaTab.rendering.glyphs.GlyphGroup(0.0, 0.0)
                                group.renderer = this.renderer
                                for (note in this.container.beat.notes)
                                {
                                    this.createBeatDot(sr.getNoteLine(note), group)
                                }
                                this.addGlyph(group)
                            }
                            finally{
                                i++
                            }
                        }
                    }
                }
            }
            else 
            {
                var line: Double = alphaTab.core.ecmaScript.Math.ceil((this.renderer.bar.staff.standardNotationLineCount - 1.0) / (2.0).toDouble()) * 2.0
                if (this.container.beat.duration == alphaTab.model.Duration.Whole && this.renderer.bar.staff.standardNotationLineCount != 1.0 && this.renderer.bar.staff.standardNotationLineCount != 3.0)
                {
                    line -= 2.0
                }
                var restGlyph: alphaTab.rendering.glyphs.ScoreRestGlyph = alphaTab.rendering.glyphs.ScoreRestGlyph(0.0, sr.getScoreY(line), this.container.beat.duration)
                this.restGlyph = restGlyph
                restGlyph.beat = this.container.beat
                restGlyph.beamingHelper = this.beamingHelper
                this.addGlyph(restGlyph)
                if (this.renderer.bar.isMultiVoice)
                {
                    if (this.container.beat.voice.index == 0.0)
                    {
                        var restSizes: alphaTab.collections.DoubleList = alphaTab.rendering.utils.BeamingHelper.computeLineHeightsForRest(this.container.beat.duration)
                        var restTop: Double = restGlyph.y - sr.getScoreHeight(restSizes[(0).toInt()])
                        var restBottom: Double = restGlyph.y + sr.getScoreHeight(restSizes[(1).toInt()])
                        this.renderer.helpers.collisionHelper.reserveBeatSlot(this.container.beat, restTop, restBottom)
                    }
                    else 
                    {
                        this.renderer.helpers.collisionHelper.registerRest(this.container.beat)
                    }
                }
                if (alphaTab.core.TypeHelper.isTruthy(this.beamingHelper))
                {
                    this.beamingHelper.applyRest(this.container.beat, line)
                }
                if (this.container.beat.dots > 0)
                {
                    this.addGlyph(alphaTab.rendering.glyphs.SpacingGlyph(0.0, 0.0, 5.0 * this.scale))
                    if(true) {
                        var i: Double = 0.0
                        
                        while(i < this.container.beat.dots){
                            try{
                                var group: alphaTab.rendering.glyphs.GlyphGroup = alphaTab.rendering.glyphs.GlyphGroup(0.0, 0.0)
                                group.renderer = this.renderer
                                this.createBeatDot(line, group)
                                this.addGlyph(group)
                            }
                            finally{
                                i++
                            }
                        }
                    }
                }
            }
        }
        super.doLayout()
        if (this.container.beat.isEmpty)
        {
            this.centerX = this.width / (2.0).toDouble()
        }
        else if (this.container.beat.isRest)
        {
            this.centerX = this.restGlyph!!.x + this.restGlyph!!.width / (2.0).toDouble()
        }
        else 
        {
            this.centerX = this.noteHeads!!.x + this.noteHeads!!.width / (2.0).toDouble()
        }
    }
    
    /**
     */
    private fun createBeatDot(line: Double, group: alphaTab.rendering.glyphs.GlyphGroup): Unit{
        var sr: alphaTab.rendering.ScoreBarRenderer = (this.renderer as alphaTab.rendering.ScoreBarRenderer)
        group.addGlyph(alphaTab.rendering.glyphs.CircleGlyph(0.0, sr.getScoreY(line), 1.5 * this.scale))
    }
    
    /**
     */
    private fun createNoteHeadGlyph(n: alphaTab.model.Note): alphaTab.rendering.glyphs.EffectGlyph{
        var isGrace: Boolean = this.container.beat.graceType != alphaTab.model.GraceType.None
        if (n.beat.voice.bar.staff.isPercussion)
        {
            var articulation: alphaTab.model.InstrumentArticulation? = alphaTab.model.PercussionMapper.getArticulation(n)
            if (alphaTab.core.TypeHelper.isTruthy(articulation))
            {
                return alphaTab.rendering.glyphs.PercussionNoteHeadGlyph(0.0, 0.0, articulation, n.beat.duration, isGrace)
            }
            else 
            {
                alphaTab.Logger.warning("Rendering", """No articulation found for percussion instrument ${(n.percussionArticulation).toTemplate()}""")
            }
        }
        if (n.isDead)
        {
            return alphaTab.rendering.glyphs.DeadNoteHeadGlyph(0.0, 0.0, isGrace)
        }
        if (n.beat.graceType == alphaTab.model.GraceType.BendGrace)
        {
            return alphaTab.rendering.glyphs.NoteHeadGlyph(0.0, 0.0, alphaTab.model.Duration.Quarter, true)
        }
        if (n.harmonicType == alphaTab.model.HarmonicType.Natural)
        {
            return alphaTab.rendering.glyphs.DiamondNoteHeadGlyph(0.0, 0.0, n.beat.duration, isGrace)
        }
        return alphaTab.rendering.glyphs.NoteHeadGlyph(0.0, 0.0, n.beat.duration, isGrace)
    }
    
    /**
     */
    private fun createNoteGlyph(n: alphaTab.model.Note): Unit{
        if (n.beat.graceType == alphaTab.model.GraceType.BendGrace && !n.hasBend)
        {
            return
        }
        var sr: alphaTab.rendering.ScoreBarRenderer = (this.renderer as alphaTab.rendering.ScoreBarRenderer)
        var noteHeadGlyph: alphaTab.rendering.glyphs.EffectGlyph = this.createNoteHeadGlyph(n)
        var line: Double = sr.getNoteLine(n)
        noteHeadGlyph.y = sr.getScoreY(line)
        this.noteHeads!!.addNoteGlyph(noteHeadGlyph, n, line)
        if (n.harmonicType != alphaTab.model.HarmonicType.None && n.harmonicType != alphaTab.model.HarmonicType.Natural)
        {
            var harmonicFret: Double = n.displayValue + n.harmonicPitch
            noteHeadGlyph = alphaTab.rendering.glyphs.DiamondNoteHeadGlyph(0.0, 0.0, n.beat.duration, this.container.beat.graceType != alphaTab.model.GraceType.None)
            line = sr.accidentalHelper.getNoteLineForValue(harmonicFret, false)
            noteHeadGlyph.y = sr.getScoreY(line)
            this.noteHeads!!.addNoteGlyph(noteHeadGlyph, n, line)
        }
        if (n.isStaccato && !this.noteHeads!!.aboveBeatEffects.has("Staccato"))
        {
            this.noteHeads!!.belowBeatEffects.set("Staccato", alphaTab.rendering.glyphs.ArticStaccatoAboveGlyph(0.0, 0.0))
        }
        if (n.accentuated == alphaTab.model.AccentuationType.Normal && !this.noteHeads!!.aboveBeatEffects.has("Accent"))
        {
            this.noteHeads!!.belowBeatEffects.set("Accent", alphaTab.rendering.glyphs.AccentuationGlyph(0.0, 0.0, alphaTab.model.AccentuationType.Normal))
        }
        if (n.accentuated == alphaTab.model.AccentuationType.Heavy && !this.noteHeads!!.aboveBeatEffects.has("HAccent"))
        {
            this.noteHeads!!.belowBeatEffects.set("HAccent", alphaTab.rendering.glyphs.AccentuationGlyph(0.0, 0.0, alphaTab.model.AccentuationType.Heavy))
        }
        if (n.isPercussion)
        {
            var articulation: alphaTab.model.InstrumentArticulation? = alphaTab.model.PercussionMapper.getArticulation(n)
            if (alphaTab.core.TypeHelper.isTruthy(articulation) && articulation.techniqueSymbolPlacement != alphaTab.platform.TextBaseline.Middle)
            {
                var effectContainer: alphaTab.collections.Map<String, alphaTab.rendering.glyphs.EffectGlyph> = if(articulation.techniqueSymbolPlacement == alphaTab.platform.TextBaseline.Top)  this.noteHeads!!.aboveBeatEffects else this.noteHeads!!.belowBeatEffects
                when (articulation.techniqueSymbol)
                {
                    alphaTab.model.MusicFontSymbol.PictEdgeOfCymbal -> 
                    {
                        effectContainer.set("PictEdgeOfCymbal", alphaTab.rendering.glyphs.PictEdgeOfCymbalGlyph(0.0, 0.0))
                    }
                    alphaTab.model.MusicFontSymbol.ArticStaccatoAbove -> 
                    {
                        effectContainer.set("ArticStaccatoAbove", alphaTab.rendering.glyphs.ArticStaccatoAboveGlyph(0.0, 0.0))
                    }
                    alphaTab.model.MusicFontSymbol.StringsUpBow -> 
                    {
                        effectContainer.set("StringsUpBow", alphaTab.rendering.glyphs.PickStrokeGlyph(0.0, 0.0, alphaTab.model.PickStroke.Up))
                    }
                    alphaTab.model.MusicFontSymbol.StringsDownBow -> 
                    {
                        effectContainer.set("StringsDownBow", alphaTab.rendering.glyphs.PickStrokeGlyph(0.0, 0.0, alphaTab.model.PickStroke.Down))
                    }
                    alphaTab.model.MusicFontSymbol.GuitarGolpe -> 
                    {
                        effectContainer.set("GuitarGolpe", alphaTab.rendering.glyphs.GuitarGolpeGlyph(0.0, 0.0))
                    }
                    else -> { }
                }
            }
        }
    }
    
    public constructor()
        : super()
}

