// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ScoreNoteChordGlyph: alphaTab.rendering.glyphs.ScoreNoteChordGlyphBase
{
    private var _noteGlyphLookup: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.EffectGlyph> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.EffectGlyph>()
    
    private var _notes: alphaTab.collections.List<alphaTab.model.Note> = alphaTab.collections.List<alphaTab.model.Note>(
    )
    
    
    private var _tremoloPicking: alphaTab.rendering.glyphs.Glyph? = null
    
    public var aboveBeatEffects: alphaTab.collections.Map<String, alphaTab.rendering.glyphs.EffectGlyph> = alphaTab.collections.Map<String, alphaTab.rendering.glyphs.EffectGlyph>()
    
    public var belowBeatEffects: alphaTab.collections.Map<String, alphaTab.rendering.glyphs.EffectGlyph> = alphaTab.collections.Map<String, alphaTab.rendering.glyphs.EffectGlyph>()
    
    public lateinit var beat: alphaTab.model.Beat
    public lateinit var beamingHelper: alphaTab.rendering.utils.BeamingHelper
    public constructor()
        : super()
    public override val direction: alphaTab.rendering.utils.BeamDirection
    get(){
        return this.beamingHelper.direction
    }
    
    /**
     */
    public fun getNoteX(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteXPosition): Double{
        if (this._noteGlyphLookup.has(note.id))
        {
            var n: alphaTab.rendering.glyphs.EffectGlyph = this._noteGlyphLookup.get(note.id)!!
            var pos: Double = this.x + n.x + this._noteHeadPadding
            when (requestedPosition)
            {
                alphaTab.rendering.NoteXPosition.Left -> 
                {
                }
                alphaTab.rendering.NoteXPosition.Center -> 
                {
                    pos += n.width / (2.0).toDouble()
                }
                alphaTab.rendering.NoteXPosition.Right -> 
                {
                    pos += n.width
                }
                else -> { }
            }
            return pos
        }
        return 0.0
    }
    
    /**
     */
    public fun getNoteY(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteYPosition): Double{
        if (this._noteGlyphLookup.has(note.id))
        {
            var n: alphaTab.rendering.glyphs.EffectGlyph = this._noteGlyphLookup.get(note.id)!!
            var pos: Double = this.y + n.y
            when (requestedPosition)
            {
                alphaTab.rendering.NoteYPosition.TopWithStem -> 
                {
                    pos -= ((this.renderer as alphaTab.rendering.ScoreBarRenderer)).getStemSize(this.beamingHelper)
                }
                alphaTab.rendering.NoteYPosition.Top -> 
                {
                    pos -= n.height / (2.0).toDouble()
                }
                alphaTab.rendering.NoteYPosition.Center -> 
                {
                }
                alphaTab.rendering.NoteYPosition.Bottom -> 
                {
                    pos += n.height / (2.0).toDouble()
                }
                alphaTab.rendering.NoteYPosition.BottomWithStem -> 
                {
                    pos += ((this.renderer as alphaTab.rendering.ScoreBarRenderer)).getStemSize(this.beamingHelper)
                }
                else -> { }
            }
            return pos
        }
        return 0.0
    }
    
    /**
     */
    public fun addNoteGlyph(noteGlyph: alphaTab.rendering.glyphs.EffectGlyph, note: alphaTab.model.Note, noteLine: Double): Unit{
        super.add(noteGlyph, noteLine)
        this._noteGlyphLookup.set(note.id, noteGlyph)
        this._notes.push(note)
    }
    
    /**
     */
    public fun updateBeamingHelper(cx: Double): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(this.beamingHelper))
        {
            this.beamingHelper.registerBeatLineX("score", this.beat, cx + this.x + this.upLineX, cx + this.x + this.downLineX)
        }
    }
    
    public override fun doLayout(): Unit{
        super.doLayout()
        var direction: alphaTab.rendering.utils.BeamDirection = this.direction
        for (effect in this.aboveBeatEffects.values())
        {
            effect.renderer = this.renderer
            effect.doLayout()
        }
        for (effect in this.belowBeatEffects.values())
        {
            effect.renderer = this.renderer
            effect.doLayout()
        }
        if (this.beat.isTremolo)
        {
            var offset: Double = 0.0
            var baseNote: alphaTab.rendering.glyphs.ScoreNoteGlyphInfo = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.minNote!! else this.maxNote!!
            var tremoloX: Double = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  this.displacedX else 0.0
            var speed: alphaTab.model.Duration = this.beat.tremoloSpeed!!
            when (speed)
            {
                alphaTab.model.Duration.ThirtySecond -> 
                {
                    offset = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  -15.0 else 15.0
                }
                alphaTab.model.Duration.Sixteenth -> 
                {
                    offset = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  -12.0 else 15.0
                }
                alphaTab.model.Duration.Eighth -> 
                {
                    offset = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  -10.0 else 10.0
                }
                else -> 
                {
                    offset = if(direction == alphaTab.rendering.utils.BeamDirection.Up)  -10.0 else 15.0
                }
            }
            this._tremoloPicking = alphaTab.rendering.glyphs.TremoloPickingGlyph(tremoloX, baseNote.glyph.y + offset * this.scale, speed)
            this._tremoloPicking!!.renderer = this.renderer
            this._tremoloPicking!!.doLayout()
        }
    }
    
    /**
     */
    public fun buildBoundingsLookup(beatBounds: alphaTab.rendering.utils.BeatBounds, cx: Double, cy: Double): Unit{
        for (note in this._notes)
        {
            if (this._noteGlyphLookup.has(note.id))
            {
                var glyph: alphaTab.rendering.glyphs.EffectGlyph = this._noteGlyphLookup.get(note.id)!!
                var noteBounds: alphaTab.rendering.utils.NoteBounds = alphaTab.rendering.utils.NoteBounds()
                noteBounds.note = note
                noteBounds.noteHeadBounds = alphaTab.rendering.utils.Bounds()
                noteBounds.noteHeadBounds.x = cx + this.x + this._noteHeadPadding + glyph.x
                noteBounds.noteHeadBounds.y = cy + this.y + glyph.y - glyph.height / (2.0).toDouble()
                noteBounds.noteHeadBounds.w = glyph.width
                noteBounds.noteHeadBounds.h = glyph.height
                beatBounds.addNote(noteBounds)
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        var scoreRenderer: alphaTab.rendering.ScoreBarRenderer = (this.renderer as alphaTab.rendering.ScoreBarRenderer)
        var aboveBeatEffectsY: Double = 0.0
        var belowBeatEffectsY: Double = 0.0
        var belowEffectSpacing: Double = 1.0
        var aboveEffectSpacing: Double = -belowEffectSpacing
        if (this.beamingHelper.direction == alphaTab.rendering.utils.BeamDirection.Up)
        {
            belowBeatEffectsY = scoreRenderer.getScoreY(this.minNote!!.line)
            aboveBeatEffectsY = scoreRenderer.getScoreY(this.maxNote!!.line - 2.0)
        }
        else 
        {
            belowBeatEffectsY = scoreRenderer.getScoreY(this.maxNote!!.line - 1.0)
            aboveBeatEffectsY = scoreRenderer.getScoreY(this.minNote!!.line + 1.0)
            aboveEffectSpacing *= -1.0
            belowEffectSpacing *= -1.0
        }
        for (g in this.aboveBeatEffects.values())
        {
            aboveBeatEffectsY += aboveEffectSpacing * g.height
            g.paint(cx + this.x + 2.0 * this.scale, cy + this.y + aboveBeatEffectsY, canvas)
        }
        for (g in this.belowBeatEffects.values())
        {
            belowBeatEffectsY += belowEffectSpacing * g.height
            g.paint(cx + this.x + 2.0 * this.scale, cy + this.y + belowBeatEffectsY, canvas)
        }
        super.paint(cx, cy, canvas)
        if (alphaTab.core.TypeHelper.isTruthy(this._tremoloPicking))
        {
            this._tremoloPicking!!.paint(cx, cy, canvas)
        }
    }
    
}

