// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TabBendGlyph: alphaTab.rendering.glyphs.Glyph
{
    private var _notes: alphaTab.collections.List<alphaTab.model.Note> = alphaTab.collections.List<alphaTab.model.Note>(
    )
    
    
    private var _renderPoints: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint>> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint>>()
    
    private var _preBendMinValue: Double = -1.0
    
    private var _bendMiddleMinValue: Double = -1.0
    
    private var _bendEndMinValue: Double = -1.0
    
    private var _bendEndContinuedMinValue: Double = -1.0
    
    private var _releaseMinValue: Double = -1.0
    
    private var _releaseContinuedMinValue: Double = -1.0
    
    private var _maxBendValue: Double = -1.0
    
    public constructor()
        : super(0.0, 0.0)
    /**
     */
    public fun addBends(note: alphaTab.model.Note): Unit{
        this._notes.push(note)
        var renderPoints: alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint> = this.createRenderingPoints(note)
        this._renderPoints.set(note.id, renderPoints)
        if (this._maxBendValue == -1.0 || this._maxBendValue < note.maxBendPoint!!.value)
        {
            this._maxBendValue = note.maxBendPoint!!.value
        }
        var value: Double = 0.0
        when (note.bendType)
        {
            alphaTab.model.BendType.Bend -> 
            {
                value = renderPoints[(1).toInt()].value
                if (note.isTieOrigin)
                {
                    if (this._bendEndContinuedMinValue == -1.0 || value < this._bendEndContinuedMinValue)
                    {
                        this._bendEndContinuedMinValue = value
                    }
                }
                else 
                {
                    if (this._bendEndMinValue == -1.0 || value < this._bendEndMinValue)
                    {
                        this._bendEndMinValue = value
                    }
                }
            }
            alphaTab.model.BendType.Release -> 
            {
                value = renderPoints[(1).toInt()].value
                if (note.isTieOrigin)
                {
                    if (this._releaseContinuedMinValue == -1.0 || value < this._releaseContinuedMinValue)
                    {
                        this._releaseContinuedMinValue = value
                    }
                }
                else 
                {
                    if (value > 0 && (this._releaseMinValue == -1.0 || value < this._releaseMinValue))
                    {
                        this._releaseMinValue = value
                    }
                }
            }
            alphaTab.model.BendType.BendRelease -> 
            {
                value = renderPoints[(1).toInt()].value
                if (this._bendMiddleMinValue == -1.0 || value < this._bendMiddleMinValue)
                {
                    this._bendMiddleMinValue = value
                }
                value = renderPoints[(2).toInt()].value
                if (note.isTieOrigin)
                {
                    if (this._releaseContinuedMinValue == -1.0 || value < this._releaseContinuedMinValue)
                    {
                        this._releaseContinuedMinValue = value
                    }
                }
                else 
                {
                    if (value > 0 && (this._releaseMinValue == -1.0 || value < this._releaseMinValue))
                    {
                        this._releaseMinValue = value
                    }
                }
            }
            alphaTab.model.BendType.Prebend -> 
            {
                value = renderPoints[(0).toInt()].value
                if (this._preBendMinValue == -1.0 || value < this._preBendMinValue)
                {
                    this._preBendMinValue = value
                }
            }
            alphaTab.model.BendType.PrebendBend -> 
            {
                value = renderPoints[(0).toInt()].value
                if (this._preBendMinValue == -1.0 || value < this._preBendMinValue)
                {
                    this._preBendMinValue = value
                }
                value = renderPoints[(1).toInt()].value
                if (note.isTieOrigin)
                {
                    if (this._bendEndContinuedMinValue == -1.0 || value < this._bendEndContinuedMinValue)
                    {
                        this._bendEndContinuedMinValue = value
                    }
                }
                else 
                {
                    if (this._bendEndMinValue == -1.0 || value < this._bendEndMinValue)
                    {
                        this._bendEndMinValue = value
                    }
                }
            }
            alphaTab.model.BendType.PrebendRelease -> 
            {
                value = renderPoints[(0).toInt()].value
                if (this._preBendMinValue == -1.0 || value < this._preBendMinValue)
                {
                    this._preBendMinValue = value
                }
                value = renderPoints[(1).toInt()].value
                if (note.isTieOrigin)
                {
                    if (this._releaseContinuedMinValue == -1.0 || value < this._releaseContinuedMinValue)
                    {
                        this._releaseContinuedMinValue = value
                    }
                }
                else 
                {
                    if (value > 0 && (this._releaseMinValue == -1.0 || value < this._releaseMinValue))
                    {
                        this._releaseMinValue = value
                    }
                }
            }
            else -> { }
        }
    }
    
    public override fun doLayout(): Unit{
        super.doLayout()
        var bendHeight: Double = this._maxBendValue * alphaTab.rendering.glyphs.TabBendGlyph.BendValueHeight * this.scale
        this.renderer.registerOverflowTop(bendHeight)
        var value: Double = 0.0
        for (note in this._notes)
        {
            var renderPoints: alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint> = this._renderPoints.get(note.id)!!
            when (note.bendType)
            {
                alphaTab.model.BendType.Bend -> 
                {
                    renderPoints[(1).toInt()].lineValue = if(note.isTieOrigin)  this._bendEndContinuedMinValue else this._bendEndMinValue
                }
                alphaTab.model.BendType.Release -> 
                {
                    value = if(note.isTieOrigin)  this._releaseContinuedMinValue else this._releaseMinValue
                    if (value >= 0)
                    {
                        renderPoints[(1).toInt()].lineValue = value
                    }
                }
                alphaTab.model.BendType.BendRelease -> 
                {
                    renderPoints[(1).toInt()].lineValue = this._bendMiddleMinValue
                    value = if(note.isTieOrigin)  this._releaseContinuedMinValue else this._releaseMinValue
                    if (value >= 0)
                    {
                        renderPoints[(2).toInt()].lineValue = value
                    }
                }
                alphaTab.model.BendType.Prebend -> 
                {
                    renderPoints[(0).toInt()].lineValue = this._preBendMinValue
                }
                alphaTab.model.BendType.PrebendBend -> 
                {
                    renderPoints[(0).toInt()].lineValue = this._preBendMinValue
                    renderPoints[(1).toInt()].lineValue = if(note.isTieOrigin)  this._bendEndContinuedMinValue else this._bendEndMinValue
                }
                alphaTab.model.BendType.PrebendRelease -> 
                {
                    renderPoints[(0).toInt()].lineValue = this._preBendMinValue
                    value = if(note.isTieOrigin)  this._releaseContinuedMinValue else this._releaseMinValue
                    if (value >= 0)
                    {
                        renderPoints[(1).toInt()].lineValue = value
                    }
                }
                else -> { }
            }
        }
        this.width = 0.0
        this._notes.sort(fun(a: alphaTab.model.Note, b: alphaTab.model.Note): Double{
            if (a.isStringed)
            {
                return a.string - b.string
            }
            return a.realValue - b.realValue
        }
        )
    }
    
    /**
     */
    private fun createRenderingPoints(note: alphaTab.model.Note): alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint>{
        var renderingPoints: alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint> = alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint>(
        )
        
        when (note.bendType)
        {
            alphaTab.model.BendType.Custom -> 
            {
                for (bendPoint in note.bendPoints!!)
                {
                    renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint(bendPoint.offset, bendPoint.value))
                }
            }
            alphaTab.model.BendType.BendRelease -> 
            {
                renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint(0.0, note.bendPoints!![(0).toInt()].value))
                renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), note.bendPoints!![(1).toInt()].value))
                renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint(alphaTab.model.BendPoint.MaxPosition, note.bendPoints!![(3).toInt()].value))
            }
            alphaTab.model.BendType.Bend, alphaTab.model.BendType.Hold, alphaTab.model.BendType.Prebend, alphaTab.model.BendType.PrebendBend, alphaTab.model.BendType.PrebendRelease, alphaTab.model.BendType.Release -> 
            {
                renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint(0.0, note.bendPoints!![(0).toInt()].value))
                renderingPoints.push(alphaTab.rendering.glyphs.TabBendRenderPoint(alphaTab.model.BendPoint.MaxPosition, note.bendPoints!![(1).toInt()].value))
            }
            else -> { }
        }
        return renderingPoints
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        var color: alphaTab.model.Color = canvas.color
        if (this._notes.length > 1)
        {
            canvas.color = this.renderer.resources.secondaryGlyphColor
        }
        for (note in this._notes)
        {
            var renderPoints: alphaTab.collections.List<alphaTab.rendering.glyphs.TabBendRenderPoint> = this._renderPoints.get(note.id)!!
            var startNoteRenderer: alphaTab.rendering.BarRendererBase = this.renderer
            var endNote: alphaTab.model.Note = note
            var isMultiBeatBend: Boolean = false
            var endNoteRenderer: alphaTab.rendering.TabBarRenderer? = null
            var endNoteHasBend: Boolean = false
            var slurText: String = if(note.bendStyle == alphaTab.model.BendStyle.Gradual)  "grad." else ""
            var endBeat: alphaTab.model.Beat? = null
            while (endNote.isTieOrigin)
            {
                var nextNote: alphaTab.model.Note = endNote.tieDestination!!
                endNoteRenderer = (this.renderer.scoreRenderer.layout!!.getRendererForBar(this.renderer.staff.staveId, nextNote.beat.voice.bar) as alphaTab.rendering.TabBarRenderer)
                if (!alphaTab.core.TypeHelper.isTruthy(endNoteRenderer) || startNoteRenderer.staff != endNoteRenderer.staff)
                {
                    break
                }
                endNote = nextNote
                isMultiBeatBend = true
                if (endNote.hasBend || !this.renderer.settings.notation.extendBendArrowsOnTiedNotes)
                {
                    endNoteHasBend = true
                    break
                }
            }
            endBeat = endNote.beat
            endNoteRenderer = (this.renderer.scoreRenderer.layout!!.getRendererForBar(this.renderer.staff.staveId, endBeat.voice.bar) as alphaTab.rendering.TabBarRenderer)
            if (endBeat.isLastOfVoice && !endNote.hasBend && this.renderer.settings.notation.extendBendArrowsOnTiedNotes)
            {
                endBeat = null
            }
            var startX: Double = 0.0
            var endX: Double = 0.0
            var topY: Double = cy + startNoteRenderer.y
            startX = cx + startNoteRenderer.x
            if (renderPoints[(0).toInt()].value > 0 || note.isContinuedBend)
            {
                startX += startNoteRenderer.getBeatX(note.beat, alphaTab.rendering.BeatXPosition.MiddleNotes)
            }
            else 
            {
                startX += startNoteRenderer.getNoteX(note, alphaTab.rendering.NoteXPosition.Right)
            }
            if (!alphaTab.core.TypeHelper.isTruthy(endBeat) || (endBeat.isLastOfVoice && !endNoteHasBend))
            {
                endX = cx + endNoteRenderer!!.x + endNoteRenderer!!.postBeatGlyphsStart
            }
            else if (endNoteHasBend || !alphaTab.core.TypeHelper.isTruthy(endBeat.nextBeat))
            {
                endX = cx + endNoteRenderer!!.x + endNoteRenderer!!.getBeatX(endBeat, alphaTab.rendering.BeatXPosition.MiddleNotes)
            }
            else if (note.bendType == alphaTab.model.BendType.Hold)
            {
                endX = cx + endNoteRenderer!!.x + endNoteRenderer!!.getBeatX(endBeat.nextBeat!!, alphaTab.rendering.BeatXPosition.OnNotes)
            }
            else 
            {
                endX = cx + endNoteRenderer!!.x + endNoteRenderer!!.getBeatX(endBeat.nextBeat!!, alphaTab.rendering.BeatXPosition.PreNotes)
            }
            if (!isMultiBeatBend)
            {
                endX -= alphaTab.rendering.glyphs.TabBendGlyph.ArrowSize * this.scale
            }
            var width: Double = endX - startX
            var dX: Double = width / alphaTab.model.BendPoint.MaxPosition
            canvas.beginPath()
            if(true) {
                var i: Double = 0.0
                var j: Double = renderPoints.length - 1.0
                
                while(i < j){
                    try{
                        var firstPt: alphaTab.rendering.glyphs.TabBendRenderPoint = renderPoints[(i).toInt()]
                        var secondPt: alphaTab.rendering.glyphs.TabBendRenderPoint = renderPoints[(i + 1.0).toInt()]
                        if (i == 0.0 && firstPt.value != 0.0 && !note.isTieDestination)
                        {
                            this.paintBend(
                                note
                                , 
                                alphaTab.rendering.glyphs.TabBendRenderPoint(0.0, 0.0)
                                , 
                                firstPt
                                , 
                                startX
                                , 
                                topY
                                , 
                                dX
                                , 
                                slurText
                                , 
                                canvas
                            
                            )
                        }
                        if (note.bendType != alphaTab.model.BendType.Prebend)
                        {
                            if (i == 0.0)
                            {
                                startX += 2.0 * this.scale
                            }
                            this.paintBend(
                                note
                                , 
                                firstPt
                                , 
                                secondPt
                                , 
                                startX
                                , 
                                topY
                                , 
                                dX
                                , 
                                slurText
                                , 
                                canvas
                            
                            )
                        }
                        else if (note.isTieOrigin && note.tieDestination!!.hasBend)
                        {
                            secondPt = alphaTab.rendering.glyphs.TabBendRenderPoint(alphaTab.model.BendPoint.MaxPosition, firstPt.value)
                            secondPt.lineValue = firstPt.lineValue
                            this.paintBend(
                                note
                                , 
                                firstPt
                                , 
                                secondPt
                                , 
                                startX
                                , 
                                topY
                                , 
                                dX
                                , 
                                slurText
                                , 
                                canvas
                            
                            )
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            canvas.color = color
        }
    }
    
    /**
     */
    private fun paintBend(note: alphaTab.model.Note, firstPt: alphaTab.rendering.glyphs.TabBendRenderPoint, secondPt: alphaTab.rendering.glyphs.TabBendRenderPoint, cx: Double, cy: Double, dX: Double, slurText: String, canvas: alphaTab.platform.ICanvas): Unit{
        var r: alphaTab.rendering.TabBarRenderer = (this.renderer as alphaTab.rendering.TabBarRenderer)
        var res: alphaTab.RenderingResources = this.renderer.resources
        var overflowOffset: Double = r.lineOffset / (2.0).toDouble()
        var x1: Double = cx + dX * firstPt.offset
        var bendValueHeight: Double = alphaTab.rendering.glyphs.TabBendGlyph.BendValueHeight * this.scale
        var y1: Double = cy - bendValueHeight * firstPt.lineValue
        if (firstPt.value == 0.0)
        {
            if (secondPt.offset == firstPt.offset)
            {
                y1 += r.getNoteY(note.beat.maxStringNote!!, alphaTab.rendering.NoteYPosition.Top)
            }
            else 
            {
                y1 += r.getNoteY(note, alphaTab.rendering.NoteYPosition.Center)
            }
        }
        else 
        {
            y1 += overflowOffset
        }
        var x2: Double = cx + dX * secondPt.offset
        var y2: Double = cy - bendValueHeight * secondPt.lineValue
        if (secondPt.lineValue == 0.0)
        {
            y2 += r.getNoteY(note, alphaTab.rendering.NoteYPosition.Center)
        }
        else 
        {
            y2 += overflowOffset
        }
        var arrowOffset: Double = 0.0
        var arrowSize: Double = alphaTab.rendering.glyphs.TabBendGlyph.ArrowSize * this.scale
        if (secondPt.value > firstPt.value)
        {
            if (y2 + arrowSize > y1)
            {
                y2 = y1 - arrowSize
            }
            canvas.beginPath()
            canvas.moveTo(x2, y2)
            canvas.lineTo(x2 - arrowSize * 0.5, y2 + arrowSize)
            canvas.lineTo(x2 + arrowSize * 0.5, y2 + arrowSize)
            canvas.closePath()
            canvas.fill()
            arrowOffset = arrowSize
        }
        else if (secondPt.value != firstPt.value)
        {
            if (y2 < y1)
            {
                y2 = y1 + arrowSize
            }
            canvas.beginPath()
            canvas.moveTo(x2, y2)
            canvas.lineTo(x2 - arrowSize * 0.5, y2 - arrowSize)
            canvas.lineTo(x2 + arrowSize * 0.5, y2 - arrowSize)
            canvas.closePath()
            canvas.fill()
            arrowOffset = -arrowSize
        }
        canvas.stroke()
        if (firstPt.value == secondPt.value)
        {
            if (firstPt.lineValue > 0)
            {
                var dashX: Double = x2
                var dashSize: Double = alphaTab.rendering.glyphs.TabBendGlyph.DashSize * this.scale
                var end: Double = x1 + dashSize
                var dashes: Double = (dashX - x1) / (dashSize * 2.0)
                if (dashes < 1)
                {
                    canvas.moveTo(dashX, y1)
                    canvas.lineTo(x1, y1)
                }
                else 
                {
                    while (dashX > end)
                    {
                        canvas.moveTo(dashX, y1)
                        canvas.lineTo(dashX - dashSize, y1)
                        dashX -= dashSize * 2.0
                    }
                }
                canvas.stroke()
            }
        }
        else 
        {
            if (x2 > x1)
            {
                canvas.moveTo(x1, y1)
                canvas.bezierCurveTo(
                    (x1 + x2) / (2.0).toDouble()
                    , 
                    y1
                    , 
                    x2
                    , 
                    y1
                    , 
                    x2
                    , 
                    y2 + arrowOffset
                
                )
                canvas.stroke()
            }
            else 
            {
                canvas.moveTo(x1, y1)
                canvas.lineTo(x2, y2)
                canvas.stroke()
            }
        }
        if (alphaTab.core.TypeHelper.isTruthy(slurText) && firstPt.offset < secondPt.offset)
        {
            canvas.font = res.graceFont
            var size: Double = canvas.measureText(slurText)
            var y: Double = 0.0
            var x: Double = 0.0
            if (y1 > y2)
            {
                var h: Double = alphaTab.core.ecmaScript.Math.abs(y1 - y2)
                y = if(h > canvas.font.size * 1.3)  y1 - h / (2.0).toDouble() else y1
                x = (x1 + x2 - size) / (2.0).toDouble()
            }
            else 
            {
                y = y1
                x = x2 - size
            }
            canvas.fillText(slurText, x, y)
        }
        if (secondPt.value != 0.0 && firstPt.value != secondPt.value)
        {
            var dV: Double = secondPt.value
            var up: Boolean = secondPt.value > firstPt.value
            dV = alphaTab.core.ecmaScript.Math.abs(dV)
            var s: String = ""
            if (dV == 4.0)
            {
                s = "full"
                dV -= 4.0
            }
            else if (dV >= 4 || dV <= -4.0)
            {
                var steps: Double = (((dV / (4.0).toDouble())).toInt() or 0).toDouble()
                s += (steps).toInvariantString()
                dV -= steps * 4.0
            }
            if (dV > 0)
            {
                s += alphaTab.rendering.glyphs.TabBendGlyph.getFractionSign(dV)
            }
            if (s != "")
            {
                y2 = cy - bendValueHeight * secondPt.value
                var startY: Double = y2
                if (!up)
                {
                    startY = y1 + (alphaTab.core.ecmaScript.Math.abs(y2 - y1) * 1.0) / (3.0).toDouble()
                }
                canvas.font = res.tablatureFont
                var size: Double = canvas.measureText(s)
                var y: Double = startY - res.tablatureFont.size * 0.5 - 2.0 * this.scale
                var x: Double = x2 - size / (2.0).toDouble()
                canvas.fillText(s, x, y)
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val ArrowSize: Double = 6.0
        
        @kotlin.jvm.JvmStatic
        private val DashSize: Double = 3.0
        
        @kotlin.jvm.JvmStatic
        private val BendValueHeight: Double = 6.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getFractionSign(steps: Double): String{
            when (steps)
            {
                1.0 -> 
                {
                    return "¼"
                }
                2.0 -> 
                {
                    return "½"
                }
                3.0 -> 
                {
                    return "¾"
                }
                else -> 
                {
                    return (steps).toInvariantString() + "/ 4"
                }
            }
        }
        
    }
}

