// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TabNoteChordGlyph: alphaTab.rendering.glyphs.Glyph
{
    private var _notes: alphaTab.collections.List<alphaTab.rendering.glyphs.NoteNumberGlyph> = alphaTab.collections.List<alphaTab.rendering.glyphs.NoteNumberGlyph>(
    )
    
    
    private var _isGrace: Boolean
    
    public lateinit var beat: alphaTab.model.Beat
    public lateinit var beamingHelper: alphaTab.rendering.utils.BeamingHelper
    public var minStringNote: alphaTab.model.Note? = null
    
    public var beatEffects: alphaTab.collections.Map<String, alphaTab.rendering.glyphs.Glyph> = alphaTab.collections.Map<String, alphaTab.rendering.glyphs.Glyph>()
    
    public var notesPerString: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.NoteNumberGlyph> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.glyphs.NoteNumberGlyph>()
    
    public var noteStringWidth: Double = 0.0
    
    public constructor(x: Double, y: Double, isGrace: Boolean)
        : super(x, y){
        this._isGrace = isGrace
    }
    
    /**
     */
    public fun buildBoundingsLookup(beatBounds: alphaTab.rendering.utils.BeatBounds, cx: Double, cy: Double): Unit{
        for (note in this._notes)
        {
            note.buildBoundingsLookup(beatBounds, cx + this.x, cy + this.y)
        }
    }
    
    /**
     */
    public fun getNoteX(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteXPosition): Double{
        if (this.notesPerString.has(note.string))
        {
            var n: alphaTab.rendering.glyphs.NoteNumberGlyph = this.notesPerString.get(note.string)!!
            var pos: Double = this.x + n.x
            when (requestedPosition)
            {
                alphaTab.rendering.NoteXPosition.Left -> 
                {
                }
                alphaTab.rendering.NoteXPosition.Center -> 
                {
                    pos += n.noteStringWidth / (2.0).toDouble()
                }
                alphaTab.rendering.NoteXPosition.Right -> 
                {
                    pos += n.width
                }
                else -> { }
            }
            return pos
        }
        return 0.0
    }
    
    /**
     */
    public fun getNoteY(note: alphaTab.model.Note, requestedPosition: alphaTab.rendering.NoteYPosition): Double{
        if (this.notesPerString.has(note.string))
        {
            var n: alphaTab.rendering.glyphs.NoteNumberGlyph = this.notesPerString.get(note.string)!!
            var pos: Double = this.y + n.y
            when (requestedPosition)
            {
                alphaTab.rendering.NoteYPosition.Top, alphaTab.rendering.NoteYPosition.TopWithStem -> 
                {
                    pos -= n.height / (2.0).toDouble() + 2.0 * this.scale
                }
                alphaTab.rendering.NoteYPosition.Center -> 
                {
                }
                alphaTab.rendering.NoteYPosition.Bottom, alphaTab.rendering.NoteYPosition.BottomWithStem -> 
                {
                    pos += n.height / (2.0).toDouble()
                }
                else -> { }
            }
            return pos
        }
        return 0.0
    }
    
    public override fun doLayout(): Unit{
        var w: Double = 0.0
        var noteStringWidth: Double = 0.0
        if(true) {
            var i: Double = 0.0
            var j: Double = this._notes.length
            
            while(i < j){
                try{
                    var g: alphaTab.rendering.glyphs.NoteNumberGlyph = this._notes[(i).toInt()]
                    g.renderer = this.renderer
                    g.doLayout()
                    if (g.width > w)
                    {
                        w = g.width
                    }
                    if (g.noteStringWidth > noteStringWidth)
                    {
                        noteStringWidth = g.noteStringWidth
                    }
                }
                finally{
                    i++
                }
            }
        }
        this.noteStringWidth = noteStringWidth
        var tabHeight: Double = this.renderer.resources.tablatureFont.size
        var effectY: Double = this.getNoteY(this.minStringNote!!, alphaTab.rendering.NoteYPosition.Center) + tabHeight / (2.0).toDouble()
        var effectSpacing: Double = 7.0 * this.scale
        for (g in this.beatEffects.values())
        {
            g.y += effectY
            g.x += this.width / (2.0).toDouble()
            g.renderer = this.renderer
            effectY += effectSpacing
            g.doLayout()
        }
        this.width = w
    }
    
    /**
     */
    public fun addNoteGlyph(noteGlyph: alphaTab.rendering.glyphs.NoteNumberGlyph, note: alphaTab.model.Note): Unit{
        this._notes.push(noteGlyph)
        this.notesPerString.set(note.string, noteGlyph)
        if (!alphaTab.core.TypeHelper.isTruthy(this.minStringNote) || note.string < this.minStringNote!!.string)
        {
            this.minStringNote = note
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        var paramcx = cx
        var paramcy = cy
        paramcx += this.x
        paramcy += this.y
        var res: alphaTab.RenderingResources = this.renderer.resources
        var oldBaseLine: alphaTab.platform.TextBaseline = canvas.textBaseline
        canvas.textBaseline = alphaTab.platform.TextBaseline.Middle
        canvas.font = if(this._isGrace)  res.graceFont else res.tablatureFont
        var notes: alphaTab.collections.List<alphaTab.rendering.glyphs.NoteNumberGlyph> = this._notes
        var w: Double = this.width
        for (g in notes)
        {
            g.renderer = this.renderer
            g.width = w
            g.paint(paramcx, paramcy, canvas)
        }
        canvas.textBaseline = oldBaseLine
        for (g in this.beatEffects.values())
        {
            g.paint(paramcx, paramcy, canvas)
        }
    }
    
    /**
     */
    public fun updateBeamingHelper(cx: Double): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(this.beamingHelper) && this.beamingHelper.isPositionFrom("tab", this.beat))
        {
            this.beamingHelper.registerBeatLineX("tab", this.beat, cx + this.x + this.width / (2.0).toDouble(), cx + this.x + this.width / (2.0).toDouble())
        }
    }
    
}

