// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TabWhammyBarGlyph: alphaTab.rendering.glyphs.Glyph
{
    private var _beat: alphaTab.model.Beat
    
    private var _renderPoints: alphaTab.collections.List<alphaTab.model.BendPoint>
    
    private var _isSimpleDip: Boolean = false
    
    public constructor(beat: alphaTab.model.Beat)
        : super(0.0, 0.0){
        this._beat = beat
        this._renderPoints = this.createRenderingPoints(beat)
    }
    
    /**
     */
    private fun createRenderingPoints(beat: alphaTab.model.Beat): alphaTab.collections.List<alphaTab.model.BendPoint>{
        if (beat.whammyBarType == alphaTab.model.WhammyType.Custom)
        {
            return beat.whammyBarPoints!!
        }
        var renderingPoints: alphaTab.collections.List<alphaTab.model.BendPoint> = alphaTab.collections.List<alphaTab.model.BendPoint>(
        )
        
        when (beat.whammyBarType)
        {
            alphaTab.model.WhammyType.Dive, alphaTab.model.WhammyType.Hold, alphaTab.model.WhammyType.PrediveDive, alphaTab.model.WhammyType.Predive -> 
            {
                renderingPoints.push(alphaTab.model.BendPoint(0.0, beat.whammyBarPoints!![(0).toInt()].value))
                renderingPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, beat.whammyBarPoints!![(1).toInt()].value))
            }
            alphaTab.model.WhammyType.Dip -> 
            {
                renderingPoints.push(alphaTab.model.BendPoint(0.0, beat.whammyBarPoints!![(0).toInt()].value))
                renderingPoints.push(alphaTab.model.BendPoint((((alphaTab.model.BendPoint.MaxPosition / (2.0).toDouble())).toInt() or 0).toDouble(), beat.whammyBarPoints!![(1).toInt()].value))
                renderingPoints.push(alphaTab.model.BendPoint(alphaTab.model.BendPoint.MaxPosition, beat.whammyBarPoints!![(beat.whammyBarPoints!!.length - 1.0).toInt()].value))
            }
            else -> { }
        }
        return renderingPoints
    }
    
    public override fun doLayout(): Unit{
        super.doLayout()
        this._isSimpleDip = this.renderer.settings.notation.notationMode == alphaTab.NotationMode.SongBook && this._beat.whammyBarType == alphaTab.model.WhammyType.Dip
        var minValue: alphaTab.model.BendPoint? = null
        var maxValue: alphaTab.model.BendPoint? = null
        var beat: alphaTab.model.Beat? = this._beat
        while (alphaTab.core.TypeHelper.isTruthy(beat) && beat.hasWhammyBar)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(minValue) || minValue.value > beat.minWhammyPoint!!.value)
            {
                minValue = beat.minWhammyPoint
            }
            if (!alphaTab.core.TypeHelper.isTruthy(maxValue) || maxValue.value < beat.maxWhammyPoint!!.value)
            {
                maxValue = beat.maxWhammyPoint
            }
            beat = beat.nextBeat
        }
        var topOffset: Double = if(maxValue!!.value > 0)  alphaTab.core.ecmaScript.Math.abs(this.getOffset(maxValue!!.value)) else 0.0
        if (topOffset > 0 || this._beat.whammyBarPoints!![(0).toInt()].value != 0.0 || this.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.ZerosOnDiveWhammys))
        {
            topOffset += this.renderer.resources.tablatureFont.size * 2.0
        }
        var bottomOffset: Double = if(minValue!!.value < 0)  alphaTab.core.ecmaScript.Math.abs(this.getOffset(minValue!!.value)) else 0.0
        this.renderer.registerOverflowTop(topOffset + bottomOffset)
        var currentOffset: Double = this.renderer.staff.getSharedLayoutData<Double>(alphaTab.rendering.glyphs.TabWhammyBarGlyph.TopOffsetSharedDataKey, -1.0)
        if (topOffset > currentOffset)
        {
            this.renderer.staff.setSharedLayoutData(alphaTab.rendering.glyphs.TabWhammyBarGlyph.TopOffsetSharedDataKey, topOffset)
        }
    }
    
    /**
     */
    private fun getOffset(value: Double): Double{
        if (value == 0.0)
        {
            return 0.0
        }
        var offset: Double = alphaTab.rendering.glyphs.TabWhammyBarGlyph.PerHalfSize * this.scale + alphaTab.core.ecmaScript.Math.log2(alphaTab.core.ecmaScript.Math.abs(value) / (2.0).toDouble()) * alphaTab.rendering.glyphs.TabWhammyBarGlyph.PerHalfSize * this.scale
        if (value < 0)
        {
            offset = -offset
        }
        return offset
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        var startNoteRenderer: alphaTab.rendering.BarRendererBase = this.renderer
        var endBeat: alphaTab.model.Beat? = this._beat.nextBeat
        var endNoteRenderer: alphaTab.rendering.TabBarRenderer? = null
        var endXPositionType: alphaTab.rendering.BeatXPosition = alphaTab.rendering.BeatXPosition.PreNotes
        if (alphaTab.core.TypeHelper.isTruthy(endBeat))
        {
            endNoteRenderer = (this.renderer.scoreRenderer.layout!!.getRendererForBar(this.renderer.staff.staveId, endBeat.voice.bar) as alphaTab.rendering.TabBarRenderer?)
            if (!alphaTab.core.TypeHelper.isTruthy(endNoteRenderer) || endNoteRenderer.staff != startNoteRenderer.staff)
            {
                endBeat = null
                endNoteRenderer = null
            }
            else if (endNoteRenderer != startNoteRenderer && !endBeat.hasWhammyBar)
            {
                endBeat = null
                endNoteRenderer = null
            }
            else 
            {
                endXPositionType = if(endBeat.hasWhammyBar && (startNoteRenderer.settings.notation.notationMode != alphaTab.NotationMode.SongBook || endBeat.whammyBarType != alphaTab.model.WhammyType.Dip))  alphaTab.rendering.BeatXPosition.MiddleNotes else alphaTab.rendering.BeatXPosition.PreNotes
            }
        }
        var startX: Double = 0.0
        var endX: Double = 0.0
        if (this._isSimpleDip)
        {
            startX = cx + startNoteRenderer.x + startNoteRenderer.getBeatX(this._beat, alphaTab.rendering.BeatXPosition.OnNotes) - 2.0 * this.scale
            endX = cx + startNoteRenderer.x + startNoteRenderer.getBeatX(this._beat, alphaTab.rendering.BeatXPosition.PostNotes) + 2.0 * this.scale
        }
        else 
        {
            startX = cx + startNoteRenderer.x + startNoteRenderer.getBeatX(this._beat, alphaTab.rendering.BeatXPosition.MiddleNotes)
            endX = if(!alphaTab.core.TypeHelper.isTruthy(endNoteRenderer))  cx + startNoteRenderer.x + startNoteRenderer.width - 2.0 * this.scale else cx + endNoteRenderer.x + endNoteRenderer.getBeatX(endBeat!!, endXPositionType)
        }
        var old: alphaTab.platform.TextAlign = canvas.textAlign
        canvas.textAlign = alphaTab.platform.TextAlign.Center
        if (this._renderPoints.length >= 2)
        {
            var dx: Double = (endX - startX) / alphaTab.model.BendPoint.MaxPosition
            canvas.beginPath()
            var zeroY: Double = cy + this.renderer.staff.getSharedLayoutData<Double>(alphaTab.rendering.glyphs.TabWhammyBarGlyph.TopOffsetSharedDataKey, 0.0)
            var slurText: String = if(this._beat.whammyStyle == alphaTab.model.BendStyle.Gradual)  "grad." else ""
            if(true) {
                var i: Double = 0.0
                var j: Double = this._renderPoints.length - 1.0
                
                while(i < j){
                    try{
                        var firstPt: alphaTab.model.BendPoint = this._renderPoints[(i).toInt()]
                        var secondPt: alphaTab.model.BendPoint = this._renderPoints[(i + 1.0).toInt()]
                        var nextPt: alphaTab.model.BendPoint? = if(i < j - 2.0)  this._renderPoints[(i + 2.0).toInt()] else null
                        var isFirst: Boolean = i == 0.0
                        if (i == 0.0 && firstPt.value != 0.0 && !this._beat.isContinuedWhammy)
                        {
                            this.paintWhammy(
                                false
                                , 
                                alphaTab.model.BendPoint(0.0, 0.0)
                                , 
                                firstPt
                                , 
                                secondPt
                                , 
                                startX
                                , 
                                zeroY
                                , 
                                dx
                                , 
                                canvas
                            
                            )
                            isFirst = false
                        }
                        this.paintWhammy(
                            isFirst
                            , 
                            firstPt
                            , 
                            secondPt
                            , 
                            nextPt
                            , 
                            startX
                            , 
                            zeroY
                            , 
                            dx
                            , 
                            canvas
                            , 
                            slurText
                        
                        )
                        slurText = ""
                    }
                    finally{
                        i++
                    }
                }
            }
            canvas.stroke()
        }
        canvas.textAlign = old
    }
    
    /**
     */
    private fun paintWhammy(isFirst: Boolean, firstPt: alphaTab.model.BendPoint, secondPt: alphaTab.model.BendPoint, nextPt: alphaTab.model.BendPoint?, cx: Double, cy: Double, dx: Double, canvas: alphaTab.platform.ICanvas, slurText: String? = null): Unit{
        var x1: Double = cx + dx * firstPt.offset
        var x2: Double = cx + dx * secondPt.offset
        var y1: Double = cy - this.getOffset(firstPt.value)
        var y2: Double = cy - this.getOffset(secondPt.value)
        if (firstPt.offset == secondPt.offset)
        {
            var dashSize: Double = alphaTab.rendering.glyphs.TabWhammyBarGlyph.DashSize * this.scale
            var dashes: Double = alphaTab.core.ecmaScript.Math.abs(y2 - y1) / (dashSize * 2.0)
            if (dashes < 1)
            {
                canvas.moveTo(x1, y1)
                canvas.lineTo(x2, y2)
            }
            else 
            {
                var dashEndY: Double = alphaTab.core.ecmaScript.Math.max(y1, y2)
                var dashStartY: Double = alphaTab.core.ecmaScript.Math.min(y1, y2)
                while (dashEndY > dashStartY)
                {
                    canvas.moveTo(x1, dashStartY)
                    canvas.lineTo(x1, dashStartY + dashSize)
                    dashStartY += dashSize * 2.0
                }
            }
            canvas.stroke()
        }
        else if (firstPt.value == secondPt.value)
        {
            var dashSize: Double = alphaTab.rendering.glyphs.TabWhammyBarGlyph.DashSize * this.scale
            var dashes: Double = alphaTab.core.ecmaScript.Math.abs(x2 - x1) / (dashSize * 2.0)
            if (dashes < 1)
            {
                canvas.moveTo(x1, y1)
                canvas.lineTo(x2, y2)
            }
            else 
            {
                var dashEndX: Double = alphaTab.core.ecmaScript.Math.max(x1, x2)
                var dashStartX: Double = alphaTab.core.ecmaScript.Math.min(x1, x2)
                while (dashEndX > dashStartX)
                {
                    canvas.moveTo(dashEndX, y1)
                    canvas.lineTo(dashEndX - dashSize, y1)
                    dashEndX -= dashSize * 2.0
                }
            }
            canvas.stroke()
        }
        else 
        {
            canvas.moveTo(x1, y1)
            canvas.lineTo(x2, y2)
        }
        var res: alphaTab.RenderingResources = this.renderer.resources
        if (isFirst && !this._beat.isContinuedWhammy && !this._isSimpleDip)
        {
            var y: Double = y1
            y -= res.tablatureFont.size + 2.0 * this.scale
            if (this.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.ZerosOnDiveWhammys))
            {
                canvas.fillText("0", x1, y)
            }
            if (alphaTab.core.TypeHelper.isTruthy(slurText))
            {
                y -= res.tablatureFont.size + 2.0 * this.scale
                canvas.fillText(slurText, x1, y)
            }
        }
        var dV: Double = alphaTab.core.ecmaScript.Math.abs(secondPt.value)
        if ((dV != 0.0 || (this.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.ZerosOnDiveWhammys) && !this._isSimpleDip)) && firstPt.value != secondPt.value)
        {
            var s: String = ""
            if (secondPt.value < 0)
            {
                s += "-"
            }
            if (dV >= 4)
            {
                var steps: Double = (((dV / (4.0).toDouble())).toInt() or 0).toDouble()
                s += (steps).toInvariantString()
                dV -= steps * 4.0
            }
            else if (dV == 0.0)
            {
                s += "0"
            }
            if (dV > 0)
            {
                s += alphaTab.rendering.glyphs.TabBendGlyph.getFractionSign(dV)
            }
            var y: Double = 0.0
            if (this._isSimpleDip)
            {
                y = alphaTab.core.ecmaScript.Math.min(y1, y2) - res.tablatureFont.size - 2.0 * this.scale
            }
            else 
            {
                y = if(firstPt.offset == secondPt.offset)  alphaTab.core.ecmaScript.Math.min(y1, y2) else y2
                y -= res.tablatureFont.size + 2.0 * this.scale
                if (alphaTab.core.TypeHelper.isTruthy(nextPt) && nextPt.value > secondPt.value)
                {
                    y -= 2.0 * this.scale
                }
            }
            var x: Double = x2
            canvas.fillText(s, x, y)
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val TopOffsetSharedDataKey: String = "tab.whammy.topoffset"
        
        @kotlin.jvm.JvmStatic
        public val PerHalfSize: Double = 6.0
        
        @kotlin.jvm.JvmStatic
        private val DashSize: Double = 3.0
        
    }
}

