// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.glyphs
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal open class TieGlyph: alphaTab.rendering.glyphs.Glyph
{
    protected var startBeat: alphaTab.model.Beat?
    protected var endBeat: alphaTab.model.Beat?
    protected var yOffset: Double = 0.0
    
    protected var forEnd: Boolean
    protected var startNoteRenderer: alphaTab.rendering.BarRendererBase? = null
    
    protected var endNoteRenderer: alphaTab.rendering.BarRendererBase? = null
    
    protected var tieDirection: alphaTab.rendering.utils.BeamDirection = alphaTab.rendering.utils.BeamDirection.Up
    
    public constructor(startBeat: alphaTab.model.Beat?, endBeat: alphaTab.model.Beat?, forEnd: Boolean)
        : super(0.0, 0.0){
        this.startBeat = startBeat
        this.endBeat = endBeat
        this.forEnd = forEnd
    }
    
    private var _startX: Double = 0.0
    
    private var _startY: Double = 0.0
    
    private var _endX: Double = 0.0
    
    private var _endY: Double = 0.0
    
    private var _tieHeight: Double = 0.0
    
    private var _shouldDraw: Boolean = false
    
    public override fun doLayout(): Unit{
        this.width = 0.0
        if (!alphaTab.core.TypeHelper.isTruthy(this.endBeat))
        {
            this._shouldDraw = false
            return
        }
        var startNoteRenderer: alphaTab.rendering.BarRendererBase? = this.renderer.scoreRenderer.layout!!.getRendererForBar(this.renderer.staff.staveId, this.startBeat!!.voice.bar)
        this.startNoteRenderer = startNoteRenderer
        var endNoteRenderer: alphaTab.rendering.BarRendererBase? = this.renderer.scoreRenderer.layout!!.getRendererForBar(this.renderer.staff.staveId, this.endBeat!!.voice.bar)
        this.endNoteRenderer = endNoteRenderer
        this._startX = 0.0
        this._endX = 0.0
        this._startY = 0.0
        this._endY = 0.0
        this.height = 0.0
        this._shouldDraw = false
        this.tieDirection = if(!alphaTab.core.TypeHelper.isTruthy(startNoteRenderer))  this.getBeamDirection(this.endBeat!!, endNoteRenderer!!) else this.getBeamDirection(this.startBeat!!, startNoteRenderer)
        if (!this.forEnd && alphaTab.core.TypeHelper.isTruthy(startNoteRenderer))
        {
            if (startNoteRenderer != endNoteRenderer)
            {
                this._startX = startNoteRenderer.x + this.getStartX()
                this._startY = startNoteRenderer.y + this.getStartY() + this.yOffset
                if (!alphaTab.core.TypeHelper.isTruthy(endNoteRenderer) || startNoteRenderer.staff != endNoteRenderer.staff)
                {
                    this._endX = startNoteRenderer.x + startNoteRenderer.width
                    this._endY = this._startY
                }
                else 
                {
                    this._endX = endNoteRenderer.x + this.getEndX()
                    this._endY = endNoteRenderer.y + this.getEndY() + this.yOffset
                }
            }
            else 
            {
                this._startX = startNoteRenderer.x + this.getStartX()
                this._endX = endNoteRenderer.x + this.getEndX()
                this._startY = startNoteRenderer.y + this.getStartY() + this.yOffset
                this._endY = endNoteRenderer.y + this.getEndY() + this.yOffset
            }
            this._shouldDraw = true
        }
        else if (!alphaTab.core.TypeHelper.isTruthy(startNoteRenderer) || startNoteRenderer.staff != endNoteRenderer!!.staff)
        {
            this._startX = endNoteRenderer!!.x
            this._endX = endNoteRenderer!!.x + this.getEndX()
            this._startY = endNoteRenderer!!.y + this.getEndY() + this.yOffset
            this._endY = this._startY
            this._shouldDraw = true
        }
        if (this._shouldDraw)
        {
            this.y = alphaTab.core.ecmaScript.Math.min(this._startY, this._endY)
            if (this.shouldDrawBendSlur())
            {
                this._tieHeight = 0.0
            }
            else 
            {
                this._tieHeight = this.getTieHeight(this._startX, this._startY, this._endX, this._endY)
                this.height = alphaTab.rendering.glyphs.TieGlyph.calculateActualTieHeight(
                    this.renderer.scale
                    , 
                    this._startX
                    , 
                    this._startY
                    , 
                    this._endX
                    , 
                    this._endY
                    , 
                    this.tieDirection == alphaTab.rendering.utils.BeamDirection.Down
                    , 
                    this._tieHeight
                    , 
                    4.0
                
                ).h
            }
            if (this.tieDirection == alphaTab.rendering.utils.BeamDirection.Up)
            {
                this.y -= this.height
            }
        }
    }
    
    /**
     */
    public override fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        if (this._shouldDraw)
        {
            if (this.shouldDrawBendSlur())
            {
                alphaTab.rendering.glyphs.TieGlyph.drawBendSlur(
                    canvas
                    , 
                    cx + this._startX
                    , 
                    cy + this._startY
                    , 
                    cx + this._endX
                    , 
                    cy + this._endY
                    , 
                    this.tieDirection == alphaTab.rendering.utils.BeamDirection.Down
                    , 
                    this.scale
                
                )
            }
            else 
            {
                alphaTab.rendering.glyphs.TieGlyph.paintTie(
                    canvas
                    , 
                    this.scale
                    , 
                    cx + this._startX
                    , 
                    cy + this._startY
                    , 
                    cx + this._endX
                    , 
                    cy + this._endY
                    , 
                    this.tieDirection == alphaTab.rendering.utils.BeamDirection.Down
                    , 
                    this._tieHeight
                    , 
                    4.0
                
                )
            }
        }
    }
    
    protected open fun shouldDrawBendSlur(): Boolean{
        return false
    }
    
    /**
     */
    protected open fun getTieHeight(startX: Double, startY: Double, endX: Double, endY: Double): Double{
        return 22.0
    }
    
    /**
     */
    protected open fun getBeamDirection(beat: alphaTab.model.Beat, noteRenderer: alphaTab.rendering.BarRendererBase): alphaTab.rendering.utils.BeamDirection{
        return alphaTab.rendering.utils.BeamDirection.Down
    }
    
    protected open fun getStartY(): Double{
        return 0.0
    }
    
    protected open fun getEndY(): Double{
        return 0.0
    }
    
    protected open fun getStartX(): Double{
        return 0.0
    }
    
    protected open fun getEndX(): Double{
        return 0.0
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun calculateActualTieHeight(scale: Double, x1: Double, y1: Double, x2: Double, y2: Double, down: Boolean, offset: Double, size: Double): alphaTab.rendering.utils.Bounds{
            var paramx1 = x1
            var paramy1 = y1
            var paramx2 = x2
            var paramy2 = y2
            var cp: alphaTab.collections.DoubleList = alphaTab.rendering.glyphs.TieGlyph.computeBezierControlPoints(
                scale
                , 
                paramx1
                , 
                paramy1
                , 
                paramx2
                , 
                paramy2
                , 
                down
                , 
                offset
                , 
                size
            
            )
            paramx1 = cp[(0).toInt()]
            paramy1 = cp[(1).toInt()]
            var cpx: Double = cp[(2).toInt()]
            var cpy: Double = cp[(3).toInt()]
            paramx2 = cp[(6).toInt()]
            paramy2 = cp[(7).toInt()]
            var tx: Double = (paramx1 - cpx) / (paramx1 - 2.0 * cpx + paramx2)
            var ex: alphaTab.collections.DoubleList = alphaTab.rendering.glyphs.TieGlyph.calculateExtrema(
                paramx1
                , 
                paramy1
                , 
                cpx
                , 
                cpy
                , 
                paramx2
                , 
                paramy2
                , 
                tx
            
            )
            var xMin: Double = if(ex.length > 0)  alphaTab.core.ecmaScript.Math.min(paramx1, paramx2, ex[(0).toInt()]) else alphaTab.core.ecmaScript.Math.min(paramx1, paramx2)
            var xMax: Double = if(ex.length > 0)  alphaTab.core.ecmaScript.Math.max(paramx1, paramx2, ex[(0).toInt()]) else alphaTab.core.ecmaScript.Math.max(paramx1, paramx2)
            var ty: Double = (paramy1 - cpy) / (paramy1 - 2.0 * cpy + paramy2)
            var ey: alphaTab.collections.DoubleList = alphaTab.rendering.glyphs.TieGlyph.calculateExtrema(
                paramx1
                , 
                paramy1
                , 
                cpx
                , 
                cpy
                , 
                paramx2
                , 
                paramy2
                , 
                ty
            
            )
            var yMin: Double = if(ey.length > 0)  alphaTab.core.ecmaScript.Math.min(paramy1, paramy2, ey[(1).toInt()]) else alphaTab.core.ecmaScript.Math.min(paramy1, paramy2)
            var yMax: Double = if(ey.length > 0)  alphaTab.core.ecmaScript.Math.max(paramy1, paramy2, ey[(1).toInt()]) else alphaTab.core.ecmaScript.Math.max(paramy1, paramy2)
            var b: alphaTab.rendering.utils.Bounds = alphaTab.rendering.utils.Bounds()
            b.x = xMin
            b.y = yMin
            b.w = xMax - xMin
            b.h = yMax - yMin
            return b
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun calculateExtrema(x1: Double, y1: Double, cpx: Double, cpy: Double, x2: Double, y2: Double, t: Double): alphaTab.collections.DoubleList{
            if (t <= 0 || 1 <= t)
            {
                return alphaTab.collections.DoubleList(
                )
                
            }
            var c1x: Double = x1 + (cpx - x1) * t
            var c1y: Double = y1 + (cpy - y1) * t
            var c2x: Double = cpx + (x2 - cpx) * t
            var c2y: Double = cpy + (y2 - cpy) * t
            return alphaTab.collections.DoubleList(
                c1x + (c2x - c1x) * t, c1y + (c2y - c1y) * t)
            
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun computeBezierControlPoints(scale: Double, x1: Double, y1: Double, x2: Double, y2: Double, down: Boolean, offset: Double, size: Double): alphaTab.collections.DoubleList{
            var paramx1 = x1
            var paramx2 = x2
            var paramy1 = y1
            var paramy2 = y2
            var paramoffset = offset
            var paramsize = size
            if (paramx1 == paramx2 && paramy1 == paramy2)
            {
                return alphaTab.collections.DoubleList(
                )
                
            }
            if (paramx2 < paramx1)
            {
                var t: Double = paramx1
                paramx1 = paramx2
                paramx2 = t
                t = paramy1
                paramy1 = paramy2
                paramy2 = t
            }
            paramoffset *= scale
            paramsize *= scale
            var normalVectorX: Double = paramy2 - paramy1
            var normalVectorY: Double = paramx2 - paramx1
            var length: Double = alphaTab.core.ecmaScript.Math.sqrt(normalVectorX * normalVectorX + normalVectorY * normalVectorY)
            if (down)
            {
                normalVectorX *= -1.0
            }
            else 
            {
                normalVectorY *= -1.0
            }
            normalVectorX /= length
            normalVectorY /= length
            var centerX: Double = (paramx2 + paramx1) / (2.0).toDouble()
            var centerY: Double = (paramy2 + paramy1) / (2.0).toDouble()
            var cp1X: Double = centerX + paramoffset * normalVectorX
            var cp1Y: Double = centerY + paramoffset * normalVectorY
            var cp2X: Double = centerX + (paramoffset - paramsize) * normalVectorX
            var cp2Y: Double = centerY + (paramoffset - paramsize) * normalVectorY
            return alphaTab.collections.DoubleList(
                paramx1, paramy1, cp1X, cp1Y, cp2X, cp2Y, paramx2, paramy2)
            
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun paintTie(canvas: alphaTab.platform.ICanvas, scale: Double, x1: Double, y1: Double, x2: Double, y2: Double, down: Boolean = false, offset: Double = 22.0, size: Double = 4.0): Unit{
            var cps: alphaTab.collections.DoubleList = alphaTab.rendering.glyphs.TieGlyph.computeBezierControlPoints(
                scale
                , 
                x1
                , 
                y1
                , 
                x2
                , 
                y2
                , 
                down
                , 
                offset
                , 
                size
            
            )
            canvas.beginPath()
            canvas.moveTo(cps[(0).toInt()], cps[(1).toInt()])
            canvas.quadraticCurveTo(cps[(2).toInt()], cps[(3).toInt()], cps[(6).toInt()], cps[(7).toInt()])
            canvas.quadraticCurveTo(cps[(4).toInt()], cps[(5).toInt()], cps[(0).toInt()], cps[(1).toInt()])
            canvas.closePath()
            canvas.fill()
        }
        
        @kotlin.jvm.JvmStatic
        private val BendSlurHeight: Double = 11.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun drawBendSlur(canvas: alphaTab.platform.ICanvas, x1: Double, y1: Double, x2: Double, y2: Double, down: Boolean, scale: Double, slurText: String? = null): Unit{
            var normalVectorX: Double = y2 - y1
            var normalVectorY: Double = x2 - x1
            var length: Double = alphaTab.core.ecmaScript.Math.sqrt(normalVectorX * normalVectorX + normalVectorY * normalVectorY)
            if (down)
            {
                normalVectorX *= -1.0
            }
            else 
            {
                normalVectorY *= -1.0
            }
            normalVectorX /= length
            normalVectorY /= length
            var centerX: Double = (x2 + x1) / (2.0).toDouble()
            var centerY: Double = (y2 + y1) / (2.0).toDouble()
            var offset: Double = alphaTab.rendering.glyphs.TieGlyph.BendSlurHeight * scale
            if (x2 - x1 < 20)
            {
                offset /= 2.0
            }
            var cp1X: Double = centerX + offset * normalVectorX
            var cp1Y: Double = centerY + offset * normalVectorY
            canvas.beginPath()
            canvas.moveTo(x1, y1)
            canvas.lineTo(cp1X, cp1Y)
            canvas.lineTo(x2, y2)
            canvas.stroke()
            if (alphaTab.core.TypeHelper.isTruthy(slurText))
            {
                var w: Double = canvas.measureText(slurText)
                var textOffset: Double = if(down)  0.0 else -canvas.font.size
                canvas.fillText(slurText, cp1X - w / (2.0).toDouble(), cp1Y + textOffset)
            }
        }
        
    }
}

