// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.layout
import alphaTab.core.*

/**
 * This layout arranges the bars into a fixed width and dynamic height region.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class PageViewLayout: alphaTab.rendering.layout.ScoreLayout
{
    private var _groups: alphaTab.collections.List<alphaTab.rendering.staves.StaveGroup> = alphaTab.collections.List<alphaTab.rendering.staves.StaveGroup>(
    )
    
    
    private var _allMasterBarRenderers: alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers> = alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers>(
    )
    
    
    private var _barsFromPreviousGroup: alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers> = alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers>(
    )
    
    
    private var _pagePadding: alphaTab.collections.DoubleList? = null
    
    public override val name: String
    get(){
        return "PageView"
    }
    
    public constructor(renderer: alphaTab.rendering.ScoreRenderer)
        : super(renderer)
    protected override fun doLayoutAndRender(): Unit{
        when (this.renderer.settings.display.systemsLayoutMode)
        {
            alphaTab.SystemsLayoutMode.Automatic -> 
            {
                this.systemsLayoutMode = alphaTab.rendering.layout.InternalSystemsLayoutMode.Automatic
            }
            alphaTab.SystemsLayoutMode.UseModelLayout -> 
            {
                this.systemsLayoutMode = alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithScale
            }
            else -> { }
        }
        this._pagePadding = this.renderer.settings.display.padding
        if (!alphaTab.core.TypeHelper.isTruthy(this._pagePadding))
        {
            this._pagePadding = alphaTab.rendering.layout.PageViewLayout.PagePadding
        }
        if (this._pagePadding!!.length == 1.0)
        {
            this._pagePadding = alphaTab.collections.DoubleList(
                this._pagePadding!![(0).toInt()], this._pagePadding!![(0).toInt()], this._pagePadding!![(0).toInt()], this._pagePadding!![(0).toInt()])
            
        }
        else if (this._pagePadding!!.length == 2.0)
        {
            this._pagePadding = alphaTab.collections.DoubleList(
                this._pagePadding!![(0).toInt()], this._pagePadding!![(1).toInt()], this._pagePadding!![(0).toInt()], this._pagePadding!![(1).toInt()])
            
        }
        var y: Double = 0.0
        this.width = this.renderer.width
        this._allMasterBarRenderers = alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers>(
        )
        
        y = this.layoutAndRenderScoreInfo(y, -1.0)
        y = this.layoutAndRenderTunings(y, -1.0)
        y = this.layoutAndRenderChordDiagrams(y, -1.0)
        y = this.layoutAndRenderScore(y)
        y = this.layoutAndRenderAnnotation(y)
        this.height = y + this._pagePadding!![(3).toInt()]
    }
    
    public override val supportsResize: Boolean
    get(){
        return true
    }
    
    public override val firstBarX: Double
    get(){
        var x: Double = this._pagePadding!![(0).toInt()]
        if (this._groups.length > 0)
        {
            x += this._groups[(0).toInt()].accoladeSpacing
        }
        return x
    }
    
    public override fun doResize(): Unit{
        var y: Double = 0.0
        this.width = this.renderer.width
        var oldHeight: Double = this.height
        y = this.layoutAndRenderScoreInfo(y, oldHeight)
        y = this.layoutAndRenderTunings(y, oldHeight)
        y = this.layoutAndRenderChordDiagrams(y, oldHeight)
        y = this.resizeAndRenderScore(y, oldHeight)
        y = this.layoutAndRenderAnnotation(y)
        this.height = y + this._pagePadding!![(3).toInt()]
    }
    
    /**
     */
    private fun layoutAndRenderTunings(y: Double, totalHeight: Double = -1.0): Double{
        if (!alphaTab.core.TypeHelper.isTruthy(this.tuningGlyph))
        {
            return y
        }
        var res: alphaTab.RenderingResources = this.renderer.settings.display.resources
        this.tuningGlyph!!.x = this._pagePadding!![(0).toInt()]
        this.tuningGlyph!!.width = this.width
        this.tuningGlyph!!.doLayout()
        var tuningHeight: Double = this.tuningGlyph!!.height + 11.0 * this.scale
        var e: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        e.x = 0.0
        e.y = y
        e.width = this.width
        e.height = tuningHeight
        e.totalWidth = this.width
        e.totalHeight = if(totalHeight < 0)  y + e.height else totalHeight
        this.registerPartial(e, fun(canvas: alphaTab.platform.ICanvas): Unit{
            canvas.color = res.scoreInfoColor
            canvas.textAlign = alphaTab.platform.TextAlign.Center
            this.tuningGlyph!!.paint(0.0, 0.0, canvas)
        }
        )
        return y + tuningHeight
    }
    
    /**
     */
    private fun layoutAndRenderChordDiagrams(y: Double, totalHeight: Double = -1.0): Double{
        if (!alphaTab.core.TypeHelper.isTruthy(this.chordDiagrams))
        {
            return y
        }
        var res: alphaTab.RenderingResources = this.renderer.settings.display.resources
        this.chordDiagrams!!.width = this.width
        this.chordDiagrams!!.doLayout()
        var diagramHeight: Double = alphaTab.core.ecmaScript.Math.floor(this.chordDiagrams!!.height)
        var e: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        e.x = 0.0
        e.y = y
        e.width = this.width
        e.height = diagramHeight
        e.totalWidth = this.width
        e.totalHeight = if(totalHeight < 0)  y + diagramHeight else totalHeight
        this.registerPartial(e, fun(canvas: alphaTab.platform.ICanvas): Unit{
            canvas.color = res.scoreInfoColor
            canvas.textAlign = alphaTab.platform.TextAlign.Center
            this.chordDiagrams!!.paint(0.0, 0.0, canvas)
        }
        )
        return y + diagramHeight
    }
    
    /**
     */
    private fun layoutAndRenderScoreInfo(y: Double, totalHeight: Double = -1.0): Double{
        alphaTab.Logger.debug(this.name, "Layouting score info")
        var e: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        e.x = 0.0
        e.y = y
        var infoHeight: Double = this._pagePadding!![(1).toInt()]
        var scale: Double = this.scale
        var res: alphaTab.RenderingResources = this.renderer.settings.display.resources
        var centeredGlyphs: alphaTab.collections.List<alphaTab.NotationElement> = alphaTab.collections.List<alphaTab.NotationElement>(
            alphaTab.NotationElement.ScoreTitle, alphaTab.NotationElement.ScoreSubTitle, alphaTab.NotationElement.ScoreArtist, alphaTab.NotationElement.ScoreAlbum, alphaTab.NotationElement.ScoreWordsAndMusic)
        
        if(true) {
            var i: Double = 0.0
            
            while(i < centeredGlyphs.length){
                try{
                    if (this.scoreInfoGlyphs.has(centeredGlyphs[(i).toInt()]))
                    {
                        var glyph: alphaTab.rendering.glyphs.TextGlyph = this.scoreInfoGlyphs.get(centeredGlyphs[(i).toInt()])!!
                        glyph.x = this.width / (2.0).toDouble()
                        glyph.y = infoHeight
                        glyph.textAlign = alphaTab.platform.TextAlign.Center
                        infoHeight += glyph.font.size * scale
                    }
                }
                finally{
                    i++
                }
            }
        }
        var musicOrWords: Boolean = false
        var musicOrWordsHeight: Double = 0.0
        if (this.scoreInfoGlyphs.has(alphaTab.NotationElement.ScoreMusic))
        {
            var glyph: alphaTab.rendering.glyphs.TextGlyph = this.scoreInfoGlyphs.get(alphaTab.NotationElement.ScoreMusic)!!
            glyph.x = this.width - this._pagePadding!![(2).toInt()]
            glyph.y = infoHeight
            glyph.textAlign = alphaTab.platform.TextAlign.Right
            musicOrWords = true
            musicOrWordsHeight = glyph.font.size * scale
        }
        if (this.scoreInfoGlyphs.has(alphaTab.NotationElement.ScoreWords))
        {
            var glyph: alphaTab.rendering.glyphs.TextGlyph = this.scoreInfoGlyphs.get(alphaTab.NotationElement.ScoreWords)!!
            glyph.x = this._pagePadding!![(0).toInt()]
            glyph.y = infoHeight
            glyph.textAlign = alphaTab.platform.TextAlign.Left
            musicOrWords = true
            musicOrWordsHeight = glyph.font.size * scale
        }
        if (musicOrWords)
        {
            infoHeight += musicOrWordsHeight
        }
        infoHeight = alphaTab.core.ecmaScript.Math.floor(infoHeight + 17.0 * this.scale)
        e.width = this.width
        e.height = infoHeight
        e.totalWidth = this.width
        e.totalHeight = if(totalHeight < 0)  y + e.height else totalHeight
        this.registerPartial(e, fun(canvas: alphaTab.platform.ICanvas): Unit{
            canvas.color = res.scoreInfoColor
            canvas.textAlign = alphaTab.platform.TextAlign.Center
            for (g in this.scoreInfoGlyphs.values())
            {
                g.paint(0.0, 0.0, canvas)
            }
        }
        )
        return y + infoHeight
    }
    
    /**
     */
    private fun resizeAndRenderScore(y: Double, oldHeight: Double): Double{
        var paramy = y
        var barsPerRowActive: Boolean = this.renderer.settings.display.barsPerRow > 0 || this.systemsLayoutMode == alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithScale
        if (barsPerRowActive)
        {
            if(true) {
                var i: Double = 0.0
                
                while(i < this._groups.length){
                    try{
                        var group: alphaTab.rendering.staves.StaveGroup = this._groups[(i).toInt()]
                        this.fitGroup(group)
                        paramy += this.paintGroup(group, oldHeight)
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        else 
        {
            this._groups = alphaTab.collections.List<alphaTab.rendering.staves.StaveGroup>(
            )
            
            var currentIndex: Double = 0.0
            var maxWidth: Double = this.maxWidth
            var group: alphaTab.rendering.staves.StaveGroup = this.createEmptyStaveGroup()
            group.index = this._groups.length
            group.x = this._pagePadding!![(0).toInt()]
            group.y = paramy
            while (currentIndex < this._allMasterBarRenderers.length)
            {
                var renderers: alphaTab.rendering.staves.MasterBarsRenderers? = this._allMasterBarRenderers[(currentIndex).toInt()]
                if (group.width + renderers!!.width <= maxWidth || group.masterBarsRenderers.length == 0.0)
                {
                    group.addMasterBarRenderers(this.renderer.tracks!!, renderers!!)
                    currentIndex++
                }
                else 
                {
                    while (alphaTab.core.TypeHelper.isTruthy(renderers) && !renderers.canWrap && group.masterBarsRenderers.length > 1)
                    {
                        renderers = group.revertLastBar()
                        currentIndex--
                    }
                    group.isFull = true
                    group.isLast = this.lastBarIndex == group.lastBarIndex
                    this._groups.push(group)
                    this.fitGroup(group)
                    paramy += this.paintGroup(group, oldHeight)
                    group = this.createEmptyStaveGroup()
                    group.index = this._groups.length
                    group.x = this._pagePadding!![(0).toInt()]
                    group.y = paramy
                }
            }
            group.isLast = this.lastBarIndex == group.lastBarIndex
            this.fitGroup(group)
            paramy += this.paintGroup(group, oldHeight)
        }
        return paramy
    }
    
    /**
     */
    private fun layoutAndRenderScore(y: Double): Double{
        var paramy = y
        var startIndex: Double = this.firstBarIndex
        var currentBarIndex: Double = startIndex
        var endBarIndex: Double = this.lastBarIndex
        this._groups = alphaTab.collections.List<alphaTab.rendering.staves.StaveGroup>(
        )
        
        while (currentBarIndex <= endBarIndex)
        {
            var group: alphaTab.rendering.staves.StaveGroup = this.createStaveGroup(currentBarIndex, endBarIndex)
            this._groups.push(group)
            group.x = this._pagePadding!![(0).toInt()]
            group.y = paramy
            currentBarIndex = group.lastBarIndex + 1.0
            this.fitGroup(group)
            alphaTab.Logger.debug(this.name, "Rendering partial from bar " + (group.firstBarIndex).toInvariantString() + " to " + (group.lastBarIndex).toInvariantString(), null)
            paramy += this.paintGroup(group, paramy)
        }
        return paramy
    }
    
    /**
     */
    private fun paintGroup(group: alphaTab.rendering.staves.StaveGroup, totalHeight: Double): Double{
        var paramtotalHeight = totalHeight
        var height: Double = alphaTab.core.ecmaScript.Math.floor(group.height + 20.0 * this.scale)
        var args: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        args.x = 0.0
        args.y = group.y
        args.totalWidth = this.width
        args.totalHeight = paramtotalHeight
        args.width = this.width
        args.height = height
        args.firstMasterBarIndex = group.firstBarIndex
        args.lastMasterBarIndex = group.lastBarIndex
        group.buildBoundingsLookup(0.0, 0.0)
        this.registerPartial(args, fun(canvas: alphaTab.platform.ICanvas): Unit{
            this.renderer.canvas!!.color = this.renderer.settings.display.resources.mainGlyphColor
            this.renderer.canvas!!.textAlign = alphaTab.platform.TextAlign.Left
            group.paint(0.0, -args.y, canvas)
        }
        )
        paramtotalHeight += height
        return height
    }
    
    /**
     * Realignes the bars in this line according to the available space
     */
    private fun fitGroup(group: alphaTab.rendering.staves.StaveGroup): Unit{
        if (group.isFull || group.width > this.maxWidth || this.renderer.settings.display.justifyLastSystem)
        {
            group.scaleToWidth(this.maxWidth)
        }
        else 
        {
            group.scaleToWidth(group.width)
        }
        group.finalizeGroup()
    }
    
    /**
     */
    private fun getBarsPerRow(rowIndex: Double): Double{
        var barsPerRow: Double = this.renderer.settings.display.barsPerRow
        if (this.systemsLayoutMode == alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithScale)
        {
            var defaultSystemsLayout: Double
            var systemsLayout: alphaTab.collections.DoubleList
            if (this.renderer.tracks!!.length > 1)
            {
                defaultSystemsLayout = this.renderer.score!!.defaultSystemsLayout
                systemsLayout = this.renderer.score!!.systemsLayout
            }
            else 
            {
                defaultSystemsLayout = this.renderer.tracks!![(0).toInt()].defaultSystemsLayout
                systemsLayout = this.renderer.tracks!![(0).toInt()].systemsLayout
            }
            barsPerRow = if((rowIndex < systemsLayout.length))  systemsLayout[(rowIndex).toInt()] else defaultSystemsLayout
        }
        return barsPerRow
    }
    
    /**
     */
    private fun createStaveGroup(currentBarIndex: Double, endIndex: Double): alphaTab.rendering.staves.StaveGroup{
        var group: alphaTab.rendering.staves.StaveGroup = this.createEmptyStaveGroup()
        group.index = this._groups.length
        var barsPerRow: Double = this.getBarsPerRow(group.index)
        var maxWidth: Double = this.maxWidth
        var end: Double = endIndex + 1.0
        var barIndex: Double = currentBarIndex
        while (barIndex < end)
        {
            if (this._barsFromPreviousGroup.length > 0)
            {
                for (renderer in this._barsFromPreviousGroup)
                {
                    group.addMasterBarRenderers(this.renderer.tracks!!, renderer)
                    barIndex = renderer.masterBar.index
                }
            }
            else 
            {
                var renderers: alphaTab.rendering.staves.MasterBarsRenderers? = group.addBars(this.renderer.tracks!!, barIndex)
                if (alphaTab.core.TypeHelper.isTruthy(renderers))
                {
                    this._allMasterBarRenderers.push(renderers)
                }
            }
            this._barsFromPreviousGroup = alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers>(
            )
            
            var groupIsFull: Boolean = false
            if (barsPerRow == -1.0 && group.width >= maxWidth && group.masterBarsRenderers.length != 0.0)
            {
                groupIsFull = true
            }
            else if (group.masterBarsRenderers.length == barsPerRow + 1.0)
            {
                groupIsFull = true
            }
            if (groupIsFull)
            {
                var reverted: alphaTab.rendering.staves.MasterBarsRenderers? = group.revertLastBar()
                if (alphaTab.core.TypeHelper.isTruthy(reverted))
                {
                    this._barsFromPreviousGroup.push(reverted)
                    while (alphaTab.core.TypeHelper.isTruthy(reverted) && !reverted.canWrap && group.masterBarsRenderers.length > 1)
                    {
                        reverted = group.revertLastBar()
                        if (alphaTab.core.TypeHelper.isTruthy(reverted))
                        {
                            this._barsFromPreviousGroup.push(reverted)
                        }
                    }
                }
                group.isFull = true
                group.isLast = false
                this._barsFromPreviousGroup.reverse()
                return group
            }
            group.x = 0.0
            barIndex++
        }
        group.isLast = endIndex == group.lastBarIndex
        return group
    }
    
    private val maxWidth: Double
    get(){
        return this.renderer.width - this._pagePadding!![(0).toInt()] - this._pagePadding!![(2).toInt()]
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        public var PagePadding: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            40.0, 40.0, 40.0, 40.0)
        
        
        @kotlin.jvm.JvmStatic
        public val GroupSpacing: Double = 20.0
        
    }
}

