// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.layout
import alphaTab.core.*

/**
 * This is the base class for creating new layouting engines for the score renderer.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public abstract class ScoreLayout
{
    private var _barRendererLookup: alphaTab.collections.Map<String, alphaTab.collections.DoubleObjectMap<alphaTab.rendering.BarRendererBase>> = alphaTab.collections.Map<String, alphaTab.collections.DoubleObjectMap<alphaTab.rendering.BarRendererBase>>()
    
    public abstract val name: String
    public var renderer: alphaTab.rendering.ScoreRenderer
    public var width: Double = 0.0
    
    public var height: Double = 0.0
    
    protected var scoreInfoGlyphs: alphaTab.collections.Map<alphaTab.NotationElement, alphaTab.rendering.glyphs.TextGlyph> = alphaTab.collections.Map<alphaTab.NotationElement, alphaTab.rendering.glyphs.TextGlyph>()
    
    protected var chordDiagrams: alphaTab.rendering.glyphs.ChordDiagramContainerGlyph? = null
    
    protected var tuningGlyph: alphaTab.rendering.glyphs.TuningContainerGlyph? = null
    
    public var systemsLayoutMode: alphaTab.rendering.layout.InternalSystemsLayoutMode = alphaTab.rendering.layout.InternalSystemsLayoutMode.Automatic
    
    protected constructor(renderer: alphaTab.rendering.ScoreRenderer){
        this.renderer = renderer
    }
    
    public abstract val firstBarX: Double
    public abstract val supportsResize: Boolean
    public fun resize(): Unit{
        this._lazyPartials.clear()
        this.doResize()
    }
    
    public abstract fun doResize(): Unit
    
    public fun layoutAndRender(): Unit{
        this._lazyPartials.clear()
        var score: alphaTab.model.Score = this.renderer.score!!
        var startIndex: Double = this.renderer.settings.display.startBar
        startIndex--
        startIndex = alphaTab.core.ecmaScript.Math.min(score.masterBars.length - 1.0, alphaTab.core.ecmaScript.Math.max(0.0, startIndex))
        this.firstBarIndex = startIndex
        var endBarIndex: Double = this.renderer.settings.display.barCount
        if (endBarIndex < 0)
        {
            endBarIndex = score.masterBars.length
        }
        endBarIndex = startIndex + endBarIndex - 1.0
        endBarIndex = alphaTab.core.ecmaScript.Math.min(score.masterBars.length - 1.0, alphaTab.core.ecmaScript.Math.max(0.0, endBarIndex))
        this.lastBarIndex = endBarIndex
        this.createScoreInfoGlyphs()
        this.doLayoutAndRender()
    }
    
    private var _lazyPartials: alphaTab.collections.Map<String, alphaTab.rendering.layout.LazyPartial> = alphaTab.collections.Map<String, alphaTab.rendering.layout.LazyPartial>()
    
    /**
     */
    protected fun registerPartial(args: alphaTab.rendering.RenderFinishedEventArgs, callback: (arg1: alphaTab.platform.ICanvas) -> Unit): Unit{
        if (!this.renderer.settings.core.enableLazyLoading)
        {
            ((this.renderer.partialLayoutFinished as alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>)).trigger(args)
            this.internalRenderLazyPartial(args, callback)
        }
        else 
        {
            this._lazyPartials.set(args.id, alphaTab.rendering.layout.LazyPartial(args, callback))
            ((this.renderer.partialLayoutFinished as alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>)).trigger(args)
        }
    }
    
    /**
     */
    private fun internalRenderLazyPartial(args: alphaTab.rendering.RenderFinishedEventArgs, callback: (arg1: alphaTab.platform.ICanvas) -> Unit): Unit{
        var canvas: alphaTab.platform.ICanvas = this.renderer.canvas!!
        canvas.beginRender(args.width, args.height)
        callback(canvas)
        args.renderResult = canvas.endRender()
        ((this.renderer.partialRenderFinished as alphaTab.EventEmitterOfT<alphaTab.rendering.RenderFinishedEventArgs>)).trigger(args)
    }
    
    /**
     */
    public fun renderLazyPartial(resultId: String): Unit{
        if (this._lazyPartials.has(resultId))
        {
            var lazyPartial: alphaTab.rendering.layout.LazyPartial = this._lazyPartials.get(resultId)!!
            this.internalRenderLazyPartial(lazyPartial.args, lazyPartial.renderCallback)
        }
    }
    
    protected abstract fun doLayoutAndRender(): Unit
    
    private fun createScoreInfoGlyphs(): Unit{
        alphaTab.Logger.debug("ScoreLayout", "Creating score info glyphs")
        var notation: alphaTab.NotationSettings = this.renderer.settings.notation
        var score: alphaTab.model.Score = this.renderer.score!!
        var res: alphaTab.RenderingResources = this.renderer.settings.display.resources
        this.scoreInfoGlyphs = alphaTab.collections.Map<alphaTab.NotationElement, alphaTab.rendering.glyphs.TextGlyph>()
        if (alphaTab.core.TypeHelper.isTruthy(score.title) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreTitle))
        {
            this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreTitle, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, score.title, res.titleFont, alphaTab.platform.TextAlign.Center))
        }
        if (alphaTab.core.TypeHelper.isTruthy(score.subTitle) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreSubTitle))
        {
            this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreSubTitle, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, score.subTitle, res.subTitleFont, alphaTab.platform.TextAlign.Center))
        }
        if (alphaTab.core.TypeHelper.isTruthy(score.artist) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreArtist))
        {
            this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreArtist, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, score.artist, res.subTitleFont, alphaTab.platform.TextAlign.Center))
        }
        if (alphaTab.core.TypeHelper.isTruthy(score.album) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreAlbum))
        {
            this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreAlbum, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, score.album, res.subTitleFont, alphaTab.platform.TextAlign.Center))
        }
        if (alphaTab.core.TypeHelper.isTruthy(score.music) && score.music == score.words && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreWordsAndMusic))
        {
            this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreWordsAndMusic, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, "Music and Words by " + score.words, res.wordsFont, alphaTab.platform.TextAlign.Center))
        }
        else 
        {
            if (alphaTab.core.TypeHelper.isTruthy(score.music) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreMusic))
            {
                this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreMusic, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, "Music by " + score.music, res.wordsFont, alphaTab.platform.TextAlign.Right))
            }
            if (alphaTab.core.TypeHelper.isTruthy(score.words) && notation.isNotationElementVisible(alphaTab.NotationElement.ScoreWords))
            {
                this.scoreInfoGlyphs.set(alphaTab.NotationElement.ScoreWords, alphaTab.rendering.glyphs.TextGlyph(0.0, 0.0, "Words by " + score.words, res.wordsFont, alphaTab.platform.TextAlign.Left))
            }
        }
        var fakeBarRenderer: alphaTab.rendering.BarRendererBase = alphaTab.rendering.BarRendererBase(this.renderer, this.renderer.tracks!![(0).toInt()].staves[(0).toInt()].bars[(0).toInt()])
        if (notation.isNotationElementVisible(alphaTab.NotationElement.GuitarTuning))
        {
            var tunings: alphaTab.collections.List<alphaTab.model.Staff> = alphaTab.collections.List<alphaTab.model.Staff>(
            )
            
            for (track in this.renderer.tracks!!)
            {
                for (staff in track.staves)
                {
                    if (!staff.isPercussion && staff.isStringed && staff.tuning.length > 0 && staff.showTablature)
                    {
                        tunings.push(staff)
                        break
                    }
                }
            }
            if (tunings.length > 0)
            {
                this.tuningGlyph = alphaTab.rendering.glyphs.TuningContainerGlyph(0.0, 0.0)
                this.tuningGlyph!!.renderer = fakeBarRenderer
                for (t in tunings)
                {
                    this.tuningGlyph!!.addTuning(t.stringTuning, if(tunings.length > 1)  t.track.name else "")
                }
            }
        }
        if (notation.isNotationElementVisible(alphaTab.NotationElement.ChordDiagrams))
        {
            this.chordDiagrams = alphaTab.rendering.glyphs.ChordDiagramContainerGlyph(0.0, 0.0)
            this.chordDiagrams!!.renderer = fakeBarRenderer
            var chordIds: alphaTab.core.ecmaScript.Set<String> = alphaTab.core.ecmaScript.Set<String>()
            for (track in this.renderer.tracks!!)
            {
                for (staff in track.staves)
                {
                    var sc: alphaTab.collections.Map<String, alphaTab.model.Chord>? = staff.chords
                    if (alphaTab.core.TypeHelper.isTruthy(sc))
                    {
                        for ((_, chord) in sc)
                        {
                            if (!chordIds.has(chord.uniqueId))
                            {
                                if (chord.showDiagram)
                                {
                                    chordIds.add(chord.uniqueId)
                                    this.chordDiagrams!!.addChord(chord)
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    public val scale: Double
    get(){
        return this.renderer.settings.display.scale
    }
    
    public var firstBarIndex: Double = 0.0
    
    public var lastBarIndex: Double = 0.0
    
    protected fun createEmptyStaveGroup(): alphaTab.rendering.staves.StaveGroup{
        var group: alphaTab.rendering.staves.StaveGroup = alphaTab.rendering.staves.StaveGroup()
        group.layout = this
        if(true) {
            var trackIndex: Double = 0.0
            
            while(trackIndex < this.renderer.tracks!!.length){
                try{
                    var track: alphaTab.model.Track = this.renderer.tracks!![(trackIndex).toInt()]
                    var hasScore: Boolean = false
                    for (staff in track.staves)
                    {
                        if (staff.showStandardNotation)
                        {
                            hasScore = true
                            break
                        }
                    }
                    if(true) {
                        var staffIndex: Double = 0.0
                        
                        while(staffIndex < track.staves.length){
                            try{
                                var staff: alphaTab.model.Staff = track.staves[(staffIndex).toInt()]
                                var staveProfile: alphaTab.StaveProfile
                                if (staff.isPercussion)
                                {
                                    staveProfile = alphaTab.StaveProfile.Score
                                }
                                else if (this.renderer.settings.display.staveProfile != alphaTab.StaveProfile.Default)
                                {
                                    staveProfile = this.renderer.settings.display.staveProfile
                                }
                                else if (staff.showTablature && staff.showStandardNotation)
                                {
                                    staveProfile = alphaTab.StaveProfile.ScoreTab
                                }
                                else if (staff.showTablature)
                                {
                                    staveProfile = if(hasScore)  alphaTab.StaveProfile.TabMixed else alphaTab.StaveProfile.Tab
                                }
                                else if (staff.showStandardNotation)
                                {
                                    staveProfile = alphaTab.StaveProfile.Score
                                }
                                else 
                                {
                                    continue
                                }
                                var profile: alphaTab.collections.List<alphaTab.rendering.BarRendererFactory> = alphaTab.Environment.staveProfiles.get(staveProfile)!!
                                for (factory in profile)
                                {
                                    if (factory.canCreate(track, staff))
                                    {
                                        group.addStaff(track, alphaTab.rendering.staves.RenderStaff(trackIndex, staff, factory))
                                    }
                                }
                            }
                            finally{
                                staffIndex++
                            }
                        }
                    }
                }
                finally{
                    trackIndex++
                }
            }
        }
        return group
    }
    
    /**
     */
    public fun registerBarRenderer(key: String, renderer: alphaTab.rendering.BarRendererBase): Unit{
        if (!this._barRendererLookup.has(key))
        {
            this._barRendererLookup.set(key, alphaTab.collections.DoubleObjectMap<alphaTab.rendering.BarRendererBase>())
        }
        this._barRendererLookup.get(key)!!.set(renderer.bar.id, renderer)
    }
    
    /**
     */
    public fun unregisterBarRenderer(key: String, renderer: alphaTab.rendering.BarRendererBase): Unit{
        if (this._barRendererLookup.has(key))
        {
            var lookup: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.BarRendererBase> = this._barRendererLookup.get(key)!!
            lookup.delete(renderer.bar.id)
        }
    }
    
    /**
     */
    public fun getRendererForBar(key: String, bar: alphaTab.model.Bar): alphaTab.rendering.BarRendererBase?{
        var barRendererId: Double = bar.id
        if (this._barRendererLookup.has(key) && this._barRendererLookup.get(key)!!.has(barRendererId))
        {
            return this._barRendererLookup.get(key)!!.get(barRendererId)!!
        }
        return null
    }
    
    /**
     */
    public fun layoutAndRenderAnnotation(y: Double): Double{
        var msg: String = "rendered by alphaTab"
        var resources: alphaTab.RenderingResources = this.renderer.settings.display.resources
        var size: Double = 12.0 * this.renderer.settings.display.scale
        var height: Double = alphaTab.core.ecmaScript.Math.floor(size * 2.0)
        var e: alphaTab.rendering.RenderFinishedEventArgs = alphaTab.rendering.RenderFinishedEventArgs()
        var font: alphaTab.model.Font = alphaTab.model.Font.withFamilyList(resources.copyrightFont.families, size, alphaTab.model.FontStyle.Plain, alphaTab.model.FontWeight.Bold)
        this.renderer.canvas!!.font = font
        var centered: Boolean = alphaTab.Environment.getLayoutEngineFactory(this.renderer.settings.display.layoutMode).vertical
        e.width = this.renderer.canvas!!.measureText(msg)
        e.height = height
        e.x = if(centered)  (this.width - e.width) / (2.0).toDouble() else this.firstBarX
        e.y = y
        e.totalWidth = this.width
        e.totalHeight = y + height
        e.firstMasterBarIndex = -1.0
        e.lastMasterBarIndex = -1.0
        this.registerPartial(e, fun(canvas: alphaTab.platform.ICanvas): Unit{
            canvas.color = resources.mainGlyphColor
            canvas.font = font
            canvas.textAlign = alphaTab.platform.TextAlign.Left
            canvas.fillText(msg, 0.0, size)
        }
        )
        return y + height
    }
    
}

/**
 * Lists the different modes in which the staves and systems are arranged.
 */
public enum class InternalSystemsLayoutMode(override val value: Int): alphaTab.core.IAlphaTabEnum
{
    /**
     * Use the automatic alignment system provided by alphaTab (default)
     */
    Automatic(0),
    /**
     * Use the relative scaling information stored in the score model.
     */
    FromModelWithScale(1),
    /**
     * Use the absolute size information stored in the score model.
     */
    FromModelWithWidths(2);
    companion object{
        public fun fromValue(v:Double): InternalSystemsLayoutMode{
            return when(v.toInt()){
                Automatic.value -> Automatic
                FromModelWithScale.value -> FromModelWithScale
                FromModelWithWidths.value -> FromModelWithWidths
                else -> throw ClassCastException("No enum with value $v found")}
        }
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class LazyPartial
{
    public var args: alphaTab.rendering.RenderFinishedEventArgs
    public var renderCallback: (arg1: alphaTab.platform.ICanvas) -> Unit
    public constructor(args: alphaTab.rendering.RenderFinishedEventArgs, renderCallback: (arg1: alphaTab.platform.ICanvas) -> Unit){
        this.args = args
        this.renderCallback = renderCallback
    }
    
}

