// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.staves
import alphaTab.core.*

/**
 * This public class stores size information about a stave.
 * It is used by the layout engine to collect the sizes of score parts
 * to align the parts across multiple staves.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BarLayoutingInfo
{
    private var _timeSortedSprings: alphaTab.collections.List<alphaTab.rendering.staves.Spring> = alphaTab.collections.List<alphaTab.rendering.staves.Spring>(
    )
    
    
    private var _xMin: Double = 0.0
    
    private var _minTime: Double = -1.0
    
    private var _onTimePositionsForce: Double = 0.0
    
    private var _onTimePositions: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    private var _incompleteGraceRodsWidth: Double = 0.0
    
    /**
     * an internal version number that increments whenever a change was made.
     */
    public var version: Double = 0.0
    
    public var preBeatSizes: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    public var onBeatSizes: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    public var onBeatCenterX: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    public var preBeatSize: Double = 0.0
    
    public var postBeatSize: Double = 0.0
    
    public var voiceSize: Double = 0.0
    
    public var minStretchForce: Double = 0.0
    
    public var totalSpringConstant: Double = 0.0
    
    /**
     */
    public fun updateVoiceSize(size: Double): Unit{
        if (size > this.voiceSize)
        {
            this.voiceSize = size
            this.version++
        }
    }
    
    /**
     */
    public fun setPreBeatSize(beat: alphaTab.model.Beat, size: Double): Unit{
        if (!this.preBeatSizes.has(beat.id) || this.preBeatSizes.get(beat.id)!! < size)
        {
            this.preBeatSizes.set(beat.id, size)
            this.version++
        }
    }
    
    /**
     */
    public fun getPreBeatSize(beat: alphaTab.model.Beat): Double{
        if (this.preBeatSizes.has(beat.id))
        {
            return this.preBeatSizes.get(beat.id)!!
        }
        return 0.0
    }
    
    /**
     */
    public fun setOnBeatSize(beat: alphaTab.model.Beat, size: Double): Unit{
        if (!this.onBeatSizes.has(beat.id) || this.onBeatSizes.get(beat.id)!! < size)
        {
            this.onBeatSizes.set(beat.id, size)
            this.version++
        }
    }
    
    /**
     */
    public fun getOnBeatSize(beat: alphaTab.model.Beat): Double{
        if (this.onBeatSizes.has(beat.id))
        {
            return this.onBeatSizes.get(beat.id)!!
        }
        return 0.0
    }
    
    /**
     */
    public fun getBeatCenterX(beat: alphaTab.model.Beat): Double{
        if (this.onBeatCenterX.has(beat.id))
        {
            return this.onBeatCenterX.get(beat.id)!!
        }
        return 0.0
    }
    
    /**
     */
    public fun setBeatCenterX(beat: alphaTab.model.Beat, x: Double): Unit{
        if (!this.onBeatCenterX.has(beat.id) || this.onBeatCenterX.get(beat.id)!! < x)
        {
            this.onBeatCenterX.set(beat.id, x)
            this.version++
        }
    }
    
    /**
     */
    private fun updateMinStretchForce(force: Double): Unit{
        if (this.minStretchForce < force)
        {
            this.minStretchForce = force
        }
    }
    
    public var incompleteGraceRods: alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.rendering.staves.Spring>> = alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.rendering.staves.Spring>>()
    
    public var allGraceRods: alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.rendering.staves.Spring>> = alphaTab.collections.Map<String, alphaTab.collections.List<alphaTab.rendering.staves.Spring>>()
    
    public var springs: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.staves.Spring> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.staves.Spring>()
    
    /**
     */
    public fun addSpring(start: Double, duration: Double, graceBeatWidth: Double, preBeatWidth: Double, postSpringSize: Double): alphaTab.rendering.staves.Spring{
        this.version++
        var spring: alphaTab.rendering.staves.Spring
        if (!this.springs.has(start))
        {
            spring = alphaTab.rendering.staves.Spring()
            spring.timePosition = start
            spring.allDurations.add(duration)
            if (this._timeSortedSprings.length > 0)
            {
                var smallestDuration: Double = duration
                var previousSpring: alphaTab.rendering.staves.Spring = this._timeSortedSprings[(this._timeSortedSprings.length - 1.0).toInt()]
                for (prevDuration in previousSpring.allDurations)
                {
                    var end: Double = previousSpring.timePosition + prevDuration
                    if (end >= start && prevDuration < smallestDuration)
                    {
                        smallestDuration = prevDuration
                    }
                }
            }
            spring.longestDuration = duration
            spring.postSpringWidth = postSpringSize
            spring.graceBeatWidth = graceBeatWidth
            spring.preBeatWidth = preBeatWidth
            this.springs.set(start, spring)
            var timeSorted: alphaTab.collections.List<alphaTab.rendering.staves.Spring> = this._timeSortedSprings
            var insertPos: Double = timeSorted.length - 1.0
            while (insertPos > 0 && timeSorted[(insertPos).toInt()].timePosition > start)
            {
                insertPos--
            }
            this._timeSortedSprings.splice(insertPos + 1.0, 0.0, spring)
        }
        else 
        {
            spring = this.springs.get(start)!!
            if (spring.postSpringWidth < postSpringSize)
            {
                spring.postSpringWidth = postSpringSize
            }
            if (spring.graceBeatWidth < graceBeatWidth)
            {
                spring.graceBeatWidth = graceBeatWidth
            }
            if (spring.preBeatWidth < preBeatWidth)
            {
                spring.preBeatWidth = preBeatWidth
            }
            if (duration < spring.smallestDuration)
            {
                spring.smallestDuration = duration
            }
            if (duration > spring.longestDuration)
            {
                spring.longestDuration = duration
            }
            spring.allDurations.add(duration)
        }
        if (this._minTime == -1.0 || this._minTime > start)
        {
            this._minTime = start
        }
        return spring
    }
    
    /**
     */
    public fun addBeatSpring(beat: alphaTab.model.Beat, preBeatSize: Double, postBeatSize: Double): Unit{
        var start: Double = beat.absoluteDisplayStart
        if (beat.graceType != alphaTab.model.GraceType.None)
        {
            var groupId: String = beat.graceGroup!!.id
            if (!this.allGraceRods.has(groupId))
            {
                this.allGraceRods.set(groupId, alphaTab.collections.List<alphaTab.rendering.staves.Spring>((beat.graceGroup!!.beats.length).toInt()))
            }
            if (!beat.graceGroup!!.isComplete && !this.incompleteGraceRods.has(groupId))
            {
                this.incompleteGraceRods.set(groupId, alphaTab.collections.List<alphaTab.rendering.staves.Spring>((beat.graceGroup!!.beats.length).toInt()))
            }
            var existingSpring: alphaTab.rendering.staves.Spring = this.allGraceRods.get(groupId)!![(beat.graceIndex).toInt()]
            if (alphaTab.core.TypeHelper.isTruthy(existingSpring))
            {
                if (existingSpring.postSpringWidth < postBeatSize)
                {
                    existingSpring.postSpringWidth = postBeatSize
                }
                if (existingSpring.preBeatWidth < preBeatSize)
                {
                    existingSpring.preBeatWidth = preBeatSize
                }
            }
            else 
            {
                var graceSpring: alphaTab.rendering.staves.Spring = alphaTab.rendering.staves.Spring()
                graceSpring.timePosition = start
                graceSpring.postSpringWidth = postBeatSize
                graceSpring.preBeatWidth = preBeatSize
                if (!beat.graceGroup!!.isComplete)
                {
                    this.incompleteGraceRods.get(groupId)!![(beat.graceIndex).toInt()] = graceSpring
                }
                this.allGraceRods.get(groupId)!![(beat.graceIndex).toInt()] = graceSpring
            }
        }
        else 
        {
            var graceBeatSize: Double = 0.0
            if (alphaTab.core.TypeHelper.isTruthy(beat.graceGroup) && this.allGraceRods.has(beat.graceGroup!!.id))
            {
                for (graceBeat in this.allGraceRods.get(beat.graceGroup!!.id)!!)
                {
                    graceBeatSize += graceBeat.springWidth
                }
            }
            this.addSpring(start, beat.displayDuration, graceBeatSize, preBeatSize, postBeatSize)
        }
    }
    
    public fun finish(): Unit{
        for ((k, s) in this.allGraceRods)
        {
            var offset: Double = 0.0
            if (this.incompleteGraceRods.has(k))
            {
                for (sp in s)
                {
                    offset += sp.preBeatWidth
                    sp.graceBeatWidth = offset
                    offset += sp.postSpringWidth
                }
            }
            else 
            {
                if(true) {
                    var i: Double = s.length - 1.0
                    
                    while(i >= 0){
                        try{
                            s[(i).toInt()].graceBeatWidth = offset
                            offset -= (s[(i).toInt()].preBeatWidth + s[(i).toInt()].postSpringWidth)
                        }
                        finally{
                            i--
                        }
                    }
                }
            }
        }
        this._incompleteGraceRodsWidth = 0.0
        for (s in this.incompleteGraceRods.values())
        {
            for (sp in s)
            {
                this._incompleteGraceRodsWidth += sp.preBeatWidth + sp.postSpringWidth
            }
        }
        this.calculateSpringConstants()
        this.version++
    }
    
    private fun calculateSpringConstants(): Unit{
        this._xMin = 0.0
        var springs: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.staves.Spring> = this.springs
        for (spring in springs.values())
        {
            if (spring.springWidth < this._xMin)
            {
                this._xMin = spring.springWidth
            }
        }
        var totalSpringConstant: Double = 0.0
        var sortedSprings: alphaTab.collections.List<alphaTab.rendering.staves.Spring> = this._timeSortedSprings
        if (sortedSprings.length == 0.0)
        {
            this.totalSpringConstant = -1.0
            this.minStretchForce = -1.0
            return
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < sortedSprings.length){
                try{
                    var currentSpring: alphaTab.rendering.staves.Spring = sortedSprings[(i).toInt()]
                    var duration: Double = 0.0
                    if (i == sortedSprings.length - 1.0)
                    {
                        duration = currentSpring.longestDuration
                    }
                    else 
                    {
                        var nextSpring: alphaTab.rendering.staves.Spring = sortedSprings[(i + 1.0).toInt()]
                        duration = alphaTab.core.ecmaScript.Math.abs(nextSpring.timePosition - currentSpring.timePosition)
                    }
                    currentSpring.springConstant = this.calculateSpringConstant(currentSpring, duration)
                    totalSpringConstant += (1.0).toDouble() / currentSpring.springConstant
                }
                finally{
                    i++
                }
            }
        }
        this.totalSpringConstant = (1.0).toDouble() / totalSpringConstant
        this.minStretchForce = 0.0
        if(true) {
            var i: Double = 0.0
            
            while(i < sortedSprings.length){
                try{
                    var currentSpring: alphaTab.rendering.staves.Spring = sortedSprings[(i).toInt()]
                    var requiredSpace: Double = 0.0
                    if (i == sortedSprings.length - 1.0)
                    {
                        requiredSpace = currentSpring.postSpringWidth
                    }
                    else 
                    {
                        var nextSpring: alphaTab.rendering.staves.Spring = sortedSprings[(i + 1.0).toInt()]
                        requiredSpace = currentSpring.postSpringWidth + nextSpring.preSpringWidth
                    }
                    if (i == 0.0)
                    {
                        requiredSpace += currentSpring.preSpringWidth
                    }
                    var requiredSpaceForce: Double = requiredSpace * currentSpring.springConstant
                    this.updateMinStretchForce(requiredSpaceForce)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    public var height: Double = 0.0
    
    /**
     */
    public fun paint(_cx: Double, _cy: Double, _canvas: alphaTab.platform.ICanvas): Unit{
    }
    
    /**
     */
    private fun calculateSpringConstant(spring: alphaTab.rendering.staves.Spring, duration: Double): Double{
        var paramduration = duration
        if (paramduration <= 0)
        {
            paramduration = alphaTab.midi.MidiUtils.toTicks(alphaTab.model.Duration.SixtyFourth)
        }
        if (spring.smallestDuration == 0.0)
        {
            spring.smallestDuration = paramduration
        }
        var minDuration: Double = spring.smallestDuration
        var phi: Double = 1.0 + 0.85 * alphaTab.core.ecmaScript.Math.log2(paramduration / alphaTab.rendering.staves.BarLayoutingInfo.MinDuration)
        return (minDuration / paramduration) * ((1.0).toDouble() / (phi * alphaTab.rendering.staves.BarLayoutingInfo.MinDurationWidth))
    }
    
    /**
     */
    public fun spaceToForce(space: Double): Double{
        var paramspace = space
        if (this.totalSpringConstant != -1.0)
        {
            if (this._timeSortedSprings.length > 0)
            {
                paramspace -= this._timeSortedSprings[(0).toInt()].preSpringWidth
            }
            paramspace -= this._incompleteGraceRodsWidth
            return alphaTab.core.ecmaScript.Math.max(paramspace, 0.0) * this.totalSpringConstant
        }
        return -1.0
    }
    
    /**
     */
    public fun calculateVoiceWidth(force: Double): Double{
        var width: Double = 0.0
        if (this.totalSpringConstant != -1.0)
        {
            width = this.calculateWidth(force, this.totalSpringConstant)
        }
        if (this._timeSortedSprings.length > 0)
        {
            width += this._timeSortedSprings[(0).toInt()].preSpringWidth
        }
        width += this._incompleteGraceRodsWidth
        return width
    }
    
    /**
     */
    private fun calculateWidth(force: Double, springConstant: Double): Double{
        return force / springConstant
    }
    
    /**
     */
    public fun buildOnTimePositions(force: Double): alphaTab.collections.DoubleDoubleMap{
        if (this.totalSpringConstant == -1.0)
        {
            return alphaTab.collections.DoubleDoubleMap()
        }
        if (alphaTab.model.ModelUtils.isAlmostEqualTo(this._onTimePositionsForce, force) && alphaTab.core.TypeHelper.isTruthy(this._onTimePositions))
        {
            return this._onTimePositions
        }
        this._onTimePositionsForce = force
        var positions: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
        this._onTimePositions = positions
        var sortedSprings: alphaTab.collections.List<alphaTab.rendering.staves.Spring> = this._timeSortedSprings
        if (sortedSprings.length == 0.0)
        {
            return positions
        }
        var springX: Double = sortedSprings[(0).toInt()].preSpringWidth
        if(true) {
            var i: Double = 0.0
            
            while(i < sortedSprings.length){
                try{
                    positions.set(sortedSprings[(i).toInt()].timePosition, springX)
                    springX += this.calculateWidth(force, sortedSprings[(i).toInt()].springConstant)
                }
                finally{
                    i++
                }
            }
        }
        return positions
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val MinDuration: Double = 30.0
        
        @kotlin.jvm.JvmStatic
        private val MinDurationWidth: Double = 7.0
        
    }
    public constructor()
}

