// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.staves
import alphaTab.core.*

/**
 * A Staff represents a single line within a StaveGroup.
 * It stores BarRenderer instances created from a given factory.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class RenderStaff
{
    private var _factory: alphaTab.rendering.BarRendererFactory
    
    private var _sharedLayoutData: alphaTab.collections.Map<String, Any?> = alphaTab.collections.Map<String, Any?>()
    
    public lateinit var staveTrackGroup: alphaTab.rendering.staves.StaveTrackGroup
    public lateinit var staveGroup: alphaTab.rendering.staves.StaveGroup
    public var barRenderers: alphaTab.collections.List<alphaTab.rendering.BarRendererBase> = alphaTab.collections.List<alphaTab.rendering.BarRendererBase>(
    )
    
    
    public var x: Double = 0.0
    
    public var y: Double = 0.0
    
    public var height: Double = 0.0
    
    public var index: Double = 0.0
    
    public var staffIndex: Double = 0.0
    
    /**
     * This is the index of the track being rendered. This is not the index of the track within the model,
     * but the n-th track being rendered. It is the index of the  array defining
     * which tracks should be rendered.
     * For single-track rendering this will always be zero.
     */
    public var trackIndex: Double = 0.0
    
    public var modelStaff: alphaTab.model.Staff
    public val staveId: String
    get(){
        return this._factory.staffId
    }
    
    /**
     * This is the visual offset from top where the
     * Staff contents actually start. Used for grouping
     * using a accolade
     */
    public var staveTop: Double = 0.0
    
    public var topSpacing: Double = 20.0
    
    public var bottomSpacing: Double = 5.0
    
    /**
     * This is the visual offset from top where the
     * Staff contents actually ends. Used for grouping
     * using a accolade
     */
    public var staveBottom: Double = 0.0
    
    public var isFirstInAccolade: Boolean = false
    
    public var isLastInAccolade: Boolean = false
    
    public constructor(trackIndex: Double, staff: alphaTab.model.Staff, factory: alphaTab.rendering.BarRendererFactory){
        this._factory = factory
        this.trackIndex = trackIndex
        this.modelStaff = staff
    }
    
    /**
     */
    public fun <T>getSharedLayoutData(key: String, def: T): T{
        if (this._sharedLayoutData.has(key))
        {
            return (this._sharedLayoutData.get(key) as T)
        }
        return def
    }
    
    /**
     */
    public fun <T>setSharedLayoutData(key: String, def: T): Unit{
        this._sharedLayoutData.set(key, ((def as Any?)))
    }
    
    public val isInAccolade: Boolean
    get(){
        return this._factory.isInAccolade
    }
    
    public val isRelevantForBoundsLookup: Boolean
    get(){
        return this._factory.isRelevantForBoundsLookup
    }
    
    /**
     */
    public fun registerStaffTop(offset: Double): Unit{
        this.staveTop = offset
    }
    
    /**
     */
    public fun registerStaffBottom(offset: Double): Unit{
        this.staveBottom = offset
    }
    
    /**
     */
    public fun addBarRenderer(renderer: alphaTab.rendering.BarRendererBase): Unit{
        renderer.staff = this
        renderer.index = this.barRenderers.length
        renderer.reLayout()
        this.barRenderers.push(renderer)
        this.staveGroup.layout.registerBarRenderer(this.staveId, renderer)
    }
    
    /**
     */
    public fun addBar(bar: alphaTab.model.Bar, layoutingInfo: alphaTab.rendering.staves.BarLayoutingInfo): Unit{
        var renderer: alphaTab.rendering.BarRendererBase
        if (!alphaTab.core.TypeHelper.isTruthy(bar))
        {
            renderer = alphaTab.rendering.BarRendererBase(this.staveGroup.layout.renderer, bar)
        }
        else 
        {
            renderer = this._factory.create(this.staveGroup.layout.renderer, bar)
        }
        renderer.staff = this
        renderer.index = this.barRenderers.length
        renderer.layoutingInfo = layoutingInfo
        renderer.doLayout()
        renderer.registerLayoutingInfo()
        var barDisplayWidth: Double = renderer.barDisplayWidth
        if (barDisplayWidth > 0 && this.staveGroup.layout.systemsLayoutMode == alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithWidths)
        {
            renderer.width = barDisplayWidth
        }
        this.barRenderers.push(renderer)
        if (alphaTab.core.TypeHelper.isTruthy(bar))
        {
            this.staveGroup.layout.registerBarRenderer(this.staveId, renderer)
        }
    }
    
    public fun revertLastBar(): alphaTab.rendering.BarRendererBase{
        var lastBar: alphaTab.rendering.BarRendererBase = this.barRenderers[(this.barRenderers.length - 1.0).toInt()]
        this.barRenderers.splice(this.barRenderers.length - 1.0, 1.0)
        this.staveGroup.layout.unregisterBarRenderer(this.staveId, lastBar)
        return lastBar
    }
    
    /**
     */
    public fun scaleToWidth(width: Double): Unit{
        var paramwidth = width
        this._sharedLayoutData = alphaTab.collections.Map<String, Any?>()
        var topOverflow: Double = this.topOverflow
        var x: Double = 0.0
        when (this.staveGroup.layout.systemsLayoutMode)
        {
            alphaTab.rendering.layout.InternalSystemsLayoutMode.Automatic -> 
            {
                var difference: Double = paramwidth - this.staveGroup.computedWidth
                var spacePerBar: Double = difference / this.barRenderers.length
                for (renderer in this.barRenderers)
                {
                    renderer.x = x
                    renderer.y = this.topSpacing + topOverflow
                    var actualBarWidth: Double = renderer.computedWidth + spacePerBar
                    renderer.scaleToWidth(actualBarWidth)
                    x += renderer.width
                }
            }
            alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithScale -> 
            {
                paramwidth -= this.staveGroup.accoladeSpacing
                var totalScale: Double = this.staveGroup.totalBarDisplayScale
                for (renderer in this.barRenderers)
                {
                    renderer.x = x
                    renderer.y = this.topSpacing + topOverflow
                    var actualBarWidth: Double = renderer.barDisplayScale * paramwidth / totalScale
                    renderer.scaleToWidth(actualBarWidth)
                    x += renderer.width
                }
            }
            alphaTab.rendering.layout.InternalSystemsLayoutMode.FromModelWithWidths -> 
            {
                for (renderer in this.barRenderers)
                {
                    renderer.x = x
                    renderer.y = this.topSpacing + topOverflow
                    var displayWidth: Double = renderer.barDisplayWidth
                    if (displayWidth > 0)
                    {
                        renderer.scaleToWidth(displayWidth)
                    }
                    else 
                    {
                        renderer.scaleToWidth(renderer.computedWidth)
                    }
                    x += renderer.width
                }
            }
            else -> { }
        }
    }
    
    public val topOverflow: Double
    get(){
        var m: Double = 0.0
        if(true) {
            var i: Double = 0.0
            var j: Double = this.barRenderers.length
            
            while(i < j){
                try{
                    var r: alphaTab.rendering.BarRendererBase = this.barRenderers[(i).toInt()]
                    if (r.topOverflow > m)
                    {
                        m = r.topOverflow
                    }
                }
                finally{
                    i++
                }
            }
        }
        return m
    }
    
    public val bottomOverflow: Double
    get(){
        var m: Double = 0.0
        if(true) {
            var i: Double = 0.0
            var j: Double = this.barRenderers.length
            
            while(i < j){
                try{
                    var r: alphaTab.rendering.BarRendererBase = this.barRenderers[(i).toInt()]
                    if (r.bottomOverflow > m)
                    {
                        m = r.bottomOverflow
                    }
                }
                finally{
                    i++
                }
            }
        }
        return m
    }
    
    public fun finalizeStaff(): Unit{
        this.height = 0.0
        var needsSecondPass: Boolean = false
        var topOverflow: Double = this.topOverflow
        if(true) {
            var i: Double = 0.0
            
            while(i < this.barRenderers.length){
                try{
                    this.barRenderers[(i).toInt()].y = this.topSpacing + topOverflow
                    this.height = alphaTab.core.ecmaScript.Math.max(this.height, this.barRenderers[(i).toInt()].height)
                    if (this.barRenderers[(i).toInt()].finalizeRenderer())
                    {
                        needsSecondPass = true
                    }
                }
                finally{
                    i++
                }
            }
        }
        if (needsSecondPass)
        {
            topOverflow = this.topOverflow
            if(true) {
                var i: Double = 0.0
                
                while(i < this.barRenderers.length){
                    try{
                        this.barRenderers[(i).toInt()].y = this.topSpacing + topOverflow
                        this.height = alphaTab.core.ecmaScript.Math.max(this.height, this.barRenderers[(i).toInt()].height)
                        this.barRenderers[(i).toInt()].finalizeRenderer()
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        if (this.height > 0)
        {
            this.height += this.topSpacing + topOverflow + this.bottomOverflow + this.bottomSpacing
        }
    }
    
    /**
     */
    public fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, startIndex: Double, count: Double): Unit{
        if (this.height == 0.0 || count == 0.0)
        {
            return
        }
        if(true) {
            var i: Double = startIndex
            var j: Double = alphaTab.core.ecmaScript.Math.min(startIndex + count, this.barRenderers.length)
            
            while(i < j){
                try{
                    this.barRenderers[(i).toInt()].paint(cx + this.x, cy + this.y, canvas)
                }
                finally{
                    i++
                }
            }
        }
    }
    
}

