// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.staves
import alphaTab.core.*

/**
 * A Staff consists of a list of different staves and groups
 * them using an accolade.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class StaveGroup
{
    private var _allStaves: alphaTab.collections.List<alphaTab.rendering.staves.RenderStaff> = alphaTab.collections.List<alphaTab.rendering.staves.RenderStaff>(
    )
    
    
    private var _firstStaffInAccolade: alphaTab.rendering.staves.RenderStaff? = null
    
    private var _lastStaffInAccolade: alphaTab.rendering.staves.RenderStaff? = null
    
    private var _accoladeSpacingCalculated: Boolean = false
    
    public var x: Double = 0.0
    
    public var y: Double = 0.0
    
    public var index: Double = 0.0
    
    public var accoladeSpacing: Double = 0.0
    
    /**
     * Indicates whether this line is full or not. If the line is full the
     * bars can be aligned to the maximum width. If the line is not full
     * the bars will not get stretched.
     */
    public var isFull: Boolean = false
    
    /**
     * The width that the content bars actually need
     */
    public var width: Double = 0.0
    
    public var computedWidth: Double = 0.0
    
    public var totalBarDisplayScale: Double = 0.0
    
    public var isLast: Boolean = false
    
    public var masterBarsRenderers: alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers> = alphaTab.collections.List<alphaTab.rendering.staves.MasterBarsRenderers>(
    )
    
    
    public var staves: alphaTab.collections.List<alphaTab.rendering.staves.StaveTrackGroup> = alphaTab.collections.List<alphaTab.rendering.staves.StaveTrackGroup>(
    )
    
    
    public lateinit var layout: alphaTab.rendering.layout.ScoreLayout
    public val firstBarIndex: Double
    get(){
        return this.masterBarsRenderers[(0).toInt()].masterBar.index
    }
    
    public val lastBarIndex: Double
    get(){
        return this.masterBarsRenderers[(this.masterBarsRenderers.length - 1.0).toInt()].masterBar.index
    }
    
    /**
     */
    public fun addMasterBarRenderers(tracks: alphaTab.collections.List<alphaTab.model.Track>, renderers: alphaTab.rendering.staves.MasterBarsRenderers): alphaTab.rendering.staves.MasterBarsRenderers?{
        if (tracks.length == 0.0)
        {
            return null
        }
        this.masterBarsRenderers.push(renderers)
        this.calculateAccoladeSpacing(tracks)
        renderers.layoutingInfo.preBeatSize = 0.0
        var src: Double = 0.0
        if(true) {
            var i: Double = 0.0
            var j: Double = this.staves.length
            
            while(i < j){
                try{
                    var g: alphaTab.rendering.staves.StaveTrackGroup = this.staves[(i).toInt()]
                    if(true) {
                        var k: Double = 0.0
                        var l: Double = g.staves.length
                        
                        while(k < l){
                            try{
                                var s: alphaTab.rendering.staves.RenderStaff = g.staves[(k).toInt()]
                                var renderer: alphaTab.rendering.BarRendererBase = renderers.renderers[(src++).toInt()]
                                s.addBarRenderer(renderer)
                            }
                            finally{
                                k++
                            }
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
        this.updateWidthFromLastBar()
        return renderers
    }
    
    /**
     */
    public fun addBars(tracks: alphaTab.collections.List<alphaTab.model.Track>, barIndex: Double): alphaTab.rendering.staves.MasterBarsRenderers?{
        if (tracks.length == 0.0)
        {
            return null
        }
        var result: alphaTab.rendering.staves.MasterBarsRenderers = alphaTab.rendering.staves.MasterBarsRenderers()
        result.layoutingInfo = alphaTab.rendering.staves.BarLayoutingInfo()
        result.masterBar = tracks[(0).toInt()].score.masterBars[(barIndex).toInt()]
        this.masterBarsRenderers.push(result)
        this.calculateAccoladeSpacing(tracks)
        var barLayoutingInfo: alphaTab.rendering.staves.BarLayoutingInfo = result.layoutingInfo
        for (g in this.staves)
        {
            for (s in g.staves)
            {
                var bar: alphaTab.model.Bar = g.track.staves[(s.modelStaff.index).toInt()].bars[(barIndex).toInt()]
                s.addBar(bar, barLayoutingInfo)
                var renderer: alphaTab.rendering.BarRendererBase = s.barRenderers[(s.barRenderers.length - 1.0).toInt()]
                result.renderers.push(renderer)
                if (renderer.isLinkedToPrevious)
                {
                    result.isLinkedToPrevious = true
                }
                if (!renderer.canWrap)
                {
                    result.canWrap = false
                }
            }
        }
        barLayoutingInfo.finish()
        result.width = this.updateWidthFromLastBar()
        return result
    }
    
    public fun revertLastBar(): alphaTab.rendering.staves.MasterBarsRenderers?{
        if (this.masterBarsRenderers.length > 1)
        {
            var toRemove: alphaTab.rendering.staves.MasterBarsRenderers = this.masterBarsRenderers[(this.masterBarsRenderers.length - 1.0).toInt()]
            this.masterBarsRenderers.splice(this.masterBarsRenderers.length - 1.0, 1.0)
            var width: Double = 0.0
            var barDisplayScale: Double = 0.0
            if(true) {
                var i: Double = 0.0
                var j: Double = this._allStaves.length
                
                while(i < j){
                    try{
                        var s: alphaTab.rendering.staves.RenderStaff = this._allStaves[(i).toInt()]
                        var lastBar: alphaTab.rendering.BarRendererBase = s.revertLastBar()
                        var computedWidth: Double = lastBar.computedWidth
                        if (computedWidth > width)
                        {
                            width = computedWidth
                        }
                        var newBarDisplayScale: Double = lastBar.barDisplayScale
                        if (newBarDisplayScale > barDisplayScale)
                        {
                            barDisplayScale = newBarDisplayScale
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
            this.width -= width
            this.computedWidth -= width
            this.totalBarDisplayScale -= barDisplayScale
            return toRemove
        }
        return null
    }
    
    private fun updateWidthFromLastBar(): Double{
        var realWidth: Double = 0.0
        var barDisplayScale: Double = 0.0
        if(true) {
            var i: Double = 0.0
            var j: Double = this._allStaves.length
            
            while(i < j){
                try{
                    var s: alphaTab.rendering.staves.RenderStaff = this._allStaves[(i).toInt()]
                    var last: alphaTab.rendering.BarRendererBase = s.barRenderers[(s.barRenderers.length - 1.0).toInt()]
                    last.applyLayoutingInfo()
                    if (last.computedWidth > realWidth)
                    {
                        realWidth = last.computedWidth
                    }
                    var newBarDisplayScale: Double = last.barDisplayScale
                    if (newBarDisplayScale > barDisplayScale)
                    {
                        barDisplayScale = newBarDisplayScale
                    }
                }
                finally{
                    i++
                }
            }
        }
        this.width += realWidth
        this.computedWidth += realWidth
        this.totalBarDisplayScale += barDisplayScale
        return realWidth
    }
    
    /**
     */
    private fun calculateAccoladeSpacing(tracks: alphaTab.collections.List<alphaTab.model.Track>): Unit{
        if (!this._accoladeSpacingCalculated && this.index == 0.0)
        {
            this._accoladeSpacingCalculated = true
            if (!this.layout.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.TrackNames))
            {
                this.accoladeSpacing = 0.0
            }
            else 
            {
                var canvas: alphaTab.platform.ICanvas = this.layout.renderer.canvas!!
                var res: alphaTab.model.Font = this.layout.renderer.settings.display.resources.effectFont
                canvas.font = res
                for (t in tracks)
                {
                    this.accoladeSpacing = alphaTab.core.ecmaScript.Math.ceil(alphaTab.core.ecmaScript.Math.max(this.accoladeSpacing, canvas.measureText(t.shortName)))
                }
                this.accoladeSpacing *= this.layout.scale
                this.accoladeSpacing += 2.0 * alphaTab.rendering.staves.StaveGroup.AccoladeLabelSpacing * this.layout.scale
                this.width += this.accoladeSpacing
                this.computedWidth += this.accoladeSpacing
            }
        }
    }
    
    /**
     */
    private fun getStaveTrackGroup(track: alphaTab.model.Track): alphaTab.rendering.staves.StaveTrackGroup?{
        if(true) {
            var i: Double = 0.0
            var j: Double = this.staves.length
            
            while(i < j){
                try{
                    var g: alphaTab.rendering.staves.StaveTrackGroup = this.staves[(i).toInt()]
                    if (g.track == track)
                    {
                        return g
                    }
                }
                finally{
                    i++
                }
            }
        }
        return null
    }
    
    /**
     */
    public fun addStaff(track: alphaTab.model.Track, staff: alphaTab.rendering.staves.RenderStaff): Unit{
        var group: alphaTab.rendering.staves.StaveTrackGroup? = this.getStaveTrackGroup(track)
        if (!alphaTab.core.TypeHelper.isTruthy(group))
        {
            group = alphaTab.rendering.staves.StaveTrackGroup(this, track)
            this.staves.push(group)
        }
        staff.staveTrackGroup = group
        staff.staveGroup = this
        staff.index = this._allStaves.length
        this._allStaves.push(staff)
        group.addStaff(staff)
        if (staff.isInAccolade)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(this._firstStaffInAccolade))
            {
                this._firstStaffInAccolade = staff
                staff.isFirstInAccolade = true
            }
            if (!alphaTab.core.TypeHelper.isTruthy(group.firstStaffInAccolade))
            {
                group.firstStaffInAccolade = staff
            }
            if (!alphaTab.core.TypeHelper.isTruthy(this._lastStaffInAccolade))
            {
                this._lastStaffInAccolade = staff
                staff.isLastInAccolade = true
            }
            if (alphaTab.core.TypeHelper.isTruthy(this._lastStaffInAccolade))
            {
                this._lastStaffInAccolade!!.isLastInAccolade = false
            }
            this._lastStaffInAccolade = staff
            this._lastStaffInAccolade!!.isLastInAccolade = true
            group.lastStaffInAccolade = staff
        }
    }
    
    public val height: Double
    get(){
        return this._allStaves[(this._allStaves.length - 1.0).toInt()].y + this._allStaves[(this._allStaves.length - 1.0).toInt()].height
    }
    
    /**
     */
    public fun scaleToWidth(width: Double): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = this._allStaves.length
            
            while(i < j){
                try{
                    this._allStaves[(i).toInt()].scaleToWidth(width)
                }
                finally{
                    i++
                }
            }
        }
        this.width = width
    }
    
    /**
     */
    public fun paint(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas): Unit{
        this.paintPartial(cx + this.x, cy + this.y, canvas, 0.0, this.masterBarsRenderers.length)
    }
    
    /**
     */
    public fun paintPartial(cx: Double, cy: Double, canvas: alphaTab.platform.ICanvas, startIndex: Double, count: Double): Unit{
        if(true) {
            var i: Double = 0.0
            var j: Double = this._allStaves.length
            
            while(i < j){
                try{
                    this._allStaves[(i).toInt()].paint(cx, cy, canvas, startIndex, count)
                }
                finally{
                    i++
                }
            }
        }
        var res: alphaTab.RenderingResources = this.layout.renderer.settings.display.resources
        if (this.staves.length > 0 && startIndex == 0.0)
        {
            canvas.color = res.barSeparatorColor
            if (alphaTab.core.TypeHelper.isTruthy(this._firstStaffInAccolade) && alphaTab.core.TypeHelper.isTruthy(this._lastStaffInAccolade))
            {
                var firstStart: Double = cy + this._firstStaffInAccolade!!.y + this._firstStaffInAccolade!!.staveTop + this._firstStaffInAccolade!!.topSpacing + this._firstStaffInAccolade!!.topOverflow
                var lastEnd: Double = cy + this._lastStaffInAccolade!!.y + this._lastStaffInAccolade!!.topSpacing + this._lastStaffInAccolade!!.topOverflow + this._lastStaffInAccolade!!.staveBottom
                var acooladeX: Double = cx + this._firstStaffInAccolade!!.x
                canvas.beginPath()
                canvas.moveTo(acooladeX, firstStart)
                canvas.lineTo(acooladeX, lastEnd)
                canvas.stroke()
            }
            canvas.font = res.effectFont
            if(true) {
                var i: Double = 0.0
                var j: Double = this.staves.length
                
                while(i < j){
                    try{
                        var g: alphaTab.rendering.staves.StaveTrackGroup = this.staves[(i).toInt()]
                        if (alphaTab.core.TypeHelper.isTruthy(g.firstStaffInAccolade) && alphaTab.core.TypeHelper.isTruthy(g.lastStaffInAccolade))
                        {
                            var firstStart: Double = cy + g.firstStaffInAccolade!!.y + g.firstStaffInAccolade!!.staveTop + g.firstStaffInAccolade!!.topSpacing + g.firstStaffInAccolade!!.topOverflow
                            var lastEnd: Double = cy + g.lastStaffInAccolade!!.y + g.lastStaffInAccolade!!.topSpacing + g.lastStaffInAccolade!!.topOverflow + g.lastStaffInAccolade!!.staveBottom
                            var acooladeX: Double = cx + g.firstStaffInAccolade!!.x
                            var barSize: Double = 3.0 * this.layout.renderer.settings.display.scale
                            var barOffset: Double = barSize
                            var accoladeStart: Double = firstStart - barSize * 4.0
                            var accoladeEnd: Double = lastEnd + barSize * 4.0
                            if (this.index == 0.0 && this.layout.renderer.settings.notation.isNotationElementVisible(alphaTab.NotationElement.TrackNames))
                            {
                                canvas.fillText(g.track.shortName, cx + alphaTab.rendering.staves.StaveGroup.AccoladeLabelSpacing * this.layout.scale, firstStart)
                            }
                            canvas.fillRect(acooladeX - barOffset - barSize, accoladeStart, barSize, accoladeEnd - accoladeStart)
                            var spikeStartX: Double = acooladeX - barOffset - barSize
                            var spikeEndX: Double = acooladeX + barSize * 2.0
                            canvas.beginPath()
                            canvas.moveTo(spikeStartX, accoladeStart)
                            canvas.bezierCurveTo(
                                spikeStartX
                                , 
                                accoladeStart
                                , 
                                spikeStartX
                                , 
                                accoladeStart
                                , 
                                spikeEndX
                                , 
                                accoladeStart - barSize
                            
                            )
                            canvas.bezierCurveTo(
                                acooladeX
                                , 
                                accoladeStart + barSize
                                , 
                                spikeStartX
                                , 
                                accoladeStart + barSize
                                , 
                                spikeStartX
                                , 
                                accoladeStart + barSize
                            
                            )
                            canvas.closePath()
                            canvas.fill()
                            canvas.beginPath()
                            canvas.moveTo(spikeStartX, accoladeEnd)
                            canvas.bezierCurveTo(
                                spikeStartX
                                , 
                                accoladeEnd
                                , 
                                acooladeX
                                , 
                                accoladeEnd
                                , 
                                spikeEndX
                                , 
                                accoladeEnd + barSize
                            
                            )
                            canvas.bezierCurveTo(
                                acooladeX
                                , 
                                accoladeEnd - barSize
                                , 
                                spikeStartX
                                , 
                                accoladeEnd - barSize
                                , 
                                spikeStartX
                                , 
                                accoladeEnd - barSize
                            
                            )
                            canvas.closePath()
                            canvas.fill()
                        }
                    }
                    finally{
                        i++
                    }
                }
            }
        }
    }
    
    public fun finalizeGroup(): Unit{
        var currentY: Double = 0.0
        for (staff in this._allStaves)
        {
            staff.x = this.accoladeSpacing
            staff.y = currentY
            staff.finalizeStaff()
            currentY += staff.height
        }
    }
    
    /**
     */
    public fun buildBoundingsLookup(cx: Double, cy: Double): Unit{
        if (this.layout.renderer.boundsLookup!!.isFinished)
        {
            return
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this._firstStaffInAccolade) || !alphaTab.core.TypeHelper.isTruthy(this._lastStaffInAccolade))
        {
            return
        }
        var lastStaff: alphaTab.rendering.staves.RenderStaff = this._allStaves[(this._allStaves.length - 1.0).toInt()]
        var visualTop: Double = cy + this.y + this._firstStaffInAccolade!!.y
        var visualBottom: Double = cy + this.y + this._lastStaffInAccolade!!.y + this._lastStaffInAccolade!!.height
        var realTop: Double = cy + this.y + this._allStaves[(0).toInt()].y
        var realBottom: Double = cy + this.y + lastStaff.y + lastStaff.height
        var lineTop: Double = cy + this.y + this._firstStaffInAccolade!!.y + this._firstStaffInAccolade!!.topSpacing + this._firstStaffInAccolade!!.topOverflow + (if(this._firstStaffInAccolade!!.barRenderers.length > 0)  this._firstStaffInAccolade!!.barRenderers[(0).toInt()].topPadding else 0.0)
        var lineBottom: Double = cy + this.y + lastStaff.y + lastStaff.height - lastStaff.bottomSpacing - lastStaff.bottomOverflow - (if(lastStaff.barRenderers.length > 0)  lastStaff.barRenderers[(0).toInt()].bottomPadding else 0.0)
        var visualHeight: Double = visualBottom - visualTop
        var lineHeight: Double = lineBottom - lineTop
        var realHeight: Double = realBottom - realTop
        var x: Double = this.x + this._firstStaffInAccolade!!.x
        var staveGroupBounds: alphaTab.rendering.utils.StaveGroupBounds = alphaTab.rendering.utils.StaveGroupBounds()
        staveGroupBounds.visualBounds = alphaTab.rendering.utils.Bounds()
        staveGroupBounds.visualBounds.x = cx
        staveGroupBounds.visualBounds.y = cy + this.y
        staveGroupBounds.visualBounds.w = this.width
        staveGroupBounds.visualBounds.h = this.height
        staveGroupBounds.realBounds = alphaTab.rendering.utils.Bounds()
        staveGroupBounds.realBounds.x = cx
        staveGroupBounds.realBounds.y = cy + this.y
        staveGroupBounds.realBounds.w = this.width
        staveGroupBounds.realBounds.h = this.height
        this.layout.renderer.boundsLookup!!.addStaveGroup(staveGroupBounds)
        var masterBarBoundsLookup: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.MasterBarBounds> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.MasterBarBounds>()
        if(true) {
            var i: Double = 0.0
            
            while(i < this.staves.length){
                try{
                    for (staff in this.staves[(i).toInt()].stavesRelevantForBoundsLookup)
                    {
                        for (renderer in staff.barRenderers)
                        {
                            var masterBarBounds: alphaTab.rendering.utils.MasterBarBounds
                            if (!masterBarBoundsLookup.has(renderer.bar.masterBar.index))
                            {
                                masterBarBounds = alphaTab.rendering.utils.MasterBarBounds()
                                masterBarBounds.index = renderer.bar.masterBar.index
                                masterBarBounds.isFirstOfLine = renderer.isFirstOfLine
                                masterBarBounds.realBounds = alphaTab.rendering.utils.Bounds()
                                masterBarBounds.realBounds.x = x + renderer.x
                                masterBarBounds.realBounds.y = realTop
                                masterBarBounds.realBounds.w = renderer.width
                                masterBarBounds.realBounds.h = realHeight
                                masterBarBounds.visualBounds = alphaTab.rendering.utils.Bounds()
                                masterBarBounds.visualBounds.x = x + renderer.x
                                masterBarBounds.visualBounds.y = visualTop
                                masterBarBounds.visualBounds.w = renderer.width
                                masterBarBounds.visualBounds.h = visualHeight
                                masterBarBounds.lineAlignedBounds = alphaTab.rendering.utils.Bounds()
                                masterBarBounds.lineAlignedBounds.x = x + renderer.x
                                masterBarBounds.lineAlignedBounds.y = lineTop
                                masterBarBounds.lineAlignedBounds.w = renderer.width
                                masterBarBounds.lineAlignedBounds.h = lineHeight
                                this.layout.renderer.boundsLookup!!.addMasterBar(masterBarBounds)
                                masterBarBoundsLookup.set(masterBarBounds.index, masterBarBounds)
                            }
                            else 
                            {
                                masterBarBounds = masterBarBoundsLookup.get(renderer.bar.masterBar.index)!!
                            }
                            renderer.buildBoundingsLookup(masterBarBounds, x, cy + this.y + staff.y)
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    public fun getBarX(index: Double): Double{
        if (!alphaTab.core.TypeHelper.isTruthy(this._firstStaffInAccolade) || this.layout.renderer.tracks!!.length == 0.0)
        {
            return 0.0
        }
        var bar: alphaTab.model.Bar = this.layout.renderer.tracks!![(0).toInt()].staves[(0).toInt()].bars[(index).toInt()]
        var renderer: alphaTab.rendering.BarRendererBase = this.layout.getRendererForBar(this._firstStaffInAccolade!!.staveId, bar)!!
        return renderer.x
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val AccoladeLabelSpacing: Double = 10.0
        
    }
    public constructor()
}

