// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

/**
 * This small utilty public class allows the assignment of accidentals within a
 * desired scope.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class AccidentalHelper
{
    private var _bar: alphaTab.model.Bar
    
    private var _barRenderer: alphaTab.rendering.ScoreBarRenderer
    
    private var _registeredAccidentals: alphaTab.collections.DoubleObjectMap<alphaTab.model.AccidentalType> = alphaTab.collections.DoubleObjectMap<alphaTab.model.AccidentalType>()
    
    private var _appliedScoreLines: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    private var _appliedScoreLinesByValue: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    private var _notesByValue: alphaTab.collections.DoubleObjectMap<alphaTab.model.Note> = alphaTab.collections.DoubleObjectMap<alphaTab.model.Note>()
    
    private var _beatLines: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.BeatLines> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.BeatLines>()
    
    /**
     * The beat on which the highest note of this helper was added.
     * Used together with beaming helper to calculate overflow.
     */
    public var maxLineBeat: alphaTab.model.Beat? = null
    
    /**
     * The beat on which the lowest note of this helper was added.
     * Used together with beaming helper to calculate overflow.
     */
    public var minLineBeat: alphaTab.model.Beat? = null
    
    /**
     * The line of the highest note added to this helper.
     */
    public var maxLine: Double = -1000.0
    
    /**
     * The line of the lowest note added to this helper.
     */
    public var minLine: Double = -1000.0
    
    public constructor(barRenderer: alphaTab.rendering.ScoreBarRenderer){
        this._barRenderer = barRenderer
        this._bar = barRenderer.bar
    }
    
    /**
     * Calculates the accidental for the given note and assignes the value to it.
     * The new accidental type is also registered within the current scope
     */
    public fun applyAccidental(note: alphaTab.model.Note): alphaTab.model.AccidentalType{
        var noteValue: Double = alphaTab.rendering.utils.AccidentalHelper.getNoteValue(note)
        var quarterBend: Boolean = note.hasQuarterToneOffset
        return this.getAccidental(noteValue, quarterBend, note.beat, false, note)
    }
    
    /**
     * Calculates the accidental for the given note value and assignes the value to it.
     * The new accidental type is also registered within the current scope
     * @param isHelperNote true if the note registered via this call, is a small helper note (e.g. for bends) or false if it is a main note head (e.g. for harmonics)
     */
    public fun applyAccidentalForValue(relatedBeat: alphaTab.model.Beat, noteValue: Double, quarterBend: Boolean, isHelperNote: Boolean): alphaTab.model.AccidentalType{
        return this.getAccidental(noteValue, quarterBend, relatedBeat, isHelperNote, null)
    }
    
    /**
     */
    private fun getAccidental(noteValue: Double, quarterBend: Boolean, relatedBeat: alphaTab.model.Beat, isHelperNote: Boolean, note: alphaTab.model.Note? = null): alphaTab.model.AccidentalType{
        var accidentalToSet: alphaTab.model.AccidentalType = alphaTab.model.AccidentalType.None
        var line: Double = 0.0
        if (this._bar.staff.isPercussion)
        {
            line = alphaTab.rendering.utils.AccidentalHelper.getPercussionLine(this._bar, noteValue)
        }
        else 
        {
            var accidentalMode: alphaTab.model.NoteAccidentalMode = if(alphaTab.core.TypeHelper.isTruthy(note))  note.accidentalMode else alphaTab.model.NoteAccidentalMode.Default
            line = alphaTab.rendering.utils.AccidentalHelper.calculateNoteLine(this._bar, noteValue, accidentalMode)
            var ks: Double = (this._bar.masterBar.keySignature.toDouble())
            var ksi: Double = ks + 7.0
            var index: Double = noteValue % 12.0
            var accidentalForKeySignature: alphaTab.model.AccidentalType = if(ksi < 7)  alphaTab.model.AccidentalType.Flat else alphaTab.model.AccidentalType.Sharp
            var hasKeySignatureAccidentalSetForNote: Boolean = alphaTab.rendering.utils.AccidentalHelper.KeySignatureLookup[(ksi).toInt()][(index).toInt()]
            var hasNoteAccidentalWithinOctave: Boolean = alphaTab.rendering.utils.AccidentalHelper.AccidentalNotes[(index).toInt()]
            if (quarterBend)
            {
                accidentalToSet = if(hasNoteAccidentalWithinOctave)  accidentalForKeySignature else alphaTab.model.AccidentalType.Natural
                when (accidentalToSet)
                {
                    alphaTab.model.AccidentalType.Natural -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.NaturalQuarterNoteUp
                    }
                    alphaTab.model.AccidentalType.Sharp -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.SharpQuarterNoteUp
                    }
                    alphaTab.model.AccidentalType.Flat -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.FlatQuarterNoteUp
                    }
                    else -> { }
                }
            }
            else 
            {
                when (accidentalMode)
                {
                    alphaTab.model.NoteAccidentalMode.ForceSharp -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.Sharp
                    }
                    alphaTab.model.NoteAccidentalMode.ForceDoubleSharp -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.DoubleSharp
                    }
                    alphaTab.model.NoteAccidentalMode.ForceFlat -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.Flat
                    }
                    alphaTab.model.NoteAccidentalMode.ForceDoubleFlat -> 
                    {
                        accidentalToSet = alphaTab.model.AccidentalType.DoubleFlat
                    }
                    else -> 
                    {
                        if (hasNoteAccidentalWithinOctave)
                        {
                            accidentalToSet = accidentalForKeySignature
                        }
                        else if (hasKeySignatureAccidentalSetForNote)
                        {
                            accidentalToSet = alphaTab.model.AccidentalType.Natural
                        }
                    }
                }
                var skipAccidental: Boolean = false
                if (alphaTab.core.TypeHelper.isTruthy(note) && note.isTieDestination && note.beat.index == 0.0)
                {
                    var previousRenderer: alphaTab.rendering.ScoreBarRenderer = (this._barRenderer.previousRenderer as alphaTab.rendering.ScoreBarRenderer)
                    if (alphaTab.core.TypeHelper.isTruthy(previousRenderer))
                    {
                        var tieOriginLine: Double = previousRenderer.accidentalHelper.getNoteLine(note.tieOrigin!!)
                        if (tieOriginLine == line)
                        {
                            skipAccidental = true
                        }
                    }
                }
                if (skipAccidental)
                {
                    accidentalToSet = alphaTab.model.AccidentalType.None
                }
                else 
                {
                    if (accidentalToSet != alphaTab.model.AccidentalType.None)
                    {
                        if (this._registeredAccidentals.has(line))
                        {
                            if (this._registeredAccidentals.get(line) == accidentalToSet)
                            {
                                accidentalToSet = alphaTab.model.AccidentalType.None
                            }
                        }
                        else if (hasKeySignatureAccidentalSetForNote && accidentalToSet == accidentalForKeySignature)
                        {
                            accidentalToSet = alphaTab.model.AccidentalType.None
                        }
                        if (accidentalToSet != alphaTab.model.AccidentalType.None)
                        {
                            this._registeredAccidentals.set(line, accidentalToSet)
                        }
                    }
                    else 
                    {
                        if (this._registeredAccidentals.has(line))
                        {
                            if (this._registeredAccidentals.get(line) == alphaTab.model.AccidentalType.Natural)
                            {
                                accidentalToSet = alphaTab.model.AccidentalType.None
                            }
                            else 
                            {
                                accidentalToSet = alphaTab.model.AccidentalType.Natural
                                this._registeredAccidentals.set(line, accidentalToSet)
                            }
                        }
                        else 
                        {
                            this._registeredAccidentals.delete(line)
                        }
                    }
                }
            }
        }
        if (alphaTab.core.TypeHelper.isTruthy(note))
        {
            this._appliedScoreLines.set(note.id, line)
            this._notesByValue.set(noteValue, note)
        }
        else 
        {
            this._appliedScoreLinesByValue.set(noteValue, line)
        }
        if (this.minLine == -1000.0 || this.minLine < line)
        {
            this.minLine = line
            this.minLineBeat = relatedBeat
        }
        if (this.maxLine == -1000.0 || this.maxLine > line)
        {
            this.maxLine = line
            this.maxLineBeat = relatedBeat
        }
        if (!isHelperNote)
        {
            this.registerLine(relatedBeat, line)
        }
        return accidentalToSet
    }
    
    /**
     */
    private fun registerLine(relatedBeat: alphaTab.model.Beat, line: Double): Unit{
        var lines: alphaTab.rendering.utils.BeatLines
        if (this._beatLines.has(relatedBeat.id))
        {
            lines = this._beatLines.get(relatedBeat.id)!!
        }
        else 
        {
            lines = alphaTab.rendering.utils.BeatLines()
            this._beatLines.set(relatedBeat.id, lines)
        }
        if (lines.minLine == -1000.0 || line < lines.minLine)
        {
            lines.minLine = line
        }
        if (lines.minLine == -1000.0 || line > lines.maxLine)
        {
            lines.maxLine = line
        }
    }
    
    /**
     */
    public fun getMaxLine(b: alphaTab.model.Beat): Double{
        return if(this._beatLines.has(b.id))  this._beatLines.get(b.id)!!.maxLine else 0.0
    }
    
    /**
     */
    public fun getMinLine(b: alphaTab.model.Beat): Double{
        return if(this._beatLines.has(b.id))  this._beatLines.get(b.id)!!.minLine else 0.0
    }
    
    /**
     */
    public fun getNoteLine(n: alphaTab.model.Note): Double{
        return this._appliedScoreLines.get(n.id)!!
    }
    
    /**
     */
    public fun getNoteLineForValue(rawValue: Double, searchForNote: Boolean = false): Double{
        if (this._appliedScoreLinesByValue.has(rawValue))
        {
            return this._appliedScoreLinesByValue.get(rawValue)!!
        }
        if (searchForNote && this._notesByValue.has(rawValue))
        {
            return this.getNoteLine(this._notesByValue.get(rawValue)!!)
        }
        return 0.0
    }
    
    companion object{
        /**
         * a lookup list containing an info whether the notes within an octave
         * need an accidental rendered. the accidental symbol is determined based on the type of key signature.
         */
        @kotlin.jvm.JvmStatic
        private var KeySignatureLookup: alphaTab.collections.List<alphaTab.collections.BooleanList> = alphaTab.collections.List<alphaTab.collections.BooleanList>(
            
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                true, 
                false, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                true, 
                true, 
                true, 
                true, 
                false, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                true, 
                true, 
                true, 
                true, 
                false, 
                false, 
                false, 
                true, 
                true, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                false, 
                false, 
                true, 
                true, 
                false, 
                false, 
                false, 
                true, 
                true, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                false, 
                false, 
                true, 
                true, 
                false, 
                false, 
                false, 
                false, 
                false, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                true, 
                true)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                false, 
                false, 
                false, 
                false, 
                false, 
                true, 
                true, 
                false, 
                false, 
                false, 
                false, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                false, 
                false, 
                false, 
                true, 
                true, 
                false, 
                false, 
                false, 
                false, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                false, 
                false, 
                false, 
                true, 
                true, 
                true, 
                true, 
                false, 
                false, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                false, 
                true, 
                true, 
                true, 
                true, 
                false, 
                false, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                false, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                false)
            , 
            alphaTab.collections.BooleanList(
                
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true, 
                true)
        )
        
        
        /**
         * Contains the list of notes within an octave have accidentals set.
         */
        @kotlin.jvm.JvmStatic
        private var AccidentalNotes: alphaTab.collections.BooleanList = alphaTab.collections.BooleanList(
            
            false, 
            true, 
            false, 
            true, 
            false, 
            false, 
            true, 
            false, 
            true, 
            false, 
            true, 
            false)
        
        
        /**
         * We always have 7 steps per octave.
         * (by a step the offsets inbetween score lines is meant,
         *      0 steps is on the first line (counting from top)
         *      1 steps is on the space inbetween the first and the second line
         */
        @kotlin.jvm.JvmStatic
        private val StepsPerOctave: Double = 7.0
        
        /**
         * Those are the amount of steps for the different clefs in case of a note value 0
         * [Neutral, C3, C4, F4, G2]
         */
        @kotlin.jvm.JvmStatic
        private var OctaveSteps: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            38.0, 32.0, 30.0, 26.0, 38.0)
        
        
        /**
         * The step offsets of the notes within an octave in case of for sharp keysignatures
         */
        @kotlin.jvm.JvmStatic
        private var SharpNoteSteps: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            
            0.0, 
            0.0, 
            1.0, 
            1.0, 
            2.0, 
            3.0, 
            3.0, 
            4.0, 
            4.0, 
            5.0, 
            5.0, 
            6.0)
        
        
        /**
         * The step offsets of the notes within an octave in case of for flat keysignatures
         */
        @kotlin.jvm.JvmStatic
        private var FlatNoteSteps: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            
            0.0, 
            1.0, 
            1.0, 
            2.0, 
            2.0, 
            3.0, 
            4.0, 
            4.0, 
            5.0, 
            5.0, 
            6.0, 
            6.0)
        
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getPercussionLine(bar: alphaTab.model.Bar, noteValue: Double): Double{
            if (noteValue < bar.staff.track.percussionArticulations.length)
            {
                return bar.staff.track.percussionArticulations[(noteValue).toInt()]!!.staffLine
            }
            else 
            {
                return alphaTab.model.PercussionMapper.getArticulationByValue(noteValue)?.staffLine ?: 0.0
            }
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun getNoteValue(note: alphaTab.model.Note): Double{
            if (note.isPercussion)
            {
                return note.percussionArticulation
            }
            var noteValue: Double = note.displayValue
            when (note.accidentalMode)
            {
                alphaTab.model.NoteAccidentalMode.ForceDoubleFlat -> 
                {
                    noteValue += 2.0
                }
                alphaTab.model.NoteAccidentalMode.ForceDoubleSharp -> 
                {
                    noteValue -= 2.0
                }
                alphaTab.model.NoteAccidentalMode.ForceFlat -> 
                {
                    noteValue += 1.0
                }
                alphaTab.model.NoteAccidentalMode.ForceSharp -> 
                {
                    noteValue -= 1.0
                }
                else -> { }
            }
            return noteValue
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun computeLineWithoutAccidentals(bar: alphaTab.model.Bar, note: alphaTab.model.Note): Double{
            var line: Double = 0.0
            var noteValue: Double = alphaTab.rendering.utils.AccidentalHelper.getNoteValue(note)
            if (bar.staff.isPercussion)
            {
                line = alphaTab.rendering.utils.AccidentalHelper.getPercussionLine(bar, noteValue)
            }
            else 
            {
                var accidentalMode: alphaTab.model.NoteAccidentalMode = if(alphaTab.core.TypeHelper.isTruthy(note))  note.accidentalMode else alphaTab.model.NoteAccidentalMode.Default
                line = alphaTab.rendering.utils.AccidentalHelper.calculateNoteLine(bar, noteValue, accidentalMode)
            }
            return line
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun calculateNoteLine(bar: alphaTab.model.Bar, noteValue: Double, mode: alphaTab.model.NoteAccidentalMode): Double{
            var value: Double = noteValue
            var ks: Double = (bar.masterBar.keySignature.toDouble())
            var clef: Double = bar.clef.toDouble()
            var index: Double = value % 12.0
            var octave: Double = (((value / (12.0).toDouble())).toInt() or 0) - 1.0
            var steps: Double = alphaTab.rendering.utils.AccidentalHelper.OctaveSteps[(clef).toInt()]
            steps -= octave * alphaTab.rendering.utils.AccidentalHelper.StepsPerOctave
            var stepList: alphaTab.collections.DoubleList = if(alphaTab.model.ModelUtils.keySignatureIsSharp(ks) || alphaTab.model.ModelUtils.keySignatureIsNatural(ks))  alphaTab.rendering.utils.AccidentalHelper.SharpNoteSteps else alphaTab.rendering.utils.AccidentalHelper.FlatNoteSteps
            steps -= stepList[(index).toInt()]
            return steps
        }
        
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class BeatLines
{
    public var maxLine: Double = -1000.0
    
    public var minLine: Double = -1000.0
    
    public constructor()
}

