// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BarCollisionHelper
{
    public var reservedLayoutAreasByDisplayTime: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.ReservedLayoutArea> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.ReservedLayoutArea>()
    
    public var restDurationsByDisplayTime: alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleDoubleMap> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.DoubleDoubleMap>()
    
    public fun getBeatMinMaxY(): alphaTab.collections.DoubleList{
        var minY: Double = -1000.0
        var maxY: Double = -1000.0
        for (v in this.reservedLayoutAreasByDisplayTime.values())
        {
            if (minY == -1000.0)
            {
                minY = v.topY
                maxY = v.bottomY
            }
            else 
            {
                if (minY > v.topY)
                {
                    minY = v.topY
                }
                if (maxY < v.bottomY)
                {
                    maxY = v.bottomY
                }
            }
        }
        if (minY == -1000.0)
        {
            return alphaTab.collections.DoubleList(
                0.0, 0.0)
            
        }
        return alphaTab.collections.DoubleList(
            minY, maxY)
        
    }
    
    /**
     */
    public fun reserveBeatSlot(beat: alphaTab.model.Beat, topY: Double, bottomY: Double): Unit{
        if (topY == bottomY)
        {
            return
        }
        if (!this.reservedLayoutAreasByDisplayTime.has(beat.displayStart))
        {
            this.reservedLayoutAreasByDisplayTime.set(beat.displayStart, alphaTab.rendering.utils.ReservedLayoutArea(beat))
        }
        this.reservedLayoutAreasByDisplayTime.get(beat.displayStart)!!.addSlot(topY, bottomY)
        if (beat.isRest)
        {
            this.registerRest(beat)
        }
    }
    
    /**
     */
    public fun registerRest(beat: alphaTab.model.Beat): Unit{
        if (!this.restDurationsByDisplayTime.has(beat.displayStart))
        {
            this.restDurationsByDisplayTime.set(beat.displayStart, alphaTab.collections.DoubleDoubleMap())
        }
        if (!this.restDurationsByDisplayTime.get(beat.displayStart)!!.has(beat.playbackDuration))
        {
            this.restDurationsByDisplayTime.get(beat.displayStart)!!.set(beat.playbackDuration, beat.id)
        }
    }
    
    /**
     */
    public fun applyRestCollisionOffset(beat: alphaTab.model.Beat, currentY: Double, linesToPixel: Double): Double{
        if (beat.voice.index > 0)
        {
            if (this.reservedLayoutAreasByDisplayTime.has(beat.playbackStart))
            {
                var restSizes: alphaTab.collections.DoubleList = alphaTab.rendering.utils.BeamingHelper.computeLineHeightsForRest(beat.duration).map(fun(i: Double): Double{
                    return i * linesToPixel
                }
                )
                var oldRestTopY: Double = currentY - restSizes[(0).toInt()]
                var oldRestBottomY: Double = currentY + restSizes[(1).toInt()]
                var newRestTopY: Double = oldRestTopY
                var reservedSlots: alphaTab.rendering.utils.ReservedLayoutArea = this.reservedLayoutAreasByDisplayTime.get(beat.playbackStart)!!
                var hasCollision: Boolean = false
                for (slot in reservedSlots.slots)
                {
                    if ((oldRestTopY >= slot.topY && oldRestTopY <= slot.bottomY) || (oldRestBottomY >= slot.topY && oldRestBottomY <= slot.bottomY))
                    {
                        hasCollision = true
                        break
                    }
                }
                if (hasCollision)
                {
                    if (beat.voice.index == 1.0)
                    {
                        newRestTopY = reservedSlots.topY - restSizes[(1).toInt()] - restSizes[(0).toInt()]
                    }
                    else 
                    {
                        newRestTopY = reservedSlots.bottomY
                    }
                    var newRestBottomY: Double = newRestTopY + restSizes[(0).toInt()] + restSizes[(1).toInt()]
                    var staveSpace: Double = linesToPixel * 2.0
                    var distanceInLines: Double = alphaTab.core.ecmaScript.Math.ceil(alphaTab.core.ecmaScript.Math.abs(newRestTopY - oldRestTopY) / staveSpace)
                    reservedSlots.addSlot(newRestTopY, newRestBottomY)
                    if (newRestTopY < oldRestTopY)
                    {
                        return distanceInLines * -staveSpace
                    }
                    else 
                    {
                        return distanceInLines * staveSpace
                    }
                }
            }
        }
        return 0.0
    }
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ReservedLayoutAreaSlot
{
    public var topY: Double = 0.0
    
    public var bottomY: Double = 0.0
    
    public constructor(topY: Double, bottomY: Double){
        this.topY = topY
        this.bottomY = bottomY
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class ReservedLayoutArea
{
    public var beat: alphaTab.model.Beat
    public var topY: Double = -1000.0
    
    public var bottomY: Double = -1000.0
    
    public var slots: alphaTab.collections.List<alphaTab.rendering.utils.ReservedLayoutAreaSlot> = alphaTab.collections.List<alphaTab.rendering.utils.ReservedLayoutAreaSlot>(
    )
    
    
    public constructor(beat: alphaTab.model.Beat){
        this.beat = beat
    }
    
    /**
     */
    public fun addSlot(topY: Double, bottomY: Double): Unit{
        this.slots.push(alphaTab.rendering.utils.ReservedLayoutAreaSlot(topY, bottomY))
        if (this.topY == -1000.0)
        {
            this.topY = topY
            this.bottomY = bottomY
        }
        else 
        {
            var min: Double = alphaTab.core.ecmaScript.Math.min(topY, bottomY)
            var max: Double = alphaTab.core.ecmaScript.Math.max(topY, bottomY)
            if (min < this.topY)
            {
                this.topY = min
            }
            if (max > this.bottomY)
            {
                this.bottomY = max
            }
        }
    }
    
}

