// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

/**
 * This public class helps drawing beams and bars for notes.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BeamingHelper
{
    private var _staff: alphaTab.model.Staff
    
    private var _beatLineXPositions: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.BeatLinePositions> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.BeatLinePositions>()
    
    private var _renderer: alphaTab.rendering.BarRendererBase
    
    private var _firstNonRestBeat: alphaTab.model.Beat? = null
    
    private var _lastNonRestBeat: alphaTab.model.Beat? = null
    
    public var voice: alphaTab.model.Voice? = null
    
    public var beats: alphaTab.collections.List<alphaTab.model.Beat> = alphaTab.collections.List<alphaTab.model.Beat>(
    )
    
    
    public var shortestDuration: alphaTab.model.Duration = alphaTab.model.Duration.QuadrupleWhole
    
    /**
     * the number of fingering indicators that will be drawn
     */
    public var fingeringCount: Double = 0.0
    
    /**
     * an indicator whether any beat has a tuplet on it.
     */
    public var hasTuplet: Boolean = false
    
    private var _firstBeatLowestNoteCompareValue: Double = -1.0
    
    private var _firstBeatHighestNoteCompareValue: Double = -1.0
    
    private var _lastBeatLowestNoteCompareValue: Double = -1.0
    
    private var _lastBeatHighestNoteCompareValue: Double = -1.0
    
    public var lowestNoteInHelper: alphaTab.model.Note? = null
    
    private var _lowestNoteCompareValueInHelper: Double = -1.0
    
    public var highestNoteInHelper: alphaTab.model.Note? = null
    
    private var _highestNoteCompareValueInHelper: Double = -1.0
    
    public var invertBeamDirection: Boolean = false
    
    public var preferredBeamDirection: alphaTab.rendering.utils.BeamDirection? = null
    
    public var isGrace: Boolean = false
    
    public var minRestLine: Double? = null
    
    public var beatOfMinRestLine: alphaTab.model.Beat? = null
    
    public var maxRestLine: Double? = null
    
    public var beatOfMaxRestLine: alphaTab.model.Beat? = null
    
    public val isRestBeamHelper: Boolean
    get(){
        return this.beats.length == 1.0 && this.beats[(0).toInt()].isRest
    }
    
    public val hasLine: Boolean
    get(){
        return this.beats.length == 1.0 && this.beats[(0).toInt()].duration > alphaTab.model.Duration.Whole
    }
    
    public val hasFlag: Boolean
    get(){
        return (this.beats.length == 1.0 && !this.beats[(0).toInt()].isRest && (this.beats[(0).toInt()].duration > alphaTab.model.Duration.Quarter || this.beats[(0).toInt()].graceType != alphaTab.model.GraceType.None))
    }
    
    public constructor(staff: alphaTab.model.Staff, renderer: alphaTab.rendering.BarRendererBase){
        this._staff = staff
        this._renderer = renderer
        this.beats = alphaTab.collections.List<alphaTab.model.Beat>(
        )
        
    }
    
    /**
     */
    public fun getBeatLineX(beat: alphaTab.model.Beat): Double{
        if (this.hasBeatLineX(beat))
        {
            if (this.direction == alphaTab.rendering.utils.BeamDirection.Up)
            {
                return this._beatLineXPositions.get(beat.index)!!.up
            }
            return this._beatLineXPositions.get(beat.index)!!.down
        }
        return 0.0
    }
    
    /**
     */
    public fun hasBeatLineX(beat: alphaTab.model.Beat): Boolean{
        return this._beatLineXPositions.has(beat.index)
    }
    
    /**
     */
    public fun registerBeatLineX(staffId: String, beat: alphaTab.model.Beat, up: Double, down: Double): Unit{
        var positions: alphaTab.rendering.utils.BeatLinePositions = this.getOrCreateBeatPositions(beat)
        positions.staffId = staffId
        positions.up = up
        positions.down = down
        for (v in this.drawingInfos.values())
        {
            if (v.startBeat == beat)
            {
                v.startX = this.getBeatLineX(beat)
            }
            else if (v.endBeat == beat)
            {
                v.endX = this.getBeatLineX(beat)
            }
        }
    }
    
    /**
     */
    private fun getOrCreateBeatPositions(beat: alphaTab.model.Beat): alphaTab.rendering.utils.BeatLinePositions{
        if (!this._beatLineXPositions.has(beat.index))
        {
            this._beatLineXPositions.set(beat.index, alphaTab.rendering.utils.BeatLinePositions())
        }
        return this._beatLineXPositions.get(beat.index)!!
    }
    
    public var direction: alphaTab.rendering.utils.BeamDirection = alphaTab.rendering.utils.BeamDirection.Up
    
    public fun finish(): Unit{
        this.direction = this.calculateDirection()
    }
    
    private fun calculateDirection(): alphaTab.rendering.utils.BeamDirection{
        var direction: alphaTab.rendering.utils.BeamDirection? = null
        if (!alphaTab.core.TypeHelper.isTruthy(this.voice))
        {
            direction = alphaTab.rendering.utils.BeamDirection.Up
        }
        else if (this.preferredBeamDirection != null)
        {
            direction = this.preferredBeamDirection
        }
        else if (this.voice!!.index > 0)
        {
            direction = this.invert(alphaTab.rendering.utils.BeamDirection.Down)
        }
        else if (this.voice!!.bar.isMultiVoice)
        {
            direction = this.invert(alphaTab.rendering.utils.BeamDirection.Up)
        }
        else if (this.beats[(0).toInt()].graceType != alphaTab.model.GraceType.None)
        {
            direction = this.invert(alphaTab.rendering.utils.BeamDirection.Up)
        }
        if (alphaTab.core.TypeHelper.isTruthy(this.highestNoteInHelper) && alphaTab.core.TypeHelper.isTruthy(this.lowestNoteInHelper))
        {
            var highestNotePosition: Double = this._renderer.getNoteY(this.highestNoteInHelper!!, alphaTab.rendering.NoteYPosition.Center)
            var lowestNotePosition: Double = this._renderer.getNoteY(this.lowestNoteInHelper!!, alphaTab.rendering.NoteYPosition.Center)
            if (direction == null)
            {
                var avg: Double = (highestNotePosition + lowestNotePosition) / (2.0).toDouble()
                direction = this.invert(if(this._renderer.middleYPosition < avg)  alphaTab.rendering.utils.BeamDirection.Up else alphaTab.rendering.utils.BeamDirection.Down)
            }
            this._renderer.completeBeamingHelper(this)
        }
        else 
        {
            direction = this.invert(alphaTab.rendering.utils.BeamDirection.Up)
            this._renderer.completeBeamingHelper(this)
        }
        return direction
    }
    
    /**
     * Registers a rest beat within the accidental helper so the rest
     * symbol is considered properly during beaming.
     * @param beat The rest beat.
     * @param line The line on which the rest symbol is placed
     */
    public fun applyRest(beat: alphaTab.model.Beat, line: Double): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(this._lastNonRestBeat) && beat.index >= this._lastNonRestBeat!!.index || alphaTab.core.TypeHelper.isTruthy(this._firstNonRestBeat) && beat.index <= this._firstNonRestBeat!!.index)
        {
            return
        }
        var aboveRest: Double = line
        var belowRest: Double = line
        var offsets: alphaTab.collections.DoubleList = alphaTab.rendering.utils.BeamingHelper.computeLineHeightsForRest(beat.duration)
        aboveRest -= offsets[(0).toInt()]
        belowRest += offsets[(1).toInt()]
        var minRestLine: Double? = this.minRestLine
        var maxRestLine: Double? = this.maxRestLine
        if (minRestLine == null || minRestLine > aboveRest)
        {
            this.minRestLine = aboveRest
            this.beatOfMinRestLine = beat
        }
        if (maxRestLine == null || maxRestLine < belowRest)
        {
            this.maxRestLine = belowRest
            this.beatOfMaxRestLine = beat
        }
    }
    
    /**
     */
    private fun invert(direction: alphaTab.rendering.utils.BeamDirection): alphaTab.rendering.utils.BeamDirection{
        if (!this.invertBeamDirection)
        {
            return direction
        }
        when (direction)
        {
            alphaTab.rendering.utils.BeamDirection.Down -> 
            {
                return alphaTab.rendering.utils.BeamDirection.Up
            }
            else -> 
            {
                return alphaTab.rendering.utils.BeamDirection.Down
            }
        }
    }
    
    /**
     */
    public fun checkBeat(beat: alphaTab.model.Beat): Boolean{
        if (beat.invertBeamDirection)
        {
            this.invertBeamDirection = true
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this.voice))
        {
            this.voice = beat.voice
        }
        var add: Boolean = false
        if (this.beats.length == 0.0)
        {
            add = true
        }
        else 
        {
            when (this.beats[(this.beats.length - 1.0).toInt()].beamingMode)
            {
                alphaTab.model.BeatBeamingMode.Auto -> 
                {
                    add = alphaTab.rendering.utils.BeamingHelper.canJoin(this.beats[(this.beats.length - 1.0).toInt()], beat)
                }
                alphaTab.model.BeatBeamingMode.ForceSplitToNext -> 
                {
                    add = false
                }
                alphaTab.model.BeatBeamingMode.ForceMergeWithNext -> 
                {
                    add = true
                }
                else -> { }
            }
        }
        if (add)
        {
            if (beat.preferredBeamDirection != null)
            {
                this.preferredBeamDirection = beat.preferredBeamDirection
            }
            if (!beat.isRest)
            {
                if (this.isRestBeamHelper)
                {
                    this.beats = alphaTab.collections.List<alphaTab.model.Beat>(
                    )
                    
                }
                this.beats.push(beat)
                if (beat.graceType != alphaTab.model.GraceType.None)
                {
                    this.isGrace = true
                }
                if (beat.hasTuplet)
                {
                    this.hasTuplet = true
                }
                var fingeringCount: Double = 0.0
                if(true) {
                    var n: Double = 0.0
                    
                    while(n < beat.notes.length){
                        try{
                            var note: alphaTab.model.Note = beat.notes[(n).toInt()]
                            if (note.leftHandFinger != alphaTab.model.Fingers.Unknown || note.rightHandFinger != alphaTab.model.Fingers.Unknown)
                            {
                                fingeringCount++
                            }
                        }
                        finally{
                            n++
                        }
                    }
                }
                if (fingeringCount > this.fingeringCount)
                {
                    this.fingeringCount = fingeringCount
                }
                this.checkNote(beat.minNote)
                this.checkNote(beat.maxNote)
                if (this.shortestDuration < beat.duration)
                {
                    this.shortestDuration = beat.duration
                }
                if (!alphaTab.core.TypeHelper.isTruthy(this._firstNonRestBeat))
                {
                    this._firstNonRestBeat = beat
                }
                this._lastNonRestBeat = beat
            }
            else if (this.beats.length == 0.0)
            {
                this.beats.push(beat)
            }
            if (beat.hasTuplet)
            {
                this.hasTuplet = true
            }
        }
        return add
    }
    
    /**
     */
    private fun checkNote(note: alphaTab.model.Note?): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(note))
        {
            return
        }
        var lowestValueForNote: Double
        var highestValueForNote: Double
        if (alphaTab.core.TypeHelper.isTruthy(this.voice) && note.isPercussion)
        {
            lowestValueForNote = -alphaTab.rendering.utils.AccidentalHelper.getPercussionLine(this.voice!!.bar, alphaTab.rendering.utils.AccidentalHelper.getNoteValue(note))
            highestValueForNote = lowestValueForNote
        }
        else 
        {
            lowestValueForNote = alphaTab.rendering.utils.AccidentalHelper.getNoteValue(note)
            highestValueForNote = lowestValueForNote
            if (note.harmonicType != alphaTab.model.HarmonicType.None && note.harmonicType != alphaTab.model.HarmonicType.Natural)
            {
                highestValueForNote = note.realValue - this._staff.displayTranspositionPitch
            }
        }
        if (this.beats.length == 1.0 && this.beats[(0.0).toInt()] == note.beat)
        {
            if (this._firstBeatLowestNoteCompareValue == -1.0 || lowestValueForNote < this._firstBeatLowestNoteCompareValue)
            {
                this._firstBeatLowestNoteCompareValue = lowestValueForNote
            }
            if (this._firstBeatHighestNoteCompareValue == -1.0 || highestValueForNote > this._firstBeatHighestNoteCompareValue)
            {
                this._firstBeatHighestNoteCompareValue = highestValueForNote
            }
        }
        if (this._lastBeatLowestNoteCompareValue == -1.0 || lowestValueForNote < this._lastBeatLowestNoteCompareValue)
        {
            this._lastBeatLowestNoteCompareValue = lowestValueForNote
        }
        if (this._lastBeatHighestNoteCompareValue == -1.0 || highestValueForNote > this._lastBeatHighestNoteCompareValue)
        {
            this._lastBeatHighestNoteCompareValue = highestValueForNote
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this.lowestNoteInHelper) || lowestValueForNote < this._lowestNoteCompareValueInHelper)
        {
            this.lowestNoteInHelper = note
            this._lowestNoteCompareValueInHelper = lowestValueForNote
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this.highestNoteInHelper) || highestValueForNote > this._highestNoteCompareValueInHelper)
        {
            this.highestNoteInHelper = note
            this._highestNoteCompareValueInHelper = highestValueForNote
        }
    }
    
    public val beatOfLowestNote: alphaTab.model.Beat
    get(){
        return this.lowestNoteInHelper!!.beat
    }
    
    public val beatOfHighestNote: alphaTab.model.Beat
    get(){
        return this.highestNoteInHelper!!.beat
    }
    
    /**
     * Returns whether the the position of the given beat, was registered by the staff of the given ID
     */
    public fun isPositionFrom(staffId: String, beat: alphaTab.model.Beat): Boolean{
        if (!this._beatLineXPositions.has(beat.index))
        {
            return true
        }
        return (this._beatLineXPositions.get(beat.index)!!.staffId == staffId || !alphaTab.core.TypeHelper.isTruthy(this._beatLineXPositions.get(beat.index)!!.staffId))
    }
    
    public var drawingInfos: alphaTab.collections.Map<alphaTab.rendering.utils.BeamDirection, alphaTab.rendering.utils.BeamingHelperDrawInfo> = alphaTab.collections.Map<alphaTab.rendering.utils.BeamDirection, alphaTab.rendering.utils.BeamingHelperDrawInfo>()
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun computeLineHeightsForRest(duration: alphaTab.model.Duration): alphaTab.collections.DoubleList{
            when (duration)
            {
                alphaTab.model.Duration.QuadrupleWhole -> 
                {
                    return alphaTab.collections.DoubleList(
                        2.0, 2.0)
                    
                }
                alphaTab.model.Duration.DoubleWhole -> 
                {
                    return alphaTab.collections.DoubleList(
                        2.0, 2.0)
                    
                }
                alphaTab.model.Duration.Whole -> 
                {
                    return alphaTab.collections.DoubleList(
                        0.0, 1.0)
                    
                }
                alphaTab.model.Duration.Half -> 
                {
                    return alphaTab.collections.DoubleList(
                        1.0, 0.0)
                    
                }
                alphaTab.model.Duration.Quarter -> 
                {
                    return alphaTab.collections.DoubleList(
                        3.0, 3.0)
                    
                }
                alphaTab.model.Duration.Eighth -> 
                {
                    return alphaTab.collections.DoubleList(
                        2.0, 2.0)
                    
                }
                alphaTab.model.Duration.Sixteenth -> 
                {
                    return alphaTab.collections.DoubleList(
                        2.0, 4.0)
                    
                }
                alphaTab.model.Duration.ThirtySecond -> 
                {
                    return alphaTab.collections.DoubleList(
                        4.0, 4.0)
                    
                }
                alphaTab.model.Duration.SixtyFourth -> 
                {
                    return alphaTab.collections.DoubleList(
                        4.0, 6.0)
                    
                }
                alphaTab.model.Duration.OneHundredTwentyEighth -> 
                {
                    return alphaTab.collections.DoubleList(
                        6.0, 6.0)
                    
                }
                alphaTab.model.Duration.TwoHundredFiftySixth -> 
                {
                    return alphaTab.collections.DoubleList(
                        6.0, 8.0)
                    
                }
                else -> { }
            }
            return alphaTab.collections.DoubleList(
                0.0, 0.0)
            
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun canJoin(b1: alphaTab.model.Beat, b2: alphaTab.model.Beat): Boolean{
            if (!alphaTab.core.TypeHelper.isTruthy(b1) || !alphaTab.core.TypeHelper.isTruthy(b2) || b1.graceType != b2.graceType || b1.graceType == alphaTab.model.GraceType.BendGrace || b2.graceType == alphaTab.model.GraceType.BendGrace)
            {
                return false
            }
            if (b1.graceType != alphaTab.model.GraceType.None && b2.graceType != alphaTab.model.GraceType.None)
            {
                return true
            }
            var m1: alphaTab.model.Bar = b1.voice.bar
            var m2: alphaTab.model.Bar = b2.voice.bar
            if (m1 != m2)
            {
                return false
            }
            var start1: Double = b1.playbackStart
            var start2: Double = b2.playbackStart
            if (!alphaTab.rendering.utils.BeamingHelper.canJoinDuration(b1.duration) || !alphaTab.rendering.utils.BeamingHelper.canJoinDuration(b2.duration))
            {
                return start1 == start2
            }
            if (b1.tupletGroup != b2.tupletGroup)
            {
                return false
            }
            if (b1.hasTuplet && b2.hasTuplet)
            {
                if (b1.tupletGroup == b2.tupletGroup && b1.tupletGroup!!.isFull)
                {
                    return true
                }
            }
            var divisionLength: Double = alphaTab.midi.MidiUtils.QuarterTime
            when (m1.masterBar.timeSignatureDenominator)
            {
                8.0 -> 
                {
                    if (m1.masterBar.timeSignatureNumerator % 3.0 == 0.0)
                    {
                        divisionLength += ((alphaTab.midi.MidiUtils.QuarterTime / (2.0).toDouble())).toInt() or 0
                    }
                }
                else -> { }
            }
            var division1: Double = ((((divisionLength + start1) / divisionLength)).toInt() or 0 or 0).toDouble()
            var division2: Double = ((((divisionLength + start2) / divisionLength)).toInt() or 0 or 0).toDouble()
            return division1 == division2
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun canJoinDuration(d: alphaTab.model.Duration): Boolean{
            when (d)
            {
                alphaTab.model.Duration.Whole, alphaTab.model.Duration.Half, alphaTab.model.Duration.Quarter -> 
                {
                    return false
                }
                else -> 
                {
                    return true
                }
            }
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun isFullBarJoin(a: alphaTab.model.Beat, b: alphaTab.model.Beat, barIndex: Double): Boolean{
            return alphaTab.model.ModelUtils.getIndex(a.duration) - 2.0 - barIndex > 0 && alphaTab.model.ModelUtils.getIndex(b.duration) - 2.0 - barIndex > 0
        }
        
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BeamingHelperDrawInfo
{
    public var startBeat: alphaTab.model.Beat? = null
    
    public var startX: Double = 0.0
    
    public var startY: Double = 0.0
    
    public var endBeat: alphaTab.model.Beat? = null
    
    public var endX: Double = 0.0
    
    public var endY: Double = 0.0
    
    /**
     * calculates the Y-position given a X-pos using the current start end point
     */
    public fun calcY(x: Double): Double{
        if (this.startX == this.endX)
        {
            return this.startY
        }
        return ((this.endY - this.startY) / (this.endX - this.startX)) * (x - this.startX) + this.startY
    }
    
    public constructor()
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class BeatLinePositions
{
    public var staffId: String = ""
    
    public var up: Double = 0.0
    
    public var down: Double = 0.0
    
    public constructor()
}

