// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class BoundsLookup
{
    private var _beatLookup: alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>> = alphaTab.collections.DoubleObjectMap<alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>>()
    
    private var _masterBarLookup: alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.MasterBarBounds> = alphaTab.collections.DoubleObjectMap<alphaTab.rendering.utils.MasterBarBounds>()
    
    private var _currentStaveGroup: alphaTab.rendering.utils.StaveGroupBounds? = null
    
    /**
     * Gets a list of all individual stave groups contained in the rendered music notation.
     */
    public var staveGroups: alphaTab.collections.List<alphaTab.rendering.utils.StaveGroupBounds> = alphaTab.collections.List<alphaTab.rendering.utils.StaveGroupBounds>(
    )
    
    
    /**
     * Gets or sets a value indicating whether this lookup was finished already.
     */
    public var isFinished: Boolean = false
    
    /**
     * Finishes the lookup for optimized access.
     */
    public fun finish(): Unit{
        for (t in this.staveGroups)
        {
            t.finish()
        }
        this.isFinished = true
    }
    
    /**
     * Adds a new stave group to the lookup.
     * @param bounds The stave group bounds to add.
     */
    public fun addStaveGroup(bounds: alphaTab.rendering.utils.StaveGroupBounds): Unit{
        bounds.index = this.staveGroups.length
        bounds.boundsLookup = this
        this.staveGroups.push(bounds)
        this._currentStaveGroup = bounds
    }
    
    /**
     * Adds a new master bar to the lookup.
     * @param bounds The master bar bounds to add.
     */
    public fun addMasterBar(bounds: alphaTab.rendering.utils.MasterBarBounds): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(bounds.staveGroupBounds))
        {
            bounds.staveGroupBounds = this._currentStaveGroup!!
            this._masterBarLookup.set(bounds.index, bounds)
            this._currentStaveGroup!!.addBar(bounds)
        }
        else 
        {
            this._masterBarLookup.set(bounds.index, bounds)
        }
    }
    
    /**
     * Adds a new beat to the lookup.
     * @param bounds The beat bounds to add.
     */
    public fun addBeat(bounds: alphaTab.rendering.utils.BeatBounds): Unit{
        if (!this._beatLookup.has(bounds.beat.id))
        {
            this._beatLookup.set(bounds.beat.id, alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>(
            )
            )
        }
        this._beatLookup.get(bounds.beat.id)?.push(bounds)
    }
    
    /**
     * Tries to find the master bar bounds by a given index.
     * @param index The index of the master bar to find.
     */
    public fun findMasterBarByIndex(index: Double): alphaTab.rendering.utils.MasterBarBounds?{
        if (this._masterBarLookup.has(index))
        {
            return this._masterBarLookup.get(index)!!
        }
        return null
    }
    
    /**
     * Tries to find the master bar bounds by a given master bar.
     * @param bar The master bar to find.
     */
    public fun findMasterBar(bar: alphaTab.model.MasterBar): alphaTab.rendering.utils.MasterBarBounds?{
        var id: Double = bar.index
        if (this._masterBarLookup.has(id))
        {
            return this._masterBarLookup.get(id)!!
        }
        return null
    }
    
    /**
     * Tries to find the bounds of a given beat.
     * @param beat The beat to find.
     */
    public fun findBeat(beat: alphaTab.model.Beat): alphaTab.rendering.utils.BeatBounds?{
        var all: alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>? = this.findBeats(beat)
        return if(alphaTab.core.TypeHelper.isTruthy(all))  all[(0).toInt()] else null
    }
    
    /**
     * Tries to find the bounds of a given beat.
     * @param beat The beat to find.
     */
    public fun findBeats(beat: alphaTab.model.Beat): alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>?{
        var id: Double = beat.id
        if (this._beatLookup.has(id))
        {
            return this._beatLookup.get(id)!!
        }
        return null
    }
    
    /**
     * Tries to find a beat at the given absolute position.
     * @param x The absolute X-position of the beat to find.
     * @param y The absolute Y-position of the beat to find.
     */
    public fun getBeatAtPos(x: Double, y: Double): alphaTab.model.Beat?{
        var bottom: Double = 0.0
        var top: Double = this.staveGroups.length - 1.0
        var staveGroupIndex: Double = -1.0
        while (bottom <= top)
        {
            var middle: Double = ((((top + bottom) / (2.0).toDouble())).toInt() or 0).toDouble()
            var group: alphaTab.rendering.utils.StaveGroupBounds = this.staveGroups[(middle).toInt()]
            if (y >= group.realBounds.y && y <= group.realBounds.y + group.realBounds.h)
            {
                staveGroupIndex = middle
                break
            }
            if (y < group.realBounds.y)
            {
                top = middle - 1.0
            }
            else 
            {
                bottom = middle + 1.0
            }
        }
        if (staveGroupIndex == -1.0)
        {
            return null
        }
        var staveGroup: alphaTab.rendering.utils.StaveGroupBounds = this.staveGroups[(staveGroupIndex).toInt()]
        var bar: alphaTab.rendering.utils.MasterBarBounds? = staveGroup.findBarAtPos(x)
        if (alphaTab.core.TypeHelper.isTruthy(bar))
        {
            return bar.findBeatAtPos(x, y)
        }
        return null
    }
    
    /**
     * Tries to find the note at the given position using the given beat for fast access.
     * Use  to find a beat for a given position first.
     * @param beat The beat containing the note.
     * @param x The X-position of the note.
     * @param y The Y-position of the note.
     */
    public fun getNoteAtPos(beat: alphaTab.model.Beat, x: Double, y: Double): alphaTab.model.Note?{
        var beatBounds: alphaTab.collections.List<alphaTab.rendering.utils.BeatBounds>? = this.findBeats(beat)
        if (alphaTab.core.TypeHelper.isTruthy(beatBounds))
        {
            for (b in beatBounds)
            {
                var note: alphaTab.model.Note? = b.findNoteAtPos(x, y)
                if (alphaTab.core.TypeHelper.isTruthy(note))
                {
                    return note
                }
            }
        }
        return null
    }
    
    public constructor()
}

