// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

/**
 * Represents the boundaries of a list of bars related to a single master bar.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class MasterBarBounds
{
    /**
     * Gets or sets the index of this bounds relative within the parent lookup.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets a value indicating whether this bounds are the first of the line.
     */
    public var isFirstOfLine: Boolean = false
    
    /**
     * Gets or sets the bounds covering all visually visible elements spanning all bars of this master bar.
     */
    public lateinit var visualBounds: alphaTab.rendering.utils.Bounds
    /**
     * Gets or sets the actual bounds of the elements in this master bar including whitespace areas.
     */
    public lateinit var realBounds: alphaTab.rendering.utils.Bounds
    /**
     * Gets or sets the actual bounds which are exactly aligned with the lines of the staffs.
     */
    public lateinit var lineAlignedBounds: alphaTab.rendering.utils.Bounds
    /**
     * Gets or sets the list of individual bars within this lookup.
     */
    public var bars: alphaTab.collections.List<alphaTab.rendering.utils.BarBounds> = alphaTab.collections.List<alphaTab.rendering.utils.BarBounds>(
    )
    
    
    /**
     * Gets or sets a reference to the parent .
     */
    public var staveGroupBounds: alphaTab.rendering.utils.StaveGroupBounds? = null
    
    /**
     * Adds a new bar to this lookup.
     * @param bounds The bar bounds to add to this lookup.
     */
    public fun addBar(bounds: alphaTab.rendering.utils.BarBounds): Unit{
        bounds.masterBarBounds = this
        this.bars.push(bounds)
    }
    
    /**
     * Tries to find a beat at the given location.
     * @param x The absolute X position where the beat spans across.
     * @param y The absolute Y position where the beat spans across.
     */
    public fun findBeatAtPos(x: Double, y: Double): alphaTab.model.Beat?{
        var beat: alphaTab.rendering.utils.BeatBounds? = null
        var distance: Double = 10000000.0
        for (bar in this.bars)
        {
            var b: alphaTab.rendering.utils.BeatBounds? = bar.findBeatAtPos(x)
            if (alphaTab.core.TypeHelper.isTruthy(b) && (!alphaTab.core.TypeHelper.isTruthy(beat) || beat.realBounds.x < b.realBounds.x))
            {
                var newDistance: Double = alphaTab.core.ecmaScript.Math.abs(b.realBounds.x - x)
                if (!alphaTab.core.TypeHelper.isTruthy(beat) || newDistance < distance)
                {
                    beat = b
                }
            }
        }
        return if(!alphaTab.core.TypeHelper.isTruthy(beat))  null else beat.beat
    }
    
    /**
     * Finishes the lookup object and optimizes itself for fast access.
     */
    public fun finish(): Unit{
        this.bars.sort(fun(a: alphaTab.rendering.utils.BarBounds, b: alphaTab.rendering.utils.BarBounds): Double{
            if (a.realBounds.y < b.realBounds.y)
            {
                return -1.0
            }
            if (a.realBounds.y > b.realBounds.y)
            {
                return 1.0
            }
            if (a.realBounds.x < b.realBounds.x)
            {
                return -1.0
            }
            if (a.realBounds.x > b.realBounds.x)
            {
                return 1.0
            }
            return 0.0
        }
        )
        for (bar in this.bars)
        {
            bar.finish()
        }
    }
    
    /**
     * Adds a new beat to the lookup.
     * @param bounds The beat bounds to add.
     */
    public fun addBeat(bounds: alphaTab.rendering.utils.BeatBounds): Unit{
        this.staveGroupBounds!!.boundsLookup.addBeat(bounds)
    }
    
    public constructor()
}

