// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.rendering.utils
import alphaTab.core.*

/**
 * Represents the bounds of a stave group.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class StaveGroupBounds
{
    /**
     * Gets or sets the index of the bounds within the parent lookup.
     * This allows fast access of the next/previous groups.
     */
    public var index: Double = 0.0
    
    /**
     * Gets or sets the bounds covering all visually visible elements of this stave group.
     */
    public lateinit var visualBounds: alphaTab.rendering.utils.Bounds
    /**
     * Gets or sets the actual bounds of the elements in this stave group including whitespace areas.
     */
    public lateinit var realBounds: alphaTab.rendering.utils.Bounds
    /**
     * Gets or sets the list of master bar bounds related to this stave group.
     */
    public var bars: alphaTab.collections.List<alphaTab.rendering.utils.MasterBarBounds> = alphaTab.collections.List<alphaTab.rendering.utils.MasterBarBounds>(
    )
    
    
    /**
     * Gets or sets a reference to the parent bounds lookup.
     */
    public lateinit var boundsLookup: alphaTab.rendering.utils.BoundsLookup
    /**
     * Finished the lookup for optimized access.
     */
    public fun finish(): Unit{
        for (t in this.bars)
        {
            t.finish()
        }
    }
    
    /**
     * Adds a new master bar to this lookup.
     * @param bounds The master bar bounds to add.
     */
    public fun addBar(bounds: alphaTab.rendering.utils.MasterBarBounds): Unit{
        this.boundsLookup.addMasterBar(bounds)
        bounds.staveGroupBounds = this
        this.bars.push(bounds)
    }
    
    /**
     * Tries to find the master bar bounds that are located at the given X-position.
     * @param x The X-position to find a master bar.
     */
    public fun findBarAtPos(x: Double): alphaTab.rendering.utils.MasterBarBounds?{
        var b: alphaTab.rendering.utils.MasterBarBounds? = null
        for (bar in this.bars)
        {
            if (!alphaTab.core.TypeHelper.isTruthy(b) || bar.realBounds.x < x)
            {
                b = bar
            }
            else if (x > bar.realBounds.x + bar.realBounds.w)
            {
                break
            }
        }
        return b
    }
    
    public constructor()
}

