// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth
import alphaTab.core.*

/**
 * This is the main synthesizer component which can be used to
 * play a  via a .
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class AlphaSynth: alphaTab.synth.IAlphaSynth
{
    private var _sequencer: alphaTab.synth.MidiFileSequencer
    
    private var _synthesizer: alphaTab.synth.synthesis.TinySoundFont
    
    private var _isSoundFontLoaded: Boolean = false
    
    private var _isMidiLoaded: Boolean = false
    
    private var _tickPosition: Double = 0.0
    
    private var _timePosition: Double = 0.0
    
    private var _metronomeVolume: Double = 0.0
    
    private var _countInVolume: Double = 0.0
    
    private var _playedEventsQueue: alphaTab.synth.ds.Queue<alphaTab.synth.synthesis.SynthEvent> = alphaTab.synth.ds.Queue<alphaTab.synth.synthesis.SynthEvent>()
    
    private var _midiEventsPlayedFilter: alphaTab.core.ecmaScript.Set<alphaTab.midi.MidiEventType> = alphaTab.core.ecmaScript.Set<alphaTab.midi.MidiEventType>()
    
    private var _notPlayedSamples: Double = 0.0
    
    /**
     * Gets the  used for playing the generated samples.
     */
    public var output: alphaTab.synth.ISynthOutput
    /**
     * Gets or sets whether the synthesizer is ready for interaction. (output and worker are initialized)
     */
    public override var isReady: Boolean = false
    
    public override val isReadyForPlayback: Boolean
    get(){
        return this.isReady && this._isSoundFontLoaded && this._isMidiLoaded
    }
    
    /**
     * Gets the current player state.
     */
    public override var state: alphaTab.synth.PlayerState = alphaTab.synth.PlayerState.Paused
    
    public override var logLevel: alphaTab.LogLevel
    get(){
        return alphaTab.Logger.logLevel
    }
    set(value){
        alphaTab.Logger.logLevel = value
    }
    
    public override var masterVolume: Double
    get(){
        return this._synthesizer.masterVolume
    }
    set(value){
        var paramvalue = value
        paramvalue = alphaTab.core.ecmaScript.Math.max(paramvalue, alphaTab.synth.SynthConstants.MinVolume)
        this._synthesizer.masterVolume = paramvalue
    }
    
    public override var metronomeVolume: Double
    get(){
        return this._metronomeVolume
    }
    set(value){
        var paramvalue = value
        paramvalue = alphaTab.core.ecmaScript.Math.max(paramvalue, alphaTab.synth.SynthConstants.MinVolume)
        this._metronomeVolume = paramvalue
        this._synthesizer.metronomeVolume = paramvalue
    }
    
    public override var countInVolume: Double
    get(){
        return this._countInVolume
    }
    set(value){
        var paramvalue = value
        paramvalue = alphaTab.core.ecmaScript.Math.max(paramvalue, alphaTab.synth.SynthConstants.MinVolume)
        this._countInVolume = paramvalue
    }
    
    public override var midiEventsPlayedFilter: alphaTab.collections.List<alphaTab.midi.MidiEventType>
    get(){
        return alphaTab.core.ecmaScript.Array.from(this._midiEventsPlayedFilter)
    }
    set(value){
        this._midiEventsPlayedFilter = alphaTab.core.ecmaScript.Set<alphaTab.midi.MidiEventType>(((value as alphaTab.core.ecmaScript.Iterable<alphaTab.midi.MidiEventType>?)))
    }
    
    public override var playbackSpeed: Double
    get(){
        return this._sequencer.playbackSpeed
    }
    set(value){
        var paramvalue = value
        paramvalue = alphaTab.synth.SynthHelper.clamp(paramvalue, alphaTab.synth.SynthConstants.MinPlaybackSpeed, alphaTab.synth.SynthConstants.MaxPlaybackSpeed)
        var oldSpeed: Double = this._sequencer.playbackSpeed
        this._sequencer.playbackSpeed = paramvalue
        this.timePosition = this.timePosition * (oldSpeed / paramvalue)
    }
    
    public override var tickPosition: Double
    get(){
        return this._tickPosition
    }
    set(value){
        this.timePosition = this._sequencer.mainTickPositionToTimePosition(value)
    }
    
    public override var timePosition: Double
    get(){
        return this._timePosition
    }
    set(value){
        alphaTab.Logger.debug("AlphaSynth", """Seeking to position ${(value).toTemplate()}ms (main)""")
        this._sequencer.mainSeek(value)
        this.updateTimePosition(value, true)
        if (this._sequencer.isPlayingMain)
        {
            this._notPlayedSamples = 0.0
            this.output.resetSamples()
        }
    }
    
    public override var playbackRange: alphaTab.synth.PlaybackRange?
    get(){
        return this._sequencer.mainPlaybackRange
    }
    set(value){
        this._sequencer.mainPlaybackRange = value
        if (alphaTab.core.TypeHelper.isTruthy(value))
        {
            this.tickPosition = value.startTick
        }
        ((this.playbackRangeChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs>)).trigger(alphaTab.synth.PlaybackRangeChangedEventArgs(value))
    }
    
    public override var isLooping: Boolean
    get(){
        return this._sequencer.isLooping
    }
    set(value){
        this._sequencer.isLooping = value
    }
    
    /**
     * Destroys the synthesizer and all related components
     */
    public override fun destroy(): Unit{
        alphaTab.Logger.debug("AlphaSynth", "Destroying player")
        this.stop()
        this.output.destroy()
    }
    
    public constructor(output: alphaTab.synth.ISynthOutput, bufferTimeInMilliseconds: Double){
        alphaTab.Logger.debug("AlphaSynth", "Initializing player")
        this.state = alphaTab.synth.PlayerState.Paused
        alphaTab.Logger.debug("AlphaSynth", "Creating output")
        this.output = output
        alphaTab.Logger.debug("AlphaSynth", "Creating synthesizer")
        this._synthesizer = alphaTab.synth.synthesis.TinySoundFont(this.output.sampleRate)
        this._sequencer = alphaTab.synth.MidiFileSequencer(this._synthesizer)
        alphaTab.Logger.debug("AlphaSynth", "Opening output")
        this.output.ready.on(fun(): Unit{
            this.isReady = true
            ((this.ready as alphaTab.EventEmitter)).trigger()
            this.checkReadyForPlayback()
        }
        )
        this.output.sampleRequest.on(fun(): Unit{
            if (this.state == alphaTab.synth.PlayerState.Playing && !this._sequencer.isFinished)
            {
                var samples: alphaTab.core.ecmaScript.Float32Array = alphaTab.core.ecmaScript.Float32Array(alphaTab.synth.SynthConstants.MicroBufferSize * alphaTab.synth.SynthConstants.MicroBufferCount * alphaTab.synth.SynthConstants.AudioChannels)
                var bufferPos: Double = 0.0
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < alphaTab.synth.SynthConstants.MicroBufferCount){
                        try{
                            this._sequencer.fillMidiEventQueue()
                            var synthesizedEvents: alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent> = this._synthesizer.synthesize(samples, bufferPos, alphaTab.synth.SynthConstants.MicroBufferSize)
                            bufferPos += alphaTab.synth.SynthConstants.MicroBufferSize * alphaTab.synth.SynthConstants.AudioChannels
                            for (e in synthesizedEvents)
                            {
                                if (this._midiEventsPlayedFilter.has(e.event.type))
                                {
                                    this._playedEventsQueue.enqueue(e)
                                }
                            }
                            if (this._sequencer.isFinished)
                            {
                                break
                            }
                        }
                        finally{
                            i++
                        }
                    }
                }
                if (bufferPos < samples.length)
                {
                    samples = samples.subarray(0.0, bufferPos)
                }
                this._notPlayedSamples += samples.length
                this.output.addSamples(samples)
            }
            else 
            {
                var samples: alphaTab.core.ecmaScript.Float32Array = alphaTab.core.ecmaScript.Float32Array(0.0)
                this.output.addSamples(samples)
            }
        }
        )
        this.output.samplesPlayed.on(this::onSamplesPlayed)
        this.output.`open`(bufferTimeInMilliseconds)
    }
    
    /**
     * Starts the playback if possible
     */
    public override fun play(): Boolean{
        if (this.state != alphaTab.synth.PlayerState.Paused || !this._isMidiLoaded)
        {
            return false
        }
        this.output.activate()
        this.playInternal()
        if (this._countInVolume > 0)
        {
            alphaTab.Logger.debug("AlphaSynth", "Starting countin")
            this._sequencer.startCountIn()
            this._synthesizer.setupMetronomeChannel(this._countInVolume)
            this.updateTimePosition(0.0, true)
        }
        this.output.play()
        return true
    }
    
    private fun playInternal(): Unit{
        if (this._sequencer.isPlayingOneTimeMidi)
        {
            alphaTab.Logger.debug("AlphaSynth", "Cancelling one time midi")
            this.stopOneTimeMidi()
        }
        alphaTab.Logger.debug("AlphaSynth", "Starting playback")
        this._synthesizer.setupMetronomeChannel(this.metronomeVolume)
        this.state = alphaTab.synth.PlayerState.Playing
        ((this.stateChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>)).trigger(alphaTab.synth.PlayerStateChangedEventArgs(this.state, false))
    }
    
    /**
     * Pauses the playback if was running
     */
    public override fun pause(): Unit{
        if (this.state == alphaTab.synth.PlayerState.Paused || !this._isMidiLoaded)
        {
            return
        }
        alphaTab.Logger.debug("AlphaSynth", "Pausing playback")
        this.state = alphaTab.synth.PlayerState.Paused
        ((this.stateChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>)).trigger(alphaTab.synth.PlayerStateChangedEventArgs(this.state, false))
        this.output.pause()
        this._synthesizer.noteOffAll(false)
    }
    
    /**
     * Starts the playback if possible, pauses the playback if was running
     */
    public override fun playPause(): Unit{
        if (this.state != alphaTab.synth.PlayerState.Paused || !this._isMidiLoaded)
        {
            this.pause()
        }
        else 
        {
            this.play()
        }
    }
    
    /**
     * Stopps the playback
     */
    public override fun stop(): Unit{
        if (!this._isMidiLoaded)
        {
            return
        }
        alphaTab.Logger.debug("AlphaSynth", "Stopping playback")
        this.state = alphaTab.synth.PlayerState.Paused
        this.output.pause()
        this._notPlayedSamples = 0.0
        this._sequencer.stop()
        this._synthesizer.noteOffAll(true)
        this.tickPosition = if(alphaTab.core.TypeHelper.isTruthy(this._sequencer.mainPlaybackRange))  this._sequencer.mainPlaybackRange!!.startTick else 0.0
        ((this.stateChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>)).trigger(alphaTab.synth.PlayerStateChangedEventArgs(this.state, true))
    }
    
    /**
     * Stops any ongoing playback and plays the given midi file instead.
     */
    public override fun playOneTimeMidiFile(midi: alphaTab.midi.MidiFile): Unit{
        if (this._sequencer.isPlayingOneTimeMidi)
        {
            this.stopOneTimeMidi()
        }
        else 
        {
            this.pause()
        }
        this._sequencer.loadOneTimeMidi(midi)
        this._synthesizer.noteOffAll(true)
        this.updateTimePosition(0.0, true)
        this._notPlayedSamples = 0.0
        this.output.resetSamples()
        this.output.play()
    }
    
    /**
     * Resets all loaded soundfonts as if they were not loaded.
     */
    public override fun resetSoundFonts(): Unit{
        this.stop()
        this._synthesizer.resetPresets()
        this._isSoundFontLoaded = false
        ((this.soundFontLoaded as alphaTab.EventEmitter)).trigger()
    }
    
    /**
     * Loads a soundfont from the given data
     */
    public override fun loadSoundFont(`data`: alphaTab.core.ecmaScript.Uint8Array, append: Boolean): Unit{
        this.pause()
        var input: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.fromBuffer(`data`)
        try
        {
            alphaTab.Logger.debug("AlphaSynth", "Loading soundfont from bytes")
            var soundFont: alphaTab.synth.soundfont.Hydra = alphaTab.synth.soundfont.Hydra()
            soundFont.load(input)
            this._synthesizer.loadPresets(soundFont, append)
            this._isSoundFontLoaded = true
            ((this.soundFontLoaded as alphaTab.EventEmitter)).trigger()
            alphaTab.Logger.debug("AlphaSynth", "soundFont successfully loaded")
            this.checkReadyForPlayback()
        }
        catch (e: kotlin.Throwable)
        {
            alphaTab.Logger.error("AlphaSynth", "Could not load soundfont from bytes " + e)
            ((this.soundFontLoadFailed as alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>)).trigger((e as alphaTab.core.ecmaScript.Error))
        }
    }
    
    private fun checkReadyForPlayback(): Unit{
        if (this.isReadyForPlayback)
        {
            this._synthesizer.setupMetronomeChannel(this.metronomeVolume)
            ((this.readyForPlayback as alphaTab.EventEmitter)).trigger()
        }
    }
    
    /**
     * Loads the given midi file for playback.
     * @param midi The midi file to load
     */
    public override fun loadMidiFile(midi: alphaTab.midi.MidiFile): Unit{
        this.stop()
        try
        {
            alphaTab.Logger.debug("AlphaSynth", "Loading midi from model")
            this._sequencer.loadMidi(midi)
            this._isMidiLoaded = true
            ((this.midiLoaded as alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>)).trigger(alphaTab.synth.PositionChangedEventArgs(0.0, this._sequencer.currentEndTime, 0.0, this._sequencer.currentEndTick, false))
            alphaTab.Logger.debug("AlphaSynth", "Midi successfully loaded")
            this.checkReadyForPlayback()
            this.tickPosition = 0.0
        }
        catch (e: kotlin.Throwable)
        {
            alphaTab.Logger.error("AlphaSynth", "Could not load midi from model " + e)
            ((this.midiLoadFailed as alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>)).trigger((e as alphaTab.core.ecmaScript.Error))
        }
    }
    
    /**
     * Applies the given transposition pitches to be used during playback.
     */
    public override fun applyTranspositionPitches(transpositionPitches: alphaTab.collections.DoubleDoubleMap): Unit{
        this._synthesizer.applyTranspositionPitches(transpositionPitches)
    }
    
    /**
     * Sets the mute state of a channel.
     */
    public override fun setChannelMute(channel: Double, mute: Boolean): Unit{
        this._synthesizer.channelSetMute(channel, mute)
    }
    
    /**
     * Resets the mute/solo state of all channels
     */
    public override fun resetChannelStates(): Unit{
        this._synthesizer.resetChannelStates()
    }
    
    /**
     * Gets the solo state of a channel.
     */
    public override fun setChannelSolo(channel: Double, solo: Boolean): Unit{
        this._synthesizer.channelSetSolo(channel, solo)
    }
    
    /**
     * Gets or sets the current and initial volume of the given channel.
     */
    public override fun setChannelVolume(channel: Double, volume: Double): Unit{
        var paramvolume = volume
        paramvolume = alphaTab.core.ecmaScript.Math.max(paramvolume, alphaTab.synth.SynthConstants.MinVolume)
        this._synthesizer.channelSetMixVolume(channel, paramvolume)
    }
    
    /**
     */
    private fun onSamplesPlayed(sampleCount: Double): Unit{
        if (sampleCount == 0.0)
        {
            return
        }
        var playedMillis: Double = (sampleCount / this._synthesizer.outSampleRate) * 1000.0
        this._notPlayedSamples -= sampleCount * alphaTab.synth.SynthConstants.AudioChannels
        this.updateTimePosition(this._timePosition + playedMillis, false)
        this.checkForFinish()
    }
    
    private fun checkForFinish(): Unit{
        var startTick: Double = 0.0
        var endTick: Double = 0.0
        if (alphaTab.core.TypeHelper.isTruthy(this.playbackRange) && this._sequencer.isPlayingMain)
        {
            startTick = this.playbackRange!!.startTick
            endTick = this.playbackRange!!.endTick
        }
        else 
        {
            endTick = this._sequencer.currentEndTick
        }
        if (this._tickPosition >= endTick && this._notPlayedSamples <= 0)
        {
            this._notPlayedSamples = 0.0
            if (this._sequencer.isPlayingCountIn)
            {
                alphaTab.Logger.debug("AlphaSynth", "Finished playback (count-in)")
                this._sequencer.resetCountIn()
                this.timePosition = this._sequencer.currentTime
                this.playInternal()
                this.output.resetSamples()
            }
            else if (this._sequencer.isPlayingOneTimeMidi)
            {
                alphaTab.Logger.debug("AlphaSynth", "Finished playback (one time)")
                this.output.resetSamples()
                this.state = alphaTab.synth.PlayerState.Paused
                this.stopOneTimeMidi()
            }
            else 
            {
                alphaTab.Logger.debug("AlphaSynth", "Finished playback (main)")
                ((this.finished as alphaTab.EventEmitter)).trigger()
                if (this.isLooping)
                {
                    this.tickPosition = startTick
                }
                else 
                {
                    this.stop()
                }
            }
        }
    }
    
    private fun stopOneTimeMidi(): Unit{
        this.output.pause()
        this._synthesizer.noteOffAll(true)
        this._sequencer.resetOneTimeMidi()
        this.timePosition = this._sequencer.currentTime
    }
    
    /**
     */
    private fun updateTimePosition(timePosition: Double, isSeek: Boolean): Unit{
        var currentTime: Double = timePosition
        this._timePosition = currentTime
        var currentTick: Double = this._sequencer.currentTimePositionToTickPosition(currentTime)
        this._tickPosition = currentTick
        var endTime: Double = this._sequencer.currentEndTime
        var endTick: Double = this._sequencer.currentEndTick
        var mode: String = if(this._sequencer.isPlayingMain)  "main" else if(this._sequencer.isPlayingCountIn)  "count-in" else "one-time"
        alphaTab.Logger.debug("AlphaSynth", """Position changed: (time: ${(currentTime).toTemplate()}/${(endTime).toTemplate()}, tick: ${(currentTick).toTemplate()}/${(endTick).toTemplate()}, Active Voices: ${(this._synthesizer.activeVoiceCount).toTemplate()} (${(mode).toTemplate()})""")
        if (this._sequencer.isPlayingMain)
        {
            ((this.positionChanged as alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>)).trigger(alphaTab.synth.PositionChangedEventArgs(currentTime, endTime, currentTick, endTick, isSeek))
        }
        if (isSeek)
        {
            this._playedEventsQueue.clear()
        }
        else 
        {
            var playedEvents: alphaTab.synth.ds.Queue<alphaTab.midi.MidiEvent> = alphaTab.synth.ds.Queue<alphaTab.midi.MidiEvent>()
            while (!this._playedEventsQueue.isEmpty && this._playedEventsQueue.peek().time < currentTime)
            {
                var synthEvent: alphaTab.synth.synthesis.SynthEvent = this._playedEventsQueue.dequeue()
                playedEvents.enqueue(synthEvent.event)
            }
            if (!playedEvents.isEmpty)
            {
                ((this.midiEventsPlayed as alphaTab.EventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs>)).trigger(alphaTab.synth.MidiEventsPlayedEventArgs(playedEvents.toArray()))
            }
        }
    }
    
    /**
     * This event is fired when the player is ready to be interacted with.
     */
    public override var ready: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    /**
     * This event is fired when all required data for playback is loaded and ready.
     */
    public override var readyForPlayback: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    /**
     * This event is fired when the playback of the whole song finished.
     */
    public override var finished: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    /**
     * This event is fired when the SoundFont needed for playback was loaded.
     */
    public override var soundFontLoaded: alphaTab.IEventEmitter = alphaTab.EventEmitter()
    
    /**
     * This event is fired when the loading of the SoundFont failed.
     */
    public override var soundFontLoadFailed: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error> = alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>()
    
    /**
     * This event is fired when the Midi file needed for playback was loaded.
     */
    public override var midiLoaded: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>()
    
    /**
     * This event is fired when the loading of the Midi file failed.
     */
    public override var midiLoadFailed: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error> = alphaTab.EventEmitterOfT<alphaTab.core.ecmaScript.Error>()
    
    /**
     * This event is fired when the playback state changed.
     */
    public override var stateChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>()
    
    /**
     * This event is fired when the current playback position of/ the song changed.
     */
    public override var positionChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>()
    
    /**
     * The event is fired when certain midi events were sent to the audio output device for playback.
     */
    public override var midiEventsPlayed: alphaTab.IEventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs>()
    
    /**
     * The event is fired when the playback range within the player was updated.
     */
    public override var playbackRangeChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs> = alphaTab.EventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs>()
    
}

