// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth
import alphaTab.core.*

/**
 * The public API interface for interacting with the synthesizer.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public interface IAlphaSynth
{
    /**
     * Gets or sets whether the synthesizer is ready for interaction. (output and worker are initialized)
     */
    val isReady: Boolean
    /**
     * Gets or sets whether the synthesizer is ready for playback. (output, worker are initialized, soundfont and midi are loaded)
     */
    val isReadyForPlayback: Boolean
    /**
     * Gets the current player state.
     */
    val state: alphaTab.synth.PlayerState
    /**
     * Gets or sets the loging level.
     */
    var logLevel: alphaTab.LogLevel
    /**
     * Gets or sets the current master volume as percentage. (range: 0.0-3.0, default 1.0)
     */
    var masterVolume: Double
    /**
     * Gets or sets the metronome volume. (range: 0.0-3.0, default 0.0)
     */
    var metronomeVolume: Double
    /**
     * Gets or sets the current playback speed as percentage. (range: 0.125-8.0, default: 1.0)
     */
    var playbackSpeed: Double
    /**
     * Gets or sets the position within the song in midi ticks.
     */
    var tickPosition: Double
    /**
     * Gets or sets the position within the song in milliseconds.
     */
    var timePosition: Double
    /**
     * Gets or sets the range of the song that should be played. Set this to null
     * to play the whole song.
     */
    var playbackRange: alphaTab.synth.PlaybackRange?
    /**
     * Gets or sets whether the playback should automatically restart after it finished.
     */
    var isLooping: Boolean
    /**
     * Gets or sets volume of the metronome during count-in. (range: 0.0-3.0, default 0.0 - no count in)
     */
    var countInVolume: Double
    /**
     * Gets or sets the midi events which will trigger the `midiEventsPlayed` event.
     */
    var midiEventsPlayedFilter: alphaTab.collections.List<alphaTab.midi.MidiEventType>
    /**
     * Destroys the synthesizer and all related components
     */
    fun destroy(): Unit
    
    /**
     * Starts the playback if possible
     */
    fun play(): Boolean
    
    /**
     * Pauses the playback if was running
     */
    fun pause(): Unit
    
    /**
     * Starts the playback if possible, pauses the playback if was running
     */
    fun playPause(): Unit
    
    /**
     * Stopps the playback
     */
    fun stop(): Unit
    
    /**
     * Stops any ongoing playback and plays the given midi file instead.
     * @param midi The midi file to play
     */
    fun playOneTimeMidiFile(midi: alphaTab.midi.MidiFile): Unit
    
    /**
     * Loads a soundfont from the given data
     * @param `data` a byte array to load the data from
     * @param append Whether to fully replace or append the data from the given soundfont.
     */
    fun loadSoundFont(`data`: alphaTab.core.ecmaScript.Uint8Array, append: Boolean): Unit
    
    /**
     * Resets all loaded soundfonts as if they were not loaded.
     */
    fun resetSoundFonts(): Unit
    
    /**
     * Loads the given midi file structure.
     */
    fun loadMidiFile(midi: alphaTab.midi.MidiFile): Unit
    
    /**
     * Applies the given transposition pitches to be used during playback.
     * @param transpositionPitches a map defining the transposition pitches for midi channel.
     */
    fun applyTranspositionPitches(transpositionPitches: alphaTab.collections.DoubleDoubleMap): Unit
    
    /**
     * Sets the mute state of a channel.
     * @param channel The channel number
     * @param mute true if the channel should be muted, otherwise false.
     */
    fun setChannelMute(channel: Double, mute: Boolean): Unit
    
    /**
     * Resets the mute/solo state of all channels
     */
    fun resetChannelStates(): Unit
    
    /**
     * Gets the solo state of a channel.
     * @param channel The channel number
     * @param solo true if the channel should be played solo, otherwise false.
     */
    fun setChannelSolo(channel: Double, solo: Boolean): Unit
    
    /**
     * Gets or sets the current and initial volume of the given channel.
     * @param channel The channel number.
     * @param volume The volume of of the channel (0.0-1.0)
     */
    fun setChannelVolume(channel: Double, volume: Double): Unit
    
    /**
     * This event is fired when the player is ready to be interacted with.
     */
    val ready: alphaTab.IEventEmitter
    /**
     * This event is fired when all required data for playback is loaded and ready.
     */
    val readyForPlayback: alphaTab.IEventEmitter
    /**
     * This event is fired when the playback of the whole song finished.
     */
    val finished: alphaTab.IEventEmitter
    /**
     * This event is fired when the SoundFont needed for playback was loaded.
     */
    val soundFontLoaded: alphaTab.IEventEmitter
    /**
     * This event is fired when the loading of the SoundFont failed.
     */
    val soundFontLoadFailed: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error>
    /**
     * This event is fired when the Midi file needed for playback was loaded.
     */
    val midiLoaded: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>
    /**
     * This event is fired when the loading of the Midi file failed.
     */
    val midiLoadFailed: alphaTab.IEventEmitterOfT<alphaTab.core.ecmaScript.Error>
    /**
     * This event is fired when the playback state changed.
     */
    val stateChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlayerStateChangedEventArgs>
    /**
     * This event is fired when the current playback position of/ the song changed.
     */
    val positionChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PositionChangedEventArgs>
    /**
     * The event is fired when certain midi events were sent to the audio output device for playback.
     */
    val midiEventsPlayed: alphaTab.IEventEmitterOfT<alphaTab.synth.MidiEventsPlayedEventArgs>
    /**
     * The event is fired when the playback range within the player was updated.
     */
    val playbackRangeChanged: alphaTab.IEventEmitterOfT<alphaTab.synth.PlaybackRangeChangedEventArgs>
}

