// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth
import alphaTab.core.*

/**
 * This sequencer dispatches midi events to the synthesizer based on the current
 * synthesize position. The sequencer does not consider the playback speed.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiFileSequencer
{
    private var _synthesizer: alphaTab.synth.synthesis.TinySoundFont
    
    private var _currentState: alphaTab.synth.MidiSequencerState
    
    private var _mainState: alphaTab.synth.MidiSequencerState
    
    private var _oneTimeState: alphaTab.synth.MidiSequencerState? = null
    
    private var _countInState: alphaTab.synth.MidiSequencerState? = null
    
    public val isPlayingMain: Boolean
    get(){
        return this._currentState == this._mainState
    }
    
    public val isPlayingOneTimeMidi: Boolean
    get(){
        return this._currentState == this._oneTimeState
    }
    
    public val isPlayingCountIn: Boolean
    get(){
        return this._currentState == this._countInState
    }
    
    public constructor(synthesizer: alphaTab.synth.synthesis.TinySoundFont){
        this._synthesizer = synthesizer
        this._mainState = alphaTab.synth.MidiSequencerState()
        this._currentState = this._mainState
    }
    
    public var mainPlaybackRange: alphaTab.synth.PlaybackRange?
    get(){
        return this._mainState.playbackRange
    }
    set(value){
        this._mainState.playbackRange = value
        if (alphaTab.core.TypeHelper.isTruthy(value))
        {
            this._mainState.playbackRangeStartTime = this.tickPositionToTimePositionWithSpeed(this._mainState, value.startTick, 1.0)
            this._mainState.playbackRangeEndTime = this.tickPositionToTimePositionWithSpeed(this._mainState, value.endTick, 1.0)
        }
    }
    
    public var isLooping: Boolean = false
    
    public val currentTime: Double
    get(){
        return this._currentState.currentTime / this.playbackSpeed
    }
    
    public val currentEndTick: Double
    get(){
        return this._currentState.endTick
    }
    
    public val currentEndTime: Double
    get(){
        return this._currentState.endTime / this.playbackSpeed
    }
    
    /**
     * Gets or sets the playback speed.
     */
    public var playbackSpeed: Double = 1.0
    
    /**
     */
    public fun mainSeek(timePosition: Double): Unit{
        var paramtimePosition = timePosition
        paramtimePosition *= this.playbackSpeed
        if (alphaTab.core.TypeHelper.isTruthy(this.mainPlaybackRange))
        {
            if (paramtimePosition < this._mainState.playbackRangeStartTime)
            {
                paramtimePosition = this._mainState.playbackRangeStartTime
            }
            else if (paramtimePosition > this._mainState.playbackRangeEndTime)
            {
                paramtimePosition = this._mainState.playbackRangeEndTime
            }
        }
        if (paramtimePosition > this._mainState.currentTime)
        {
            this.mainSilentProcess(paramtimePosition - this._mainState.currentTime)
        }
        else if (paramtimePosition < this._mainState.currentTime)
        {
            this._mainState.currentTime = 0.0
            this._mainState.eventIndex = 0.0
            if (this.isPlayingMain)
            {
                var metronomeVolume: Double = this._synthesizer.metronomeVolume
                this._synthesizer.noteOffAll(true)
                this._synthesizer.resetSoft()
                this._synthesizer.setupMetronomeChannel(metronomeVolume)
            }
            this.mainSilentProcess(paramtimePosition)
        }
    }
    
    /**
     */
    private fun mainSilentProcess(milliseconds: Double): Unit{
        if (milliseconds <= 0)
        {
            return
        }
        var start: Double = alphaTab.core.ecmaScript.Date.now()
        var finalTime: Double = this._mainState.currentTime + milliseconds
        if (this.isPlayingMain)
        {
            while (this._mainState.currentTime < finalTime)
            {
                if (this.fillMidiEventQueueLimited(finalTime - this._mainState.currentTime))
                {
                    this._synthesizer.synthesizeSilent(alphaTab.synth.SynthConstants.MicroBufferSize)
                }
            }
        }
        this._mainState.currentTime = finalTime
        var duration: Double = alphaTab.core.ecmaScript.Date.now() - start
        alphaTab.Logger.debug("Sequencer", "Silent seek finished in " + (duration).toInvariantString() + "ms (main)")
    }
    
    /**
     */
    public fun loadOneTimeMidi(midiFile: alphaTab.midi.MidiFile): Unit{
        this._oneTimeState = this.createStateFromFile(midiFile)
        this._currentState = this._oneTimeState!!
    }
    
    /**
     */
    public fun loadMidi(midiFile: alphaTab.midi.MidiFile): Unit{
        this._mainState = this.createStateFromFile(midiFile)
        this._currentState = this._mainState
    }
    
    /**
     */
    public fun createStateFromFile(midiFile: alphaTab.midi.MidiFile): alphaTab.synth.MidiSequencerState{
        var state: alphaTab.synth.MidiSequencerState = alphaTab.synth.MidiSequencerState()
        state.tempoChanges = alphaTab.collections.List<alphaTab.synth.MidiFileSequencerTempoChange>(
        )
        
        state.division = midiFile.division
        state.eventIndex = 0.0
        state.currentTime = 0.0
        state.synthData = alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent>(
        )
        
        var bpm: Double = 120.0
        var absTick: Double = 0.0
        var absTime: Double = 0.0
        var metronomeCount: Double = 0.0
        var metronomeLengthInTicks: Double = 0.0
        var metronomeLengthInMillis: Double = 0.0
        var metronomeTick: Double = 0.0
        var metronomeTime: Double = 0.0
        var previousTick: Double = 0.0
        for (mEvent in midiFile.events)
        {
            var synthData: alphaTab.synth.synthesis.SynthEvent = alphaTab.synth.synthesis.SynthEvent(state.synthData.length, mEvent)
            state.synthData.push(synthData)
            var deltaTick: Double = mEvent.tick - previousTick
            absTick += deltaTick
            absTime += deltaTick * ((60000.0).toDouble() / (bpm * midiFile.division))
            synthData.time = absTime
            previousTick = mEvent.tick
            if (metronomeLengthInTicks > 0)
            {
                while (metronomeTick < absTick)
                {
                    var metronome: alphaTab.synth.synthesis.SynthEvent = alphaTab.synth.synthesis.SynthEvent.newMetronomeEvent(state.synthData.length, metronomeTick, alphaTab.core.ecmaScript.Math.floor(metronomeTick / metronomeLengthInTicks) % metronomeCount, metronomeLengthInTicks, metronomeLengthInMillis)
                    state.synthData.push(metronome)
                    metronome.time = metronomeTime
                    metronomeTick += metronomeLengthInTicks
                    metronomeTime += metronomeLengthInMillis
                }
            }
            if (mEvent.type == alphaTab.midi.MidiEventType.TempoChange)
            {
                var meta: alphaTab.midi.TempoChangeEvent = (mEvent as alphaTab.midi.TempoChangeEvent)
                bpm = (60000000.0).toDouble() / meta.microSecondsPerQuarterNote
                state.tempoChanges.push(alphaTab.synth.MidiFileSequencerTempoChange(bpm, absTick, absTime))
                metronomeLengthInMillis = metronomeLengthInTicks * ((60000.0).toDouble() / (bpm * midiFile.division))
            }
            else if (mEvent.type == alphaTab.midi.MidiEventType.TimeSignature)
            {
                var meta: alphaTab.midi.TimeSignatureEvent = (mEvent as alphaTab.midi.TimeSignatureEvent)
                var timeSignatureDenominator: Double = alphaTab.core.ecmaScript.Math.pow(2.0, meta.denominatorIndex)
                metronomeCount = meta.numerator
                metronomeLengthInTicks = (((state.division * ((4.0).toDouble() / timeSignatureDenominator))).toInt() or 0).toDouble()
                metronomeLengthInMillis = metronomeLengthInTicks * ((60000.0).toDouble() / (bpm * midiFile.division))
                if (state.firstTimeSignatureDenominator == 0.0)
                {
                    state.firstTimeSignatureNumerator = meta.numerator
                    state.firstTimeSignatureDenominator = timeSignatureDenominator
                }
            }
            else if (mEvent.type == alphaTab.midi.MidiEventType.ProgramChange)
            {
                var channel: Double = ((mEvent as alphaTab.midi.ProgramChangeEvent)).channel
                if (!state.firstProgramEventPerChannel.has(channel))
                {
                    state.firstProgramEventPerChannel.set(channel, synthData)
                }
            }
        }
        state.synthData.sort(fun(a: alphaTab.synth.synthesis.SynthEvent, b: alphaTab.synth.synthesis.SynthEvent): Double{
            if (a.time > b.time)
            {
                return 1.0
            }
            if (a.time < b.time)
            {
                return -1.0
            }
            return a.eventIndex - b.eventIndex
        }
        )
        state.endTime = absTime
        state.endTick = absTick
        return state
    }
    
    public fun fillMidiEventQueue(): Boolean{
        return this.fillMidiEventQueueLimited(-1.0)
    }
    
    /**
     */
    private fun fillMidiEventQueueLimited(maxMilliseconds: Double): Boolean{
        var millisecondsPerBuffer: Double = (alphaTab.synth.SynthConstants.MicroBufferSize / this._synthesizer.outSampleRate) * 1000.0 * this.playbackSpeed
        var endTime: Double = this.internalEndTime
        if (maxMilliseconds > 0)
        {
            if (maxMilliseconds < millisecondsPerBuffer)
            {
                millisecondsPerBuffer = maxMilliseconds
            }
            endTime = alphaTab.core.ecmaScript.Math.min(this.internalEndTime, this._currentState.currentTime + maxMilliseconds)
        }
        var anyEventsDispatched: Boolean = false
        this._currentState.currentTime += millisecondsPerBuffer
        while (this._currentState.eventIndex < this._currentState.synthData.length && this._currentState.synthData[(this._currentState.eventIndex).toInt()].time < this._currentState.currentTime && this._currentState.currentTime < endTime)
        {
            this._synthesizer.dispatchEvent(this._currentState.synthData[(this._currentState.eventIndex).toInt()])
            this._currentState.eventIndex++
            anyEventsDispatched = true
        }
        return anyEventsDispatched
    }
    
    /**
     */
    public fun mainTickPositionToTimePosition(tickPosition: Double): Double{
        return this.tickPositionToTimePositionWithSpeed(this._mainState, tickPosition, this.playbackSpeed)
    }
    
    /**
     */
    public fun mainTimePositionToTickPosition(timePosition: Double): Double{
        return this.timePositionToTickPositionWithSpeed(this._mainState, timePosition, this.playbackSpeed)
    }
    
    /**
     */
    public fun currentTimePositionToTickPosition(timePosition: Double): Double{
        return this.timePositionToTickPositionWithSpeed(this._currentState, timePosition, this.playbackSpeed)
    }
    
    /**
     */
    private fun tickPositionToTimePositionWithSpeed(state: alphaTab.synth.MidiSequencerState, tickPosition: Double, playbackSpeed: Double): Double{
        var paramtickPosition = tickPosition
        var timePosition: Double = 0.0
        var bpm: Double = 120.0
        var lastChange: Double = 0.0
        for (c in state.tempoChanges)
        {
            if (paramtickPosition < c.ticks)
            {
                break
            }
            timePosition = c.time
            bpm = c.bpm
            lastChange = c.ticks
        }
        paramtickPosition -= lastChange
        timePosition += paramtickPosition * ((60000.0).toDouble() / (bpm * state.division))
        return timePosition / playbackSpeed
    }
    
    /**
     */
    private fun timePositionToTickPositionWithSpeed(state: alphaTab.synth.MidiSequencerState, timePosition: Double, playbackSpeed: Double): Double{
        var paramtimePosition = timePosition
        paramtimePosition *= playbackSpeed
        var ticks: Double = 0.0
        var bpm: Double = 120.0
        var lastChange: Double = 0.0
        for (c in state.tempoChanges)
        {
            if (paramtimePosition < c.time)
            {
                break
            }
            ticks = c.ticks
            bpm = c.bpm
            lastChange = c.time
        }
        paramtimePosition -= lastChange
        ticks += ((paramtimePosition / ((60000.0).toDouble() / (bpm * state.division)))).toInt() or 0
        return ticks + 1.0
    }
    
    private val internalEndTime: Double
    get(){
        if (this.isPlayingMain)
        {
            return if(!alphaTab.core.TypeHelper.isTruthy(this.mainPlaybackRange))  this._currentState.endTime else this._currentState.playbackRangeEndTime
        }
        else 
        {
            return this._currentState.endTime
        }
    }
    
    public val isFinished: Boolean
    get(){
        return this._currentState.currentTime >= this.internalEndTime
    }
    
    public fun stop(): Unit{
        if (this.isPlayingMain && alphaTab.core.TypeHelper.isTruthy(this.mainPlaybackRange))
        {
            this._currentState.currentTime = this.mainPlaybackRange!!.startTick
        }
        else 
        {
            this._currentState.currentTime = 0.0
        }
        this._currentState.eventIndex = 0.0
    }
    
    public fun resetOneTimeMidi(): Unit{
        this._oneTimeState = null
        this._currentState = this._mainState
    }
    
    public fun resetCountIn(): Unit{
        this._countInState = null
        this._currentState = this._mainState
    }
    
    public fun startCountIn(): Unit{
        this.generateCountInMidi()
        this._currentState = this._countInState!!
        this.stop()
        this._synthesizer.noteOffAll(true)
    }
    
    public fun generateCountInMidi(): Unit{
        var state: alphaTab.synth.MidiSequencerState = alphaTab.synth.MidiSequencerState()
        state.division = this._mainState.division
        var bpm: Double = 120.0
        var timeSignatureNumerator: Double = 4.0
        var timeSignatureDenominator: Double = 4.0
        if (this._mainState.eventIndex == 0.0)
        {
            bpm = this._mainState.tempoChanges[(0).toInt()].bpm
            timeSignatureNumerator = this._mainState.firstTimeSignatureNumerator
            timeSignatureDenominator = this._mainState.firstTimeSignatureDenominator
        }
        else 
        {
            bpm = this._synthesizer.currentTempo
            timeSignatureNumerator = this._synthesizer.timeSignatureNumerator
            timeSignatureDenominator = this._synthesizer.timeSignatureDenominator
        }
        state.tempoChanges.push(alphaTab.synth.MidiFileSequencerTempoChange(bpm, 0.0, 0.0))
        var metronomeLengthInTicks: Double = (((state.division * ((4.0).toDouble() / timeSignatureDenominator))).toInt() or 0).toDouble()
        var metronomeLengthInMillis: Double = metronomeLengthInTicks * ((60000.0).toDouble() / (bpm * this._mainState.division))
        var metronomeTick: Double = 0.0
        var metronomeTime: Double = 0.0
        if(true) {
            var i: Double = 0.0
            
            while(i < timeSignatureNumerator){
                try{
                    var metronome: alphaTab.synth.synthesis.SynthEvent = alphaTab.synth.synthesis.SynthEvent.newMetronomeEvent(state.synthData.length, metronomeTick, i, metronomeLengthInTicks, metronomeLengthInMillis)
                    state.synthData.push(metronome)
                    metronome.time = metronomeTime
                    metronomeTick += metronomeLengthInTicks
                    metronomeTime += metronomeLengthInMillis
                }
                finally{
                    i++
                }
            }
        }
        state.synthData.sort(fun(a: alphaTab.synth.synthesis.SynthEvent, b: alphaTab.synth.synthesis.SynthEvent): Double{
            if (a.time > b.time)
            {
                return 1.0
            }
            if (a.time < b.time)
            {
                return -1.0
            }
            return a.eventIndex - b.eventIndex
        }
        )
        state.endTime = metronomeTime
        state.endTick = metronomeTick
        this._countInState = state
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiFileSequencerTempoChange
{
    public var bpm: Double
    public var ticks: Double
    public var time: Double
    public constructor(bpm: Double, ticks: Double, time: Double){
        this.bpm = bpm
        this.ticks = ticks
        this.time = time
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class MidiSequencerState
{
    public var tempoChanges: alphaTab.collections.List<alphaTab.synth.MidiFileSequencerTempoChange> = alphaTab.collections.List<alphaTab.synth.MidiFileSequencerTempoChange>(
    )
    
    
    public var firstProgramEventPerChannel: alphaTab.collections.DoubleObjectMap<alphaTab.synth.synthesis.SynthEvent> = alphaTab.collections.DoubleObjectMap<alphaTab.synth.synthesis.SynthEvent>()
    
    public var firstTimeSignatureNumerator: Double = 0.0
    
    public var firstTimeSignatureDenominator: Double = 0.0
    
    public var synthData: alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent> = alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent>(
    )
    
    
    public var division: Double = alphaTab.midi.MidiUtils.QuarterTime
    
    public var eventIndex: Double = 0.0
    
    public var currentTime: Double = 0.0
    
    public var playbackRange: alphaTab.synth.PlaybackRange? = null
    
    public var playbackRangeStartTime: Double = 0.0
    
    public var playbackRangeEndTime: Double = 0.0
    
    public var endTick: Double = 0.0
    
    public var endTime: Double = 0.0
    
    public constructor()
}

