// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth.ds
import alphaTab.core.*

/**
 * Represents a fixed size circular sample buffer that can be written to and read from.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
public class CircularSampleBuffer
{
    private var _buffer: alphaTab.core.ecmaScript.Float32Array
    
    private var _writePosition: Double = 0.0
    
    private var _readPosition: Double = 0.0
    
    /**
     * Gets the number of samples written to the buffer.
     */
    public var count: Double = 0.0
    
    public constructor(size: Double){
        this._buffer = alphaTab.core.ecmaScript.Float32Array(size)
    }
    
    /**
     * Clears all samples written to this buffer.
     */
    public fun clear(): Unit{
        this._readPosition = 0.0
        this._writePosition = 0.0
        this.count = 0.0
        this._buffer = alphaTab.core.ecmaScript.Float32Array(this._buffer.length)
    }
    
    /**
     * Writes the given samples to this buffer.
     * @param `data` The sample array to read from.
     */
    public fun write(`data`: alphaTab.core.ecmaScript.Float32Array, offset: Double, count: Double): Double{
        var paramcount = count
        var samplesWritten: Double = 0.0
        if (paramcount > this._buffer.length - this.count)
        {
            paramcount = this._buffer.length - this.count
        }
        var writeToEnd: Double = alphaTab.core.ecmaScript.Math.min(this._buffer.length - this._writePosition, paramcount)
        this._buffer.set(`data`.subarray(offset, offset + writeToEnd), this._writePosition)
        this._writePosition += writeToEnd
        this._writePosition %= this._buffer.length
        samplesWritten += writeToEnd
        if (samplesWritten < paramcount)
        {
            this._buffer.set(`data`.subarray(offset + samplesWritten, offset + samplesWritten + paramcount - samplesWritten), this._writePosition)
            this._writePosition += paramcount - samplesWritten
            samplesWritten = paramcount
        }
        this.count += samplesWritten
        return samplesWritten
    }
    
    /**
     * Reads the requested amount of samples from the buffer.
     * @param `data` The sample array to store the read elements.
     * @param offset The offset within the destination buffer to put the items at.
     * @param count The number of items to read from this buffer.
     */
    public fun read(`data`: alphaTab.core.ecmaScript.Float32Array, offset: Double, count: Double): Double{
        var paramcount = count
        if (paramcount > this.count)
        {
            paramcount = this.count
        }
        var samplesRead: Double = 0.0
        var readToEnd: Double = alphaTab.core.ecmaScript.Math.min(this._buffer.length - this._readPosition, paramcount)
        `data`.set(this._buffer.subarray(this._readPosition, this._readPosition + readToEnd), offset)
        samplesRead += readToEnd
        this._readPosition += readToEnd
        this._readPosition %= this._buffer.length
        if (samplesRead < paramcount)
        {
            `data`.set(this._buffer.subarray(this._readPosition, this._readPosition + paramcount - samplesRead), offset + samplesRead)
            this._readPosition += paramcount - samplesRead
            samplesRead = paramcount
        }
        this.count -= samplesRead
        return samplesRead
    }
    
}

