// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth.synthesis
import alphaTab.core.*

/**
 * This is a tiny soundfont based synthesizer.
 * NOT YET IMPLEMENTED
 *   - Support for ChorusEffectsSend and ReverbEffectsSend generators
 *   - Better low-pass filter without lowering performance too much
 *   - Support for modulators
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class TinySoundFont
{
    private var _midiEventQueue: alphaTab.synth.ds.Queue<alphaTab.synth.synthesis.SynthEvent> = alphaTab.synth.ds.Queue<alphaTab.synth.synthesis.SynthEvent>()
    
    private var _mutedChannels: alphaTab.collections.DoubleBooleanMap = alphaTab.collections.DoubleBooleanMap()
    
    private var _soloChannels: alphaTab.collections.DoubleBooleanMap = alphaTab.collections.DoubleBooleanMap()
    
    private var _isAnySolo: Boolean = false
    
    private var _transpositionPitches: alphaTab.collections.DoubleDoubleMap = alphaTab.collections.DoubleDoubleMap()
    
    public var currentTempo: Double = 0.0
    
    public var timeSignatureNumerator: Double = 0.0
    
    public var timeSignatureDenominator: Double = 0.0
    
    public constructor(sampleRate: Double){
        this.outSampleRate = sampleRate
    }
    
    /**
     */
    public fun synthesize(buffer: alphaTab.core.ecmaScript.Float32Array, bufferPos: Double, sampleCount: Double): alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent>{
        return this.fillWorkingBuffer(buffer, bufferPos, sampleCount)
    }
    
    /**
     */
    public fun synthesizeSilent(sampleCount: Double): Unit{
        this.fillWorkingBuffer(null, 0.0, sampleCount)
    }
    
    /**
     */
    public fun channelGetMixVolume(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].mixVolume else 1.0
    }
    
    /**
     */
    public fun channelSetMixVolume(channel: Double, volume: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        for (v in this._voices)
        {
            if (v.playingChannel == channel && v.playingPreset != -1.0)
            {
                v.mixVolume = volume
            }
        }
        c.mixVolume = volume
    }
    
    /**
     */
    public fun channelSetMute(channel: Double, mute: Boolean): Unit{
        if (mute)
        {
            this._mutedChannels.set(channel, true)
        }
        else 
        {
            this._mutedChannels.delete(channel)
        }
    }
    
    /**
     */
    public fun channelSetSolo(channel: Double, solo: Boolean): Unit{
        if (solo)
        {
            this._soloChannels.set(channel, true)
        }
        else 
        {
            this._soloChannels.delete(channel)
        }
        this._isAnySolo = this._soloChannels.size > 0
    }
    
    public fun resetChannelStates(): Unit{
        this._mutedChannels = alphaTab.collections.DoubleBooleanMap()
        this._soloChannels = alphaTab.collections.DoubleBooleanMap()
        this.applyTranspositionPitches(alphaTab.collections.DoubleDoubleMap())
        this._isAnySolo = false
    }
    
    /**
     */
    public fun applyTranspositionPitches(transpositionPitches: alphaTab.collections.DoubleDoubleMap): Unit{
        var previousTransposePitches: alphaTab.collections.DoubleDoubleMap = this._transpositionPitches
        for (voice in this._voices)
        {
            if (voice.playingChannel >= 0 && voice.playingChannel != 9.0)
            {
                var pitchDifference: Double = 0.0
                if (previousTransposePitches.has(voice.playingChannel))
                {
                    pitchDifference -= previousTransposePitches.get(voice.playingChannel)!!
                }
                if (transpositionPitches.has(voice.playingChannel))
                {
                    pitchDifference += transpositionPitches.get(voice.playingChannel)!!
                }
                voice.playingKey += pitchDifference
                if (alphaTab.core.TypeHelper.isTruthy(this._channels))
                {
                    voice.updatePitchRatio(this._channels!!.channelList[(voice.playingChannel).toInt()], this.outSampleRate)
                }
            }
        }
        this._transpositionPitches = transpositionPitches
    }
    
    /**
     */
    public fun dispatchEvent(synthEvent: alphaTab.synth.synthesis.SynthEvent): Unit{
        this._midiEventQueue.enqueue(synthEvent)
    }
    
    /**
     */
    private fun fillWorkingBuffer(buffer: alphaTab.core.ecmaScript.Float32Array?, bufferPos: Double, sampleCount: Double): alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent>{
        var anySolo: Boolean = this._isAnySolo
        var processedEvents: alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent> = alphaTab.collections.List<alphaTab.synth.synthesis.SynthEvent>(
        )
        
        while (!this._midiEventQueue.isEmpty)
        {
            var m: alphaTab.synth.synthesis.SynthEvent = this._midiEventQueue.dequeue()
            if (m.isMetronome && this.metronomeVolume > 0)
            {
                this.channelNoteOff(alphaTab.synth.SynthConstants.MetronomeChannel, 33.0)
                this.channelNoteOn(alphaTab.synth.SynthConstants.MetronomeChannel, 33.0, (95.0).toDouble() / (127.0).toDouble())
            }
            else if (alphaTab.core.TypeHelper.isTruthy(m.event))
            {
                this.processMidiMessage(m.event)
            }
            processedEvents.push(m)
        }
        for (voice in this._voices)
        {
            if (voice.playingPreset != -1.0)
            {
                var channel: Double = voice.playingChannel
                var isChannelMuted: Boolean = this._mutedChannels.has(channel) || (anySolo && channel != alphaTab.synth.SynthConstants.MetronomeChannel && !this._soloChannels.has(channel))
                if (!alphaTab.core.TypeHelper.isTruthy(buffer))
                {
                    voice.kill()
                }
                else 
                {
                    voice.render(this, buffer, bufferPos, sampleCount, isChannelMuted)
                }
            }
        }
        return processedEvents
    }
    
    /**
     */
    private fun processMidiMessage(e: alphaTab.midi.MidiEvent): Unit{
        alphaTab.Logger.debug("MIdi", "Processing Midi message " + e.type.toString() + "/" + (e.tick).toInvariantString())
        var command: alphaTab.midi.MidiEventType = e.type
        when (command)
        {
            alphaTab.midi.MidiEventType.TimeSignature -> 
            {
                var timeSignature: alphaTab.midi.TimeSignatureEvent = ((e as alphaTab.midi.TimeSignatureEvent))
                this.timeSignatureNumerator = timeSignature.numerator
                this.timeSignatureDenominator = alphaTab.core.ecmaScript.Math.pow(2.0, timeSignature.denominatorIndex)
            }
            alphaTab.midi.MidiEventType.NoteOn -> 
            {
                var noteOn: alphaTab.midi.NoteOnEvent = (e as alphaTab.midi.NoteOnEvent)
                this.channelNoteOn(noteOn.channel, noteOn.noteKey, noteOn.noteVelocity / (127.0).toDouble())
            }
            alphaTab.midi.MidiEventType.NoteOff -> 
            {
                var noteOff: alphaTab.midi.NoteOffEvent = (e as alphaTab.midi.NoteOffEvent)
                this.channelNoteOff(noteOff.channel, noteOff.noteKey)
            }
            alphaTab.midi.MidiEventType.ControlChange -> 
            {
                var controlChange: alphaTab.midi.ControlChangeEvent = (e as alphaTab.midi.ControlChangeEvent)
                this.channelMidiControl(controlChange.channel, controlChange.controller, controlChange.value)
            }
            alphaTab.midi.MidiEventType.ProgramChange -> 
            {
                var programChange: alphaTab.midi.ProgramChangeEvent = (e as alphaTab.midi.ProgramChangeEvent)
                this.channelSetPresetNumber(programChange.channel, programChange.program, programChange.channel == 9.0)
            }
            alphaTab.midi.MidiEventType.TempoChange -> 
            {
                var tempoChange: alphaTab.midi.TempoChangeEvent = (e as alphaTab.midi.TempoChangeEvent)
                this.currentTempo = (60000000.0).toDouble() / tempoChange.microSecondsPerQuarterNote
            }
            alphaTab.midi.MidiEventType.PitchBend -> 
            {
                var pitchBend: alphaTab.midi.PitchBendEvent = (e as alphaTab.midi.PitchBendEvent)
                this.channelSetPitchWheel(pitchBend.channel, pitchBend.value)
            }
            alphaTab.midi.MidiEventType.PerNotePitchBend -> 
            {
                var noteBend: alphaTab.midi.NoteBendEvent = (e as alphaTab.midi.NoteBendEvent)
                var perNotePitchWheel: Double = noteBend.value
                perNotePitchWheel = (perNotePitchWheel * alphaTab.synth.SynthConstants.MaxPitchWheel) / alphaTab.synth.SynthConstants.MaxPitchWheel20
                this.channelSetPerNotePitchWheel(noteBend.channel, noteBend.noteKey, perNotePitchWheel)
            }
            else -> { }
        }
    }
    
    public var metronomeVolume: Double
    get(){
        return this.channelGetMixVolume(alphaTab.synth.SynthConstants.MetronomeChannel)
    }
    set(value){
        this.setupMetronomeChannel(value)
    }
    
    /**
     */
    public fun setupMetronomeChannel(volume: Double): Unit{
        this.channelSetMixVolume(alphaTab.synth.SynthConstants.MetronomeChannel, volume)
        if (volume > 0)
        {
            this.channelSetVolume(alphaTab.synth.SynthConstants.MetronomeChannel, 1.0)
            this.channelSetPresetNumber(alphaTab.synth.SynthConstants.MetronomeChannel, 0.0, true)
        }
    }
    
    public var masterVolume: Double
    get(){
        return alphaTab.synth.SynthHelper.decibelsToGain(this.globalGainDb)
    }
    set(value){
        var gainDb: Double = alphaTab.synth.SynthHelper.gainToDecibels(value)
        var gainDBChange: Double = gainDb - this.globalGainDb
        if (gainDBChange == 0.0)
        {
            return
        }
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0)
            {
                v.noteGainDb += gainDBChange
            }
        }
        this.globalGainDb = gainDb
    }
    
    /**
     * Stop all playing notes immediatly and reset all channel parameters but keeps user
     * defined settings
     */
    public fun resetSoft(): Unit{
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0 && (v.ampEnv.segment < alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release || v.ampEnv.parameters!!.release != 0.0))
            {
                v.endQuick(this.outSampleRate)
            }
        }
        if (alphaTab.core.TypeHelper.isTruthy(this._channels))
        {
            for (c in this._channels!!.channelList)
            {
                c.presetIndex = 0.0
                c.bank = 0.0
                c.pitchWheel = 8192.0
                c.midiPan = 8192.0
                c.perNotePitchWheel.clear()
                c.midiVolume = 16383.0
                c.midiExpression = 16383.0
                c.midiRpn = 65535.0
                c.midiData = 0.0
                c.panOffset = 0.0
                c.gainDb = 0.0
                c.pitchRange = 2.0
                c.tuning = 0.0
            }
        }
    }
    
    public var presets: alphaTab.collections.List<alphaTab.synth.synthesis.Preset>? = null
    
    private var _voices: alphaTab.collections.List<alphaTab.synth.synthesis.Voice> = alphaTab.collections.List<alphaTab.synth.synthesis.Voice>(
    )
    
    
    private var _channels: alphaTab.synth.synthesis.Channels? = null
    
    private var _voicePlayIndex: Double = 0.0
    
    public val presetCount: Double
    get(){
        return this.presets?.length ?: 0.0
    }
    
    /**
     * Gets the currently configured output mode.
     */
    public var outputMode: alphaTab.synth.synthesis.OutputMode = alphaTab.synth.synthesis.OutputMode.StereoInterleaved
    
    /**
     * Gets the currently configured sample rate.
     */
    public var outSampleRate: Double = 0.0
    
    /**
     * Gets the currently configured global gain in DB.
     */
    public var globalGainDb: Double = 0.0
    
    /**
     * Stop all playing notes immediatly and reset all channel parameters
     */
    public fun reset(): Unit{
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0 && (v.ampEnv.segment < alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release || v.ampEnv.parameters!!.release != 0.0))
            {
                v.endQuick(this.outSampleRate)
            }
        }
        this._channels = null
    }
    
    /**
     * Setup the parameters for the voice render methods
     * @param outputMode if mono or stereo and how stereo channel data is ordered
     * @param sampleRate the number of samples per second (output frequency)
     * @param globalGainDb volume gain in decibels (>0 means higher, <0 means lower)
     */
    public fun setOutput(outputMode: alphaTab.synth.synthesis.OutputMode, sampleRate: Double, globalGainDb: Double): Unit{
        this.outputMode = outputMode
        this.outSampleRate = if(sampleRate >= 1)  sampleRate else 44100.0
        this.globalGainDb = globalGainDb
    }
    
    /**
     * Start playing a note
     * @param presetIndex preset index >= 0 and < 
     * @param key note value between 0 and 127 (60 being middle C)
     * @param vel velocity as a float between 0.0 (equal to note off) and 1.0 (full)
     */
    public fun noteOn(presetIndex: Double, key: Double, vel: Double): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.presets))
        {
            return
        }
        var midiVelocity: Double = (((vel * 127.0)).toInt() or 0).toDouble()
        if (presetIndex < 0 || presetIndex >= this.presets!!.length)
        {
            return
        }
        if (vel <= 0)
        {
            this.noteOff(presetIndex, key)
            return
        }
        var voicePlayIndex: Double = this._voicePlayIndex++
        for (region in this.presets!![(presetIndex).toInt()].regions!!)
        {
            if (key < region.loKey || key > region.hiKey || midiVelocity < region.loVel || midiVelocity > region.hiVel)
            {
                continue
            }
            var voice: alphaTab.synth.synthesis.Voice? = null
            if (region.group != 0.0)
            {
                for (v in this._voices)
                {
                    if (v.playingPreset == presetIndex && v.region!!.group == region.group)
                    {
                        v.endQuick(this.outSampleRate)
                    }
                    else if (v.playingPreset == -1.0 && !alphaTab.core.TypeHelper.isTruthy(voice))
                    {
                        voice = v
                    }
                }
            }
            else 
            {
                for (v in this._voices)
                {
                    if (v.playingPreset == -1.0)
                    {
                        voice = v
                    }
                }
            }
            if (!alphaTab.core.TypeHelper.isTruthy(voice))
            {
                if(true) {
                    var i: Double = 0.0
                    
                    while(i < 4){
                        try{
                            var newVoice: alphaTab.synth.synthesis.Voice = alphaTab.synth.synthesis.Voice()
                            newVoice.playingPreset = -1.0
                            this._voices.push(newVoice)
                        }
                        finally{
                            i++
                        }
                    }
                }
                voice = this._voices[(this._voices.length - 4.0).toInt()]
            }
            voice.region = region
            voice.playingPreset = presetIndex
            voice.playingKey = key
            voice.playIndex = voicePlayIndex
            voice.noteGainDb = this.globalGainDb - region.attenuation - alphaTab.synth.SynthHelper.gainToDecibels((1.0).toDouble() / vel)
            if (alphaTab.core.TypeHelper.isTruthy(this._channels))
            {
                this._channels!!.setupVoice(this, voice)
            }
            else 
            {
                voice.calcPitchRatio(0.0, this.outSampleRate)
                voice.panFactorLeft = alphaTab.core.ecmaScript.Math.sqrt(0.5 - region.pan)
                voice.panFactorRight = alphaTab.core.ecmaScript.Math.sqrt(0.5 + region.pan)
            }
            voice.sourceSamplePosition = region.offset
            var doLoop: Boolean = region.loopMode != alphaTab.synth.synthesis.LoopMode.None && region.loopStart < region.loopEnd
            voice.loopStart = if(doLoop)  region.loopStart else 0.0
            voice.loopEnd = if(doLoop)  region.loopEnd else 0.0
            voice.ampEnv.setup(region.ampEnv, key, midiVelocity, true, this.outSampleRate)
            voice.modEnv.setup(region.modEnv, key, midiVelocity, false, this.outSampleRate)
            var filterQDB: Double = region.initialFilterQ / (10.0).toDouble()
            voice.lowPass.qInv = (1.0).toDouble() / alphaTab.core.ecmaScript.Math.pow(10.0, filterQDB / (20.0).toDouble())
            voice.lowPass.z1 = 0.0
            voice.lowPass.z2 = 0.0
            voice.lowPass.active = region.initialFilterFc <= 13500
            if (voice.lowPass.active)
            {
                voice.lowPass.setup(alphaTab.synth.SynthHelper.cents2Hertz(region.initialFilterFc) / this.outSampleRate)
            }
            voice.modLfo.setup(region.delayModLFO, region.freqModLFO, this.outSampleRate)
            voice.vibLfo.setup(region.delayVibLFO, region.freqVibLFO, this.outSampleRate)
        }
    }
    
    /**
     * Start playing a note
     * @param bank instrument bank number (alternative to preset_index)
     * @param presetNumber preset number (alternative to preset_index)
     * @param key note value between 0 and 127 (60 being middle C)
     * @param vel velocity as a float between 0.0 (equal to note off) and 1.0 (full)
     */
    public fun bankNoteOn(bank: Double, presetNumber: Double, key: Double, vel: Double): Boolean{
        var presetIndex: Double = this.getPresetIndex(bank, presetNumber)
        if (presetIndex == -1.0)
        {
            return false
        }
        this.noteOn(presetIndex, key, vel)
        return true
    }
    
    /**
     * Stop playing a note
     */
    public fun noteOff(presetIndex: Double, key: Double): Unit{
        var matchFirst: alphaTab.synth.synthesis.Voice? = null
        var matchLast: alphaTab.synth.synthesis.Voice? = null
        var matches: alphaTab.collections.List<alphaTab.synth.synthesis.Voice> = alphaTab.collections.List<alphaTab.synth.synthesis.Voice>(
        )
        
        for (v in this._voices)
        {
            if (v.playingPreset != presetIndex || v.playingKey != key || v.ampEnv.segment >= alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release)
            {
                continue
            }
            else if (!alphaTab.core.TypeHelper.isTruthy(matchFirst) || v.playIndex < matchFirst.playIndex)
            {
                matchFirst = v
                matchLast = v
                matches.push(v)
            }
            else if (v.playIndex == matchFirst.playIndex)
            {
                matchLast = v
                matches.push(v)
            }
        }
        if (!alphaTab.core.TypeHelper.isTruthy(matchFirst))
        {
            return
        }
        for (v in matches)
        {
            if (v != matchFirst && v != matchLast && (v.playIndex != matchFirst.playIndex || v.playingPreset != presetIndex || v.playingKey != key || v.ampEnv.segment >= alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release))
            {
                continue
            }
            v.end(this.outSampleRate)
        }
    }
    
    /**
     * Stop playing a note
     */
    public fun bankNoteOff(bank: Double, presetNumber: Double, key: Double): Boolean{
        var presetIndex: Double = this.getPresetIndex(bank, presetNumber)
        if (presetIndex == -1.0)
        {
            return false
        }
        this.noteOff(presetIndex, key)
        return true
    }
    
    /**
     * Stop playing all notes (end with sustain and release)
     */
    public fun noteOffAll(immediate: Boolean): Unit{
        for (voice in this._voices)
        {
            if (voice.playingPreset != -1.0 && voice.ampEnv.segment < alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release)
            {
                if (immediate)
                {
                    voice.endQuick(this.outSampleRate)
                }
                else 
                {
                    voice.end(this.outSampleRate)
                }
            }
        }
    }
    
    public val activeVoiceCount: Double
    get(){
        var count: Double = 0.0
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0)
            {
                count++
            }
        }
        return count
    }
    
    /**
     */
    private fun channelInit(channel: Double): alphaTab.synth.synthesis.Channel{
        if (alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)
        {
            return this._channels!!.channelList[(channel).toInt()]
        }
        if (!alphaTab.core.TypeHelper.isTruthy(this._channels))
        {
            this._channels = alphaTab.synth.synthesis.Channels()
        }
        if(true) {
            var i: Double = this._channels!!.channelList.length
            
            while(i <= channel){
                try{
                    var c: alphaTab.synth.synthesis.Channel = alphaTab.synth.synthesis.Channel()
                    c.presetIndex = 0.0
                    c.bank = 0.0
                    c.pitchWheel = 8192.0
                    c.midiPan = 8192.0
                    c.midiVolume = 16383.0
                    c.midiExpression = 16383.0
                    c.midiRpn = 65535.0
                    c.midiData = 0.0
                    c.panOffset = 0.0
                    c.gainDb = 0.0
                    c.pitchRange = 2.0
                    c.tuning = 0.0
                    c.mixVolume = 1.0
                    this._channels!!.channelList.push(c)
                }
                finally{
                    i++
                }
            }
        }
        return this._channels!!.channelList[(channel).toInt()]
    }
    
    /**
     * Returns the preset index from a bank and preset number, or -1 if it does not exist in the loaded SoundFont
     */
    private fun getPresetIndex(bank: Double, presetNumber: Double): Double{
        if (!alphaTab.core.TypeHelper.isTruthy(this.presets))
        {
            return -1.0
        }
        if(true) {
            var i: Double = this.presets!!.length - 1.0
            
            while(i >= 0){
                try{
                    var preset: alphaTab.synth.synthesis.Preset = this.presets!![(i).toInt()]
                    if (preset.presetNumber == presetNumber && preset.bank == bank)
                    {
                        return i
                    }
                }
                finally{
                    i--
                }
            }
        }
        return -1.0
    }
    
    /**
     * Returns the name of a preset index >= 0 and < GetPresetName()
     */
    public fun getPresetName(presetIndex: Double): String?{
        if (!alphaTab.core.TypeHelper.isTruthy(this.presets))
        {
            return null
        }
        return if(presetIndex < 0 || presetIndex >= this.presets!!.length)  null else this.presets!![(presetIndex).toInt()].name
    }
    
    /**
     * Returns the name of a preset by bank and preset number
     */
    public fun bankGetPresetName(bank: Double, presetNumber: Double): String?{
        return this.getPresetName(this.getPresetIndex(bank, presetNumber))
    }
    
    /**
     * Start playing a note on a channel
     * @param channel channel number
     * @param key note value between 0 and 127 (60 being middle C)
     * @param vel velocity as a float between 0.0 (equal to note off) and 1.0 (full)
     */
    public fun channelNoteOn(channel: Double, key: Double, vel: Double): Unit{
        var paramkey = key
        if (!alphaTab.core.TypeHelper.isTruthy(this._channels) || channel > this._channels!!.channelList.length)
        {
            return
        }
        if (this._transpositionPitches.has(channel))
        {
            paramkey += this._transpositionPitches.get(channel)!!
        }
        this._channels!!.activeChannel = channel
        this.noteOn(this._channels!!.channelList[(channel).toInt()].presetIndex, paramkey, vel)
    }
    
    /**
     * Stop playing notes on a channel
     * @param channel channel number
     * @param key note value between 0 and 127 (60 being middle C)
     */
    public fun channelNoteOff(channel: Double, key: Double): Unit{
        var paramkey = key
        if (this._transpositionPitches.has(channel))
        {
            paramkey += this._transpositionPitches.get(channel)!!
        }
        var matches: alphaTab.collections.List<alphaTab.synth.synthesis.Voice> = alphaTab.collections.List<alphaTab.synth.synthesis.Voice>(
        )
        
        var matchFirst: alphaTab.synth.synthesis.Voice? = null
        var matchLast: alphaTab.synth.synthesis.Voice? = null
        for (v in this._voices)
        {
            if (v.playingPreset == -1.0 || v.playingChannel != channel || v.playingKey != paramkey || v.ampEnv.segment >= alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release)
            {
                continue
            }
            if (!alphaTab.core.TypeHelper.isTruthy(matchFirst) || v.playIndex < matchFirst.playIndex)
            {
                matchFirst = v
                matchLast = v
                matches.push(v)
            }
            else if (v.playIndex == matchFirst.playIndex)
            {
                matchLast = v
                matches.push(v)
            }
        }
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        c.perNotePitchWheel.delete(paramkey)
        if (!alphaTab.core.TypeHelper.isTruthy(matchFirst))
        {
            return
        }
        for (v in matches)
        {
            if (v != matchFirst && v != matchLast && (v.playIndex != matchFirst.playIndex || v.playingPreset == -1.0 || v.playingChannel != channel || v.playingKey != paramkey || v.ampEnv.segment >= alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release))
            {
                continue
            }
            v.end(this.outSampleRate)
        }
    }
    
    /**
     * Stop playing all notes on a channel with sustain and release.
     * @param channel channel number
     */
    public fun channelNoteOffAll(channel: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        c.perNotePitchWheel.clear()
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0 && v.playingChannel == channel && v.ampEnv.segment < alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release)
            {
                v.end(this.outSampleRate)
            }
        }
    }
    
    /**
     * Stop playing all notes on a channel immediately
     * @param channel channel number
     */
    public fun channelSoundsOffAll(channel: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        c.perNotePitchWheel.clear()
        for (v in this._voices)
        {
            if (v.playingPreset != -1.0 && v.playingChannel == channel && (v.ampEnv.segment < alphaTab.synth.synthesis.VoiceEnvelopeSegment.Release || v.ampEnv.parameters!!.release == 0.0))
            {
                v.endQuick(this.outSampleRate)
            }
        }
    }
    
    /**
     * @param channel channel number
     * @param presetIndex preset index <= 0 and > 
     */
    public fun channelSetPresetIndex(channel: Double, presetIndex: Double): Unit{
        this.channelInit(channel).presetIndex = alphaTab.io.TypeConversions.int32ToUint16(presetIndex)
    }
    
    /**
     * @param channel channel number
     * @param presetNumber preset number (alternative to preset_index)
     * @param midiDrums false for normal channels, otherwise apply MIDI drum channel rules
     */
    public fun channelSetPresetNumber(channel: Double, presetNumber: Double, midiDrums: Boolean = false): Boolean{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        var presetIndex: Double = 0.0
        if (midiDrums)
        {
            presetIndex = this.getPresetIndex((128 or ((c.bank).toInt() and 32767)).toDouble(), presetNumber)
            if (presetIndex == -1.0)
            {
                presetIndex = this.getPresetIndex(128.0, presetNumber)
            }
            if (presetIndex == -1.0)
            {
                presetIndex = this.getPresetIndex(128.0, 0.0)
            }
            if (presetIndex == -1.0)
            {
                presetIndex = this.getPresetIndex(((c.bank).toInt() and 2047).toDouble(), presetNumber)
            }
        }
        else 
        {
            presetIndex = this.getPresetIndex(((c.bank).toInt() and 2047).toDouble(), presetNumber)
        }
        c.presetIndex = presetIndex
        return (presetIndex != -1.0)
    }
    
    /**
     * @param channel channel number
     * @param bank instrument bank number (alternative to preset_index)
     */
    public fun channelSetBank(channel: Double, bank: Double): Unit{
        this.channelInit(channel).bank = alphaTab.io.TypeConversions.int32ToUint16(bank)
    }
    
    /**
     * @param channel channel number
     * @param bank instrument bank number (alternative to preset_index)
     * @param presetNumber preset number (alternative to preset_index)
     */
    public fun channelSetBankPreset(channel: Double, bank: Double, presetNumber: Double): Boolean{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        var presetIndex: Double = this.getPresetIndex(bank, presetNumber)
        if (presetIndex == -1.0)
        {
            return false
        }
        c.presetIndex = alphaTab.io.TypeConversions.int32ToUint16(presetIndex)
        c.bank = alphaTab.io.TypeConversions.int32ToUint16(bank)
        return true
    }
    
    /**
     * @param channel channel number
     * @param pan stereo panning value from 0.0 (left) to 1.0 (right) (default 0.5 center)
     */
    public fun channelSetPan(channel: Double, pan: Double): Unit{
        for (v in this._voices)
        {
            if (v.playingChannel == channel && v.playingPreset != -1.0)
            {
                var newPan: Double = v.region!!.pan + pan - 0.5
                if (newPan <= -0.5)
                {
                    v.panFactorLeft = 1.0
                    v.panFactorRight = 0.0
                }
                else if (newPan >= 0.5)
                {
                    v.panFactorLeft = 0.0
                    v.panFactorRight = 1.0
                }
                else 
                {
                    v.panFactorLeft = alphaTab.core.ecmaScript.Math.sqrt(0.5 - newPan)
                    v.panFactorRight = alphaTab.core.ecmaScript.Math.sqrt(0.5 + newPan)
                }
            }
        }
        this.channelInit(channel).panOffset = pan - 0.5
    }
    
    /**
     * @param channel channel number
     * @param volume linear volume scale factor (default 1.0 full)
     */
    public fun channelSetVolume(channel: Double, volume: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        var gainDb: Double = alphaTab.synth.SynthHelper.gainToDecibels(volume)
        var gainDBChange: Double = gainDb - c.gainDb
        if (gainDBChange == 0.0)
        {
            return
        }
        for (v in this._voices)
        {
            if (v.playingChannel == channel && v.playingPreset != -1.0)
            {
                v.noteGainDb += gainDBChange
            }
        }
        c.gainDb = gainDb
    }
    
    /**
     * @param channel channel number
     * @param pitchWheel pitch wheel position 0 to 16383 (default 8192 unpitched)
     */
    public fun channelSetPitchWheel(channel: Double, pitchWheel: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        if (c.pitchWheel == pitchWheel)
        {
            return
        }
        c.pitchWheel = alphaTab.io.TypeConversions.int32ToUint16(pitchWheel)
        this.channelApplyPitch(channel, c)
    }
    
    /**
     * @param channel channel number
     * @param key note value between 0 and 127
     * @param pitchWheel pitch wheel position 0 to 16383 (default 8192 unpitched)
     */
    public fun channelSetPerNotePitchWheel(channel: Double, key: Double, pitchWheel: Double): Unit{
        var paramkey = key
        if (this._transpositionPitches.has(channel))
        {
            paramkey += this._transpositionPitches.get(channel)!!
        }
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        if (c.perNotePitchWheel.has(paramkey) && c.perNotePitchWheel.get(paramkey) == pitchWheel)
        {
            return
        }
        c.perNotePitchWheel.set(paramkey, pitchWheel)
        this.channelApplyPitch(channel, c, paramkey)
    }
    
    /**
     */
    private fun channelApplyPitch(channel: Double, c: alphaTab.synth.synthesis.Channel, key: Double = -1.0): Unit{
        for (v in this._voices)
        {
            if (v.playingChannel == channel && v.playingPreset != -1.0 && (key == -1.0 || v.playingKey == key))
            {
                v.updatePitchRatio(c, this.outSampleRate)
            }
        }
    }
    
    /**
     * @param channel channel number
     * @param pitchRange range of the pitch wheel in semitones (default 2.0, total +/- 2 semitones)
     */
    public fun channelSetPitchRange(channel: Double, pitchRange: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        if (c.pitchRange == pitchRange)
        {
            return
        }
        c.pitchRange = pitchRange
        if (c.pitchWheel != 8192.0)
        {
            this.channelApplyPitch(channel, c)
        }
    }
    
    /**
     * @param channel channel number
     * @param tuning tuning of all playing voices in semitones (default 0.0, standard (A440) tuning)
     */
    public fun channelSetTuning(channel: Double, tuning: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        if (c.tuning == tuning)
        {
            return
        }
        c.tuning = tuning
        this.channelApplyPitch(channel, c)
    }
    
    /**
     * Apply a MIDI control change to the channel (not all controllers are supported!)
     */
    public fun channelMidiControl(channel: Double, controller: alphaTab.midi.ControllerType, controlValue: Double): Unit{
        var c: alphaTab.synth.synthesis.Channel = this.channelInit(channel)
        when (controller)
        {
            alphaTab.midi.ControllerType.DataEntryFine -> 
            {
                c.midiData = alphaTab.io.TypeConversions.int32ToUint16((((c.midiData).toInt() and 16256) or (controlValue).toInt()).toDouble())
                if (c.midiRpn == 0.0)
                {
                    this.channelSetPitchRange(channel, ((c.midiData).toInt() shr 7) + 0.01 * ((c.midiData).toInt() and 127))
                }
                else if (c.midiRpn == 1.0)
                {
                    this.channelSetTuning(channel, ((c.tuning).toInt() or 0) + (c.midiData - 8192.0) / (8192.0).toDouble())
                }
                else if (c.midiRpn == 2.0)
                {
                    this.channelSetTuning(channel, controlValue - 64.0 + (c.tuning - ((c.tuning).toInt() or 0)))
                }
                return
            }
            alphaTab.midi.ControllerType.VolumeCoarse -> 
            {
                c.midiVolume = alphaTab.io.TypeConversions.int32ToUint16((((c.midiVolume).toInt() and 127) or ((controlValue).toInt() shl 7)).toDouble())
                this.channelSetVolume(channel, alphaTab.core.ecmaScript.Math.pow((c.midiVolume / (16383.0).toDouble()) * (c.midiExpression / (16383.0).toDouble()), 3.0))
                return
            }
            alphaTab.midi.ControllerType.VolumeFine -> 
            {
                c.midiVolume = alphaTab.io.TypeConversions.int32ToUint16((((c.midiVolume).toInt() and 16256) or (controlValue).toInt()).toDouble())
                this.channelSetVolume(channel, alphaTab.core.ecmaScript.Math.pow((c.midiVolume / (16383.0).toDouble()) * (c.midiExpression / (16383.0).toDouble()), 3.0))
                return
            }
            alphaTab.midi.ControllerType.ExpressionControllerCoarse -> 
            {
                c.midiExpression = alphaTab.io.TypeConversions.int32ToUint16((((c.midiExpression).toInt() and 127) or ((controlValue).toInt() shl 7)).toDouble())
                this.channelSetVolume(channel, alphaTab.core.ecmaScript.Math.pow((c.midiVolume / (16383.0).toDouble()) * (c.midiExpression / (16383.0).toDouble()), 3.0))
                return
            }
            alphaTab.midi.ControllerType.ExpressionControllerFine -> 
            {
                c.midiExpression = alphaTab.io.TypeConversions.int32ToUint16((((c.midiExpression).toInt() and 16256) or (controlValue).toInt()).toDouble())
                this.channelSetVolume(channel, alphaTab.core.ecmaScript.Math.pow((c.midiVolume / (16383.0).toDouble()) * (c.midiExpression / (16383.0).toDouble()), 3.0))
                return
            }
            alphaTab.midi.ControllerType.PanCoarse -> 
            {
                c.midiPan = alphaTab.io.TypeConversions.int32ToUint16((((c.midiPan).toInt() and 127) or ((controlValue).toInt() shl 7)).toDouble())
                this.channelSetPan(channel, c.midiPan / (16383.0).toDouble())
                return
            }
            alphaTab.midi.ControllerType.PanFine -> 
            {
                c.midiPan = alphaTab.io.TypeConversions.int32ToUint16((((c.midiPan).toInt() and 16256) or (controlValue).toInt()).toDouble())
                this.channelSetPan(channel, c.midiPan / (16383.0).toDouble())
                return
            }
            alphaTab.midi.ControllerType.DataEntryCoarse -> 
            {
                c.midiData = alphaTab.io.TypeConversions.int32ToUint16((((c.midiData).toInt() and 127) or ((controlValue).toInt() shl 7)).toDouble())
                if (c.midiRpn == 0.0)
                {
                    this.channelSetPitchRange(channel, ((c.midiData).toInt() shr 7) + 0.01 * ((c.midiData).toInt() and 127))
                }
                else if (c.midiRpn == 1.0)
                {
                    this.channelSetTuning(channel, ((c.tuning).toInt() or 0) + (c.midiData - 8192.0) / (8192.0).toDouble())
                }
                else if (c.midiRpn == 2.0 && ((controller as alphaTab.midi.ControllerType)) == alphaTab.midi.ControllerType.DataEntryCoarse)
                {
                    this.channelSetTuning(channel, controlValue - 64.0 + (c.tuning - ((c.tuning).toInt() or 0)))
                }
                return
            }
            alphaTab.midi.ControllerType.BankSelectCoarse -> 
            {
                c.bank = alphaTab.io.TypeConversions.int32ToUint16((32768 or (controlValue).toInt()).toDouble())
                return
            }
            alphaTab.midi.ControllerType.BankSelectFine -> 
            {
                c.bank = alphaTab.io.TypeConversions.int32ToUint16((((if(((c.bank).toInt() and 32768) != 0)  (((c.bank).toInt() and 127) shl 7).toDouble() else 0.0)).toInt() or (controlValue).toInt()).toDouble())
                return
            }
            alphaTab.midi.ControllerType.RegisteredParameterCourse -> 
            {
                c.midiRpn = alphaTab.io.TypeConversions.int32ToUint16(((((if(c.midiRpn == 65535.0)  0.0 else c.midiRpn)).toInt() and 127) or ((controlValue).toInt() shl 7)).toDouble())
                return
            }
            alphaTab.midi.ControllerType.RegisteredParameterFine -> 
            {
                c.midiRpn = alphaTab.io.TypeConversions.int32ToUint16(((((if(c.midiRpn == 65535.0)  0.0 else c.midiRpn)).toInt() and 16256) or (controlValue).toInt()).toDouble())
                return
            }
            alphaTab.midi.ControllerType.NonRegisteredParameterFine -> 
            {
                c.midiRpn = 65535.0
                return
            }
            alphaTab.midi.ControllerType.NonRegisteredParameterCourse -> 
            {
                c.midiRpn = 65535.0
                return
            }
            alphaTab.midi.ControllerType.AllSoundOff -> 
            {
                this.channelSoundsOffAll(channel)
                return
            }
            alphaTab.midi.ControllerType.AllNotesOff -> 
            {
                this.channelNoteOffAll(channel)
                return
            }
            alphaTab.midi.ControllerType.ResetControllers -> 
            {
                c.midiVolume = 16383.0
                c.midiExpression = 16383.0
                c.midiPan = 8192.0
                c.bank = 0.0
                this.channelSetVolume(channel, 1.0)
                this.channelSetPan(channel, 0.5)
                this.channelSetPitchRange(channel, 2.0)
                return
            }
            else -> { }
        }
    }
    
    /**
     * Gets the current preset index of the given channel.
     * @param channel The channel index
     */
    public fun channelGetPresetIndex(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].presetIndex else 0.0
    }
    
    /**
     * Gets the current bank of the given channel.
     * @param channel The channel index
     */
    public fun channelGetPresetBank(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  ((this._channels!!.channelList[(channel).toInt()].bank).toInt() and 32767).toDouble() else 0.0
    }
    
    /**
     * Gets the current pan of the given channel.
     * @param channel The channel index
     */
    public fun channelGetPan(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].panOffset - 0.5 else 0.5
    }
    
    /**
     * Gets the current volume of the given channel.
     * @param channel The channel index
     */
    public fun channelGetVolume(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  alphaTab.synth.SynthHelper.decibelsToGain(this._channels!!.channelList[(channel).toInt()].gainDb) else 1.0
    }
    
    /**
     * Gets the current pitch wheel of the given channel.
     * @param channel The channel index
     */
    public fun channelGetPitchWheel(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].pitchWheel else 8192.0
    }
    
    /**
     * Gets the current pitch range of the given channel.
     * @param channel The channel index
     */
    public fun channelGetPitchRange(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].pitchRange else 2.0
    }
    
    /**
     * Gets the current tuning of the given channel.
     * @param channel The channel index
     */
    public fun channelGetTuning(channel: Double): Double{
        return if(alphaTab.core.TypeHelper.isTruthy(this._channels) && channel < this._channels!!.channelList.length)  this._channels!!.channelList[(channel).toInt()].tuning else 0.0
    }
    
    public fun resetPresets(): Unit{
        this.presets = alphaTab.collections.List(
        )
        
    }
    
    /**
     */
    public fun loadPresets(hydra: alphaTab.synth.soundfont.Hydra, append: Boolean): Unit{
        var newPresets: alphaTab.collections.List<alphaTab.synth.synthesis.Preset> = alphaTab.collections.List<alphaTab.synth.synthesis.Preset>(
        )
        
        if(true) {
            var phdrIndex: Double = 0.0
            
            while(phdrIndex < hydra.phdrs.length - 1.0){
                try{
                    var phdr: alphaTab.synth.soundfont.HydraPhdr = hydra.phdrs[(phdrIndex).toInt()]
                    var regionIndex: Double = 0.0
                    var preset: alphaTab.synth.synthesis.Preset = alphaTab.synth.synthesis.Preset()
                    newPresets.push(preset)
                    preset.name = phdr.presetName
                    preset.bank = phdr.bank
                    preset.presetNumber = phdr.preset
                    preset.fontSamples = hydra.fontSamples
                    var regionNum: Double = 0.0
                    if(true) {
                        var pbagIndex: Double = phdr.presetBagNdx
                        
                        while(pbagIndex < hydra.phdrs[(phdrIndex + 1.0).toInt()].presetBagNdx){
                            try{
                                var pbag: alphaTab.synth.soundfont.HydraPbag = hydra.pbags[(pbagIndex).toInt()]
                                var plokey: Double = 0.0
                                var phikey: Double = 127.0
                                var plovel: Double = 0.0
                                var phivel: Double = 127.0
                                if(true) {
                                    var pgenIndex: Double = pbag.genNdx
                                    
                                    while(pgenIndex < hydra.pbags[(pbagIndex + 1.0).toInt()].genNdx){
                                        try{
                                            var pgen: alphaTab.synth.soundfont.HydraPgen = hydra.pgens[(pgenIndex).toInt()]
                                            if (pgen.genOper == alphaTab.synth.soundfont.HydraPgen.GenKeyRange)
                                            {
                                                plokey = pgen.genAmount.lowByteAmount
                                                phikey = pgen.genAmount.highByteAmount
                                                continue
                                            }
                                            if (pgen.genOper == alphaTab.synth.soundfont.HydraPgen.GenVelRange)
                                            {
                                                plovel = pgen.genAmount.lowByteAmount
                                                phivel = pgen.genAmount.highByteAmount
                                                continue
                                            }
                                            if (pgen.genOper != alphaTab.synth.soundfont.HydraPgen.GenInstrument)
                                            {
                                                continue
                                            }
                                            if (pgen.genAmount.wordAmount >= hydra.insts.length)
                                            {
                                                continue
                                            }
                                            var pinst: alphaTab.synth.soundfont.HydraInst = hydra.insts[(pgen.genAmount.wordAmount).toInt()]
                                            if(true) {
                                                var ibagIndex: Double = pinst.instBagNdx
                                                
                                                while(ibagIndex < hydra.insts[(pgen.genAmount.wordAmount + 1.0).toInt()].instBagNdx){
                                                    try{
                                                        var ibag: alphaTab.synth.soundfont.HydraIbag = hydra.ibags[(ibagIndex).toInt()]
                                                        var ilokey: Double = 0.0
                                                        var ihikey: Double = 127.0
                                                        var ilovel: Double = 0.0
                                                        var ihivel: Double = 127.0
                                                        if(true) {
                                                            var igenIndex: Double = ibag.instGenNdx
                                                            
                                                            while(igenIndex < hydra.ibags[(ibagIndex + 1.0).toInt()].instGenNdx){
                                                                try{
                                                                    var igen: alphaTab.synth.soundfont.HydraIgen = hydra.igens[(igenIndex).toInt()]
                                                                    if (igen.genOper == alphaTab.synth.soundfont.HydraPgen.GenKeyRange)
                                                                    {
                                                                        ilokey = igen.genAmount.lowByteAmount
                                                                        ihikey = igen.genAmount.highByteAmount
                                                                        continue
                                                                    }
                                                                    if (igen.genOper == alphaTab.synth.soundfont.HydraPgen.GenVelRange)
                                                                    {
                                                                        ilovel = igen.genAmount.lowByteAmount
                                                                        ihivel = igen.genAmount.highByteAmount
                                                                        continue
                                                                    }
                                                                    if (igen.genOper == 53.0 && ihikey >= plokey && ilokey <= phikey && ihivel >= plovel && ilovel <= phivel)
                                                                    {
                                                                        regionNum++
                                                                    }
                                                                }
                                                                finally{
                                                                    igenIndex++
                                                                }
                                                            }
                                                        }
                                                    }
                                                    finally{
                                                        ibagIndex++
                                                    }
                                                }
                                            }
                                        }
                                        finally{
                                            pgenIndex++
                                        }
                                    }
                                }
                            }
                            finally{
                                pbagIndex++
                            }
                        }
                    }
                    preset.regions = alphaTab.collections.List<alphaTab.synth.synthesis.Region>((regionNum).toInt())
                    var globalRegion: alphaTab.synth.synthesis.Region = alphaTab.synth.synthesis.Region()
                    globalRegion.clear(true)
                    if(true) {
                        var pbagIndex: Double = phdr.presetBagNdx
                        
                        while(pbagIndex < hydra.phdrs[(phdrIndex + 1.0).toInt()].presetBagNdx){
                            try{
                                var pbag: alphaTab.synth.soundfont.HydraPbag = hydra.pbags[(pbagIndex).toInt()]
                                var presetRegion: alphaTab.synth.synthesis.Region = alphaTab.synth.synthesis.Region(globalRegion)
                                var hadGenInstrument: Boolean = false
                                if(true) {
                                    var pgenIndex: Double = pbag.genNdx
                                    
                                    while(pgenIndex < hydra.pbags[(pbagIndex + 1.0).toInt()].genNdx){
                                        try{
                                            var pgen: alphaTab.synth.soundfont.HydraPgen = hydra.pgens[(pgenIndex).toInt()]
                                            if (pgen.genOper == alphaTab.synth.soundfont.HydraPgen.GenInstrument)
                                            {
                                                var whichInst: Double = pgen.genAmount.wordAmount
                                                if (whichInst >= hydra.insts.length)
                                                {
                                                    continue
                                                }
                                                var instRegion: alphaTab.synth.synthesis.Region = alphaTab.synth.synthesis.Region()
                                                instRegion.clear(false)
                                                var inst: alphaTab.synth.soundfont.HydraInst = hydra.insts[(whichInst).toInt()]
                                                if(true) {
                                                    var ibagIndex: Double = inst.instBagNdx
                                                    
                                                    while(ibagIndex < hydra.insts[(whichInst + 1.0).toInt()].instBagNdx){
                                                        try{
                                                            var ibag: alphaTab.synth.soundfont.HydraIbag = hydra.ibags[(ibagIndex).toInt()]
                                                            var zoneRegion: alphaTab.synth.synthesis.Region = alphaTab.synth.synthesis.Region(instRegion)
                                                            var hadSampleId: Boolean = false
                                                            if(true) {
                                                                var igenIndex: Double = ibag.instGenNdx
                                                                
                                                                while(igenIndex < hydra.ibags[(ibagIndex + 1.0).toInt()].instGenNdx){
                                                                    try{
                                                                        var igen: alphaTab.synth.soundfont.HydraIgen = hydra.igens[(igenIndex).toInt()]
                                                                        if (igen.genOper == alphaTab.synth.soundfont.HydraPgen.GenSampleId)
                                                                        {
                                                                            if (zoneRegion.hiKey < presetRegion.loKey || zoneRegion.loKey > presetRegion.hiKey)
                                                                            {
                                                                                continue
                                                                            }
                                                                            if (zoneRegion.hiVel < presetRegion.loVel || zoneRegion.loVel > presetRegion.hiVel)
                                                                            {
                                                                                continue
                                                                            }
                                                                            if (presetRegion.loKey > zoneRegion.loKey)
                                                                            {
                                                                                zoneRegion.loKey = presetRegion.loKey
                                                                            }
                                                                            if (presetRegion.hiKey < zoneRegion.hiKey)
                                                                            {
                                                                                zoneRegion.hiKey = presetRegion.hiKey
                                                                            }
                                                                            if (presetRegion.loVel > zoneRegion.loVel)
                                                                            {
                                                                                zoneRegion.loVel = presetRegion.loVel
                                                                            }
                                                                            if (presetRegion.hiVel < zoneRegion.hiVel)
                                                                            {
                                                                                zoneRegion.hiVel = presetRegion.hiVel
                                                                            }
                                                                            zoneRegion.offset += presetRegion.offset
                                                                            zoneRegion.end += presetRegion.end
                                                                            zoneRegion.loopStart += presetRegion.loopStart
                                                                            zoneRegion.loopEnd += presetRegion.loopEnd
                                                                            zoneRegion.transpose += presetRegion.transpose
                                                                            zoneRegion.tune += presetRegion.tune
                                                                            zoneRegion.pitchKeyTrack += presetRegion.pitchKeyTrack
                                                                            zoneRegion.attenuation += presetRegion.attenuation
                                                                            zoneRegion.pan += presetRegion.pan
                                                                            zoneRegion.ampEnv.delay += presetRegion.ampEnv.delay
                                                                            zoneRegion.ampEnv.attack += presetRegion.ampEnv.attack
                                                                            zoneRegion.ampEnv.hold += presetRegion.ampEnv.hold
                                                                            zoneRegion.ampEnv.decay += presetRegion.ampEnv.decay
                                                                            zoneRegion.ampEnv.sustain += presetRegion.ampEnv.sustain
                                                                            zoneRegion.ampEnv.release += presetRegion.ampEnv.release
                                                                            zoneRegion.modEnv.delay += presetRegion.modEnv.delay
                                                                            zoneRegion.modEnv.attack += presetRegion.modEnv.attack
                                                                            zoneRegion.modEnv.hold += presetRegion.modEnv.hold
                                                                            zoneRegion.modEnv.decay += presetRegion.modEnv.decay
                                                                            zoneRegion.modEnv.sustain += presetRegion.modEnv.sustain
                                                                            zoneRegion.modEnv.release += presetRegion.modEnv.release
                                                                            zoneRegion.initialFilterQ += presetRegion.initialFilterQ
                                                                            zoneRegion.initialFilterFc += presetRegion.initialFilterFc
                                                                            zoneRegion.modEnvToPitch += presetRegion.modEnvToPitch
                                                                            zoneRegion.modEnvToFilterFc += presetRegion.modEnvToFilterFc
                                                                            zoneRegion.delayModLFO += presetRegion.delayModLFO
                                                                            zoneRegion.freqModLFO += presetRegion.freqModLFO
                                                                            zoneRegion.modLfoToPitch += presetRegion.modLfoToPitch
                                                                            zoneRegion.modLfoToFilterFc += presetRegion.modLfoToFilterFc
                                                                            zoneRegion.modLfoToVolume += presetRegion.modLfoToVolume
                                                                            zoneRegion.delayVibLFO += presetRegion.delayVibLFO
                                                                            zoneRegion.freqVibLFO += presetRegion.freqVibLFO
                                                                            zoneRegion.vibLfoToPitch += presetRegion.vibLfoToPitch
                                                                            zoneRegion.ampEnv.envToSecs(true)
                                                                            zoneRegion.modEnv.envToSecs(false)
                                                                            zoneRegion.delayModLFO = if(zoneRegion.delayModLFO < -11950.0)  0.0 else alphaTab.synth.SynthHelper.timecents2Secs(zoneRegion.delayModLFO)
                                                                            zoneRegion.delayVibLFO = if(zoneRegion.delayVibLFO < -11950.0)  0.0 else alphaTab.synth.SynthHelper.timecents2Secs(zoneRegion.delayVibLFO)
                                                                            if (zoneRegion.pan < -0.5)
                                                                            {
                                                                                zoneRegion.pan = -0.5
                                                                            }
                                                                            else if (zoneRegion.pan > 0.5)
                                                                            {
                                                                                zoneRegion.pan = 0.5
                                                                            }
                                                                            if (zoneRegion.initialFilterQ < 1500 || zoneRegion.initialFilterQ > 13500)
                                                                            {
                                                                                zoneRegion.initialFilterQ = 0.0
                                                                            }
                                                                            var shdr: alphaTab.synth.soundfont.HydraShdr = hydra.sHdrs[(igen.genAmount.wordAmount).toInt()]
                                                                            zoneRegion.offset += shdr.start
                                                                            zoneRegion.end += shdr.end
                                                                            zoneRegion.loopStart += shdr.startLoop
                                                                            zoneRegion.loopEnd += shdr.endLoop
                                                                            if (shdr.endLoop > 0)
                                                                            {
                                                                                zoneRegion.loopEnd -= 1.0
                                                                            }
                                                                            if (zoneRegion.pitchKeyCenter == -1.0)
                                                                            {
                                                                                zoneRegion.pitchKeyCenter = shdr.originalPitch
                                                                            }
                                                                            zoneRegion.tune += shdr.pitchCorrection
                                                                            zoneRegion.sampleRate = shdr.sampleRate
                                                                            if (zoneRegion.end != 0.0 && zoneRegion.end < preset.fontSamples!!.length)
                                                                            {
                                                                                zoneRegion.end++
                                                                            }
                                                                            else 
                                                                            {
                                                                                zoneRegion.end = preset.fontSamples!!.length
                                                                            }
                                                                            preset.regions!![(regionIndex).toInt()] = alphaTab.synth.synthesis.Region(zoneRegion)
                                                                            regionIndex++
                                                                            hadSampleId = true
                                                                        }
                                                                        else 
                                                                        {
                                                                            zoneRegion.`operator`(igen.genOper, igen.genAmount)
                                                                        }
                                                                    }
                                                                    finally{
                                                                        igenIndex++
                                                                    }
                                                                }
                                                            }
                                                            if (ibag == hydra.ibags[(inst.instBagNdx).toInt()] && !hadSampleId)
                                                            {
                                                                instRegion = alphaTab.synth.synthesis.Region(zoneRegion)
                                                            }
                                                        }
                                                        finally{
                                                            ibagIndex++
                                                        }
                                                    }
                                                }
                                                hadGenInstrument = true
                                            }
                                            else 
                                            {
                                                presetRegion.`operator`(pgen.genOper, pgen.genAmount)
                                            }
                                        }
                                        finally{
                                            pgenIndex++
                                        }
                                    }
                                }
                                if (pbag == hydra.pbags[(phdr.presetBagNdx).toInt()] && !hadGenInstrument)
                                {
                                    globalRegion = presetRegion
                                }
                            }
                            finally{
                                pbagIndex++
                            }
                        }
                    }
                }
                finally{
                    phdrIndex++
                }
            }
        }
        if (!append || !alphaTab.core.TypeHelper.isTruthy(this.presets))
        {
            this.presets = newPresets
        }
        else 
        {
            for (preset in newPresets)
            {
                this.presets!!.push(preset)
            }
        }
    }
    
}

