// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.synth.synthesis
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Voice
{
    public var playingPreset: Double = 0.0
    
    public var playingKey: Double = 0.0
    
    public var playingChannel: Double = 0.0
    
    public var region: alphaTab.synth.synthesis.Region? = null
    
    public var pitchInputTimecents: Double = 0.0
    
    public var pitchOutputFactor: Double = 0.0
    
    public var sourceSamplePosition: Double = 0.0
    
    public var noteGainDb: Double = 0.0
    
    public var panFactorLeft: Double = 0.0
    
    public var panFactorRight: Double = 0.0
    
    public var playIndex: Double = 0.0
    
    public var loopStart: Double = 0.0
    
    public var loopEnd: Double = 0.0
    
    public var ampEnv: alphaTab.synth.synthesis.VoiceEnvelope = alphaTab.synth.synthesis.VoiceEnvelope()
    
    public var modEnv: alphaTab.synth.synthesis.VoiceEnvelope = alphaTab.synth.synthesis.VoiceEnvelope()
    
    public var lowPass: alphaTab.synth.synthesis.VoiceLowPass = alphaTab.synth.synthesis.VoiceLowPass()
    
    public var modLfo: alphaTab.synth.synthesis.VoiceLfo = alphaTab.synth.synthesis.VoiceLfo()
    
    public var vibLfo: alphaTab.synth.synthesis.VoiceLfo = alphaTab.synth.synthesis.VoiceLfo()
    
    public var mixVolume: Double = 0.0
    
    public var mute: Boolean = false
    
    /**
     */
    public fun updatePitchRatio(c: alphaTab.synth.synthesis.Channel, outSampleRate: Double): Unit{
        var pitchWheel: Double = c.pitchWheel
        if (c.perNotePitchWheel.has(this.playingKey))
        {
            pitchWheel += (c.perNotePitchWheel.get(this.playingKey)!! - 8192.0)
        }
        var pitchShift: Double = if(pitchWheel == 8192.0)  c.tuning else (pitchWheel / (16383.0).toDouble() * c.pitchRange * 2.0) - c.pitchRange + c.tuning
        this.calcPitchRatio(pitchShift, outSampleRate)
    }
    
    /**
     */
    public fun calcPitchRatio(pitchShift: Double, outSampleRate: Double): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.region))
        {
            return
        }
        var note: Double = this.playingKey + this.region!!.transpose + this.region!!.tune / (100.0).toDouble()
        var adjustedPitch: Double = this.region!!.pitchKeyCenter + (note - this.region!!.pitchKeyCenter) * (this.region!!.pitchKeyTrack / (100.0).toDouble())
        if (pitchShift != 0.0)
            adjustedPitch += pitchShift
        this.pitchInputTimecents = adjustedPitch * 100.0
        this.pitchOutputFactor = this.region!!.sampleRate / (alphaTab.synth.SynthHelper.timecents2Secs(this.region!!.pitchKeyCenter * 100.0) * outSampleRate)
    }
    
    /**
     */
    public fun end(outSampleRate: Double): Unit{
        if (!alphaTab.core.TypeHelper.isTruthy(this.region))
        {
            return
        }
        this.ampEnv.nextSegment(alphaTab.synth.synthesis.VoiceEnvelopeSegment.Sustain, outSampleRate)
        this.modEnv.nextSegment(alphaTab.synth.synthesis.VoiceEnvelopeSegment.Sustain, outSampleRate)
        if (this.region!!.loopMode == alphaTab.synth.synthesis.LoopMode.Sustain)
        {
            this.loopEnd = this.loopStart
        }
    }
    
    /**
     */
    public fun endQuick(outSampleRate: Double): Unit{
        this.ampEnv.parameters!!.release = 0.0
        this.ampEnv.nextSegment(alphaTab.synth.synthesis.VoiceEnvelopeSegment.Sustain, outSampleRate)
        this.modEnv.parameters!!.release = 0.0
        this.modEnv.nextSegment(alphaTab.synth.synthesis.VoiceEnvelopeSegment.Sustain, outSampleRate)
    }
    
    /**
     */
    public fun render(f: alphaTab.synth.synthesis.TinySoundFont, outputBuffer: alphaTab.core.ecmaScript.Float32Array, offset: Double, numSamples: Double, isMuted: Boolean): Unit{
        var paramnumSamples = numSamples
        if (!alphaTab.core.TypeHelper.isTruthy(this.region))
        {
            return
        }
        var region: alphaTab.synth.synthesis.Region = this.region!!
        var preset: alphaTab.synth.synthesis.Preset = f.presets!![(this.playingPreset).toInt()]
        var input: alphaTab.core.ecmaScript.Float32Array = preset.fontSamples!!
        var outL: Double = 0.0
        var outR: Double = if(f.outputMode == alphaTab.synth.synthesis.OutputMode.StereoUnweaved)  paramnumSamples else -1.0
        var updateModEnv: Boolean = region.modEnvToPitch != 0.0 || region.modEnvToFilterFc != 0.0
        var updateModLFO: Boolean = this.modLfo.delta > 0 && (region.modLfoToPitch != 0.0 || region.modLfoToFilterFc != 0.0 || region.modLfoToVolume != 0.0)
        var updateVibLFO: Boolean = this.vibLfo.delta > 0 && region.vibLfoToPitch != 0.0
        var isLooping: Boolean = this.loopStart < this.loopEnd
        var tmpLoopStart: Double = this.loopStart
        var tmpLoopEnd: Double = this.loopEnd
        var tmpSampleEndDbl: Double = region.end
        var tmpLoopEndDbl: Double = tmpLoopEnd + 1.0
        var tmpSourceSamplePosition: Double = this.sourceSamplePosition
        var tmpLowpass: alphaTab.synth.synthesis.VoiceLowPass = alphaTab.synth.synthesis.VoiceLowPass(this.lowPass)
        var dynamicLowpass: Boolean = region.modLfoToFilterFc != 0.0 || region.modEnvToFilterFc != 0.0
        var tmpSampleRate: Double = 0.0
        var tmpInitialFilterFc: Double = 0.0
        var tmpModLfoToFilterFc: Double = 0.0
        var tmpModEnvToFilterFc: Double = 0.0
        var dynamicPitchRatio: Boolean = region.modLfoToPitch != 0.0 || region.modEnvToPitch != 0.0 || region.vibLfoToPitch != 0.0
        var pitchRatio: Double = 0.0
        var tmpModLfoToPitch: Double = 0.0
        var tmpVibLfoToPitch: Double = 0.0
        var tmpModEnvToPitch: Double = 0.0
        var dynamicGain: Boolean = region.modLfoToVolume != 0.0
        var noteGain: Double = 0.0
        var tmpModLfoToVolume: Double = 0.0
        if (dynamicLowpass)
        {
            tmpSampleRate = f.outSampleRate
            tmpInitialFilterFc = region.initialFilterFc
            tmpModLfoToFilterFc = region.modLfoToFilterFc
            tmpModEnvToFilterFc = region.modEnvToFilterFc
        }
        else 
        {
            tmpSampleRate = 0.0
            tmpInitialFilterFc = 0.0
            tmpModLfoToFilterFc = 0.0
            tmpModEnvToFilterFc = 0.0
        }
        if (dynamicPitchRatio)
        {
            pitchRatio = 0.0
            tmpModLfoToPitch = region.modLfoToPitch
            tmpVibLfoToPitch = region.vibLfoToPitch
            tmpModEnvToPitch = region.modEnvToPitch
        }
        else 
        {
            pitchRatio = alphaTab.synth.SynthHelper.timecents2Secs(this.pitchInputTimecents) * this.pitchOutputFactor
            tmpModLfoToPitch = 0.0
            tmpVibLfoToPitch = 0.0
            tmpModEnvToPitch = 0.0
        }
        if (dynamicGain)
        {
            tmpModLfoToVolume = region.modLfoToVolume * 0.1
        }
        else 
        {
            noteGain = alphaTab.synth.SynthHelper.decibelsToGain(this.noteGainDb)
            tmpModLfoToVolume = 0.0
        }
        while (paramnumSamples > 0)
        {
            var gainMono: Double
            var gainLeft: Double
            var gainRight: Double = 0.0
            var blockSamples: Double = if(paramnumSamples > alphaTab.synth.synthesis.Voice.RenderEffectSampleBlock)  alphaTab.synth.synthesis.Voice.RenderEffectSampleBlock else paramnumSamples
            paramnumSamples -= blockSamples
            if (dynamicLowpass)
            {
                var fres: Double = tmpInitialFilterFc + this.modLfo.level * tmpModLfoToFilterFc + this.modEnv.level * tmpModEnvToFilterFc
                tmpLowpass.active = fres <= 13500
                if (tmpLowpass.active)
                {
                    tmpLowpass.setup(alphaTab.synth.SynthHelper.cents2Hertz(fres) / tmpSampleRate)
                }
            }
            if (dynamicPitchRatio)
            {
                pitchRatio = alphaTab.synth.SynthHelper.timecents2Secs(this.pitchInputTimecents + (this.modLfo.level * tmpModLfoToPitch + this.vibLfo.level * tmpVibLfoToPitch + this.modEnv.level * tmpModEnvToPitch)) * this.pitchOutputFactor
            }
            if (dynamicGain)
            {
                noteGain = alphaTab.synth.SynthHelper.decibelsToGain(this.noteGainDb + this.modLfo.level * tmpModLfoToVolume)
            }
            gainMono = noteGain * this.ampEnv.level
            if (isMuted)
            {
                gainMono = 0.0
            }
            else 
            {
                gainMono *= this.mixVolume
            }
            this.ampEnv.process(blockSamples, f.outSampleRate)
            if (updateModEnv)
            {
                this.modEnv.process(blockSamples, f.outSampleRate)
            }
            if (updateModLFO)
            {
                this.modLfo.process(blockSamples)
            }
            if (updateVibLFO)
            {
                this.vibLfo.process(blockSamples)
            }
            when (f.outputMode)
            {
                alphaTab.synth.synthesis.OutputMode.StereoInterleaved -> 
                {
                    gainLeft = gainMono * this.panFactorLeft
                    gainRight = gainMono * this.panFactorRight
                    while (blockSamples-- > 0 && tmpSourceSamplePosition < tmpSampleEndDbl)
                    {
                        var pos: Double = ((tmpSourceSamplePosition).toInt() or 0).toDouble()
                        var nextPos: Double = if(pos >= tmpLoopEnd && isLooping)  tmpLoopStart else pos + 1.0
                        var alpha: Double = tmpSourceSamplePosition - pos
                        var value: Double = input[(pos).toInt()] * (1.0 - alpha) + input[(nextPos).toInt()] * alpha
                        if (tmpLowpass.active)
                            value = tmpLowpass.process(value)
                        outputBuffer[(offset + outL).toInt()] += value * gainLeft
                        outL++
                        outputBuffer[(offset + outL).toInt()] += value * gainRight
                        outL++
                        tmpSourceSamplePosition += pitchRatio
                        if (tmpSourceSamplePosition >= tmpLoopEndDbl && isLooping)
                        {
                            tmpSourceSamplePosition -= tmpLoopEnd - tmpLoopStart + 1.0
                        }
                    }
                }
                alphaTab.synth.synthesis.OutputMode.StereoUnweaved -> 
                {
                    gainLeft = gainMono * this.panFactorLeft
                    gainRight = gainMono * this.panFactorRight
                    while (blockSamples-- > 0 && tmpSourceSamplePosition < tmpSampleEndDbl)
                    {
                        var pos: Double = ((tmpSourceSamplePosition).toInt() or 0).toDouble()
                        var nextPos: Double = if(pos >= tmpLoopEnd && isLooping)  tmpLoopStart else pos + 1.0
                        var alpha: Double = tmpSourceSamplePosition - pos
                        var value: Double = input[(pos).toInt()] * (1.0 - alpha) + input[(nextPos).toInt()] * alpha
                        if (tmpLowpass.active)
                            value = tmpLowpass.process(value)
                        outputBuffer[(offset + outL).toInt()] += value * gainLeft
                        outL++
                        outputBuffer[(offset + outR).toInt()] += value * gainRight
                        outR++
                        tmpSourceSamplePosition += pitchRatio
                        if (tmpSourceSamplePosition >= tmpLoopEndDbl && isLooping)
                        {
                            tmpSourceSamplePosition -= tmpLoopEnd - tmpLoopStart + 1.0
                        }
                    }
                }
                alphaTab.synth.synthesis.OutputMode.Mono -> 
                {
                    while (blockSamples-- > 0 && tmpSourceSamplePosition < tmpSampleEndDbl)
                    {
                        var pos: Double = ((tmpSourceSamplePosition).toInt() or 0).toDouble()
                        var nextPos: Double = if(pos >= tmpLoopEnd && isLooping)  tmpLoopStart else pos + 1.0
                        var alpha: Double = tmpSourceSamplePosition - pos
                        var value: Double = input[(pos).toInt()] * (1.0 - alpha) + input[(nextPos).toInt()] * alpha
                        if (tmpLowpass.active)
                            value = tmpLowpass.process(value)
                        outputBuffer[(offset + outL).toInt()] = value * gainMono
                        outL++
                        tmpSourceSamplePosition += pitchRatio
                        if (tmpSourceSamplePosition >= tmpLoopEndDbl && isLooping)
                        {
                            tmpSourceSamplePosition -= tmpLoopEnd - tmpLoopStart + 1.0
                        }
                    }
                }
                else -> { }
            }
            if (tmpSourceSamplePosition >= tmpSampleEndDbl || this.ampEnv.segment == alphaTab.synth.synthesis.VoiceEnvelopeSegment.Done)
            {
                this.kill()
                return
            }
        }
        this.sourceSamplePosition = tmpSourceSamplePosition
        if (tmpLowpass.active || dynamicLowpass)
        {
            this.lowPass = tmpLowpass
        }
    }
    
    public fun kill(): Unit{
        this.playingPreset = -1.0
    }
    
    companion object{
        /**
         * The lower this block size is the more accurate the effects are.
         * Increasing the value significantly lowers the CPU usage of the voice rendering.
         * If LFO affects the low-pass filter it can be hearable even as low as 8.
         */
        @kotlin.jvm.JvmStatic
        private val RenderEffectSampleBlock: Double = alphaTab.synth.SynthConstants.MicroBufferSize
        
    }
    public constructor()
}

