// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.xml
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class XmlWriter
{
    private var _result: alphaTab.collections.List<String> = alphaTab.collections.List<String>(
    )
    
    
    private var _indention: String
    
    private var _xmlHeader: Boolean
    
    private var _isStartOfLine: Boolean
    
    private var _currentIndention: String
    
    public constructor(indention: String, xmlHeader: Boolean){
        this._indention = indention
        this._xmlHeader = xmlHeader
        this._currentIndention = ""
        this._isStartOfLine = true
    }
    
    /**
     */
    public fun writeNode(xml: alphaTab.xml.XmlNode): Unit{
        when (xml.nodeType)
        {
            alphaTab.xml.XmlNodeType.None -> 
            {
            }
            alphaTab.xml.XmlNodeType.Element -> 
            {
                if (this._result.length > 0)
                {
                    this.writeLine()
                }
                this.write("""<${(xml.localName).toTemplate()}""")
                for ((name, value) in xml.attributes)
                {
                    this.write(""" ${(name).toTemplate()}="""")
                    this.writeAttributeValue(value)
                    this.write("\"")
                }
                if (xml.childNodes.length == 0.0)
                {
                    this.write("/>")
                }
                else 
                {
                    this.write(">")
                    if (xml.childNodes.length == 1.0 && !alphaTab.core.TypeHelper.isTruthy(xml.firstElement))
                    {
                        this.writeNode(xml.childNodes[(0).toInt()])
                    }
                    else 
                    {
                        this.indent()
                        for (child in xml.childNodes)
                        {
                            if (child.nodeType == alphaTab.xml.XmlNodeType.Element)
                            {
                                this.writeNode(child)
                            }
                        }
                        this.unindend()
                        this.writeLine()
                    }
                    this.write("""</${(xml.localName).toTemplate()}>""")
                }
            }
            alphaTab.xml.XmlNodeType.Text -> 
            {
                if (alphaTab.core.TypeHelper.isTruthy(xml.value))
                {
                    this.write(xml.value!!)
                }
            }
            alphaTab.xml.XmlNodeType.CDATA -> 
            {
                if (xml.value != null)
                {
                    this.write("""<![CDATA[${(xml.value).toTemplate()}]]>""")
                }
            }
            alphaTab.xml.XmlNodeType.Document -> 
            {
                if (this._xmlHeader)
                {
                    this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>")
                }
                for (child in xml.childNodes)
                {
                    this.writeNode(child)
                }
            }
            alphaTab.xml.XmlNodeType.DocumentType -> 
            {
                this.write("""<!DOCTYPE ${(xml.value).toTemplate()}>""")
            }
            else -> { }
        }
    }
    
    private fun unindend(): Unit{
        this._currentIndention = this._currentIndention.substr(0.0, this._currentIndention.length.toDouble() - this._indention.length.toDouble())
    }
    
    private fun indent(): Unit{
        this._currentIndention += this._indention
    }
    
    /**
     */
    private fun writeAttributeValue(value: String): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < value.length.toDouble()){
                try{
                    var c: String = value.charAt(i)
                    when (c)
                    {
                        "<" -> 
                        {
                            this._result.push("&lt;")
                        }
                        ">" -> 
                        {
                            this._result.push("&gt;")
                        }
                        "&" -> 
                        {
                            this._result.push("&amp;")
                        }
                        "'" -> 
                        {
                            this._result.push("&apos;")
                        }
                        "\"" -> 
                        {
                            this._result.push("&quot;")
                        }
                        else -> 
                        {
                            this._result.push(c)
                        }
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     */
    private fun write(s: String): Unit{
        if (this._isStartOfLine)
        {
            this._result.push(this._currentIndention)
        }
        this._result.push(s)
        this._isStartOfLine = false
    }
    
    /**
     */
    private fun writeLine(s: String? = null): Unit{
        if (alphaTab.core.TypeHelper.isTruthy(s))
        {
            this.write(s)
        }
        if (this._indention.length.toDouble() > 0 && !this._isStartOfLine)
        {
            this._result.push("\n")
            this._isStartOfLine = true
        }
    }
    
    public override fun toString(): String{
        return this._result.join("").trimEnd()
    }
    
    companion object{
        /**
         */
        @kotlin.jvm.JvmStatic
        public fun write(xml: alphaTab.xml.XmlNode, indention: String, xmlHeader: Boolean): String{
            var writer: alphaTab.xml.XmlWriter = alphaTab.xml.XmlWriter(indention, xmlHeader)
            writer.writeNode(xml)
            return writer.toString()
        }
        
    }
}

