// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

/**
 * Computes Adler32 checksum for a stream of data. An Adler32
 * checksum is not as reliable as a CRC32 checksum, but a lot faster to
 * compute.
 * 
 * The specification for Adler32 may be found in RFC 1950.
 * ZLIB Compressed Data Format Specification version 3.3)
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Adler32
{
    /**
     * Returns the Adler32 data checksum computed so far.
     */
    public var value: Double = 1.0
    
    public constructor(){
        this.reset()
    }
    
    /**
     * Resets the Adler32 data checksum as if no update was ever called.
     */
    public fun reset(): Unit{
        this.value = 1.0
    }
    
    /**
     * Update Adler32 data checksum based on a portion of a block of data
     * @param `data` The array containing the data to add
     * @param offset Range start for data (inclusive)
     * @param count The number of bytes to checksum starting from offset
     */
    public fun update(`data`: alphaTab.core.ecmaScript.Uint8Array, offset: Double, count: Double): Unit{
        var paramcount = count
        var paramoffset = offset
        var s1: Double = ((this.value).toInt() and 65535).toDouble()
        var s2: Double = ((this.value).toInt() shr 16).toDouble()
        while (paramcount > 0)
        {
            var n: Double = 3800.0
            if (n > paramcount)
            {
                n = paramcount
            }
            paramcount -= n
            while (--n >= 0)
            {
                s1 = s1 + ((`data`[(paramoffset++).toInt()]).toInt() and 255)
                s2 = s2 + s1
            }
            s1 %= alphaTab.zip.Adler32.Base
            s2 %= alphaTab.zip.Adler32.Base
        }
        this.value = (((s2).toInt() shl 16) or (s1).toInt()).toDouble()
    }
    
    companion object{
        /**
         * largest prime smaller than 65536
         */
        @kotlin.jvm.JvmStatic
        private val Base: Double = 65521.0
        
    }
}

