// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

/**
 * This is the Deflater class.  The deflater class compresses input
 * with the deflate algorithm described in RFC 1951.  It has several
 * compression levels and three different strategies described below.
 * 
 * This class is <i>not</i> thread safe.  This is inherent in the API, due
 * to the split of deflate and setInput.
 * 
 * author of the original java version : Jochen Hoenicke
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Deflater
{
    private var _state: Double = 0.0
    
    private var _pending: alphaTab.zip.PendingBuffer
    
    private var _engine: alphaTab.zip.DeflaterEngine
    
    public val inputCrc: Double
    get(){
        return this._engine.inputCrc.value
    }
    
    public constructor(){
        this._pending = alphaTab.zip.PendingBuffer(alphaTab.zip.DeflaterConstants.PENDING_BUF_SIZE)
        this._engine = alphaTab.zip.DeflaterEngine(this._pending)
        this.reset()
    }
    
    public val isNeedingInput: Boolean
    get(){
        return this._engine.needsInput()
    }
    
    public val isFinished: Boolean
    get(){
        return (this._state == alphaTab.zip.Deflater.FinishedState) && this._pending.isFlushed
    }
    
    /**
     * Resets the deflater. The deflater acts afterwards as if it was
     * just created with the same compression level and strategy as it
     * had before.
     */
    public fun reset(): Unit{
        this._state = alphaTab.zip.Deflater.BusyState
        this._pending.reset()
        this._engine.reset()
    }
    
    /**
     * Sets the data which should be compressed next.  This should be
     * only called when needsInput indicates that more input is needed.
     * The given byte array should not be changed, before needsInput() returns
     * true again.
     * @param input the buffer containing the input data.
     * @param offset the start of the data.
     * @param count the number of data bytes of input.
     */
    public fun setInput(input: alphaTab.core.ecmaScript.Uint8Array, offset: Double, count: Double): Unit{
        this._engine.setInput(input, offset, count)
    }
    
    /**
     * Deflates the current input block to the given array.
     * @param output Buffer to store the compressed data.
     * @param offset Offset into the output array.
     * @param length The maximum number of bytes that may be stored.
     */
    public fun deflate(output: alphaTab.core.ecmaScript.Uint8Array, offset: Double, length: Double): Double{
        var paramoffset = offset
        var paramlength = length
        var origLength: Double = paramlength
        while (true)
        {
            var count: Double = this._pending.flush(output, paramoffset, paramlength)
            paramoffset += count
            paramlength -= count
            if (paramlength == 0.0 || this._state == alphaTab.zip.Deflater.FinishedState)
            {
                break
            }
            if (!this._engine.deflate(((this._state).toInt() and (alphaTab.zip.Deflater.IsFlushing).toInt()) != 0, ((this._state).toInt() and (alphaTab.zip.Deflater.IsFinishing).toInt()) != 0))
            {
                when (this._state)
                {
                    alphaTab.zip.Deflater.BusyState -> 
                    {
                        return origLength - paramlength
                    }
                    alphaTab.zip.Deflater.FlushingState -> 
                    {
                        var neededbits: Double = 8.0 + (((-this._pending.bitCount)).toInt() and 7)
                        while (neededbits > 0)
                        {
                            this._pending.writeBits(2.0, 10.0)
                            neededbits -= 10.0
                        }
                        this._state = alphaTab.zip.Deflater.BusyState
                    }
                    alphaTab.zip.Deflater.FinishingState -> 
                    {
                        this._pending.alignToByte()
                        this._state = alphaTab.zip.Deflater.FinishedState
                    }
                    else -> { }
                }
            }
        }
        return origLength - paramlength
    }
    
    /**
     * Finishes the deflater with the current input block.  It is an error
     * to give more input after this method was called.  This method must
     * be called to force all bytes to be flushed.
     */
    public fun finish(): Unit{
        this._state = ((this._state.toInt()) or (((alphaTab.zip.Deflater.IsFlushing).toInt() or (alphaTab.zip.Deflater.IsFinishing).toInt()))).toDouble()
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val IsFlushing: Double = 4.0
        
        @kotlin.jvm.JvmStatic
        private val IsFinishing: Double = 8.0
        
        @kotlin.jvm.JvmStatic
        private val BusyState: Double = 16.0
        
        @kotlin.jvm.JvmStatic
        private val FlushingState: Double = 20.0
        
        @kotlin.jvm.JvmStatic
        private val FinishingState: Double = 28.0
        
        @kotlin.jvm.JvmStatic
        private val FinishedState: Double = 30.0
        
    }
}

