// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

/**
 * Low level compression engine for deflate algorithm which uses a 32K sliding window
 * with secondary compression from Huffman/Shannon-Fano codes.
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class DeflaterEngine
{
    private var blockStart: Double
    
    private var maxChain: Double = 128.0
    
    private var niceLength: Double = 128.0
    
    private var goodLength: Double = 8.0
    
    /**
     * Hash index of string to be inserted
     */
    private var insertHashIndex: Double = 0.0
    
    /**
     * Points to the current character in the window.
     */
    private var strstart: Double
    
    /**
     * This array contains the part of the uncompressed stream that
     * is of relevance.  The current character is indexed by strstart.
     */
    private var window: alphaTab.core.ecmaScript.Uint8Array
    
    /**
     * Hashtable, hashing three characters to an index for window, so
     * that window[index]..window[index+2] have this hash code.
     * Note that the array should really be unsigned short, so you need
     * to and the values with 0xffff.
     */
    private var head: alphaTab.core.ecmaScript.Int16Array
    
    /**
     * <code>prev[index &amp; WMASK]</code> points to the previous index that has the
     * same hash code as the string starting at index.  This way
     * entries with the same hash code are in a linked list.
     * Note that the array should really be unsigned short, so you need
     * to and the values with 0xffff.
     */
    private var prev: alphaTab.core.ecmaScript.Int16Array
    
    /**
     * lookahead is the number of characters starting at strstart in
     * window that are valid.
     * So window[strstart] until window[strstart+lookahead-1] are valid
     * characters.
     */
    private var lookahead: Double = 0.0
    
    /**
     * The input data for compression.
     */
    private var inputBuf: alphaTab.core.ecmaScript.Uint8Array? = null
    
    /**
     * The offset into inputBuf, where input data starts.
     */
    private var inputOff: Double = 0.0
    
    /**
     * The end offset of the input data.
     */
    private var inputEnd: Double = 0.0
    
    /**
     * Set if previous match exists
     */
    private var prevAvailable: Boolean = false
    
    private var matchStart: Double = 0.0
    
    /**
     * Length of best match
     */
    private var matchLen: Double = 0.0
    
    private var pending: alphaTab.zip.PendingBuffer
    
    private var huffman: alphaTab.zip.DeflaterHuffman
    
    public var inputCrc: alphaTab.zip.Crc32
    public constructor(pending: alphaTab.zip.PendingBuffer){
        this.pending = pending
        this.huffman = alphaTab.zip.DeflaterHuffman(pending)
        this.inputCrc = alphaTab.zip.Crc32()
        this.window = alphaTab.core.ecmaScript.Uint8Array(2.0 * alphaTab.zip.DeflaterConstants.WSIZE)
        this.head = alphaTab.core.ecmaScript.Int16Array(alphaTab.zip.DeflaterConstants.HASH_SIZE)
        this.prev = alphaTab.core.ecmaScript.Int16Array(alphaTab.zip.DeflaterConstants.WSIZE)
        this.blockStart = 1.0
        this.strstart = 1.0
    }
    
    /**
     * Reset internal state
     */
    public fun reset(): Unit{
        this.huffman.reset()
        this.inputCrc.reset()
        this.blockStart = 1.0
        this.strstart = 1.0
        this.lookahead = 0.0
        this.prevAvailable = false
        this.matchLen = alphaTab.zip.DeflaterConstants.MIN_MATCH - 1.0
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterConstants.HASH_SIZE){
                try{
                    this.head[(i).toInt()] = 0.0
                }
                finally{
                    i++
                }
            }
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterConstants.WSIZE){
                try{
                    this.prev[(i).toInt()] = 0.0
                }
                finally{
                    i++
                }
            }
        }
    }
    
    private fun updateHash(): Unit{
        this.insertHashIndex = (((this.window[(this.strstart).toInt()]).toInt() shl (alphaTab.zip.DeflaterConstants.HASH_SHIFT).toInt()) xor (this.window[(this.strstart + 1.0).toInt()]).toInt()).toDouble()
    }
    
    /**
     * Determines if more input is needed.
     */
    public fun needsInput(): Boolean{
        return (this.inputEnd == this.inputOff)
    }
    
    /**
     * Sets input data to be deflated.  Should only be called when <code>NeedsInput()</code>
     * returns true
     * @param buffer The buffer containing input data.
     * @param offset The offset of the first byte of data.
     * @param count The number of bytes of data to use as input.
     */
    public fun setInput(buffer: alphaTab.core.ecmaScript.Uint8Array, offset: Double, count: Double): Unit{
        var end: Double = offset + count
        this.inputBuf = buffer
        this.inputOff = offset
        this.inputEnd = end
    }
    
    /**
     * Deflate drives actual compression of data
     * @param flush True to flush input buffers
     * @param finish Finish deflation with the current input.
     */
    public fun deflate(flush: Boolean, finish: Boolean): Boolean{
        var progress: Boolean
        do
        {
            this.fillWindow()
            var canFlush: Boolean = flush && (this.inputOff == this.inputEnd)
            progress = this.deflateSlow(canFlush, finish)
        }
        while (this.pending.isFlushed && progress)
        return progress
    }
    
    /**
     */
    private fun deflateSlow(flush: Boolean, finish: Boolean): Boolean{
        if (this.lookahead < alphaTab.zip.DeflaterConstants.MIN_LOOKAHEAD && !flush)
        {
            return false
        }
        while (this.lookahead >= alphaTab.zip.DeflaterConstants.MIN_LOOKAHEAD || flush)
        {
            if (this.lookahead == 0.0)
            {
                if (this.prevAvailable)
                {
                    this.huffman.tallyLit(((this.window[(this.strstart - 1.0).toInt()]).toInt() and 255).toDouble())
                }
                this.prevAvailable = false
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish)
                this.blockStart = this.strstart
                return false
            }
            if (this.strstart >= 2.0 * alphaTab.zip.DeflaterConstants.WSIZE - alphaTab.zip.DeflaterConstants.MIN_LOOKAHEAD)
            {
                this.slideWindow()
            }
            var prevMatch: Double = this.matchStart
            var prevLen: Double = this.matchLen
            if (this.lookahead >= alphaTab.zip.DeflaterConstants.MIN_MATCH)
            {
                var hashHead: Double = this.insertString()
                if (hashHead != 0.0 && this.strstart - hashHead <= alphaTab.zip.DeflaterConstants.MAX_DIST && this.findLongestMatch(hashHead))
                {
                    if (this.matchLen == alphaTab.zip.DeflaterConstants.MIN_MATCH && this.strstart - this.matchStart > alphaTab.zip.DeflaterEngine.TooFar)
                    {
                        this.matchLen = alphaTab.zip.DeflaterConstants.MIN_MATCH - 1.0
                    }
                }
            }
            if ((prevLen >= alphaTab.zip.DeflaterConstants.MIN_MATCH) && (this.matchLen <= prevLen))
            {
                this.huffman.tallyDist(this.strstart - 1.0 - prevMatch, prevLen)
                prevLen -= 2.0
                do
                {
                    this.strstart++
                    this.lookahead--
                    if (this.lookahead >= alphaTab.zip.DeflaterConstants.MIN_MATCH)
                    {
                        this.insertString()
                    }
                }
                while (--prevLen > 0)
                this.strstart++
                this.lookahead--
                this.prevAvailable = false
                this.matchLen = alphaTab.zip.DeflaterConstants.MIN_MATCH - 1.0
            }
            else 
            {
                if (this.prevAvailable)
                {
                    this.huffman.tallyLit(((this.window[(this.strstart - 1.0).toInt()]).toInt() and 255).toDouble())
                }
                this.prevAvailable = true
                this.strstart++
                this.lookahead--
            }
            if (this.huffman.isFull())
            {
                var len: Double = this.strstart - this.blockStart
                if (this.prevAvailable)
                {
                    len--
                }
                var lastBlock: Boolean = (finish && (this.lookahead == 0.0) && !this.prevAvailable)
                this.huffman.flushBlock(this.window, this.blockStart, len, lastBlock)
                this.blockStart += len
                return !lastBlock
            }
        }
        return true
    }
    
    /**
     * Find the best (longest) string in the window matching the
     * string starting at strstart.
     */
    private fun findLongestMatch(curMatch: Double): Boolean{
        var paramcurMatch = curMatch
        var match: Double
        var scan: Double = this.strstart
        var scanMax: Double = scan + alphaTab.core.ecmaScript.Math.min(alphaTab.zip.DeflaterConstants.MAX_MATCH, this.lookahead) - 1.0
        var limit: Double = alphaTab.core.ecmaScript.Math.max(scan - alphaTab.zip.DeflaterConstants.MAX_DIST, 0.0)
        var window: alphaTab.core.ecmaScript.Uint8Array = this.window
        var prev: alphaTab.core.ecmaScript.Int16Array = this.prev
        var chainLength: Double = this.maxChain
        var niceLength: Double = alphaTab.core.ecmaScript.Math.min(this.niceLength, this.lookahead)
        this.matchLen = alphaTab.core.ecmaScript.Math.max(this.matchLen, alphaTab.zip.DeflaterConstants.MIN_MATCH - 1.0)
        if (scan + this.matchLen > scanMax)
        {
            return false
        }
        var scan_end1: Double = window[(scan + this.matchLen - 1.0).toInt()]
        var scan_end: Double = window[(scan + this.matchLen).toInt()]
        if (this.matchLen >= this.goodLength)
        {
            chainLength = ((chainLength.toInt()) shr (2)).toDouble()
        }
        do
        {
            match = paramcurMatch
            scan = this.strstart
            if (window[(match + this.matchLen).toInt()] != scan_end || window[(match + this.matchLen - 1.0).toInt()] != scan_end1 || window[(match).toInt()] != window[(scan).toInt()] || window[(++match).toInt()] != window[(++scan).toInt()])
            {
                continue
            }
            when ((scanMax - scan) % 8.0)
            {
                1.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                2.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                3.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                4.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                5.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                6.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                7.0 -> 
                {
                    if (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
                        break
                }
                else -> { }
            }
            if (window[(scan).toInt()] == window[(match).toInt()])
            {
                do
                {
                    if (scan == scanMax)
                    {
                        ++scan
                        ++match
                        break
                    }
                }
                while (window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()] && window[(++scan).toInt()] == window[(++match).toInt()])
            }
            if (scan - this.strstart > this.matchLen)
            {
                this.matchStart = paramcurMatch
                this.matchLen = scan - this.strstart
                if (this.matchLen >= niceLength)
                {
                    break
                }
                scan_end1 = window[(scan - 1.0).toInt()]
                scan_end = window[(scan).toInt()]
            }
            paramcurMatch = (((prev[(((paramcurMatch).toInt() and (alphaTab.zip.DeflaterConstants.WMASK).toInt()).toDouble()).toInt()]).toInt() and 65535).toDouble())
        }
        while (paramcurMatch > limit && 0.0 != --chainLength)
        return this.matchLen >= alphaTab.zip.DeflaterConstants.MIN_MATCH
    }
    
    /**
     * Inserts the current string in the head hash and returns the previous
     * value for this hash.
     */
    private fun insertString(): Double{
        var match: Double
        var hash: Double = ((((this.insertHashIndex).toInt() shl (alphaTab.zip.DeflaterConstants.HASH_SHIFT).toInt()) xor (this.window[(this.strstart + (alphaTab.zip.DeflaterConstants.MIN_MATCH - 1.0)).toInt()]).toInt()) and (alphaTab.zip.DeflaterConstants.HASH_MASK).toInt()).toDouble()
        match = this.head[(hash).toInt()]
        this.prev[(((this.strstart).toInt() and (alphaTab.zip.DeflaterConstants.WMASK).toInt()).toDouble()).toInt()] = match
        this.head[(hash).toInt()] = this.strstart
        this.insertHashIndex = hash
        return ((match).toInt() and 65535).toDouble()
    }
    
    /**
     * Fill the window
     */
    public fun fillWindow(): Unit{
        if (this.strstart >= alphaTab.zip.DeflaterConstants.WSIZE + alphaTab.zip.DeflaterConstants.MAX_DIST)
        {
            this.slideWindow()
        }
        if (this.lookahead < alphaTab.zip.DeflaterConstants.MIN_LOOKAHEAD && this.inputOff < this.inputEnd)
        {
            var more: Double = 2.0 * alphaTab.zip.DeflaterConstants.WSIZE - this.lookahead - this.strstart
            if (more > this.inputEnd - this.inputOff)
            {
                more = this.inputEnd - this.inputOff
            }
            this.window.set(this.inputBuf!!.subarray(this.inputOff, this.inputOff + more), this.strstart + this.lookahead)
            this.inputCrc.update(this.inputBuf!!, this.inputOff, more)
            this.inputOff += more
            this.lookahead += more
        }
        if (this.lookahead >= alphaTab.zip.DeflaterConstants.MIN_MATCH)
        {
            this.updateHash()
        }
    }
    
    private fun slideWindow(): Unit{
        this.window.set(this.window.subarray(alphaTab.zip.DeflaterConstants.WSIZE, alphaTab.zip.DeflaterConstants.WSIZE + alphaTab.zip.DeflaterConstants.WSIZE), 0.0)
        this.matchStart -= alphaTab.zip.DeflaterConstants.WSIZE
        this.strstart -= alphaTab.zip.DeflaterConstants.WSIZE
        this.blockStart -= alphaTab.zip.DeflaterConstants.WSIZE
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterConstants.HASH_SIZE){
                try{
                    var m: Double = ((this.head[(i).toInt()]).toInt() and 65535).toDouble()
                    this.head[(i).toInt()] = (if(m >= alphaTab.zip.DeflaterConstants.WSIZE)  (m - alphaTab.zip.DeflaterConstants.WSIZE) else 0.0)
                }
                finally{
                    ++i
                }
            }
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterConstants.WSIZE){
                try{
                    var m: Double = ((this.prev[(i).toInt()]).toInt() and 65535).toDouble()
                    this.prev[(i).toInt()] = (if(m >= alphaTab.zip.DeflaterConstants.WSIZE)  (m - alphaTab.zip.DeflaterConstants.WSIZE) else 0.0)
                }
                finally{
                    i++
                }
            }
        }
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val TooFar: Double = 4096.0
        
    }
}

