// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class DeflaterHuffman
{
    /**
     * Pending buffer to use
     */
    public var pending: alphaTab.zip.PendingBuffer
    private var literalTree: alphaTab.zip.Tree
    
    private var distTree: alphaTab.zip.Tree
    
    private var blTree: alphaTab.zip.Tree
    
    private var d_buf: alphaTab.core.ecmaScript.Int16Array
    
    private var l_buf: alphaTab.core.ecmaScript.Uint8Array
    
    private var last_lit: Double = 0.0
    
    private var extra_bits: Double = 0.0
    
    public constructor(pending: alphaTab.zip.PendingBuffer){
        this.pending = pending
        this.literalTree = alphaTab.zip.Tree(this, (alphaTab.zip.DeflaterHuffman.LITERAL_NUM.toDouble()), 257.0, 15.0)
        this.distTree = alphaTab.zip.Tree(this, (alphaTab.zip.DeflaterHuffman.DIST_NUM.toDouble()), 1.0, 15.0)
        this.blTree = alphaTab.zip.Tree(this, (alphaTab.zip.DeflaterHuffman.BITLEN_NUM.toDouble()), 4.0, 7.0)
        this.d_buf = alphaTab.core.ecmaScript.Int16Array(alphaTab.zip.DeflaterHuffman.BUFSIZE)
        this.l_buf = alphaTab.core.ecmaScript.Uint8Array(alphaTab.zip.DeflaterHuffman.BUFSIZE)
    }
    
    public fun isFull(): Boolean{
        return this.last_lit >= alphaTab.zip.DeflaterHuffman.BUFSIZE
    }
    
    public fun reset(): Unit{
        this.last_lit = 0.0
        this.extra_bits = 0.0
        this.literalTree.reset()
        this.distTree.reset()
        this.blTree.reset()
    }
    
    /**
     */
    public fun flushStoredBlock(stored: alphaTab.core.ecmaScript.Uint8Array, storedOffset: Double, storedLength: Double, lastBlock: Boolean): Unit{
        this.pending.writeBits(((alphaTab.zip.DeflaterHuffman.STORED_BLOCK).toInt() shl 1) + (if(lastBlock)  1.0 else 0.0), 3.0)
        this.pending.alignToByte()
        this.pending.writeShort(storedLength)
        this.pending.writeShort(((storedLength).toInt()).toInt().inv().toDouble())
        this.pending.writeBlock(stored, storedOffset, storedLength)
        this.reset()
    }
    
    /**
     */
    public fun flushBlock(stored: alphaTab.core.ecmaScript.Uint8Array, storedOffset: Double, storedLength: Double, lastBlock: Boolean): Unit{
        this.literalTree.freqs[(alphaTab.zip.DeflaterHuffman.EOF_SYMBOL).toInt()]++
        this.literalTree.buildTree()
        this.distTree.buildTree()
        this.literalTree.calcBLFreq(this.blTree)
        this.distTree.calcBLFreq(this.blTree)
        this.blTree.buildTree()
        var blTreeCodes: Double = 4.0
        if(true) {
            var i: Double = 18.0
            
            while(i > blTreeCodes){
                try{
                    if (this.blTree.length!![(alphaTab.zip.DeflaterHuffman.BL_ORDER[(i).toInt()]).toInt()] > 0)
                    {
                        blTreeCodes = i + 1.0
                    }
                }
                finally{
                    i--
                }
            }
        }
        var opt_len: Double = 14.0 + blTreeCodes * 3.0 + this.blTree.getEncodedLength() + this.literalTree.getEncodedLength() + this.distTree.getEncodedLength() + this.extra_bits
        var static_len: Double = this.extra_bits
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterHuffman.LITERAL_NUM){
                try{
                    static_len += this.literalTree.freqs[(i).toInt()] * alphaTab.zip.DeflaterHuffman.staticLLength[(i).toInt()]
                }
                finally{
                    i++
                }
            }
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < alphaTab.zip.DeflaterHuffman.DIST_NUM){
                try{
                    static_len += this.distTree.freqs[(i).toInt()] * alphaTab.zip.DeflaterHuffman.staticDLength[(i).toInt()]
                }
                finally{
                    i++
                }
            }
        }
        if (opt_len >= static_len)
        {
            opt_len = static_len
        }
        if (storedOffset >= 0 && storedLength + 4.0 < (opt_len).toInt() shr 3)
        {
            this.flushStoredBlock(stored, storedOffset, storedLength, lastBlock)
        }
        else if (opt_len == static_len)
        {
            this.pending.writeBits(((alphaTab.zip.DeflaterHuffman.STATIC_TREES).toInt() shl 1) + (if(lastBlock)  1.0 else 0.0), 3.0)
            this.literalTree.setStaticCodes(alphaTab.zip.DeflaterHuffman.staticLCodes, alphaTab.zip.DeflaterHuffman.staticLLength)
            this.distTree.setStaticCodes(alphaTab.zip.DeflaterHuffman.staticDCodes, alphaTab.zip.DeflaterHuffman.staticDLength)
            this.compressBlock()
            this.reset()
        }
        else 
        {
            this.pending.writeBits(((alphaTab.zip.DeflaterHuffman.DYN_TREES).toInt() shl 1) + (if(lastBlock)  1.0 else 0.0), 3.0)
            this.sendAllTrees(blTreeCodes)
            this.compressBlock()
            this.reset()
        }
    }
    
    /**
     * Write all trees to pending buffer
     * @param blTreeCodes The number/rank of treecodes to send.
     */
    public fun sendAllTrees(blTreeCodes: Double): Unit{
        this.blTree.buildCodes()
        this.literalTree.buildCodes()
        this.distTree.buildCodes()
        this.pending.writeBits(this.literalTree.numCodes - 257.0, 5.0)
        this.pending.writeBits(this.distTree.numCodes - 1.0, 5.0)
        this.pending.writeBits(blTreeCodes - 4.0, 4.0)
        if(true) {
            var rank: Double = 0.0
            
            while(rank < blTreeCodes){
                try{
                    this.pending.writeBits(this.blTree.length!![(alphaTab.zip.DeflaterHuffman.BL_ORDER[(rank).toInt()]).toInt()], 3.0)
                }
                finally{
                    rank++
                }
            }
        }
        this.literalTree.writeTree(this.blTree)
        this.distTree.writeTree(this.blTree)
    }
    
    /**
     * Compress current buffer writing data to pending buffer
     */
    public fun compressBlock(): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < this.last_lit){
                try{
                    var litlen: Double = ((this.l_buf[(i).toInt()]).toInt() and 255).toDouble()
                    var dist: Double = this.d_buf[(i).toInt()]
                    if (dist-- != 0.0)
                    {
                        var lc: Double = alphaTab.zip.DeflaterHuffman.Lcode(litlen)
                        this.literalTree.writeSymbol(lc)
                        var bits: Double = alphaTab.core.ecmaScript.Math.floor((lc - 261.0) / (4.0).toDouble())
                        if (bits > 0 && bits <= 5)
                        {
                            this.pending.writeBits(((litlen).toInt() and (((1 shl (bits).toInt()) - 1.0)).toInt()).toDouble(), bits)
                        }
                        var dc: Double = alphaTab.zip.DeflaterHuffman.Dcode(dist)
                        this.distTree.writeSymbol(dc)
                        bits = alphaTab.core.ecmaScript.Math.floor(dc / (2.0).toDouble()) - 1.0
                        if (bits > 0)
                        {
                            this.pending.writeBits(((dist).toInt() and (((1 shl (bits).toInt()) - 1.0)).toInt()).toDouble(), bits)
                        }
                    }
                    else 
                    {
                        this.literalTree.writeSymbol(litlen)
                    }
                }
                finally{
                    i++
                }
            }
        }
        this.literalTree.writeSymbol((alphaTab.zip.DeflaterHuffman.EOF_SYMBOL.toDouble()))
    }
    
    /**
     * Add distance code and length to literal and distance trees
     * @param distance Distance code
     * @param length Length
     */
    public fun tallyDist(distance: Double, length: Double): Boolean{
        this.d_buf[(this.last_lit).toInt()] = distance
        this.l_buf[(this.last_lit++).toInt()] = length - 3.0
        var lc: Double = alphaTab.zip.DeflaterHuffman.Lcode(length - 3.0)
        this.literalTree.freqs[(lc).toInt()]++
        if (lc >= 265 && lc < 285)
        {
            this.extra_bits += alphaTab.core.ecmaScript.Math.floor((lc - 261.0) / (4.0).toDouble())
        }
        var dc: Double = alphaTab.zip.DeflaterHuffman.Dcode(distance - 1.0)
        this.distTree.freqs[(dc).toInt()]++
        if (dc >= 4)
        {
            this.extra_bits += alphaTab.core.ecmaScript.Math.floor(dc / (2.0).toDouble()) - 1.0
        }
        return this.isFull()
    }
    
    /**
     * Add literal to buffer
     * @param literal Literal value to add to buffer
     */
    public fun tallyLit(literal: Double): Boolean{
        this.d_buf[(this.last_lit).toInt()] = 0.0
        this.l_buf[(this.last_lit++).toInt()] = literal
        this.literalTree.freqs[(literal).toInt()]++
        return this.isFull()
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val BUFSIZE: Double = (1 shl ((alphaTab.zip.DeflaterConstants.DEFAULT_MEM_LEVEL + 6.0)).toInt()).toDouble()
        
        @kotlin.jvm.JvmStatic
        private val LITERAL_NUM: Double = 286.0
        
        /**
         * Written to Zip file to identify a stored block
         */
        @kotlin.jvm.JvmStatic
        public val STORED_BLOCK: Double = 0.0
        
        /**
         * Identifies static tree in Zip file
         */
        @kotlin.jvm.JvmStatic
        public val STATIC_TREES: Double = 1.0
        
        /**
         * Identifies dynamic tree in Zip file
         */
        @kotlin.jvm.JvmStatic
        public val DYN_TREES: Double = 2.0
        
        @kotlin.jvm.JvmStatic
        private val DIST_NUM: Double = 30.0
        
        @kotlin.jvm.JvmStatic
        private var staticLCodes: alphaTab.core.ecmaScript.Int16Array = alphaTab.core.ecmaScript.Int16Array((alphaTab.zip.DeflaterHuffman.LITERAL_NUM.toDouble()))
        
        @kotlin.jvm.JvmStatic
        private var staticLLength: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array((alphaTab.zip.DeflaterHuffman.LITERAL_NUM.toDouble()))
        
        @kotlin.jvm.JvmStatic
        private var staticDCodes: alphaTab.core.ecmaScript.Int16Array = alphaTab.core.ecmaScript.Int16Array((alphaTab.zip.DeflaterHuffman.DIST_NUM.toDouble()))
        
        @kotlin.jvm.JvmStatic
        private var staticDLength: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array((alphaTab.zip.DeflaterHuffman.DIST_NUM.toDouble()))
        
        @kotlin.jvm.JvmStatic
        public fun staticInit(): Unit{
            var i: Double = 0.0
            while (i < 144)
            {
                alphaTab.zip.DeflaterHuffman.staticLCodes[(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse((((48.0 + i)).toInt() shl 8).toDouble())
                alphaTab.zip.DeflaterHuffman.staticLLength[(i++).toInt()] = 8.0
            }
            while (i < 256)
            {
                alphaTab.zip.DeflaterHuffman.staticLCodes[(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse((((400.0 - 144.0 + i)).toInt() shl 7).toDouble())
                alphaTab.zip.DeflaterHuffman.staticLLength[(i++).toInt()] = 9.0
            }
            while (i < 280)
            {
                alphaTab.zip.DeflaterHuffman.staticLCodes[(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse((((0.0 - 256.0 + i)).toInt() shl 9).toDouble())
                alphaTab.zip.DeflaterHuffman.staticLLength[(i++).toInt()] = 7.0
            }
            while (i < alphaTab.zip.DeflaterHuffman.LITERAL_NUM)
            {
                alphaTab.zip.DeflaterHuffman.staticLCodes[(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse((((192.0 - 280.0 + i)).toInt() shl 8).toDouble())
                alphaTab.zip.DeflaterHuffman.staticLLength[(i++).toInt()] = 8.0
            }
            if(true) {
                i = 0.0
                while(i < alphaTab.zip.DeflaterHuffman.DIST_NUM){
                    try{
                        alphaTab.zip.DeflaterHuffman.staticDCodes[(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse(((i).toInt() shl 11).toDouble())
                        alphaTab.zip.DeflaterHuffman.staticDLength[(i).toInt()] = 5.0
                    }
                    finally{
                        i++
                    }
                }
            }
        }
        
        @kotlin.jvm.JvmStatic
        private var BL_ORDER: alphaTab.collections.DoubleList = alphaTab.collections.DoubleList(
            
            16.0, 
            17.0, 
            18.0, 
            0.0, 
            8.0, 
            7.0, 
            9.0, 
            6.0, 
            10.0, 
            5.0, 
            11.0, 
            4.0, 
            12.0, 
            3.0, 
            13.0, 
            2.0, 
            14.0, 
            1.0, 
            15.0)
        
        
        @kotlin.jvm.JvmStatic
        private var bit4Reverse: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(alphaTab.collections.List(
        0.0, 
        8.0, 
        4.0, 
        12.0, 
        2.0, 
        10.0, 
        6.0, 
        14.0, 
        1.0, 
        9.0, 
        5.0, 
        13.0, 
        3.0, 
        11.0, 
        7.0, 
        15.0))
        
        /**
         * Reverse the bits of a 16 bit value.
         * @param toReverse Value to reverse bits
         */
        @kotlin.jvm.JvmStatic
        public fun bitReverse(toReverse: Double): Double{
            return ((((alphaTab.zip.DeflaterHuffman.bit4Reverse[(((toReverse).toInt() and 15).toDouble()).toInt()]).toInt() shl 12) or ((alphaTab.zip.DeflaterHuffman.bit4Reverse[((((toReverse).toInt() shr 4) and 15).toDouble()).toInt()]).toInt() shl 8) or ((alphaTab.zip.DeflaterHuffman.bit4Reverse[((((toReverse).toInt() shr 8) and 15).toDouble()).toInt()]).toInt() shl 4) or (alphaTab.zip.DeflaterHuffman.bit4Reverse[(((toReverse).toInt() shr 12).toDouble()).toInt()]).toInt()).toDouble())
        }
        
        @kotlin.jvm.JvmStatic
        private val BITLEN_NUM: Double = 19.0
        
        @kotlin.jvm.JvmStatic
        private val EOF_SYMBOL: Double = 256.0
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun Lcode(length: Double): Double{
            var paramlength = length
            if (paramlength == 255.0)
            {
                return 285.0
            }
            var code: Double = 257.0
            while (paramlength >= 8)
            {
                code += 4.0
                paramlength = ((paramlength).toInt() shr 1).toDouble()
            }
            return code + paramlength
        }
        
        /**
         */
        @kotlin.jvm.JvmStatic
        private fun Dcode(distance: Double): Double{
            var paramdistance = distance
            var code: Double = 0.0
            while (paramdistance >= 4)
            {
                code += 2.0
                paramdistance = ((paramdistance).toInt() shr 1).toDouble()
            }
            return code + paramdistance
        }
        
        init {
            alphaTab.zip.DeflaterHuffman.staticInit()
        }
        
    }
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class Tree
{
    public var freqs: alphaTab.core.ecmaScript.Int16Array
    public var length: alphaTab.core.ecmaScript.Uint8Array? = null
    
    public var minNumCodes: Double
    public var numCodes: Double = 0.0
    
    private var codes: alphaTab.core.ecmaScript.Int16Array? = null
    
    private var bitLengthCounts: alphaTab.core.ecmaScript.Int32Array
    
    private var maxLength: Double
    
    private var huffman: alphaTab.zip.DeflaterHuffman
    
    public constructor(dh: alphaTab.zip.DeflaterHuffman, elems: Double, minCodes: Double, maxLength: Double){
        this.huffman = dh
        this.minNumCodes = minCodes
        this.maxLength = maxLength
        this.freqs = alphaTab.core.ecmaScript.Int16Array(elems)
        this.bitLengthCounts = alphaTab.core.ecmaScript.Int32Array(maxLength)
    }
    
    /**
     * Resets the internal state of the tree
     */
    public fun reset(): Unit{
        if(true) {
            var i: Double = 0.0
            
            while(i < this.freqs.length){
                try{
                    this.freqs[(i).toInt()] = 0.0
                }
                finally{
                    i++
                }
            }
        }
        this.codes = null
        this.length = null
    }
    
    public fun buildTree(): Unit{
        var numSymbols: Double = this.freqs.length
        var heap: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(numSymbols)
        var heapLen: Double = 0.0
        var maxCode: Double = 0.0
        if(true) {
            var n: Double = 0.0
            
            while(n < numSymbols){
                try{
                    var freq: Double = this.freqs[(n).toInt()]
                    if (freq != 0.0)
                    {
                        var pos: Double = heapLen++
                        while (true)
                        {
                            if (pos > 0)
                            {
                                var ppos: Double = alphaTab.core.ecmaScript.Math.floor((pos - 1.0) / (2.0).toDouble())
                                if (this.freqs[(heap[(ppos).toInt()]).toInt()] > freq)
                                {
                                    heap[(pos).toInt()] = heap[(ppos).toInt()]
                                    pos = ppos
                                }
                                else 
                                {
                                    break
                                }
                            }
                            else 
                            {
                                break
                            }
                        }
                        heap[(pos).toInt()] = n
                        maxCode = n
                    }
                }
                finally{
                    n++
                }
            }
        }
        while (heapLen < 2)
        {
            var node: Double = if(maxCode < 2)  ++maxCode else 0.0
            heap[(heapLen++).toInt()] = node
        }
        this.numCodes = alphaTab.core.ecmaScript.Math.max(maxCode + 1.0, this.minNumCodes)
        var numLeafs: Double = heapLen
        var childs: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(4.0 * heapLen - 2.0)
        var values: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(2.0 * heapLen - 1.0)
        var numNodes: Double = numLeafs
        if(true) {
            var i: Double = 0.0
            
            while(i < heapLen){
                try{
                    var node: Double = heap[(i).toInt()]
                    childs[(2.0 * i).toInt()] = node
                    childs[(2.0 * i + 1.0).toInt()] = -1.0
                    values[(i).toInt()] = ((this.freqs[(node).toInt()]).toInt() shl 8).toDouble()
                    heap[(i).toInt()] = i
                }
                finally{
                    i++
                }
            }
        }
        do
        {
            var first: Double = heap[(0).toInt()]
            var last: Double = heap[(--heapLen).toInt()]
            var ppos: Double = 0.0
            var path: Double = 1.0
            while (path < heapLen)
            {
                if (path + 1.0 < heapLen && values[(heap[(path).toInt()]).toInt()] > values[(heap[(path + 1.0).toInt()]).toInt()])
                {
                    path++
                }
                heap[(ppos).toInt()] = heap[(path).toInt()]
                ppos = path
                path = path * 2.0 + 1.0
            }
            var lastVal: Double = values[(last).toInt()]
            while (true)
            {
                path = ppos
                if (ppos > 0)
                {
                    ppos = alphaTab.core.ecmaScript.Math.floor((path - 1.0) / (2.0).toDouble())
                    if (values[(heap[(ppos).toInt()]).toInt()] > lastVal)
                    {
                        heap[(path).toInt()] = heap[(ppos).toInt()]
                    }
                    else 
                    {
                        break
                    }
                }
                else 
                {
                    break
                }
            }
            heap[(path).toInt()] = last
            var second: Double = heap[(0).toInt()]
            last = numNodes++
            childs[(2.0 * last).toInt()] = first
            childs[(2.0 * last + 1.0).toInt()] = second
            var mindepth: Double = alphaTab.core.ecmaScript.Math.min(((values[(first).toInt()]).toInt() and 255).toDouble(), ((values[(second).toInt()]).toInt() and 255).toDouble())
            lastVal = values[(first).toInt()] + values[(second).toInt()] - mindepth + 1.0
            values[(last).toInt()] = lastVal
            ppos = 0.0
            path = 1.0
            while (path < heapLen)
            {
                if (path + 1.0 < heapLen && values[(heap[(path).toInt()]).toInt()] > values[(heap[(path + 1.0).toInt()]).toInt()])
                {
                    path++
                }
                heap[(ppos).toInt()] = heap[(path).toInt()]
                ppos = path
                path = ppos * 2.0 + 1.0
            }
            while (true)
            {
                path = ppos
                if (path > 0)
                {
                    ppos = alphaTab.core.ecmaScript.Math.floor((path - 1.0) / (2.0).toDouble())
                    if (values[(heap[(ppos).toInt()]).toInt()] > lastVal)
                    {
                        heap[(path).toInt()] = heap[(ppos).toInt()]
                    }
                    else 
                    {
                        break
                    }
                }
                else 
                {
                    break
                }
            }
            heap[(path).toInt()] = last
        }
        while (heapLen > 1)
        this.buildLength(childs)
    }
    
    /**
     */
    private fun buildLength(childs: alphaTab.core.ecmaScript.Int32Array): Unit{
        this.length = alphaTab.core.ecmaScript.Uint8Array(this.freqs.length)
        var numNodes: Double = alphaTab.core.ecmaScript.Math.floor(childs.length / (2.0).toDouble())
        var numLeafs: Double = alphaTab.core.ecmaScript.Math.floor((numNodes + 1.0) / (2.0).toDouble())
        var overflow: Double = 0.0
        if(true) {
            var i: Double = 0.0
            
            while(i < this.maxLength){
                try{
                    this.bitLengthCounts[(i).toInt()] = 0.0
                }
                finally{
                    i++
                }
            }
        }
        var lengths: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(numNodes)
        lengths[(numNodes - 1.0).toInt()] = 0.0
        if(true) {
            var i: Double = numNodes - 1.0
            
            while(i >= 0){
                try{
                    if (childs[(2.0 * i + 1.0).toInt()] != -1.0)
                    {
                        var bitLength: Double = lengths[(i).toInt()] + 1.0
                        if (bitLength > this.maxLength)
                        {
                            bitLength = this.maxLength
                            overflow++
                        }
                        lengths[(childs[(2.0 * i).toInt()]).toInt()] = bitLength
                        lengths[(childs[(2.0 * i + 1.0).toInt()]).toInt()] = bitLength
                    }
                    else 
                    {
                        var bitLength: Double = lengths[(i).toInt()]
                        this.bitLengthCounts[(bitLength - 1.0).toInt()]++
                        this.length!![(childs[(2.0 * i).toInt()]).toInt()] = lengths[(i).toInt()]
                    }
                }
                finally{
                    i--
                }
            }
        }
        if (overflow == 0.0)
        {
            return
        }
        var incrBitLen: Double = this.maxLength - 1.0
        do
        {
            while (this.bitLengthCounts[(--incrBitLen).toInt()] == 0.0)
            {
            }
            do
            {
                this.bitLengthCounts[(incrBitLen).toInt()]--
                this.bitLengthCounts[(++incrBitLen).toInt()]++
                overflow -= 1 shl ((this.maxLength - 1.0 - incrBitLen)).toInt()
            }
            while (overflow > 0 && incrBitLen < this.maxLength - 1.0)
        }
        while (overflow > 0)
        this.bitLengthCounts[(this.maxLength - 1.0).toInt()] += overflow
        this.bitLengthCounts[(this.maxLength - 2.0).toInt()] -= overflow
        var nodePtr: Double = 2.0 * numLeafs
        if(true) {
            var bits: Double = this.maxLength
            
            while(bits != 0.0){
                try{
                    var n: Double = this.bitLengthCounts[(bits - 1.0).toInt()]
                    while (n > 0)
                    {
                        var childPtr: Double = 2.0 * childs[(nodePtr++).toInt()]
                        if (childs[(childPtr + 1.0).toInt()] == -1.0)
                        {
                            this.length!![(childs[(childPtr).toInt()]).toInt()] = bits
                            n--
                        }
                    }
                }
                finally{
                    bits--
                }
            }
        }
    }
    
    /**
     * Get encoded length
     */
    public fun getEncodedLength(): Double{
        var len: Double = 0.0
        if(true) {
            var i: Double = 0.0
            
            while(i < this.freqs.length){
                try{
                    len += this.freqs[(i).toInt()] * this.length!![(i).toInt()]
                }
                finally{
                    i++
                }
            }
        }
        return len
    }
    
    /**
     * Scan a literal or distance tree to determine the frequencies of the codes
     * in the bit length tree.
     */
    public fun calcBLFreq(blTree: alphaTab.zip.Tree): Unit{
        var max_count: Double
        var min_count: Double
        var count: Double
        var curlen: Double = -1.0
        var i: Double = 0.0
        while (i < this.numCodes)
        {
            count = 1.0
            var nextlen: Double = this.length!![(i).toInt()]
            if (nextlen == 0.0)
            {
                max_count = 138.0
                min_count = 3.0
            }
            else 
            {
                max_count = 6.0
                min_count = 3.0
                if (curlen != nextlen)
                {
                    blTree.freqs[(nextlen).toInt()]++
                    count = 0.0
                }
            }
            curlen = nextlen
            i++
            while (i < this.numCodes && curlen == this.length!![(i).toInt()])
            {
                i++
                if (++count >= max_count)
                {
                    break
                }
            }
            if (count < min_count)
            {
                blTree.freqs[(curlen).toInt()] += count
            }
            else if (curlen != 0.0)
            {
                blTree.freqs[(alphaTab.zip.Tree.Repeat3To6).toInt()]++
            }
            else if (count <= 10)
            {
                blTree.freqs[(alphaTab.zip.Tree.Repeat3To10).toInt()]++
            }
            else 
            {
                blTree.freqs[(alphaTab.zip.Tree.Repeat11To138).toInt()]++
            }
        }
    }
    
    /**
     * Set static codes and length
     * @param staticCodes new codes
     * @param staticLengths length for new codes
     */
    public fun setStaticCodes(staticCodes: alphaTab.core.ecmaScript.Int16Array, staticLengths: alphaTab.core.ecmaScript.Uint8Array): Unit{
        this.codes = staticCodes
        this.length = staticLengths
    }
    
    /**
     * Build dynamic codes and lengths
     */
    public fun buildCodes(): Unit{
        var nextCode: alphaTab.core.ecmaScript.Int32Array = alphaTab.core.ecmaScript.Int32Array(this.maxLength)
        var code: Double = 0.0
        this.codes = alphaTab.core.ecmaScript.Int16Array(this.freqs.length)
        if(true) {
            var bits: Double = 0.0
            
            while(bits < this.maxLength){
                try{
                    nextCode[(bits).toInt()] = code
                    code += (this.bitLengthCounts[(bits).toInt()]).toInt() shl ((15.0 - bits)).toInt()
                }
                finally{
                    bits++
                }
            }
        }
        if(true) {
            var i: Double = 0.0
            
            while(i < this.numCodes){
                try{
                    var bits: Double = this.length!![(i).toInt()]
                    if (bits > 0)
                    {
                        this.codes!![(i).toInt()] = alphaTab.zip.DeflaterHuffman.bitReverse(nextCode[(bits - 1.0).toInt()])
                        nextCode[(bits - 1.0).toInt()] += 1 shl ((16.0 - bits)).toInt()
                    }
                }
                finally{
                    i++
                }
            }
        }
    }
    
    /**
     * Write tree values
     * @param blTree Tree to write
     */
    public fun writeTree(blTree: alphaTab.zip.Tree): Unit{
        var maxCount: Double
        var minCount: Double
        var count: Double
        var curlen: Double = -1.0
        var i: Double = 0.0
        while (i < this.numCodes)
        {
            count = 1.0
            var nextlen: Double = this.length!![(i).toInt()]
            if (nextlen == 0.0)
            {
                maxCount = 138.0
                minCount = 3.0
            }
            else 
            {
                maxCount = 6.0
                minCount = 3.0
                if (curlen != nextlen)
                {
                    blTree.writeSymbol(nextlen)
                    count = 0.0
                }
            }
            curlen = nextlen
            i++
            while (i < this.numCodes && curlen == this.length!![(i).toInt()])
            {
                i++
                if (++count >= maxCount)
                {
                    break
                }
            }
            if (count < minCount)
            {
                while (count-- > 0)
                {
                    blTree.writeSymbol(curlen)
                }
            }
            else if (curlen != 0.0)
            {
                blTree.writeSymbol((alphaTab.zip.Tree.Repeat3To6.toDouble()))
                this.huffman.pending.writeBits(count - 3.0, 2.0)
            }
            else if (count <= 10)
            {
                blTree.writeSymbol((alphaTab.zip.Tree.Repeat3To10.toDouble()))
                this.huffman.pending.writeBits(count - 3.0, 3.0)
            }
            else 
            {
                blTree.writeSymbol((alphaTab.zip.Tree.Repeat11To138.toDouble()))
                this.huffman.pending.writeBits(count - 11.0, 7.0)
            }
        }
    }
    
    /**
     */
    public fun writeSymbol(code: Double): Unit{
        this.huffman.pending.writeBits(((this.codes!![(code).toInt()]).toInt() and 65535).toDouble(), this.length!![(code).toInt()])
    }
    
    companion object{
        @kotlin.jvm.JvmStatic
        private val Repeat3To6: Double = 16.0
        
        @kotlin.jvm.JvmStatic
        private val Repeat3To10: Double = 17.0
        
        @kotlin.jvm.JvmStatic
        private val Repeat11To138: Double = 18.0
        
    }
}

