// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

/**
 * This class is general purpose class for writing data to a buffer.
 * It allows you to write bits as well as bytes
 * Based on DeflaterPending.java
 */
@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class PendingBuffer
{
    private var _buffer: alphaTab.core.ecmaScript.Uint8Array
    
    private var _start: Double = 0.0
    
    private var _end: Double = 0.0
    
    private var _bits: Double = 0.0
    
    /**
     * The number of bits written to the buffer
     */
    public var bitCount: Double = 0.0
    
    public val isFlushed: Boolean
    get(){
        return this._end == 0.0
    }
    
    public constructor(bufferSize: Double){
        this._buffer = alphaTab.core.ecmaScript.Uint8Array(bufferSize)
    }
    
    /**
     * Clear internal state/buffers
     */
    public fun reset(): Unit{
        this._start = 0.0
        this._end = 0.0
        this.bitCount = 0.0
    }
    
    /**
     * Write a short value to internal buffer most significant byte first
     * @param s value to write
     */
    public fun writeShortMSB(s: Double): Unit{
        this._buffer[(this._end++).toInt()] = (((s).toInt() shr 8) and 255).toDouble()
        this._buffer[(this._end++).toInt()] = ((s).toInt() and 255).toDouble()
    }
    
    /**
     * Write a short value to buffer LSB first
     * @param value The value to write.
     */
    public fun writeShort(value: Double): Unit{
        this._buffer[(this._end++).toInt()] = value
        this._buffer[(this._end++).toInt()] = (((value).toInt() shr 8).toDouble())
    }
    
    /**
     * Write a block of data to buffer
     * @param block data to write
     * @param offset offset of first byte to write
     * @param length number of bytes to write
     */
    public fun writeBlock(block: alphaTab.core.ecmaScript.Uint8Array, offset: Double, length: Double): Unit{
        this._buffer.set(block.subarray(offset, offset + length), this._end)
        this._end += length
    }
    
    /**
     * Flushes the pending buffer into the given output array.  If the
     * output array is to small, only a partial flush is done.
     * @param output The output array.
     * @param offset The offset into output array.
     * @param length The maximum number of bytes to store.
     */
    public fun flush(output: alphaTab.core.ecmaScript.Uint8Array, offset: Double, length: Double): Double{
        var paramlength = length
        if (this.bitCount >= 8)
        {
            this._buffer[(this._end++).toInt()] = ((this._bits).toInt() and 255).toDouble()
            this._bits = ((this._bits.toInt()) shr (8)).toDouble()
            this.bitCount -= 8.0
        }
        if (paramlength > this._end - this._start)
        {
            paramlength = this._end - this._start
            output.set(this._buffer.subarray(this._start, this._start + paramlength), offset)
            this._start = 0.0
            this._end = 0.0
        }
        else 
        {
            output.set(this._buffer.subarray(this._start, this._start + paramlength), offset)
            this._start += paramlength
        }
        return paramlength
    }
    
    /**
     * Write bits to internal buffer
     * @param b source of bits
     * @param count number of bits to write
     */
    public fun writeBits(b: Double, count: Double): Unit{
        this._bits = ((this._bits.toInt()) or ((b).toInt() shl (this.bitCount).toInt())).toDouble()
        this.bitCount += count
        if (this.bitCount >= 16)
        {
            this._buffer[(this._end++).toInt()] = ((this._bits).toInt() and 255).toDouble()
            this._buffer[(this._end++).toInt()] = (((this._bits).toInt() shr 8) and 255).toDouble()
            this._bits = ((this._bits.toInt()) shr (16)).toDouble()
            this.bitCount -= 16.0
        }
    }
    
    /**
     * Align internal buffer on a byte boundary
     */
    public fun alignToByte(): Unit{
        if (this.bitCount > 0)
        {
            this._buffer[(this._end++).toInt()] = ((this._bits).toInt() and 255).toDouble()
            if (this.bitCount > 8)
            {
                this._buffer[(this._end++).toInt()] = (((this._bits).toInt() shr 8) and 255).toDouble()
            }
        }
        this._bits = 0.0
        this.bitCount = 0.0
    }
    
}

