// <auto-generated>
// This code was auto-generated.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
// </auto-generated>

@file:Suppress(
    "KotlinRedundantDiagnosticSuppress",
    "RedundantVisibilityModifier",
    "RedundantExplicitType",
    "RedundantUnitReturnType",
    "RemoveRedundantQualifierName",
    "RemoveExplicitTypeArguments",
    "MemberVisibilityCanBePrivate",
    "MoveLambdaOutsideParentheses",
    "ConvertSecondaryConstructorToPrimary",
    "RemoveRedundantCallsOfConversionMethods",
    "MayBeConstant",
    "UnusedImport",
    "CanBeVal",
    "CascadeIf",
    "unused",
    "NON_EXHAUSTIVE_WHEN",
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "UNNECESSARY_NOT_NULL_ASSERTION",
    "UNNECESSARY_SAFE_CALL",
    "UNUSED_ANONYMOUS_PARAMETER",
    "UNUSED_PARAMETER",
    "UNUSED_VALUE",
    "UNREACHABLE_CODE",
    "REDUNDANT_ELSE_IN_WHEN",
    "VARIABLE_WITH_REDUNDANT_INITIALIZER"
)
package alphaTab.zip
import alphaTab.core.*

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ZipWriter
{
    private var _data: alphaTab.io.IWriteable
    
    private var _centralDirectoryHeaders: alphaTab.collections.List<alphaTab.zip.ZipCentralDirectoryHeader> = alphaTab.collections.List<alphaTab.zip.ZipCentralDirectoryHeader>(
    )
    
    
    private var _deflater: alphaTab.zip.Deflater = alphaTab.zip.Deflater()
    
    public constructor(`data`: alphaTab.io.IWriteable){
        this._data = `data`
    }
    
    /**
     */
    public fun writeEntry(entry: alphaTab.zip.ZipEntry): Unit{
        var compressionMode: Double = alphaTab.zip.ZipEntry.CompressionMethodDeflate
        var compressedData: alphaTab.io.ByteBuffer = alphaTab.io.ByteBuffer.empty()
        var crc32: Double = this.compress(compressedData, entry.`data`, compressionMode)
        var compressedDataArray: alphaTab.core.ecmaScript.Uint8Array = compressedData.toArray()
        var directoryHeader: alphaTab.zip.ZipCentralDirectoryHeader = alphaTab.zip.ZipCentralDirectoryHeader(entry, crc32, this._data.bytesWritten, compressionMode, compressedData.length)
        this._centralDirectoryHeaders.push(directoryHeader)
        alphaTab.io.IOHelper.writeInt32LE(this._data, alphaTab.zip.ZipEntry.LocalFileHeaderSignature)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, 10.0)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, 2048.0)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, compressionMode)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt32LE(this._data, crc32)
        alphaTab.io.IOHelper.writeInt32LE(this._data, compressedDataArray.length)
        alphaTab.io.IOHelper.writeInt32LE(this._data, entry.`data`.length)
        alphaTab.io.IOHelper.writeInt16LE(this._data, entry.fullName.length.toDouble())
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        var fileNameBuffer: alphaTab.core.ecmaScript.Uint8Array = alphaTab.io.IOHelper.stringToBytes(entry.fullName)
        this._data.write(fileNameBuffer, 0.0, fileNameBuffer.length)
        this._data.write(compressedDataArray, 0.0, compressedDataArray.length)
    }
    
    /**
     */
    private fun compress(output: alphaTab.io.IWriteable, `data`: alphaTab.core.ecmaScript.Uint8Array, compressionMode: Double): Double{
        if (compressionMode != alphaTab.zip.ZipEntry.CompressionMethodDeflate)
        {
            var crc: alphaTab.zip.Crc32 = alphaTab.zip.Crc32()
            crc.update(`data`, 0.0, `data`.length)
            output.write(`data`, 0.0, `data`.length)
            return crc.value
        }
        else 
        {
            var buffer: alphaTab.core.ecmaScript.Uint8Array = alphaTab.core.ecmaScript.Uint8Array(512.0)
            this._deflater.reset()
            this._deflater.setInput(`data`, 0.0, `data`.length)
            while (!this._deflater.isNeedingInput)
            {
                var len: Double = this._deflater.deflate(buffer, 0.0, buffer.length)
                if (len <= 0)
                {
                    break
                }
                output.write(buffer, 0.0, len)
            }
            this._deflater.finish()
            while (!this._deflater.isFinished)
            {
                var len: Double = this._deflater.deflate(buffer, 0.0, buffer.length)
                if (len <= 0)
                {
                    break
                }
                output.write(buffer, 0.0, len)
            }
            return this._deflater.inputCrc
        }
    }
    
    public fun end(): Unit{
        var startOfCentralDirectory: Double = this._data.bytesWritten
        for (header in this._centralDirectoryHeaders)
        {
            this.writeCentralDirectoryHeader(header)
        }
        var endOfCentralDirectory: Double = this._data.bytesWritten
        this.writeEndOfCentralDirectoryRecord(startOfCentralDirectory, endOfCentralDirectory)
    }
    
    /**
     */
    private fun writeEndOfCentralDirectoryRecord(startOfCentralDirectory: Double, endOfCentralDirectory: Double): Unit{
        alphaTab.io.IOHelper.writeInt32LE(this._data, alphaTab.zip.ZipEntry.EndOfCentralDirSignature)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, this._centralDirectoryHeaders.length)
        alphaTab.io.IOHelper.writeInt16LE(this._data, this._centralDirectoryHeaders.length)
        alphaTab.io.IOHelper.writeInt32LE(this._data, endOfCentralDirectory - startOfCentralDirectory)
        alphaTab.io.IOHelper.writeInt32LE(this._data, startOfCentralDirectory)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
    }
    
    /**
     */
    private fun writeCentralDirectoryHeader(header: alphaTab.zip.ZipCentralDirectoryHeader): Unit{
        alphaTab.io.IOHelper.writeInt32LE(this._data, alphaTab.zip.ZipEntry.CentralFileHeaderSignature)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, 10.0)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, 10.0)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, 2048.0)
        alphaTab.io.IOHelper.writeUInt16LE(this._data, header.compressionMode)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt32LE(this._data, header.crc32)
        alphaTab.io.IOHelper.writeInt32LE(this._data, header.compressedSize)
        alphaTab.io.IOHelper.writeInt32LE(this._data, header.entry.`data`.length)
        alphaTab.io.IOHelper.writeInt16LE(this._data, header.entry.fullName.length.toDouble())
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt16LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt32LE(this._data, 0.0)
        alphaTab.io.IOHelper.writeInt32LE(this._data, header.localHeaderOffset)
        var fileNameBuffer: alphaTab.core.ecmaScript.Uint8Array = alphaTab.io.IOHelper.stringToBytes(header.entry.fullName)
        this._data.write(fileNameBuffer, 0.0, fileNameBuffer.length)
    }
    
}

@kotlin.contracts.ExperimentalContracts
@kotlin.ExperimentalUnsignedTypes
internal class ZipCentralDirectoryHeader
{
    public var entry: alphaTab.zip.ZipEntry
    public var localHeaderOffset: Double
    public var compressedSize: Double
    public var crc32: Double
    public var compressionMode: Double
    public constructor(entry: alphaTab.zip.ZipEntry, crc32: Double, localHeaderOffset: Double, compressionMode: Double, compressedSize: Double){
        this.entry = entry
        this.crc32 = crc32
        this.localHeaderOffset = localHeaderOffset
        this.compressionMode = compressionMode
        this.compressedSize = compressedSize
    }
    
}

